/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.mindmapmode;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.components.resizer.UIComponentVisibilityDispatcher;
import org.freeplane.core.ui.menubuilders.generic.UserRole;
import org.freeplane.core.util.FreeplaneVersion;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.ui.ViewController;
import org.freeplane.main.addons.AddOnProperties;
import org.freeplane.main.addons.AddOnsController;
import org.freeplane.main.mindmapmode.HttpVersionClient;

class UpdateCheckAction
extends AFreeplaneAction {
    private static final String UPDATE_AVAILABLE_COMPONENT_KEY = "updateAvailable";
    private static final String UPDATE_URL = "https://sourceforge.net/projects/freeplane/files/freeplane%20stable/";
    private static final int VISIBLE_ADDON_ROWS = 8;
    private static boolean autorunEnabled = true;
    private static Timer autorunTimer = null;
    private static final int CHECK_TIME = 30000;
    private static final String CHECK_UPDATES_AUTOMATICALLY = "check_updates_automatically";
    private static final String LAST_UPDATE_CHECK_TIME = "last_update_check_time";
    private static final String LAST_UPDATE_VERSION = "last_update_verson";
    private static final long serialVersionUID = 1L;
    private static final int ONE_DAY = 86400000;
    private static final String WEB_UPDATE_LOCATION_KEY = "webUpdateLocation";
    private final Controller controller;
    private static final String DEFAULT_LANGUAGE = "en";
    private ActionListener openUrlListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Controller.getCurrentController().getViewController().openDocument(new URL(((JButton)e.getSource()).getActionCommand()));
            }
            catch (MalformedURLException ex) {
                UITools.errorMessage((Object)(TextUtils.getText((String)"url_error") + "\n" + ex));
            }
            catch (Exception ex) {
                UITools.errorMessage((Object)ex);
            }
        }
    };

    public UpdateCheckAction(final Controller controller) {
        super("UpdateCheckAction");
        this.controller = controller;
        controller.getMapViewManager().addMapViewChangeListener(new IMapViewChangeListener(){

            public void afterViewChange(Component oldView, Component newView) {
                if (newView == null) {
                    return;
                }
                controller.getViewController().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.removeMe();
                    }
                });
                UpdateCheckAction.this.setTimer();
            }

            private void removeMe() {
                controller.getMapViewManager().removeMapViewChangeListener((IMapViewChangeListener)this);
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        final boolean autoRun = e.getSource().equals(autorunTimer);
        if (autorunTimer != null) {
            autorunTimer.stop();
            autorunTimer = null;
        }
        this.setEnabled(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    UpdateCheckAction.this.checkForUpdates(autoRun);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }, "checkForUpdates").start();
    }

    public void afterMapChange(UserRole userRole) {
    }

    private void updateButton(FreeplaneVersion lastVersion) {
        if (lastVersion == null || lastVersion.compareTo((org.freeplane.api.FreeplaneVersion)FreeplaneVersion.getVersion()) <= 0) {
            ResourceController.getResourceController().setProperty(LAST_UPDATE_VERSION, "");
            ViewController viewController = this.controller.getViewController();
            viewController.removeStatus(UPDATE_AVAILABLE_COMPONENT_KEY);
        } else {
            ResourceController.getResourceController().setProperty(LAST_UPDATE_VERSION, lastVersion.toString());
            String updateAvailable = TextUtils.format((String)"new_version_available", (Object[])new Object[]{lastVersion.toString()});
            this.putValue("ShortDescription", updateAvailable);
            this.putValue("LongDescription", updateAvailable);
            JButton newVersionButton = new JButton(updateAvailable, this.getIcon());
            newVersionButton.addActionListener(this.openUrlListener);
            newVersionButton.setActionCommand(UPDATE_URL);
            ViewController viewController = this.controller.getViewController();
            viewController.addStatusComponent(UPDATE_AVAILABLE_COMPONENT_KEY, (Component)newVersionButton);
            JComponent statusBar = viewController.getStatusBar();
            if (!statusBar.isVisible()) {
                UIComponentVisibilityDispatcher.of((JComponent)statusBar).setVisible(true);
            }
        }
    }

    private void checkForUpdates(final boolean autoRun) {
        ConnectionStatus connectionStatus;
        String history;
        FreeplaneVersion lastVersion;
        Date now = new Date();
        ResourceController.getResourceController().setProperty(LAST_UPDATE_CHECK_TIME, Long.toString(now.getTime()));
        String translatedWebUpdate = this.getWebUpdateUrl(ConnectionStatus.TRANSLATED.language);
        FreeplaneVersion localVersion = FreeplaneVersion.getVersion();
        HttpVersionClient translatedVersionClient = new HttpVersionClient(translatedWebUpdate, localVersion);
        FreeplaneVersion lastTranslatedVersion = translatedVersionClient.getRemoteVersion();
        if (lastTranslatedVersion == null) {
            lastTranslatedVersion = localVersion;
        }
        if (!ConnectionStatus.TRANSLATED.language.equals(DEFAULT_LANGUAGE)) {
            String defaultWebUpdate = this.getWebUpdateUrl(DEFAULT_LANGUAGE);
            HttpVersionClient defaultVersionClient = new HttpVersionClient(defaultWebUpdate, lastTranslatedVersion);
            lastVersion = defaultVersionClient.getRemoteVersion();
            history = defaultVersionClient.getHistory() + translatedVersionClient.getHistory();
            connectionStatus = translatedVersionClient.isSuccessful() ? ConnectionStatus.TRANSLATED : (defaultVersionClient.isSuccessful() ? ConnectionStatus.DEFAULT : ConnectionStatus.FAILURE);
        } else {
            lastVersion = lastTranslatedVersion;
            history = translatedVersionClient.getHistory();
            ConnectionStatus connectionStatus2 = connectionStatus = translatedVersionClient.isSuccessful() ? ConnectionStatus.DEFAULT : ConnectionStatus.FAILURE;
        }
        if (!autoRun) {
            this.checkForAddonsUpdates();
        }
        this.controller.getViewController().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (autoRun) {
                    UpdateCheckAction.this.updateButton(lastVersion);
                } else {
                    UpdateCheckAction.this.showUpdateDialog(connectionStatus.statusKey, lastVersion, history, connectionStatus.language);
                    UpdateCheckAction.this.updateButton(lastVersion);
                }
                UpdateCheckAction.this.setEnabled(true);
            }
        });
    }

    private void checkForAddonsUpdates() {
        List installedAddOns = AddOnsController.getController().getInstalledAddOns();
        LogUtils.info((String)("checking for updates of " + installedAddOns.size() + " add-ons"));
        for (AddOnProperties addOnProperties : installedAddOns) {
            FreeplaneVersion addOnLocalVersion = this.toFreeplaneVersion(addOnProperties.getVersion());
            URL updateUrl = addOnProperties.getUpdateUrl();
            if (updateUrl == null) continue;
            String addOnUpdateRequest = updateUrl + "?v=" + addOnLocalVersion.toString();
            HttpVersionClient versionClient = new HttpVersionClient(addOnUpdateRequest, addOnLocalVersion);
            FreeplaneVersion latestVersion = versionClient.getRemoteVersion();
            boolean connectSuccesfull = versionClient.isSuccessful();
            if (!connectSuccesfull) continue;
            addOnProperties.setLatestVersion(latestVersion.toString());
            if (versionClient.getRemoteVersionDownloadUrl() != null) {
                addOnProperties.setLatestVersionDownloadUrl(versionClient.getRemoteVersionDownloadUrl());
            }
            if (versionClient.getRemoteVersionChangelogUrl() == null) continue;
            addOnProperties.setLatestVersionChangelogUrl(versionClient.getRemoteVersionChangelogUrl());
        }
    }

    private String getWebUpdateUrl(String language) {
        String webUpdateUrl = ResourceController.getResourceController().getProperty(WEB_UPDATE_LOCATION_KEY);
        FreeplaneVersion localVersion = FreeplaneVersion.getVersion();
        StringBuilder sb = new StringBuilder(webUpdateUrl);
        String type = localVersion.getType();
        if (!type.equals("")) {
            sb.append(type);
            sb.append('/');
        }
        sb.append("history_");
        sb.append(language);
        sb.append(".txt");
        return sb.toString();
    }

    private FreeplaneVersion getKnownNewVersion() {
        FreeplaneVersion localVersion = FreeplaneVersion.getVersion();
        String property = ResourceController.getResourceController().getProperty(LAST_UPDATE_VERSION);
        if (property.equals("")) {
            return null;
        }
        FreeplaneVersion lastVersion = FreeplaneVersion.getVersion((String)property);
        if (lastVersion.compareTo((org.freeplane.api.FreeplaneVersion)localVersion) <= 0) {
            lastVersion = null;
        }
        return lastVersion;
    }

    private void setTimer() {
        if (!autorunEnabled) {
            return;
        }
        autorunEnabled = ResourceController.getResourceController().getBooleanProperty(CHECK_UPDATES_AUTOMATICALLY);
        if (!autorunEnabled) {
            return;
        }
        autorunEnabled = false;
        Date now = new Date();
        long nextCheckMillis = ResourceController.getResourceController().getLongProperty(LAST_UPDATE_CHECK_TIME, 0L) + 86400000L;
        Date nextCheckDate = new Date(nextCheckMillis);
        FreeplaneVersion knownNewVersion = this.getKnownNewVersion();
        this.updateButton(knownNewVersion);
        if (nextCheckDate.before(now)) {
            autorunTimer = new Timer(30000, (ActionListener)((Object)this));
            autorunTimer.setRepeats(false);
            autorunTimer.start();
        }
    }

    private int showUpdateDialog(String info, FreeplaneVersion freeplaneLatestVersion, String history, String language) {
        JLabel freeplaneLatestVersionLabel;
        Box messagePane = Box.createVerticalBox();
        JLabel emptyLabel = new JLabel("");
        JPanel gridPane = new JPanel(new GridBagLayout());
        gridPane.setAlignmentX(0.0f);
        Border paddingBorder = BorderFactory.createEmptyBorder(0, 10, 10, 0);
        gridPane.setBorder(BorderFactory.createCompoundBorder(paddingBorder, paddingBorder));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        int gridRow = 0;
        c.weightx = 0.5;
        JLabel componentHeader = new JLabel(TextUtils.getText((String)"updater.component"), 0);
        JLabel installedVersionHeader = new JLabel(TextUtils.getText((String)"updater.version.installed"), 0);
        JLabel latestVersionHeader = new JLabel(TextUtils.getText((String)"updater.version.latest"), 0);
        Font boldFont = new Font(componentHeader.getFont().getName(), 1, componentHeader.getFont().getSize());
        componentHeader.setFont(boldFont);
        installedVersionHeader.setFont(boldFont);
        latestVersionHeader.setFont(boldFont);
        componentHeader.setBorder(paddingBorder);
        installedVersionHeader.setBorder(paddingBorder);
        latestVersionHeader.setBorder(paddingBorder);
        c.gridy = 0;
        c.gridx = 0;
        gridPane.add((Component)componentHeader, c);
        c.gridx = 1;
        gridPane.add((Component)installedVersionHeader, c);
        c.gridx = 2;
        gridPane.add((Component)latestVersionHeader, c);
        c.gridx = 3;
        gridPane.add((Component)emptyLabel, c);
        c.gridx = 4;
        gridPane.add((Component)emptyLabel, c);
        c.gridy = 1;
        JLabel freeplaneLabel = new JLabel("Freeplane");
        FreeplaneVersion freeplaneLocalVersion = FreeplaneVersion.getVersion();
        JLabel freeplaneInstalledVersionLabel = new JLabel(freeplaneLocalVersion.toString(), 0);
        String translatedWebUpdate = this.getWebUpdateUrl(language);
        JButton changelogButton = new JButton(TextUtils.getText((String)"updater.viewChangelog"));
        changelogButton.addActionListener(this.openUrlListener);
        changelogButton.setActionCommand(translatedWebUpdate);
        JButton updateButton = new JButton(TextUtils.getText((String)"updater.goToDownload"));
        updateButton.addActionListener(this.openUrlListener);
        updateButton.setActionCommand(UPDATE_URL);
        Boolean needsUpdate = Boolean.FALSE;
        if (freeplaneLatestVersion != null) {
            needsUpdate = freeplaneLocalVersion.compareTo((org.freeplane.api.FreeplaneVersion)freeplaneLatestVersion) < 0 ? Boolean.TRUE : Boolean.FALSE;
            freeplaneLatestVersionLabel = new JLabel(freeplaneLatestVersion.toString(), 0);
        } else {
            freeplaneLatestVersionLabel = new JLabel(TextUtils.getText((String)"updater.version.unknown"), 0);
            freeplaneLatestVersionLabel.setToolTipText(TextUtils.getText((String)info));
        }
        changelogButton.setEnabled(needsUpdate);
        updateButton.setEnabled(needsUpdate);
        c.gridx = 0;
        gridPane.add((Component)freeplaneLabel, c);
        c.gridx = 1;
        gridPane.add((Component)freeplaneInstalledVersionLabel, c);
        c.gridx = 2;
        gridPane.add((Component)freeplaneLatestVersionLabel, c);
        c.gridx = 3;
        gridPane.add((Component)changelogButton, c);
        c.gridx = 4;
        gridPane.add((Component)updateButton, c);
        List installedAddOns = AddOnsController.getController().getInstalledAddOns();
        gridRow = 3;
        int addonViewportPreferredHeight = 0;
        for (AddOnProperties addOnProperties : installedAddOns) {
            JLabel addOnLatestVersionLabel;
            FreeplaneVersion addOnLocalVersion = this.toFreeplaneVersion(addOnProperties.getVersion());
            FreeplaneVersion addOnLatestVersion = this.toFreeplaneVersion(addOnProperties.getLatestVersion());
            JLabel addOnInstalledVersionLabel = new JLabel(addOnLocalVersion.toString(), 0);
            needsUpdate = Boolean.FALSE;
            if (addOnLatestVersion != null) {
                if (addOnLocalVersion.compareTo((org.freeplane.api.FreeplaneVersion)addOnLatestVersion) < 0) {
                    needsUpdate = Boolean.TRUE;
                }
                addOnLatestVersionLabel = new JLabel(addOnLatestVersion.toString(), 0);
            } else {
                addOnLatestVersionLabel = new JLabel(TextUtils.getText((String)"updater.version.unknown"), 0);
                if (addOnProperties.getUpdateUrl() != null) {
                    addOnLatestVersionLabel.setToolTipText(TextUtils.getText((String)"updater.version.unreachable") + " " + addOnProperties.getUpdateUrl());
                } else {
                    addOnLatestVersionLabel.setToolTipText(TextUtils.getText((String)"updater.version.noUpdateUrl"));
                }
            }
            JLabel addOnLabel = new JLabel(TextUtils.getText((String)("addons." + addOnProperties.getName())));
            c.gridx = 0;
            c.gridy = gridRow;
            gridPane.add((Component)addOnLabel, c);
            c.gridx = 1;
            c.gridy = gridRow;
            gridPane.add((Component)addOnInstalledVersionLabel, c);
            c.gridx = 2;
            c.gridy = gridRow;
            gridPane.add((Component)addOnLatestVersionLabel, c);
            c.gridx = 3;
            c.gridy = gridRow;
            changelogButton = new JButton(TextUtils.getText((String)"updater.viewChangelog"));
            changelogButton.addActionListener(this.openUrlListener);
            if (addOnProperties.getLatestVersionChangelogUrl() != null) {
                changelogButton.setActionCommand(addOnProperties.getLatestVersionChangelogUrl().toString());
            } else if (addOnProperties.getUpdateUrl() != null) {
                changelogButton.setActionCommand(String.valueOf(addOnProperties.getUpdateUrl()));
            }
            gridPane.add((Component)changelogButton, c);
            changelogButton.setEnabled(needsUpdate);
            c.gridx = 4;
            c.gridy = gridRow;
            updateButton = new JButton(TextUtils.getText((String)"updater.goToDownload"));
            updateButton.addActionListener(this.openUrlListener);
            if (addOnProperties.getLatestVersionDownloadUrl() != null) {
                updateButton.setActionCommand(addOnProperties.getLatestVersionDownloadUrl().toString());
            } else if (addOnProperties.getHomepage() != null) {
                updateButton.setActionCommand(addOnProperties.getHomepage().toString());
            }
            gridPane.add((Component)updateButton, c);
            updateButton.setEnabled(needsUpdate);
            if (++gridRow != 8) continue;
            addonViewportPreferredHeight = gridPane.getPreferredSize().height;
        }
        if (gridRow > 8) {
            JScrollPane scrollPane = new JScrollPane(gridPane, 22, 31);
            scrollPane.setAlignmentX(0.0f);
            JViewport viewport = scrollPane.getViewport();
            viewport.setPreferredSize(new Dimension(gridPane.getPreferredSize().width, addonViewportPreferredHeight));
            scrollPane.setBorder(BorderFactory.createEtchedBorder());
            messagePane.add(scrollPane);
        } else {
            messagePane.add(gridPane);
        }
        if (!history.isEmpty()) {
            JTextArea text = new JTextArea(history);
            text.setRows(10);
            JScrollPane scrollPane = new JScrollPane(text, 22, 32);
            scrollPane.setBorder(BorderFactory.createEtchedBorder());
            messagePane.add(scrollPane);
        }
        JLabel confLabel = new JLabel(TextUtils.getText((String)"preferences"));
        confLabel.setFont(boldFont);
        messagePane.add(confLabel);
        JCheckBox updateAutomatically = new JCheckBox(TextUtils.getText((String)"OptionPanel.check_updates_automatically"), ResourceController.getResourceController().getBooleanProperty(CHECK_UPDATES_AUTOMATICALLY));
        updateAutomatically.setAlignmentX(0.0f);
        messagePane.add(updateAutomatically);
        Object[] options = new Object[]{TextUtils.getText((String)"simplyhtml.closeBtnName")};
        int choice = JOptionPane.showOptionDialog(UITools.getMenuComponent(), messagePane, TextUtils.getText((String)"updatecheckdialog"), -1, 1, null, options, options[0]);
        ResourceController.getResourceController().setProperty(CHECK_UPDATES_AUTOMATICALLY, Boolean.toString(updateAutomatically.isSelected()));
        return choice;
    }

    private FreeplaneVersion toFreeplaneVersion(String versionString) {
        try {
            return FreeplaneVersion.getVersion((String)versionString);
        }
        catch (Exception e) {
            return FreeplaneVersion.getVersion((String)"0.0.0");
        }
    }

    static enum ConnectionStatus {
        TRANSLATED("new_version_available", Locale.getDefault().getLanguage()),
        DEFAULT("new_version_available", "en"),
        FAILURE("can_not_connect_to_info_server", "en");

        public final String statusKey;
        public final String language;

        private ConnectionStatus(String statusKey, String language) {
            this.statusKey = statusKey;
            this.language = language;
        }
    }
}

