/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui.mindmapmode;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.ResourceController;

public class TrashBin {
    public static final TrashBin INSTANCE = new TrashBin();
    private static final Icon ICON = ResourceController.getResourceController().getImageIcon("trash.icon");

    private TrashBin() {
    }

    public DragSourceListener showTrashBin(DragGestureEvent e, final Runnable onDrop) {
        JLabel trashBin = new JLabel(ICON);
        trashBin.setHorizontalAlignment(0);
        trashBin.setBorder(BorderFactory.createLineBorder(trashBin.getForeground()));
        trashBin.setOpaque(true);
        Component draggable = e.getComponent();
        final JWindow window = new JWindow();
        window.add(trashBin);
        window.setSize(trashBin.getPreferredSize());
        Point draggableLocation = draggable.getLocationOnScreen();
        window.setLocation(draggableLocation.x + draggable.getWidth() - window.getWidth(), draggableLocation.y);
        window.setVisible(true);
        DropTarget dropTarget = new DropTarget(window, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                dtde.acceptDrop(2);
                dtde.dropComplete(true);
                SwingUtilities.invokeLater(onDrop::run);
            }
        });
        return new DragSourceAdapter(){

            @Override
            public void dragDropEnd(DragSourceDropEvent dsde) {
                SwingUtilities.invokeLater(window::dispose);
            }
        };
    }
}

