/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.importer.DeclarationHandler;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.core.importer.JavaClassDescriptorImporter;
import com.tngtech.archunit.core.importer.SignatureTypeArgumentProcessor;
import com.tngtech.archunit.core.importer.SignatureTypeParameterProcessor;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.signature.SignatureReader;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.signature.SignatureVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JavaClassSignatureImporter {
    private static final Logger log = LoggerFactory.getLogger(JavaClassSignatureImporter.class);

    JavaClassSignatureImporter() {
    }

    static void parseAsmTypeSignature(String signature, DeclarationHandler declarationHandler) {
        if (signature == null) {
            return;
        }
        log.trace("Analyzing signature: {}", (Object)signature);
        SignatureProcessor signatureProcessor = new SignatureProcessor(declarationHandler);
        new SignatureReader(signature).accept(signatureProcessor);
        declarationHandler.onDeclaredTypeParameters(new DomainBuilders.JavaClassTypeParametersBuilder(signatureProcessor.getTypeParameterBuilders()));
        Optional<DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>> genericSuperclass = signatureProcessor.getGenericSuperclass();
        if (genericSuperclass.isPresent()) {
            declarationHandler.onGenericSuperclass(genericSuperclass.get());
        }
        declarationHandler.onGenericInterfaces(signatureProcessor.getGenericInterfaces());
    }

    private static class SignatureProcessor
    extends SignatureVisitor {
        private final SignatureTypeParameterProcessor<JavaClass> typeParameterProcessor;
        private final GenericSuperclassProcessor superclassProcessor;
        private final GenericInterfacesProcessor interfacesProcessor;

        SignatureProcessor(DeclarationHandler declarationHandler) {
            super(589824);
            this.typeParameterProcessor = new SignatureTypeParameterProcessor(declarationHandler);
            this.superclassProcessor = new GenericSuperclassProcessor(declarationHandler);
            this.interfacesProcessor = new GenericInterfacesProcessor(declarationHandler);
        }

        List<DomainBuilders.JavaTypeParameterBuilder<JavaClass>> getTypeParameterBuilders() {
            return this.typeParameterProcessor.getTypeParameterBuilders();
        }

        Optional<DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>> getGenericSuperclass() {
            return Optional.ofNullable(this.superclassProcessor.superclass);
        }

        List<DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>> getGenericInterfaces() {
            return this.interfacesProcessor.interfaces;
        }

        @Override
        public void visitFormalTypeParameter(String name) {
            log.trace("Encountered type parameter {}", (Object)name);
            this.typeParameterProcessor.addTypeParameter(name);
        }

        @Override
        public SignatureVisitor visitSuperclass() {
            return this.superclassProcessor;
        }

        @Override
        public SignatureVisitor visitInterface() {
            return this.interfacesProcessor;
        }

        @Override
        public SignatureVisitor visitClassBound() {
            return this.typeParameterProcessor;
        }

        @Override
        public SignatureVisitor visitInterfaceBound() {
            return this.typeParameterProcessor;
        }

        private static class GenericSuperclassProcessor
        extends SignatureVisitor {
            private final DeclarationHandler declarationHandler;
            private DomainBuilders.JavaParameterizedTypeBuilder<JavaClass> superclass;

            GenericSuperclassProcessor(DeclarationHandler declarationHandler) {
                super(589824);
                this.declarationHandler = declarationHandler;
            }

            @Override
            public void visitClassType(String internalObjectName) {
                this.superclass = new DomainBuilders.JavaParameterizedTypeBuilder(JavaClassDescriptorImporter.createFromAsmObjectTypeName(internalObjectName));
            }

            @Override
            public void visitInnerClassType(String name) {
                this.superclass = this.superclass.forInnerClass(name);
            }

            @Override
            public SignatureVisitor visitTypeArgument(char wildcard) {
                return SignatureTypeArgumentProcessor.create(wildcard, this.superclass, this.declarationHandler);
            }
        }

        private static class GenericInterfacesProcessor
        extends SignatureVisitor {
            private final DeclarationHandler declarationHandler;
            private final List<DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>> interfaces = new ArrayList<DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>>();
            private DomainBuilders.JavaParameterizedTypeBuilder<JavaClass> currentInterface;

            GenericInterfacesProcessor(DeclarationHandler declarationHandler) {
                super(589824);
                this.declarationHandler = declarationHandler;
            }

            @Override
            public void visitClassType(String internalObjectName) {
                this.currentInterface = new DomainBuilders.JavaParameterizedTypeBuilder(JavaClassDescriptorImporter.createFromAsmObjectTypeName(internalObjectName));
                this.interfaces.add(this.currentInterface);
            }

            @Override
            public SignatureVisitor visitTypeArgument(char wildcard) {
                return SignatureTypeArgumentProcessor.create(wildcard, this.currentInterface, this.declarationHandler);
            }
        }
    }
}

