local b7, B7, result;

result := rec();

b7 := (-1 + Sqrt(-7))/2; # b7 = E(7) + E(7)^2 + E(7)^4
B7 := -b7-1; # b7** = E(7)^3 + E(7)^5 + E(7)^6

result.comment := "2A7 as 4 x 4 matrices (b) over Z(b7)\n\
";

result.symmetricforms := [ ];

result.antisymmetricforms := [ ];

result.hermitianforms := [
[[7, 3*B7+4*b7, 2*B7-2*b7, -5*B7-2*b7],
 [4*B7+3*b7, 7, 3*B7+4*b7, 2*B7-2*b7],
 [-2*B7+2*b7, 4*B7+3*b7, 7, 2*B7+5*b7],
 [-2*B7-5*b7, -2*B7+2*b7, 5*B7+2*b7, 7]]];

result.centralizeralgebra := [ ];

result.generators := [
[[0,1,0,0],
[-1,-1,0,0],
[0,0,0,1],
[0,0,-1,-1]]
,
[[0,1,0,0],
[0,0,1,0],
[0,b7,-1,-1],
[1,1,-B7,0]]];

return result;

