[![Build Status](https://github.com/gap-packages/circle/workflows/CI/badge.svg?branch=master)](https://github.com/gap-packages/circle/actions?query=workflow%3ACI+branch%3Amaster)
[![Code Coverage](https://codecov.io/github/gap-packages/circle/coverage.svg?branch=master&token=)](https://codecov.io/gh/gap-packages/circle)

# The Circle Package: Adjoint groups of finite rings

Let R be an  associative ring,  not necessarily with a unit element.  The set 
of all elements of R  forms a monoid  with the neutral element 0 from R under 
the operation r*s = r + s + rs defined for all r,s from R.  This operation is
called  the  'circle  multiplication',  and  it is  also known  as  the 'star 
multiplication'. The monoid of elements of R under  the circle multiplication 
is called the adjoint semigroup of R. The group of all invertible elements of
this monoid is called the adjoint group of R.

These  notions  naturally lead  to a number of questions about the connection 
between a ring and its adjoint group,  for example,  how  the ring properties 
will determine properties  of the adjoint group;  which groups  can appear as
adjoint  groups  of  rings;   which  rings  can   have  adjoint  groups  with 
prescribed properties, etc. 

The main objective of the GAP package 'Circle' is to extend GAP functionality
for computations in adjoint groups  of associative rings to make it  possible
to use the  GAP  system for  the  investigation  of  such questions.

Circle provides functionality to construct circle  objects that  will respect
the  circle  multiplication  r*s = r + s + rs,  create multiplicative groups, 
generated by this objects,  and compute  groups of elements,  invertible with 
respect to this operation, for finite radical algebras and finite associative
rings without one.

Circle  does  not  use  external   binaries  and,  therefore,  works  without
restrictions  on the type  of the operating system.  It is redistributed with
GAP, but is not loaded by default.  Therefore,  to use Circle, first you need
to load it using the following command:

    gap> LoadPackage("circle");


Olexandr Konovalov and Panagiotis Soules
