#############################################################################
##
#W bchdat.g            Guarana package                        Bjoern Assmann
##
## Record that contains the 
## coefficients of the BCH series up to commutators of length 9. 
## Further it contains the coefficients of 
## an identity that expresses Lie brackets
## in terms of a linear combination of logarithms of group 
## commutators.  
## 
## This was computed with the code in gap/bch.gi
##
##
#H  @(#)$Id$
##
#Y 2006
##
GUARANA.recBCH := 
rec( 
length := 9,
bchSers := 
        [ [ [ -1/2, [ 2, 1 ] ] ], [ [ -1/12, [ 2, 1, 2 ] ], [ 1/12, [ 2, 1, 1 
                     ] ] ], [ [ 1/24, [ 2, 1, 2, 1 ] ] ], 
          [ [ 1/720, [ 2, 1, 2, 2, 2 ] ], [ -1/360, [ 2, 1, 2, 2, 1 ] ], 
              [ 1/90, [ 2, 1, 2, 1, 2 ] ], [ -1/360, [ 2, 1, 1, 2, 2 ] ], 
              [ -1/240, [ 2, 1, 2, 1, 1 ] ], [ -1/240, [ 2, 1, 1, 2, 1 ] ], 
              [ 1/360, [ 2, 1, 1, 1, 2 ] ], [ -1/720, [ 2, 1, 1, 1, 1 ] ] ], 
          [ [ -1/1440, [ 2, 1, 2, 2, 2, 1 ] ], 
              [ 1/720, [ 2, 1, 2, 2, 1, 1 ] ], 
              [ -1/180, [ 2, 1, 2, 1, 2, 1 ] ], 
              [ 1/720, [ 2, 1, 1, 2, 2, 1 ] ], 
              [ -1/720, [ 2, 1, 2, 1, 1, 1 ] ], 
              [ 1/480, [ 2, 1, 1, 2, 1, 1 ] ], 
              [ -1/720, [ 2, 1, 1, 1, 2, 1 ] ] ], 
          [ [ -1/30240, [ 2, 1, 2, 2, 2, 2, 2 ] ], 
              [ 1/10080, [ 2, 1, 2, 2, 2, 2, 1 ] ], 
              [ -1/3150, [ 2, 1, 2, 2, 2, 1, 2 ] ], 
              [ 1/4200, [ 2, 1, 2, 2, 1, 2, 2 ] ], 
              [ -1/3150, [ 2, 1, 2, 1, 2, 2, 2 ] ], 
              [ 1/10080, [ 2, 1, 1, 2, 2, 2, 2 ] ], 
              [ -1/20160, [ 2, 1, 2, 2, 2, 1, 1 ] ], 
              [ 1/3360, [ 2, 1, 2, 2, 1, 2, 1 ] ], 
              [ 1/3360, [ 2, 1, 2, 2, 1, 1, 2 ] ], 
              [ 1/3360, [ 2, 1, 2, 1, 2, 2, 1 ] ], 
              [ -1/560, [ 2, 1, 2, 1, 2, 1, 2 ] ], 
              [ 1/3360, [ 2, 1, 2, 1, 1, 2, 2 ] ], 
              [ -1/20160, [ 2, 1, 1, 2, 2, 2, 1 ] ], 
              [ 1/3360, [ 2, 1, 1, 2, 2, 1, 2 ] ], 
              [ 1/3360, [ 2, 1, 1, 2, 1, 2, 2 ] ], 
              [ -1/6048, [ 2, 1, 1, 1, 2, 2, 2 ] ], 
              [ -1/15120, [ 2, 1, 2, 2, 1, 1, 1 ] ], 
              [ 1/2520, [ 2, 1, 2, 1, 2, 1, 1 ] ], 
              [ 1/2520, [ 2, 1, 2, 1, 1, 2, 1 ] ], 
              [ -1/1890, [ 2, 1, 2, 1, 1, 1, 2 ] ], 
              [ -1/3360, [ 2, 1, 1, 2, 2, 1, 1 ] ], 
              [ 1/2520, [ 2, 1, 1, 2, 1, 2, 1 ] ], 
              [ 1/2520, [ 2, 1, 1, 2, 1, 1, 2 ] ], 
              [ -1/15120, [ 2, 1, 1, 1, 2, 2, 1 ] ], 
              [ -1/1890, [ 2, 1, 1, 1, 2, 1, 2 ] ], 
              [ 1/6048, [ 2, 1, 1, 1, 1, 2, 2 ] ], 
              [ 1/4032, [ 2, 1, 2, 1, 1, 1, 1 ] ], 
              [ -1/10080, [ 2, 1, 1, 2, 1, 1, 1 ] ], 
              [ -1/10080, [ 2, 1, 1, 1, 2, 1, 1 ] ], 
              [ 1/4032, [ 2, 1, 1, 1, 1, 2, 1 ] ], 
              [ -1/10080, [ 2, 1, 1, 1, 1, 1, 2 ] ], 
              [ 1/30240, [ 2, 1, 1, 1, 1, 1, 1 ] ] ], 
          [ [ 1/60480, [ 2, 1, 2, 2, 2, 2, 2, 1 ] ], 
              [ -1/20160, [ 2, 1, 2, 2, 2, 2, 1, 1 ] ], 
              [ 1/6300, [ 2, 1, 2, 2, 2, 1, 2, 1 ] ], 
              [ -1/8400, [ 2, 1, 2, 2, 1, 2, 2, 1 ] ], 
              [ 1/6300, [ 2, 1, 2, 1, 2, 2, 2, 1 ] ], 
              [ -1/20160, [ 2, 1, 1, 2, 2, 2, 2, 1 ] ], 
              [ 1/12096, [ 2, 1, 2, 2, 2, 1, 1, 1 ] ], 
              [ -1/6720, [ 2, 1, 2, 2, 1, 2, 1, 1 ] ], 
              [ -1/6720, [ 2, 1, 2, 2, 1, 1, 2, 1 ] ], 
              [ -1/6720, [ 2, 1, 2, 1, 2, 2, 1, 1 ] ], 
              [ 1/1120, [ 2, 1, 2, 1, 2, 1, 2, 1 ] ], 
              [ -1/6720, [ 2, 1, 2, 1, 1, 2, 2, 1 ] ], 
              [ 1/40320, [ 2, 1, 1, 2, 2, 2, 1, 1 ] ], 
              [ -1/6720, [ 2, 1, 1, 2, 2, 1, 2, 1 ] ], 
              [ -1/6720, [ 2, 1, 1, 2, 1, 2, 2, 1 ] ], 
              [ 1/12096, [ 2, 1, 1, 1, 2, 2, 2, 1 ] ], 
              [ -1/12096, [ 2, 1, 2, 2, 1, 1, 1, 1 ] ], 
              [ 1/3780, [ 2, 1, 2, 1, 2, 1, 1, 1 ] ], 
              [ -1/5040, [ 2, 1, 2, 1, 1, 2, 1, 1 ] ], 
              [ 1/3780, [ 2, 1, 2, 1, 1, 1, 2, 1 ] ], 
              [ 1/30240, [ 2, 1, 1, 2, 2, 1, 1, 1 ] ], 
              [ -1/5040, [ 2, 1, 1, 2, 1, 2, 1, 1 ] ], 
              [ -1/5040, [ 2, 1, 1, 2, 1, 1, 2, 1 ] ], 
              [ 1/30240, [ 2, 1, 1, 1, 2, 2, 1, 1 ] ], 
              [ 1/3780, [ 2, 1, 1, 1, 2, 1, 2, 1 ] ], 
              [ -1/12096, [ 2, 1, 1, 1, 1, 2, 2, 1 ] ], 
              [ 1/20160, [ 2, 1, 2, 1, 1, 1, 1, 1 ] ], 
              [ -1/8064, [ 2, 1, 1, 2, 1, 1, 1, 1 ] ], 
              [ 1/6048, [ 2, 1, 1, 1, 2, 1, 1, 1 ] ], 
              [ -1/8064, [ 2, 1, 1, 1, 1, 2, 1, 1 ] ], 
              [ 1/20160, [ 2, 1, 1, 1, 1, 1, 2, 1 ] ] ], 
          [ [ 1/1209600, [ 2, 1, 2, 2, 2, 2, 2, 2, 2 ] ], 
              [ -1/302400, [ 2, 1, 2, 2, 2, 2, 2, 2, 1 ] ], 
              [ 1/88200, [ 2, 1, 2, 2, 2, 2, 2, 1, 2 ] ], 
              [ -1/70560, [ 2, 1, 2, 2, 2, 2, 1, 2, 2 ] ], 
              [ 1/52920, [ 2, 1, 2, 2, 2, 1, 2, 2, 2 ] ], 
              [ -1/70560, [ 2, 1, 2, 2, 1, 2, 2, 2, 2 ] ], 
              [ 1/88200, [ 2, 1, 2, 1, 2, 2, 2, 2, 2 ] ], 
              [ -1/302400, [ 2, 1, 1, 2, 2, 2, 2, 2, 2 ] ], 
              [ 1/201600, [ 2, 1, 2, 2, 2, 2, 2, 1, 1 ] ], 
              [ -1/60480, [ 2, 1, 2, 2, 2, 2, 1, 2, 1 ] ], 
              [ -1/60480, [ 2, 1, 2, 2, 2, 2, 1, 1, 2 ] ], 
              [ 1/15120, [ 2, 1, 2, 2, 2, 1, 2, 1, 2 ] ], 
              [ -1/30240, [ 2, 1, 2, 2, 1, 2, 2, 1, 2 ] ], 
              [ -1/30240, [ 2, 1, 2, 2, 1, 2, 1, 2, 2 ] ], 
              [ -1/60480, [ 2, 1, 2, 1, 2, 2, 2, 2, 1 ] ], 
              [ 1/15120, [ 2, 1, 2, 1, 2, 2, 2, 1, 2 ] ], 
              [ -1/30240, [ 2, 1, 2, 1, 2, 2, 1, 2, 2 ] ], 
              [ 1/15120, [ 2, 1, 2, 1, 2, 1, 2, 2, 2 ] ], 
              [ -1/60480, [ 2, 1, 2, 1, 1, 2, 2, 2, 2 ] ], 
              [ 1/201600, [ 2, 1, 1, 2, 2, 2, 2, 2, 1 ] ], 
              [ -1/60480, [ 2, 1, 1, 2, 2, 2, 2, 1, 2 ] ], 
              [ -1/60480, [ 2, 1, 1, 2, 1, 2, 2, 2, 2 ] ], 
              [ 1/129600, [ 2, 1, 1, 1, 2, 2, 2, 2, 2 ] ], 
              [ -1/302400, [ 2, 1, 2, 2, 2, 2, 1, 1, 1 ] ], 
              [ 1/37800, [ 2, 1, 2, 2, 2, 1, 1, 1, 2 ] ], 
              [ 1/50400, [ 2, 1, 2, 2, 1, 2, 2, 1, 1 ] ], 
              [ -1/25200, [ 2, 1, 2, 2, 1, 2, 1, 2, 1 ] ], 
              [ -1/25200, [ 2, 1, 2, 2, 1, 2, 1, 1, 2 ] ], 
              [ 1/50400, [ 2, 1, 2, 2, 1, 1, 2, 2, 1 ] ], 
              [ -1/25200, [ 2, 1, 2, 2, 1, 1, 2, 1, 2 ] ], 
              [ -1/25200, [ 2, 1, 2, 1, 2, 2, 1, 2, 1 ] ], 
              [ -1/25200, [ 2, 1, 2, 1, 2, 2, 1, 1, 2 ] ], 
              [ -1/25200, [ 2, 1, 2, 1, 2, 1, 2, 2, 1 ] ], 
              [ 1/3150, [ 2, 1, 2, 1, 2, 1, 2, 1, 2 ] ], 
              [ -1/25200, [ 2, 1, 2, 1, 2, 1, 1, 2, 2 ] ], 
              [ -1/25200, [ 2, 1, 2, 1, 1, 2, 2, 1, 2 ] ], 
              [ -1/25200, [ 2, 1, 2, 1, 1, 2, 1, 2, 2 ] ], 
              [ 1/37800, [ 2, 1, 2, 1, 1, 1, 2, 2, 2 ] ], 
              [ 1/201600, [ 2, 1, 1, 2, 2, 2, 2, 1, 1 ] ], 
              [ 1/50400, [ 2, 1, 1, 2, 2, 1, 2, 2, 1 ] ], 
              [ -1/25200, [ 2, 1, 1, 2, 2, 1, 2, 1, 2 ] ], 
              [ 1/50400, [ 2, 1, 1, 2, 2, 1, 1, 2, 2 ] ], 
              [ -1/25200, [ 2, 1, 1, 2, 1, 2, 2, 1, 2 ] ], 
              [ -1/25200, [ 2, 1, 1, 2, 1, 2, 1, 2, 2 ] ], 
              [ -1/302400, [ 2, 1, 1, 1, 2, 2, 2, 2, 1 ] ], 
              [ 1/37800, [ 2, 1, 1, 1, 2, 2, 2, 1, 2 ] ], 
              [ 1/37800, [ 2, 1, 1, 1, 2, 1, 2, 2, 2 ] ], 
              [ -1/86400, [ 2, 1, 1, 1, 1, 2, 2, 2, 2 ] ], 
              [ -1/241920, [ 2, 1, 2, 2, 2, 1, 1, 1, 1 ] ], 
              [ 1/40320, [ 2, 1, 2, 2, 1, 1, 2, 1, 1 ] ], 
              [ -1/40320, [ 2, 1, 2, 2, 1, 1, 1, 1, 2 ] ], 
              [ -1/20160, [ 2, 1, 2, 1, 2, 1, 2, 1, 1 ] ], 
              [ -1/20160, [ 2, 1, 2, 1, 2, 1, 1, 2, 1 ] ], 
              [ 1/10080, [ 2, 1, 2, 1, 2, 1, 1, 1, 2 ] ], 
              [ 1/40320, [ 2, 1, 2, 1, 1, 2, 2, 1, 1 ] ], 
              [ -1/20160, [ 2, 1, 2, 1, 1, 2, 1, 2, 1 ] ], 
              [ -1/20160, [ 2, 1, 2, 1, 1, 2, 1, 1, 2 ] ], 
              [ 1/10080, [ 2, 1, 2, 1, 1, 1, 2, 1, 2 ] ], 
              [ -1/40320, [ 2, 1, 2, 1, 1, 1, 1, 2, 2 ] ], 
              [ -1/120960, [ 2, 1, 1, 2, 2, 2, 1, 1, 1 ] ], 
              [ 1/40320, [ 2, 1, 1, 2, 2, 1, 2, 1, 1 ] ], 
              [ 1/40320, [ 2, 1, 1, 2, 2, 1, 1, 2, 1 ] ], 
              [ 1/40320, [ 2, 1, 1, 2, 1, 2, 2, 1, 1 ] ], 
              [ -1/20160, [ 2, 1, 1, 2, 1, 2, 1, 2, 1 ] ], 
              [ -1/20160, [ 2, 1, 1, 2, 1, 2, 1, 1, 2 ] ], 
              [ 1/40320, [ 2, 1, 1, 2, 1, 1, 2, 2, 1 ] ], 
              [ -1/20160, [ 2, 1, 1, 2, 1, 1, 2, 1, 2 ] ], 
              [ -1/120960, [ 2, 1, 1, 1, 2, 2, 2, 1, 1 ] ], 
              [ 1/10080, [ 2, 1, 1, 1, 2, 1, 2, 1, 2 ] ], 
              [ -1/241920, [ 2, 1, 1, 1, 1, 2, 2, 2, 1 ] ], 
              [ -1/40320, [ 2, 1, 1, 1, 1, 2, 2, 1, 2 ] ], 
              [ -1/40320, [ 2, 1, 1, 1, 1, 2, 1, 2, 2 ] ], 
              [ 1/86400, [ 2, 1, 1, 1, 1, 1, 2, 2, 2 ] ], 
              [ 1/100800, [ 2, 1, 2, 2, 1, 1, 1, 1, 1 ] ], 
              [ -1/30240, [ 2, 1, 2, 1, 2, 1, 1, 1, 1 ] ], 
              [ -1/30240, [ 2, 1, 2, 1, 1, 1, 1, 2, 1 ] ], 
              [ 1/37800, [ 2, 1, 2, 1, 1, 1, 1, 1, 2 ] ], 
              [ 1/120960, [ 2, 1, 1, 2, 2, 1, 1, 1, 1 ] ], 
              [ 1/30240, [ 2, 1, 1, 2, 1, 1, 2, 1, 1 ] ], 
              [ -1/30240, [ 2, 1, 1, 2, 1, 1, 1, 1, 2 ] ], 
              [ -1/90720, [ 2, 1, 1, 1, 2, 2, 1, 1, 1 ] ], 
              [ 1/22680, [ 2, 1, 1, 1, 2, 1, 1, 1, 2 ] ], 
              [ 1/120960, [ 2, 1, 1, 1, 1, 2, 2, 1, 1 ] ], 
              [ -1/30240, [ 2, 1, 1, 1, 1, 2, 1, 2, 1 ] ], 
              [ -1/30240, [ 2, 1, 1, 1, 1, 2, 1, 1, 2 ] ], 
              [ 1/100800, [ 2, 1, 1, 1, 1, 1, 2, 2, 1 ] ], 
              [ 1/37800, [ 2, 1, 1, 1, 1, 1, 2, 1, 2 ] ], 
              [ -1/129600, [ 2, 1, 1, 1, 1, 1, 1, 2, 2 ] ], 
              [ -1/86400, [ 2, 1, 2, 1, 1, 1, 1, 1, 1 ] ], 
              [ 1/67200, [ 2, 1, 1, 2, 1, 1, 1, 1, 1 ] ], 
              [ -1/120960, [ 2, 1, 1, 1, 2, 1, 1, 1, 1 ] ], 
              [ -1/120960, [ 2, 1, 1, 1, 1, 2, 1, 1, 1 ] ], 
              [ 1/67200, [ 2, 1, 1, 1, 1, 1, 2, 1, 1 ] ], 
              [ -1/86400, [ 2, 1, 1, 1, 1, 1, 1, 2, 1 ] ], 
              [ 1/302400, [ 2, 1, 1, 1, 1, 1, 1, 1, 2 ] ], 
              [ -1/1209600, [ 2, 1, 1, 1, 1, 1, 1, 1, 1 ] ] ] ], 
      bchLBITOL := [ [ [-1, [ 2, 1 ] ] ], 
          [ [ 1/2, [ 2, 1, 2 ] ], [ 1/2, [ 2, 1, 1 ] ] ], 
          [ [ -1/3, [ 2, 1, 2, 2 ] ], [ -1/4, [ 2, 1, 2, 1 ] ], 
              [ -1/3, [ 2, 1, 1, 1 ] ] ], 
          [ [ 1/4, [ 2, 1, 2, 2, 2 ] ], [ 7/24, [ 2, 1, 2, 1, 1 ] ], 
              [ -3/8, [ 2, 1, 1, 2, 1 ] ], [ 1/4, [ 2, 1, 1, 1, 2 ] ], 
              [ 1/4, [ 2, 1, 1, 1, 1 ] ], [ 2/9, [ 2, 1, 2, 1, 2 ] ], 
              [ -1/18, [ 2, 1, 1, 2, 2 ] ] ], 
          [ [ -1/5, [ 2, 1, 2, 2, 2, 2 ] ], [ -1/36, [ 2, 1, 2, 2, 2, 1 ] ], 
              [ 1/216, [ 2, 1, 2, 2, 1, 1 ] ], 
              [ -1/54, [ 2, 1, 2, 1, 2, 1 ] ], 
              [ -11/54, [ 2, 1, 2, 1, 1, 2 ] ], 
              [ 1/216, [ 2, 1, 1, 2, 2, 1 ] ], 
              [ 11/54, [ 2, 1, 1, 2, 1, 2 ] ], 
              [ -11/108, [ 2, 1, 1, 1, 2, 2 ] ], 
              [ -13/48, [ 2, 1, 2, 1, 1, 1 ] ], 
              [ 7/16, [ 2, 1, 1, 2, 1, 1 ] ], [ -7/24, [ 2, 1, 1, 1, 2, 1 ] ],
              [ -1/5, [ 2, 1, 1, 1, 1, 1 ] ], [ -7/48, [ 2, 1, 2, 1, 2, 2 ] ],
              [ 7/144, [ 2, 1, 1, 2, 2, 2 ] ] ], 
          [ [ 1/6, [ 2, 1, 2, 2, 2, 2, 2 ] ], 
              [ -1/9, [ 2, 1, 2, 2, 2, 2, 1 ] ], 
              [ -1/36, [ 2, 1, 2, 2, 2, 1, 1 ] ], 
              [ -1/27, [ 2, 1, 2, 2, 1, 2, 1 ] ], 
              [ 61/864, [ 2, 1, 2, 2, 1, 1, 2 ] ], 
              [ 25/108, [ 2, 1, 2, 1, 2, 2, 1 ] ], 
              [ -5/24, [ 2, 1, 2, 1, 2, 1, 2 ] ], 
              [ 73/576, [ 2, 1, 2, 1, 1, 2, 2 ] ], 
              [ -1/12, [ 2, 1, 1, 2, 2, 2, 1 ] ], 
              [ 61/864, [ 2, 1, 1, 2, 2, 1, 2 ] ], 
              [ -161/1728, [ 2, 1, 1, 2, 1, 2, 2 ] ], 
              [ 29/864, [ 2, 1, 1, 1, 2, 2, 2 ] ], 
              [ -17/432, [ 2, 1, 2, 2, 1, 1, 1 ] ], 
              [ -17/81, [ 2, 1, 2, 1, 2, 1, 1 ] ], 
              [ 131/162, [ 2, 1, 2, 1, 1, 2, 1 ] ], 
              [ -73/1296, [ 2, 1, 1, 2, 2, 1, 1 ] ], 
              [ -121/324, [ 2, 1, 1, 2, 1, 2, 1 ] ], 
              [ 7/27, [ 2, 1, 1, 1, 2, 2, 1 ] ], 
              [ 113/480, [ 2, 1, 2, 1, 1, 1, 1 ] ], 
              [ -35/96, [ 2, 1, 1, 2, 1, 1, 1 ] ], 
              [ 5/48, [ 2, 1, 1, 1, 2, 1, 1 ] ], 
              [ 5/24, [ 2, 1, 1, 1, 1, 2, 1 ] ], 
              [ -1/12, [ 2, 1, 1, 1, 1, 1, 2 ] ], 
              [ 1/6, [ 2, 1, 1, 1, 1, 1, 1 ] ], 
              [ -41/108, [ 2, 1, 2, 1, 1, 1, 2 ] ], 
              [ 19/54, [ 2, 1, 1, 2, 1, 1, 2 ] ], 
              [ -41/108, [ 2, 1, 1, 1, 2, 1, 2 ] ], 
              [ 7/20, [ 2, 1, 2, 2, 2, 1, 2 ] ], 
              [ -21/80, [ 2, 1, 2, 2, 1, 2, 2 ] ], 
              [ 293/1800, [ 2, 1, 2, 1, 2, 2, 2 ] ], 
              [ -47/1200, [ 2, 1, 1, 2, 2, 2, 2 ] ], 
              [ 11/108, [ 2, 1, 1, 1, 1, 2, 2 ] ] ], 
          [ [ -1/7, [ 2, 1, 2, 2, 2, 2, 2, 2 ] ], 
              [ 7/120, [ 2, 1, 2, 2, 2, 2, 2, 1 ] ], 
              [ 659/7200, [ 2, 1, 2, 2, 2, 2, 1, 1 ] ], 
              [ -739/4320, [ 2, 1, 2, 2, 2, 1, 2, 1 ] ], 
              [ -41/4320, [ 2, 1, 2, 2, 2, 1, 1, 2 ] ], 
              [ 1097/3600, [ 2, 1, 2, 2, 1, 2, 2, 1 ] ], 
              [ -173/800, [ 2, 1, 2, 2, 1, 2, 1, 2 ] ], 
              [ 2297/72000, [ 2, 1, 2, 2, 1, 1, 2, 2 ] ], 
              [ -335/864, [ 2, 1, 2, 1, 2, 2, 2, 1 ] ], 
              [ 173/800, [ 2, 1, 2, 1, 2, 2, 1, 2 ] ], 
              [ 3191/36000, [ 2, 1, 2, 1, 2, 1, 2, 2 ] ], 
              [ -71/1080, [ 2, 1, 2, 1, 1, 2, 2, 2 ] ], 
              [ 1957/21600, [ 2, 1, 1, 2, 2, 2, 2, 1 ] ], 
              [ 41/4320, [ 2, 1, 1, 2, 2, 2, 1, 2 ] ], 
              [ -2171/24000, [ 2, 1, 1, 2, 2, 1, 2, 2 ] ], 
              [ 2467/54000, [ 2, 1, 1, 2, 1, 2, 2, 2 ] ], 
              [ -19/4000, [ 2, 1, 1, 1, 2, 2, 2, 2 ] ], 
              [ 595/10368, [ 2, 1, 2, 2, 2, 1, 1, 1 ] ], 
              [ 31/1296, [ 2, 1, 2, 2, 1, 2, 1, 1 ] ], 
              [ -1259/10368, [ 2, 1, 2, 2, 1, 1, 2, 1 ] ], 
              [ 2107/10368, [ 2, 1, 2, 1, 2, 2, 1, 1 ] ], 
              [ -553/1296, [ 2, 1, 2, 1, 2, 1, 2, 1 ] ], 
              [ -4019/10368, [ 2, 1, 2, 1, 1, 2, 2, 1 ] ], 
              [ -11/81, [ 2, 1, 1, 2, 2, 2, 1, 1 ] ], 
              [ 3223/10368, [ 2, 1, 1, 2, 2, 1, 2, 1 ] ], 
              [ 47/162, [ 2, 1, 1, 2, 1, 2, 2, 1 ] ], 
              [ -133/1152, [ 2, 1, 1, 1, 2, 2, 2, 1 ] ], 
              [ 2003/38880, [ 2, 1, 2, 2, 1, 1, 1, 1 ] ], 
              [ 241/486, [ 2, 1, 2, 1, 2, 1, 1, 1 ] ], 
              [ -679/486, [ 2, 1, 2, 1, 1, 2, 1, 1 ] ], 
              [ 139/216, [ 2, 1, 2, 1, 1, 1, 2, 1 ] ], 
              [ 7/108, [ 2, 1, 2, 1, 1, 1, 1, 2 ] ], 
              [ 1565/7776, [ 2, 1, 1, 2, 2, 1, 1, 1 ] ], 
              [ 409/1944, [ 2, 1, 1, 2, 1, 2, 1, 1 ] ], 
              [ -44/81, [ 2, 1, 1, 2, 1, 1, 2, 1 ] ], 
              [ -5/324, [ 2, 1, 1, 2, 1, 1, 1, 2 ] ], 
              [ -175/486, [ 2, 1, 1, 1, 2, 2, 1, 1 ] ], 
              [ 565/648, [ 2, 1, 1, 1, 2, 1, 2, 1 ] ], 
              [ 5/324, [ 2, 1, 1, 1, 2, 1, 1, 2 ] ], 
              [ -22/81, [ 2, 1, 1, 1, 1, 2, 2, 1 ] ], 
              [ -7/108, [ 2, 1, 1, 1, 1, 2, 1, 2 ] ], 
              [ 5/162, [ 2, 1, 1, 1, 1, 1, 2, 2 ] ], 
              [ -193/960, [ 2, 1, 2, 1, 1, 1, 1, 1 ] ], 
              [ 73/320, [ 2, 1, 1, 2, 1, 1, 1, 1 ] ], 
              [ 127/480, [ 2, 1, 1, 1, 2, 1, 1, 1 ] ], 
              [ -5/8, [ 2, 1, 1, 1, 1, 2, 1, 1 ] ], 
              [ 1/4, [ 2, 1, 1, 1, 1, 1, 2, 1 ] ], 
              [ -1/7, [ 2, 1, 1, 1, 1, 1, 1, 1 ] ], 
              [ 73/1152, [ 2, 1, 2, 2, 1, 1, 1, 2 ] ], 
              [ 31/128, [ 2, 1, 2, 1, 2, 1, 1, 2 ] ], 
              [ 523/2304, [ 2, 1, 2, 1, 1, 1, 2, 2 ] ], 
              [ -31/128, [ 2, 1, 1, 2, 1, 2, 1, 2 ] ], 
              [ -215/768, [ 2, 1, 1, 2, 1, 1, 2, 2 ] ], 
              [ -73/1152, [ 2, 1, 1, 1, 2, 2, 1, 2 ] ], 
              [ 79/192, [ 2, 1, 1, 1, 2, 1, 2, 2 ] ], 
              [ -113/300, [ 2, 1, 2, 2, 2, 1, 2, 2 ] ], 
              [ 113/300, [ 2, 1, 2, 2, 1, 2, 2, 2 ] ], 
              [ -13/75, [ 2, 1, 2, 1, 2, 2, 2, 2 ] ], 
              [ 19/600, [ 2, 1, 1, 2, 2, 2, 2, 2 ] ], 
              [ -413/3456, [ 2, 1, 1, 1, 1, 2, 2, 2 ] ] ], 
          [ [ 1/8, [ 2, 1, 2, 2, 2, 2, 2, 2, 2 ] ], 
              [ 11/180, [ 2, 1, 2, 2, 2, 2, 2, 2, 1 ] ], 
              [ -305/1728, [ 2, 1, 2, 2, 2, 2, 2, 1, 1 ] ], 
              [ 5257/8640, [ 2, 1, 2, 2, 2, 2, 1, 2, 1 ] ], 
              [ -5809/20250, [ 2, 1, 2, 2, 2, 2, 1, 1, 2 ] ], 
              [ -39041/43200, [ 2, 1, 2, 2, 2, 1, 2, 2, 1 ] ], 
              [ 66833/81000, [ 2, 1, 2, 2, 2, 1, 2, 1, 2 ] ], 
              [ -11323/324000, [ 2, 1, 2, 2, 2, 1, 1, 2, 2 ] ], 
              [ 39041/43200, [ 2, 1, 2, 2, 1, 2, 2, 2, 1 ] ], 
              [ -61907/36000, [ 2, 1, 2, 2, 1, 2, 2, 1, 2 ] ], 
              [ 104159/108000, [ 2, 1, 2, 2, 1, 2, 1, 2, 2 ] ], 
              [ -35689/162000, [ 2, 1, 2, 2, 1, 1, 2, 2, 2 ] ], 
              [ -2959/16200, [ 2, 1, 2, 1, 2, 2, 2, 2, 1 ] ], 
              [ 66833/81000, [ 2, 1, 2, 1, 2, 2, 2, 1, 2 ] ], 
              [ -2171/4500, [ 2, 1, 2, 1, 2, 2, 1, 2, 2 ] ], 
              [ -2243/27000, [ 2, 1, 2, 1, 2, 1, 2, 2, 2 ] ], 
              [ 9019/162000, [ 2, 1, 2, 1, 1, 2, 2, 2, 2 ] ], 
              [ 2821/64800, [ 2, 1, 1, 2, 2, 2, 2, 2, 1 ] ], 
              [ -5809/20250, [ 2, 1, 1, 2, 2, 2, 2, 1, 2 ] ], 
              [ 12709/64800, [ 2, 1, 1, 2, 2, 2, 1, 2, 2 ] ], 
              [ 371/12000, [ 2, 1, 1, 2, 2, 1, 2, 2, 2 ] ], 
              [ -1309/108000, [ 2, 1, 1, 2, 1, 2, 2, 2, 2 ] ], 
              [ -301/36000, [ 2, 1, 1, 1, 2, 2, 2, 2, 2 ] ], 
              [ -493/5184, [ 2, 1, 2, 2, 2, 2, 1, 1, 1 ] ], 
              [ 89473/324000, [ 2, 1, 2, 2, 2, 1, 2, 1, 1 ] ], 
              [ -166417/324000, [ 2, 1, 2, 2, 2, 1, 1, 2, 1 ] ], 
              [ -22559/48000, [ 2, 1, 2, 2, 1, 2, 2, 1, 1 ] ], 
              [ 1550789/1296000, [ 2, 1, 2, 2, 1, 2, 1, 2, 1 ] ], 
              [ -96023/324000, [ 2, 1, 2, 2, 1, 1, 2, 2, 1 ] ], 
              [ 12199/25920, [ 2, 1, 2, 1, 2, 2, 2, 1, 1 ] ], 
              [ -846227/1296000, [ 2, 1, 2, 1, 2, 2, 1, 2, 1 ] ], 
              [ -4807/432000, [ 2, 1, 2, 1, 2, 1, 2, 2, 1 ] ], 
              [ 121319/648000, [ 2, 1, 2, 1, 1, 2, 2, 2, 1 ] ], 
              [ -165239/1296000, [ 2, 1, 1, 2, 2, 2, 2, 1, 1 ] ], 
              [ 156731/648000, [ 2, 1, 1, 2, 2, 2, 1, 2, 1 ] ], 
              [ -255031/1296000, [ 2, 1, 1, 2, 2, 1, 2, 2, 1 ] ], 
              [ 96529/648000, [ 2, 1, 1, 2, 1, 2, 2, 2, 1 ] ], 
              [ -973/13500, [ 2, 1, 1, 1, 2, 2, 2, 2, 1 ] ], 
              [ -2467/34560, [ 2, 1, 2, 2, 2, 1, 1, 1, 1 ] ], 
              [ -2389/7776, [ 2, 1, 2, 2, 1, 2, 1, 1, 1 ] ], 
              [ 47663/41472, [ 2, 1, 2, 2, 1, 1, 2, 1, 1 ] ], 
              [ -27947/20736, [ 2, 1, 2, 2, 1, 1, 1, 2, 1 ] ], 
              [ 11489/20736, [ 2, 1, 2, 2, 1, 1, 1, 1, 2 ] ], 
              [ -32725/62208, [ 2, 1, 2, 1, 2, 2, 1, 1, 1 ] ], 
              [ 33805/62208, [ 2, 1, 2, 1, 2, 1, 2, 1, 1 ] ], 
              [ 3665/6912, [ 2, 1, 2, 1, 2, 1, 1, 2, 1 ] ], 
              [ -111/256, [ 2, 1, 2, 1, 2, 1, 1, 1, 2 ] ], 
              [ 139451/124416, [ 2, 1, 2, 1, 1, 2, 2, 1, 1 ] ], 
              [ -25145/20736, [ 2, 1, 2, 1, 1, 2, 1, 2, 1 ] ], 
              [ -14155/41472, [ 2, 1, 2, 1, 1, 2, 1, 1, 2 ] ], 
              [ -265/864, [ 2, 1, 2, 1, 1, 1, 2, 2, 1 ] ], 
              [ 3275/2592, [ 2, 1, 2, 1, 1, 1, 2, 1, 2 ] ], 
              [ -43811/82944, [ 2, 1, 2, 1, 1, 1, 1, 2, 2 ] ], 
              [ 2785/10368, [ 2, 1, 1, 2, 2, 2, 1, 1, 1 ] ], 
              [ -1283/6912, [ 2, 1, 1, 2, 2, 1, 2, 1, 1 ] ], 
              [ -41191/41472, [ 2, 1, 1, 2, 2, 1, 1, 2, 1 ] ], 
              [ 10303/20736, [ 2, 1, 1, 2, 2, 1, 1, 1, 2 ] ], 
              [ -16525/10368, [ 2, 1, 1, 2, 1, 2, 2, 1, 1 ] ], 
              [ 71387/20736, [ 2, 1, 1, 2, 1, 2, 1, 2, 1 ] ], 
              [ -20627/20736, [ 2, 1, 1, 2, 1, 2, 1, 1, 2 ] ], 
              [ -449/4608, [ 2, 1, 1, 2, 1, 1, 2, 2, 1 ] ], 
              [ -14155/41472, [ 2, 1, 1, 2, 1, 1, 2, 1, 2 ] ], 
              [ 20165/82944, [ 2, 1, 1, 2, 1, 1, 1, 2, 2 ] ], 
              [ 25589/31104, [ 2, 1, 1, 1, 2, 2, 2, 1, 1 ] ], 
              [ -3703/2592, [ 2, 1, 1, 1, 2, 2, 1, 2, 1 ] ], 
              [ 10303/20736, [ 2, 1, 1, 1, 2, 2, 1, 1, 2 ] ], 
              [ -1445/10368, [ 2, 1, 1, 1, 2, 1, 2, 2, 1 ] ], 
              [ -111/256, [ 2, 1, 1, 1, 2, 1, 2, 1, 2 ] ], 
              [ 6007/41472, [ 2, 1, 1, 1, 2, 1, 1, 2, 2 ] ], 
              [ -197/5184, [ 2, 1, 1, 1, 1, 2, 2, 2, 1 ] ], 
              [ 11489/20736, [ 2, 1, 1, 1, 1, 2, 2, 1, 2 ] ], 
              [ -2801/10368, [ 2, 1, 1, 1, 1, 2, 1, 2, 2 ] ], 
              [ 101/10368, [ 2, 1, 1, 1, 1, 1, 2, 2, 2 ] ], 
              [ -3731/77760, [ 2, 1, 2, 2, 1, 1, 1, 1, 1 ] ], 
              [ -11827/19440, [ 2, 1, 2, 1, 2, 1, 1, 1, 1 ] ], 
              [ 27569/29160, [ 2, 1, 2, 1, 1, 2, 1, 1, 1 ] ], 
              [ 281/243, [ 2, 1, 2, 1, 1, 1, 2, 1, 1 ] ], 
              [ -139/72, [ 2, 1, 2, 1, 1, 1, 1, 2, 1 ] ], 
              [ -25813/77760, [ 2, 1, 1, 2, 2, 1, 1, 1, 1 ] ], 
              [ -1687/14580, [ 2, 1, 1, 2, 1, 2, 1, 1, 1 ] ], 
              [ 1553/1944, [ 2, 1, 1, 2, 1, 1, 2, 1, 1 ] ], 
              [ 115/648, [ 2, 1, 1, 2, 1, 1, 1, 2, 1 ] ], 
              [ 3109/9720, [ 2, 1, 1, 1, 2, 2, 1, 1, 1 ] ], 
              [ -1027/972, [ 2, 1, 1, 1, 2, 1, 2, 1, 1 ] ], 
              [ -115/648, [ 2, 1, 1, 1, 2, 1, 1, 2, 1 ] ], 
              [ 2707/3888, [ 2, 1, 1, 1, 1, 2, 2, 1, 1 ] ], 
              [ -419/648, [ 2, 1, 1, 1, 1, 2, 1, 2, 1 ] ], 
              [ 1/12, [ 2, 1, 1, 1, 1, 1, 2, 2, 1 ] ], 
              [ 2311/13440, [ 2, 1, 2, 1, 1, 1, 1, 1, 1 ] ], 
              [ -43/384, [ 2, 1, 1, 2, 1, 1, 1, 1, 1 ] ], 
              [ -71/192, [ 2, 1, 1, 1, 2, 1, 1, 1, 1 ] ], 
              [ 1/96, [ 2, 1, 1, 1, 1, 2, 1, 1, 1 ] ], 
              [ 157/120, [ 2, 1, 1, 1, 1, 1, 2, 1, 1 ] ], 
              [ -21/16, [ 2, 1, 1, 1, 1, 1, 1, 2, 1 ] ], 
              [ 3/8, [ 2, 1, 1, 1, 1, 1, 1, 1, 2 ] ], 
              [ 1/8, [ 2, 1, 1, 1, 1, 1, 1, 1, 1 ] ], 
              [ 384107/1080000, [ 2, 1, 2, 2, 2, 1, 1, 1, 2 ] ], 
              [ -161999/216000, [ 2, 1, 2, 2, 1, 2, 1, 1, 2 ] ], 
              [ -368819/4320000, [ 2, 1, 2, 2, 1, 1, 1, 2, 2 ] ], 
              [ -429187/1080000, [ 2, 1, 2, 1, 2, 2, 1, 1, 2 ] ], 
              [ -122029/432000, [ 2, 1, 2, 1, 2, 1, 1, 2, 2 ] ], 
              [ 1219/120000, [ 2, 1, 2, 1, 1, 1, 2, 2, 2 ] ], 
              [ 190183/1080000, [ 2, 1, 1, 2, 2, 2, 1, 1, 2 ] ], 
              [ -429187/1080000, [ 2, 1, 1, 2, 2, 1, 2, 1, 2 ] ], 
              [ -161999/216000, [ 2, 1, 1, 2, 1, 2, 2, 1, 2 ] ], 
              [ 1937209/2160000, [ 2, 1, 1, 2, 1, 2, 1, 2, 2 ] ], 
              [ 80831/2160000, [ 2, 1, 1, 2, 1, 1, 2, 2, 2 ] ], 
              [ 384107/1080000, [ 2, 1, 1, 1, 2, 2, 2, 1, 2 ] ], 
              [ -527881/2160000, [ 2, 1, 1, 1, 2, 2, 1, 2, 2 ] ], 
              [ -119639/432000, [ 2, 1, 1, 1, 2, 1, 2, 2, 2 ] ], 
              [ 193/324, [ 2, 1, 2, 1, 1, 1, 1, 1, 2 ] ], 
              [ -65/324, [ 2, 1, 1, 2, 1, 1, 1, 1, 2 ] ], 
              [ 65/243, [ 2, 1, 1, 1, 2, 1, 1, 1, 2 ] ], 
              [ -65/324, [ 2, 1, 1, 1, 1, 2, 1, 1, 2 ] ], 
              [ 193/324, [ 2, 1, 1, 1, 1, 1, 2, 1, 2 ] ], 
              [ -641/2100, [ 2, 1, 2, 2, 2, 2, 2, 1, 2 ] ], 
              [ 641/1680, [ 2, 1, 2, 2, 2, 2, 1, 2, 2 ] ], 
              [ 983/6300, [ 2, 1, 2, 2, 2, 1, 2, 2, 2 ] ], 
              [ -3077/8400, [ 2, 1, 2, 2, 1, 2, 2, 2, 2 ] ], 
              [ 1669/9800, [ 2, 1, 2, 1, 2, 2, 2, 2, 2 ] ], 
              [ -51/1960, [ 2, 1, 1, 2, 2, 2, 2, 2, 2 ] ], 
              [ 246643/720000, [ 2, 1, 2, 2, 1, 1, 2, 1, 2 ] ], 
              [ 11513/10800, [ 2, 1, 2, 1, 2, 1, 2, 1, 2 ] ], 
              [ 246643/720000, [ 2, 1, 2, 1, 1, 2, 2, 1, 2 ] ], 
              [ -1315579/2160000, [ 2, 1, 2, 1, 1, 2, 1, 2, 2 ] ], 
              [ 11513/172800, [ 2, 1, 1, 2, 2, 1, 1, 2, 2 ] ], 
              [ 25799/240000, [ 2, 1, 1, 1, 1, 2, 2, 2, 2 ] ], 
              [ -257/972, [ 2, 1, 1, 1, 1, 1, 1, 2, 2 ] ] ] ] );

