#############################################################################
##
#W  ctprods32.g                GAP4 Package `RCWA'                Stefan Kohl
##
##  This file contains a database of pairs of class transpositions of Z
##  which interchange residue classes with moduli <= 32, whose product has
##  order distinct from 1, 2, 3, 4, 6, 10, 12, 15, 20, 30, 60 and infinity.
##  The orders which occur are 8, 24, 40, 42, 84, 120, 168 and 420.
##  The database comes in form of a list CTProds32 such that CTProds32[n] is
##  the list of pairs of such class transpositions whose product has order n.
##  Class transpositions are stored as lists of 4 integers, where a list
##  [ r1, m1, r2, m2 ] stands for the class transposition which interchanges
##  the residue classes r1(m1) and r2(m2).
##  The database is supposed to be either complete or almost complete,
##  although it is possible that some entries are missing.
## 
#############################################################################

return
[ ,,,,,,, 
  [ [ [ 0, 2, 5, 6 ], [ 2, 9, 8, 9 ] ], 
      [ [ 1, 2, 0, 6 ], [ 0, 9, 6, 9 ] ], 
      [ [ 0, 2, 9, 10 ], [ 4, 15, 14, 15 ] ], 
      [ [ 1, 2, 0, 10 ], [ 0, 15, 10, 15 ] ], 
      [ [ 0, 2, 5, 12 ], [ 2, 15, 14, 15 ] ], 
      [ [ 1, 2, 6, 12 ], [ 0, 15, 12, 15 ] ], 
      [ [ 0, 3, 1, 6 ], [ 3, 4, 9, 16 ] ], 
      [ [ 0, 3, 2, 6 ], [ 2, 4, 8, 16 ] ], 
      [ [ 0, 3, 4, 6 ], [ 0, 4, 6, 16 ] ], 
      [ [ 0, 3, 5, 6 ], [ 3, 4, 9, 16 ] ], 
      [ [ 1, 3, 0, 6 ], [ 2, 4, 8, 16 ] ], 
      [ [ 1, 3, 2, 6 ], [ 0, 4, 6, 16 ] ], 
      [ [ 1, 3, 3, 6 ], [ 3, 4, 9, 16 ] ], 
      [ [ 1, 3, 5, 6 ], [ 1, 4, 7, 16 ] ], 
      [ [ 2, 3, 0, 6 ], [ 0, 4, 6, 16 ] ], 
      [ [ 2, 3, 1, 6 ], [ 3, 4, 9, 16 ] ], 
      [ [ 2, 3, 3, 6 ], [ 1, 4, 7, 16 ] ], 
      [ [ 2, 3, 4, 6 ], [ 0, 4, 6, 16 ] ], 
      [ [ 0, 6, 4, 9 ], [ 0, 4, 6, 16 ] ], 
      [ [ 1, 6, 5, 9 ], [ 1, 4, 7, 16 ] ], 
      [ [ 2, 6, 0, 9 ], [ 2, 4, 8, 16 ] ], 
      [ [ 2, 6, 1, 9 ], [ 0, 4, 6, 16 ] ], 
      [ [ 2, 6, 6, 9 ], [ 2, 4, 8, 16 ] ], 
      [ [ 2, 6, 7, 9 ], [ 0, 4, 6, 16 ] ], 
      [ [ 3, 6, 1, 9 ], [ 3, 4, 9, 16 ] ], 
      [ [ 3, 6, 2, 9 ], [ 1, 4, 7, 16 ] ], 
      [ [ 3, 6, 7, 9 ], [ 3, 4, 9, 16 ] ], 
      [ [ 3, 6, 8, 9 ], [ 1, 4, 7, 16 ] ], 
      [ [ 4, 6, 3, 9 ], [ 2, 4, 8, 16 ] ], 
      [ [ 5, 6, 4, 9 ], [ 3, 4, 9, 16 ] ], 
      [ [ 0, 6, 5, 15 ], [ 2, 4, 8, 16 ] ], 
      [ [ 0, 6, 8, 15 ], [ 0, 4, 6, 16 ] ], 
      [ [ 1, 6, 6, 15 ], [ 3, 4, 9, 16 ] ], 
      [ [ 1, 6, 9, 15 ], [ 1, 4, 7, 16 ] ], 
      [ [ 2, 6, 0, 15 ], [ 2, 4, 8, 16 ] ], 
      [ [ 2, 6, 3, 15 ], [ 0, 4, 6, 16 ] ], 
      [ [ 2, 6, 10, 15 ], [ 2, 4, 8, 16 ] ], 
      [ [ 2, 6, 13, 15 ], [ 0, 4, 6, 16 ] ], 
      [ [ 3, 6, 1, 15 ], [ 3, 4, 9, 16 ] ], 
      [ [ 3, 6, 4, 15 ], [ 1, 4, 7, 16 ] ], 
      [ [ 3, 6, 11, 15 ], [ 3, 4, 9, 16 ] ], 
      [ [ 3, 6, 14, 15 ], [ 1, 4, 7, 16 ] ], 
      [ [ 4, 6, 5, 15 ], [ 2, 4, 8, 16 ] ], 
      [ [ 4, 6, 8, 15 ], [ 0, 4, 6, 16 ] ], 
      [ [ 5, 6, 6, 15 ], [ 3, 4, 9, 16 ] ], 
      [ [ 5, 6, 9, 15 ], [ 1, 4, 7, 16 ] ], 
      [ [ 0, 3, 7, 12 ], [ 3, 16, 15, 16 ] ], 
      [ [ 0, 3, 10, 12 ], [ 2, 16, 14, 16 ] ], 
      [ [ 1, 3, 0, 12 ], [ 0, 16, 12, 16 ] ], 
      [ [ 1, 3, 11, 12 ], [ 3, 16, 15, 16 ] ], 
      [ [ 2, 3, 1, 12 ], [ 1, 16, 13, 16 ] ], 
      [ [ 2, 3, 4, 12 ], [ 0, 16, 12, 16 ] ], 
      [ [ 0, 4, 6, 16 ], [ 0, 3, 4, 18 ] ], 
      [ [ 0, 4, 6, 16 ], [ 0, 3, 16, 18 ] ], 
      [ [ 0, 4, 6, 16 ], [ 2, 3, 4, 18 ] ], 
      [ [ 0, 4, 6, 16 ], [ 2, 3, 16, 18 ] ], 
      [ [ 1, 4, 7, 16 ], [ 0, 3, 11, 18 ] ], 
      [ [ 1, 4, 7, 16 ], [ 1, 3, 5, 18 ] ], 
      [ [ 1, 4, 7, 16 ], [ 1, 3, 17, 18 ] ], 
      [ [ 2, 4, 8, 16 ], [ 1, 3, 0, 18 ] ], 
      [ [ 2, 4, 8, 16 ], [ 1, 3, 12, 18 ] ], 
      [ [ 2, 4, 8, 16 ], [ 2, 3, 6, 18 ] ], 
      [ [ 3, 4, 9, 16 ], [ 0, 3, 1, 18 ] ], 
      [ [ 3, 4, 9, 16 ], [ 0, 3, 13, 18 ] ], 
      [ [ 3, 4, 9, 16 ], [ 2, 3, 1, 18 ] ], 
      [ [ 3, 4, 9, 16 ], [ 2, 3, 13, 18 ] ], 
      [ [ 0, 4, 6, 16 ], [ 4, 9, 16, 18 ] ], 
      [ [ 0, 4, 6, 16 ], [ 7, 9, 10, 18 ] ], 
      [ [ 1, 4, 7, 16 ], [ 5, 9, 17, 18 ] ], 
      [ [ 1, 4, 7, 16 ], [ 8, 9, 11, 18 ] ], 
      [ [ 2, 4, 8, 16 ], [ 0, 9, 6, 18 ] ], 
      [ [ 2, 4, 8, 16 ], [ 3, 9, 0, 18 ] ], 
      [ [ 3, 4, 9, 16 ], [ 1, 9, 7, 18 ] ], 
      [ [ 3, 4, 9, 16 ], [ 4, 9, 1, 18 ] ], 
      [ [ 0, 4, 6, 16 ], [ 3, 15, 10, 18 ] ], 
      [ [ 0, 4, 6, 16 ], [ 8, 15, 4, 18 ] ], 
      [ [ 0, 4, 6, 16 ], [ 8, 15, 16, 18 ] ], 
      [ [ 1, 4, 7, 16 ], [ 4, 15, 11, 18 ] ], 
      [ [ 1, 4, 7, 16 ], [ 9, 15, 5, 18 ] ], 
      [ [ 1, 4, 7, 16 ], [ 9, 15, 17, 18 ] ], 
      [ [ 2, 4, 8, 16 ], [ 5, 15, 0, 18 ] ], 
      [ [ 2, 4, 8, 16 ], [ 5, 15, 12, 18 ] ], 
      [ [ 2, 4, 8, 16 ], [ 10, 15, 6, 18 ] ], 
      [ [ 3, 4, 9, 16 ], [ 6, 15, 1, 18 ] ], 
      [ [ 3, 4, 9, 16 ], [ 6, 15, 13, 18 ] ], 
      [ [ 3, 4, 9, 16 ], [ 11, 15, 7, 18 ] ], 
      [ [ 0, 4, 10, 12 ], [ 4, 18, 16, 18 ] ], 
      [ [ 1, 4, 11, 12 ], [ 5, 18, 17, 18 ] ], 
      [ [ 2, 4, 0, 12 ], [ 0, 18, 12, 18 ] ], 
      [ [ 3, 4, 1, 12 ], [ 1, 18, 13, 18 ] ], 
      [ [ 0, 3, 11, 12 ], [ 7, 20, 19, 20 ] ], 
      [ [ 2, 3, 0, 12 ], [ 0, 20, 12, 20 ] ], 
      [ [ 0, 3, 4, 15 ], [ 4, 20, 19, 20 ] ], 
      [ [ 0, 3, 8, 15 ], [ 3, 20, 18, 20 ] ], 
      [ [ 1, 3, 5, 15 ], [ 0, 20, 15, 20 ] ], 
      [ [ 1, 3, 9, 15 ], [ 4, 20, 19, 20 ] ], 
      [ [ 2, 3, 6, 15 ], [ 1, 20, 16, 20 ] ], 
      [ [ 2, 3, 10, 15 ], [ 0, 20, 15, 20 ] ], 
      [ [ 0, 4, 6, 16 ], [ 2, 6, 19, 21 ] ], 
      [ [ 0, 4, 6, 16 ], [ 4, 6, 12, 21 ] ], 
      [ [ 1, 4, 7, 16 ], [ 3, 6, 20, 21 ] ], 
      [ [ 1, 4, 7, 16 ], [ 5, 6, 13, 21 ] ], 
      [ [ 2, 4, 8, 16 ], [ 0, 6, 7, 21 ] ], 
      [ [ 2, 4, 8, 16 ], [ 2, 6, 0, 21 ] ], 
      [ [ 3, 4, 9, 16 ], [ 1, 6, 8, 21 ] ], 
      [ [ 3, 4, 9, 16 ], [ 3, 6, 1, 21 ] ], 
      [ [ 0, 4, 6, 16 ], [ 4, 18, 12, 21 ] ], 
      [ [ 0, 4, 6, 16 ], [ 10, 18, 5, 21 ] ], 
      [ [ 0, 4, 6, 16 ], [ 16, 18, 12, 21 ] ], 
      [ [ 1, 4, 7, 16 ], [ 5, 18, 13, 21 ] ], 
      [ [ 1, 4, 7, 16 ], [ 11, 18, 6, 21 ] ], 
      [ [ 1, 4, 7, 16 ], [ 17, 18, 13, 21 ] ], 
      [ [ 2, 4, 8, 16 ], [ 0, 18, 7, 21 ] ], 
      [ [ 2, 4, 8, 16 ], [ 6, 18, 14, 21 ] ], 
      [ [ 2, 4, 8, 16 ], [ 12, 18, 7, 21 ] ], 
      [ [ 3, 4, 9, 16 ], [ 1, 18, 8, 21 ] ], 
      [ [ 3, 4, 9, 16 ], [ 7, 18, 15, 21 ] ], 
      [ [ 3, 4, 9, 16 ], [ 13, 18, 8, 21 ] ], 
      [ [ 0, 2, 3, 12 ], [ 6, 21, 18, 21 ] ], 
      [ [ 0, 2, 7, 12 ], [ 1, 21, 13, 21 ] ], 
      [ [ 1, 2, 4, 12 ], [ 7, 21, 19, 21 ] ], 
      [ [ 1, 2, 8, 12 ], [ 2, 21, 14, 21 ] ], 
      [ [ 0, 2, 3, 14 ], [ 3, 21, 17, 21 ] ], 
      [ [ 0, 2, 9, 14 ], [ 2, 21, 16, 21 ] ], 
      [ [ 1, 2, 4, 14 ], [ 4, 21, 18, 21 ] ], 
      [ [ 1, 2, 10, 14 ], [ 3, 21, 17, 21 ] ], 
      [ [ 0, 5, 1, 10 ], [ 3, 4, 13, 24 ] ], 
      [ [ 0, 5, 2, 10 ], [ 2, 4, 12, 24 ] ], 
      [ [ 0, 5, 3, 10 ], [ 1, 4, 11, 24 ] ], 
      [ [ 0, 5, 4, 10 ], [ 0, 4, 10, 24 ] ], 
      [ [ 0, 5, 6, 10 ], [ 2, 4, 12, 24 ] ], 
      [ [ 0, 5, 7, 10 ], [ 1, 4, 11, 24 ] ], 
      [ [ 0, 5, 8, 10 ], [ 0, 4, 10, 24 ] ], 
      [ [ 0, 5, 9, 10 ], [ 3, 4, 13, 24 ] ], 
      [ [ 1, 5, 0, 10 ], [ 2, 4, 12, 24 ] ], 
      [ [ 1, 5, 2, 10 ], [ 0, 4, 10, 24 ] ], 
      [ [ 1, 5, 3, 10 ], [ 3, 4, 13, 24 ] ], 
      [ [ 1, 5, 4, 10 ], [ 2, 4, 12, 24 ] ], 
      [ [ 1, 5, 5, 10 ], [ 1, 4, 11, 24 ] ], 
      [ [ 1, 5, 7, 10 ], [ 3, 4, 13, 24 ] ], 
      [ [ 1, 5, 8, 10 ], [ 2, 4, 12, 24 ] ], 
      [ [ 1, 5, 9, 10 ], [ 1, 4, 11, 24 ] ], 
      [ [ 2, 5, 0, 10 ], [ 0, 4, 10, 24 ] ], 
      [ [ 2, 5, 1, 10 ], [ 3, 4, 13, 24 ] ], 
      [ [ 2, 5, 3, 10 ], [ 1, 4, 11, 24 ] ], 
      [ [ 2, 5, 4, 10 ], [ 0, 4, 10, 24 ] ], 
      [ [ 2, 5, 5, 10 ], [ 3, 4, 13, 24 ] ], 
      [ [ 2, 5, 6, 10 ], [ 2, 4, 12, 24 ] ], 
      [ [ 2, 5, 8, 10 ], [ 0, 4, 10, 24 ] ], 
      [ [ 2, 5, 9, 10 ], [ 3, 4, 13, 24 ] ], 
      [ [ 3, 5, 0, 10 ], [ 2, 4, 12, 24 ] ], 
      [ [ 3, 5, 1, 10 ], [ 1, 4, 11, 24 ] ], 
      [ [ 3, 5, 2, 10 ], [ 0, 4, 10, 24 ] ], 
      [ [ 3, 5, 4, 10 ], [ 2, 4, 12, 24 ] ], 
      [ [ 3, 5, 5, 10 ], [ 1, 4, 11, 24 ] ], 
      [ [ 3, 5, 6, 10 ], [ 0, 4, 10, 24 ] ], 
      [ [ 3, 5, 7, 10 ], [ 3, 4, 13, 24 ] ], 
      [ [ 3, 5, 9, 10 ], [ 1, 4, 11, 24 ] ], 
      [ [ 4, 5, 0, 10 ], [ 0, 4, 10, 24 ] ], 
      [ [ 4, 5, 1, 10 ], [ 3, 4, 13, 24 ] ], 
      [ [ 4, 5, 2, 10 ], [ 2, 4, 12, 24 ] ], 
      [ [ 4, 5, 3, 10 ], [ 1, 4, 11, 24 ] ], 
      [ [ 4, 5, 5, 10 ], [ 3, 4, 13, 24 ] ], 
      [ [ 4, 5, 6, 10 ], [ 2, 4, 12, 24 ] ], 
      [ [ 4, 5, 7, 10 ], [ 1, 4, 11, 24 ] ], 
      [ [ 4, 5, 8, 10 ], [ 0, 4, 10, 24 ] ], 
      [ [ 0, 4, 10, 24 ], [ 0, 10, 8, 25 ] ], 
      [ [ 0, 4, 10, 24 ], [ 0, 10, 18, 25 ] ], 
      [ [ 0, 4, 10, 24 ], [ 2, 10, 3, 25 ] ], 
      [ [ 0, 4, 10, 24 ], [ 2, 10, 13, 25 ] ], 
      [ [ 0, 4, 10, 24 ], [ 2, 10, 23, 25 ] ], 
      [ [ 0, 4, 10, 24 ], [ 4, 10, 8, 25 ] ], 
      [ [ 0, 4, 10, 24 ], [ 4, 10, 18, 25 ] ], 
      [ [ 0, 4, 10, 24 ], [ 6, 10, 3, 25 ] ], 
      [ [ 0, 4, 10, 24 ], [ 6, 10, 13, 25 ] ], 
      [ [ 0, 4, 10, 24 ], [ 6, 10, 23, 25 ] ], 
      [ [ 1, 4, 11, 24 ], [ 1, 10, 9, 25 ] ], 
      [ [ 1, 4, 11, 24 ], [ 1, 10, 19, 25 ] ], 
      [ [ 1, 4, 11, 24 ], [ 3, 10, 4, 25 ] ], 
      [ [ 1, 4, 11, 24 ], [ 3, 10, 14, 25 ] ], 
      [ [ 1, 4, 11, 24 ], [ 3, 10, 24, 25 ] ], 
      [ [ 1, 4, 11, 24 ], [ 5, 10, 9, 25 ] ], 
      [ [ 1, 4, 11, 24 ], [ 5, 10, 19, 25 ] ], 
      [ [ 1, 4, 11, 24 ], [ 7, 10, 4, 25 ] ], 
      [ [ 1, 4, 11, 24 ], [ 7, 10, 14, 25 ] ], 
      [ [ 1, 4, 11, 24 ], [ 7, 10, 24, 25 ] ], 
      [ [ 2, 4, 12, 24 ], [ 2, 10, 0, 25 ] ], 
      [ [ 2, 4, 12, 24 ], [ 2, 10, 10, 25 ] ], 
      [ [ 2, 4, 12, 24 ], [ 2, 10, 20, 25 ] ], 
      [ [ 2, 4, 12, 24 ], [ 4, 10, 5, 25 ] ], 
      [ [ 2, 4, 12, 24 ], [ 4, 10, 15, 25 ] ], 
      [ [ 2, 4, 12, 24 ], [ 6, 10, 0, 25 ] ], 
      [ [ 2, 4, 12, 24 ], [ 6, 10, 10, 25 ] ], 
      [ [ 2, 4, 12, 24 ], [ 6, 10, 20, 25 ] ], 
      [ [ 2, 4, 12, 24 ], [ 8, 10, 5, 25 ] ], 
      [ [ 2, 4, 12, 24 ], [ 8, 10, 15, 25 ] ], 
      [ [ 3, 4, 13, 24 ], [ 3, 10, 1, 25 ] ], 
      [ [ 3, 4, 13, 24 ], [ 3, 10, 11, 25 ] ], 
      [ [ 3, 4, 13, 24 ], [ 3, 10, 21, 25 ] ], 
      [ [ 3, 4, 13, 24 ], [ 5, 10, 6, 25 ] ], 
      [ [ 3, 4, 13, 24 ], [ 5, 10, 16, 25 ] ], 
      [ [ 3, 4, 13, 24 ], [ 7, 10, 1, 25 ] ], 
      [ [ 3, 4, 13, 24 ], [ 7, 10, 11, 25 ] ], 
      [ [ 3, 4, 13, 24 ], [ 7, 10, 21, 25 ] ], 
      [ [ 3, 4, 13, 24 ], [ 9, 10, 6, 25 ] ], 
      [ [ 3, 4, 13, 24 ], [ 9, 10, 16, 25 ] ], 
      [ [ 0, 2, 1, 10 ], [ 6, 25, 16, 25 ] ], 
      [ [ 0, 2, 3, 10 ], [ 8, 25, 18, 25 ] ], 
      [ [ 0, 2, 5, 10 ], [ 5, 25, 15, 25 ] ], 
      [ [ 0, 2, 7, 10 ], [ 7, 25, 17, 25 ] ], 
      [ [ 0, 2, 9, 10 ], [ 4, 25, 14, 25 ] ], 
      [ [ 0, 2, 9, 10 ], [ 4, 25, 24, 25 ] ], 
      [ [ 1, 2, 0, 10 ], [ 0, 25, 20, 25 ] ], 
      [ [ 1, 2, 0, 10 ], [ 10, 25, 20, 25 ] ], 
      [ [ 1, 2, 2, 10 ], [ 7, 25, 17, 25 ] ], 
      [ [ 1, 2, 4, 10 ], [ 9, 25, 19, 25 ] ], 
      [ [ 1, 2, 6, 10 ], [ 6, 25, 16, 25 ] ], 
      [ [ 1, 2, 8, 10 ], [ 8, 25, 18, 25 ] ], 
      [ [ 0, 4, 3, 10 ], [ 3, 25, 23, 25 ] ], 
      [ [ 1, 4, 4, 10 ], [ 4, 25, 24, 25 ] ], 
      [ [ 2, 4, 5, 10 ], [ 0, 25, 20, 25 ] ], 
      [ [ 3, 4, 6, 10 ], [ 1, 25, 21, 25 ] ], 
      [ [ 0, 3, 1, 15 ], [ 6, 25, 21, 25 ] ], 
      [ [ 0, 3, 4, 15 ], [ 9, 25, 24, 25 ] ], 
      [ [ 0, 3, 5, 15 ], [ 5, 25, 20, 25 ] ], 
      [ [ 0, 3, 7, 15 ], [ 2, 25, 17, 25 ] ], 
      [ [ 0, 3, 8, 15 ], [ 8, 25, 23, 25 ] ], 
      [ [ 0, 3, 11, 15 ], [ 1, 25, 16, 25 ] ], 
      [ [ 0, 3, 13, 15 ], [ 3, 25, 18, 25 ] ], 
      [ [ 0, 3, 14, 15 ], [ 9, 25, 24, 25 ] ], 
      [ [ 1, 3, 0, 15 ], [ 5, 25, 20, 25 ] ], 
      [ [ 1, 3, 2, 15 ], [ 7, 25, 22, 25 ] ], 
      [ [ 1, 3, 5, 15 ], [ 0, 25, 15, 25 ] ], 
      [ [ 1, 3, 6, 15 ], [ 6, 25, 21, 25 ] ], 
      [ [ 1, 3, 8, 15 ], [ 3, 25, 18, 25 ] ], 
      [ [ 1, 3, 9, 15 ], [ 9, 25, 24, 25 ] ], 
      [ [ 1, 3, 12, 15 ], [ 2, 25, 17, 25 ] ], 
      [ [ 1, 3, 14, 15 ], [ 4, 25, 19, 25 ] ], 
      [ [ 2, 3, 0, 15 ], [ 0, 25, 15, 25 ] ], 
      [ [ 2, 3, 1, 15 ], [ 6, 25, 21, 25 ] ], 
      [ [ 2, 3, 3, 15 ], [ 8, 25, 23, 25 ] ], 
      [ [ 2, 3, 6, 15 ], [ 1, 25, 16, 25 ] ], 
      [ [ 2, 3, 7, 15 ], [ 7, 25, 22, 25 ] ], 
      [ [ 2, 3, 9, 15 ], [ 4, 25, 19, 25 ] ], 
      [ [ 2, 3, 10, 15 ], [ 0, 25, 15, 25 ] ], 
      [ [ 2, 3, 13, 15 ], [ 3, 25, 18, 25 ] ], 
      [ [ 0, 2, 7, 20 ], [ 2, 25, 22, 25 ] ], 
      [ [ 0, 2, 9, 20 ], [ 4, 25, 24, 25 ] ], 
      [ [ 0, 2, 11, 20 ], [ 1, 25, 21, 25 ] ], 
      [ [ 1, 2, 8, 20 ], [ 3, 25, 23, 25 ] ], 
      [ [ 1, 2, 10, 20 ], [ 0, 25, 20, 25 ] ], 
      [ [ 1, 2, 12, 20 ], [ 2, 25, 22, 25 ] ], 
      [ [ 0, 4, 9, 20 ], [ 4, 25, 24, 25 ] ], 
      [ [ 0, 4, 13, 20 ], [ 3, 25, 23, 25 ] ], 
      [ [ 0, 4, 17, 20 ], [ 2, 25, 22, 25 ] ], 
      [ [ 1, 4, 0, 20 ], [ 0, 25, 20, 25 ] ], 
      [ [ 1, 4, 14, 20 ], [ 4, 25, 24, 25 ] ], 
      [ [ 1, 4, 18, 20 ], [ 3, 25, 23, 25 ] ], 
      [ [ 2, 4, 1, 20 ], [ 1, 25, 21, 25 ] ], 
      [ [ 2, 4, 5, 20 ], [ 0, 25, 20, 25 ] ], 
      [ [ 2, 4, 19, 20 ], [ 4, 25, 24, 25 ] ], 
      [ [ 3, 4, 2, 20 ], [ 2, 25, 22, 25 ] ], 
      [ [ 3, 4, 6, 20 ], [ 1, 25, 21, 25 ] ], 
      [ [ 3, 4, 10, 20 ], [ 0, 25, 20, 25 ] ], 
      [ [ 0, 4, 6, 16 ], [ 0, 6, 16, 27 ] ], 
      [ [ 0, 4, 6, 16 ], [ 2, 6, 7, 27 ] ], 
      [ [ 0, 4, 6, 16 ], [ 2, 6, 25, 27 ] ], 
      [ [ 1, 4, 7, 16 ], [ 1, 6, 17, 27 ] ], 
      [ [ 1, 4, 7, 16 ], [ 3, 6, 8, 27 ] ], 
      [ [ 1, 4, 7, 16 ], [ 3, 6, 26, 27 ] ], 
      [ [ 2, 4, 8, 16 ], [ 2, 6, 0, 27 ] ], 
      [ [ 2, 4, 8, 16 ], [ 2, 6, 18, 27 ] ], 
      [ [ 2, 4, 8, 16 ], [ 4, 6, 9, 27 ] ], 
      [ [ 3, 4, 9, 16 ], [ 3, 6, 1, 27 ] ], 
      [ [ 3, 4, 9, 16 ], [ 3, 6, 19, 27 ] ], 
      [ [ 3, 4, 9, 16 ], [ 5, 6, 10, 27 ] ], 
      [ [ 0, 2, 1, 6 ], [ 4, 9, 10, 27 ] ], 
      [ [ 0, 2, 1, 6 ], [ 4, 9, 16, 27 ] ], 
      [ [ 0, 2, 3, 6 ], [ 3, 9, 9, 27 ] ], 
      [ [ 0, 2, 3, 6 ], [ 3, 9, 15, 27 ] ], 
      [ [ 0, 2, 5, 6 ], [ 2, 9, 8, 27 ] ], 
      [ [ 0, 2, 5, 6 ], [ 2, 9, 14, 27 ] ], 
      [ [ 0, 2, 5, 6 ], [ 2, 9, 26, 27 ] ], 
      [ [ 1, 2, 0, 6 ], [ 6, 9, 0, 27 ] ], 
      [ [ 1, 2, 0, 6 ], [ 6, 9, 12, 27 ] ], 
      [ [ 1, 2, 0, 6 ], [ 6, 9, 18, 27 ] ], 
      [ [ 1, 2, 2, 6 ], [ 5, 9, 11, 27 ] ], 
      [ [ 1, 2, 2, 6 ], [ 5, 9, 17, 27 ] ], 
      [ [ 1, 2, 4, 6 ], [ 4, 9, 10, 27 ] ], 
      [ [ 1, 2, 4, 6 ], [ 4, 9, 16, 27 ] ], 
      [ [ 0, 4, 1, 6 ], [ 7, 9, 1, 27 ] ], 
      [ [ 0, 4, 1, 6 ], [ 7, 9, 13, 27 ] ], 
      [ [ 0, 4, 3, 6 ], [ 3, 9, 9, 27 ] ], 
      [ [ 0, 4, 5, 6 ], [ 8, 9, 20, 27 ] ], 
      [ [ 1, 4, 0, 6 ], [ 3, 9, 15, 27 ] ], 
      [ [ 1, 4, 2, 6 ], [ 8, 9, 2, 27 ] ], 
      [ [ 1, 4, 2, 6 ], [ 8, 9, 14, 27 ] ], 
      [ [ 1, 4, 4, 6 ], [ 4, 9, 10, 27 ] ], 
      [ [ 2, 4, 1, 6 ], [ 4, 9, 16, 27 ] ], 
      [ [ 2, 4, 3, 6 ], [ 0, 9, 12, 27 ] ], 
      [ [ 2, 4, 3, 6 ], [ 0, 9, 24, 27 ] ], 
      [ [ 2, 4, 5, 6 ], [ 5, 9, 11, 27 ] ], 
      [ [ 3, 4, 0, 6 ], [ 0, 9, 6, 27 ] ], 
      [ [ 3, 4, 2, 6 ], [ 5, 9, 17, 27 ] ], 
      [ [ 3, 4, 4, 6 ], [ 1, 9, 13, 27 ] ], 
      [ [ 3, 4, 4, 6 ], [ 1, 9, 25, 27 ] ], 
      [ [ 0, 6, 1, 8 ], [ 6, 9, 0, 27 ] ], 
      [ [ 0, 6, 5, 8 ], [ 3, 9, 15, 27 ] ], 
      [ [ 0, 6, 7, 8 ], [ 6, 9, 12, 27 ] ], 
      [ [ 1, 6, 2, 8 ], [ 7, 9, 1, 27 ] ], 
      [ [ 1, 6, 6, 8 ], [ 4, 9, 16, 27 ] ], 
      [ [ 2, 6, 3, 8 ], [ 8, 9, 2, 27 ] ], 
      [ [ 2, 6, 7, 8 ], [ 5, 9, 17, 27 ] ], 
      [ [ 3, 6, 0, 8 ], [ 3, 9, 9, 27 ] ], 
      [ [ 3, 6, 4, 8 ], [ 0, 9, 24, 27 ] ], 
      [ [ 4, 6, 1, 8 ], [ 4, 9, 10, 27 ] ], 
      [ [ 4, 6, 5, 8 ], [ 1, 9, 25, 27 ] ], 
      [ [ 5, 6, 0, 8 ], [ 2, 9, 14, 27 ] ], 
      [ [ 5, 6, 2, 8 ], [ 5, 9, 11, 27 ] ], 
      [ [ 5, 6, 6, 8 ], [ 2, 9, 26, 27 ] ], 
      [ [ 0, 6, 3, 10 ], [ 0, 9, 24, 27 ] ], 
      [ [ 0, 6, 5, 10 ], [ 6, 9, 18, 27 ] ], 
      [ [ 0, 6, 7, 10 ], [ 3, 9, 15, 27 ] ], 
      [ [ 0, 6, 9, 10 ], [ 0, 9, 12, 27 ] ], 
      [ [ 1, 6, 0, 10 ], [ 7, 9, 1, 27 ] ], 
      [ [ 1, 6, 4, 10 ], [ 1, 9, 25, 27 ] ], 
      [ [ 1, 6, 6, 10 ], [ 7, 9, 19, 27 ] ], 
      [ [ 1, 6, 8, 10 ], [ 4, 9, 16, 27 ] ], 
      [ [ 2, 6, 1, 10 ], [ 8, 9, 2, 27 ] ], 
      [ [ 2, 6, 5, 10 ], [ 2, 9, 26, 27 ] ], 
      [ [ 2, 6, 7, 10 ], [ 8, 9, 20, 27 ] ], 
      [ [ 2, 6, 9, 10 ], [ 5, 9, 17, 27 ] ], 
      [ [ 3, 6, 0, 10 ], [ 3, 9, 9, 27 ] ], 
      [ [ 3, 6, 2, 10 ], [ 0, 9, 6, 27 ] ], 
      [ [ 3, 6, 4, 10 ], [ 6, 9, 0, 27 ] ], 
      [ [ 3, 6, 8, 10 ], [ 0, 9, 24, 27 ] ], 
      [ [ 4, 6, 1, 10 ], [ 4, 9, 10, 27 ] ], 
      [ [ 4, 6, 3, 10 ], [ 1, 9, 7, 27 ] ], 
      [ [ 4, 6, 5, 10 ], [ 7, 9, 1, 27 ] ], 
      [ [ 4, 6, 9, 10 ], [ 1, 9, 25, 27 ] ], 
      [ [ 5, 6, 0, 10 ], [ 8, 9, 14, 27 ] ], 
      [ [ 5, 6, 2, 10 ], [ 5, 9, 11, 27 ] ], 
      [ [ 5, 6, 4, 10 ], [ 2, 9, 8, 27 ] ], 
      [ [ 5, 6, 6, 10 ], [ 8, 9, 2, 27 ] ], 
      [ [ 0, 2, 1, 12 ], [ 7, 9, 19, 27 ] ], 
      [ [ 0, 2, 3, 12 ], [ 3, 9, 15, 27 ] ], 
      [ [ 0, 2, 5, 12 ], [ 8, 9, 2, 27 ] ], 
      [ [ 0, 2, 5, 12 ], [ 8, 9, 14, 27 ] ], 
      [ [ 0, 2, 7, 12 ], [ 4, 9, 10, 27 ] ], 
      [ [ 0, 2, 9, 12 ], [ 0, 9, 6, 27 ] ], 
      [ [ 0, 2, 11, 12 ], [ 5, 9, 17, 27 ] ], 
      [ [ 1, 2, 0, 12 ], [ 3, 9, 9, 27 ] ], 
      [ [ 1, 2, 2, 12 ], [ 8, 9, 20, 27 ] ], 
      [ [ 1, 2, 4, 12 ], [ 4, 9, 16, 27 ] ], 
      [ [ 1, 2, 6, 12 ], [ 0, 9, 12, 27 ] ], 
      [ [ 1, 2, 6, 12 ], [ 0, 9, 24, 27 ] ], 
      [ [ 1, 2, 8, 12 ], [ 5, 9, 11, 27 ] ], 
      [ [ 1, 2, 10, 12 ], [ 1, 9, 7, 27 ] ], 
      [ [ 0, 4, 2, 12 ], [ 8, 9, 20, 27 ] ], 
      [ [ 0, 4, 6, 12 ], [ 6, 9, 18, 27 ] ], 
      [ [ 0, 4, 10, 12 ], [ 4, 9, 16, 27 ] ], 
      [ [ 1, 4, 3, 12 ], [ 0, 9, 6, 27 ] ], 
      [ [ 1, 4, 7, 12 ], [ 7, 9, 19, 27 ] ], 
      [ [ 1, 4, 11, 12 ], [ 5, 9, 17, 27 ] ], 
      [ [ 2, 4, 0, 12 ], [ 3, 9, 9, 27 ] ], 
      [ [ 2, 4, 4, 12 ], [ 1, 9, 7, 27 ] ], 
      [ [ 2, 4, 8, 12 ], [ 8, 9, 20, 27 ] ], 
      [ [ 3, 4, 1, 12 ], [ 4, 9, 10, 27 ] ], 
      [ [ 3, 4, 5, 12 ], [ 2, 9, 8, 27 ] ], 
      [ [ 3, 4, 9, 12 ], [ 0, 9, 6, 27 ] ], 
      [ [ 0, 8, 6, 12 ], [ 6, 9, 18, 27 ] ], 
      [ [ 0, 8, 10, 12 ], [ 7, 9, 13, 27 ] ], 
      [ [ 1, 8, 3, 12 ], [ 6, 9, 0, 27 ] ], 
      [ [ 1, 8, 7, 12 ], [ 7, 9, 19, 27 ] ], 
      [ [ 1, 8, 11, 12 ], [ 8, 9, 14, 27 ] ], 
      [ [ 2, 8, 4, 12 ], [ 7, 9, 1, 27 ] ], 
      [ [ 2, 8, 8, 12 ], [ 8, 9, 20, 27 ] ], 
      [ [ 3, 8, 5, 12 ], [ 8, 9, 2, 27 ] ], 
      [ [ 4, 8, 6, 12 ], [ 0, 9, 24, 27 ] ], 
      [ [ 5, 8, 3, 12 ], [ 0, 9, 6, 27 ] ], 
      [ [ 5, 8, 7, 12 ], [ 1, 9, 25, 27 ] ], 
      [ [ 6, 8, 0, 12 ], [ 0, 9, 12, 27 ] ], 
      [ [ 6, 8, 4, 12 ], [ 1, 9, 7, 27 ] ], 
      [ [ 6, 8, 8, 12 ], [ 2, 9, 26, 27 ] ], 
      [ [ 7, 8, 1, 12 ], [ 1, 9, 13, 27 ] ], 
      [ [ 7, 8, 5, 12 ], [ 2, 9, 8, 27 ] ], 
      [ [ 0, 10, 7, 12 ], [ 1, 9, 13, 27 ] ], 
      [ [ 0, 10, 11, 12 ], [ 8, 9, 14, 27 ] ], 
      [ [ 1, 10, 8, 12 ], [ 2, 9, 14, 27 ] ], 
      [ [ 2, 10, 9, 12 ], [ 3, 9, 15, 27 ] ], 
      [ [ 3, 10, 0, 12 ], [ 0, 9, 24, 27 ] ], 
      [ [ 3, 10, 10, 12 ], [ 4, 9, 16, 27 ] ], 
      [ [ 4, 10, 1, 12 ], [ 1, 9, 25, 27 ] ], 
      [ [ 4, 10, 9, 12 ], [ 6, 9, 0, 27 ] ], 
      [ [ 4, 10, 11, 12 ], [ 5, 9, 17, 27 ] ], 
      [ [ 5, 10, 0, 12 ], [ 3, 9, 9, 27 ] ], 
      [ [ 5, 10, 2, 12 ], [ 2, 9, 26, 27 ] ], 
      [ [ 5, 10, 10, 12 ], [ 7, 9, 1, 27 ] ], 
      [ [ 6, 10, 1, 12 ], [ 4, 9, 10, 27 ] ], 
      [ [ 6, 10, 11, 12 ], [ 8, 9, 2, 27 ] ], 
      [ [ 7, 10, 2, 12 ], [ 5, 9, 11, 27 ] ], 
      [ [ 8, 10, 3, 12 ], [ 6, 9, 12, 27 ] ], 
      [ [ 9, 10, 0, 12 ], [ 0, 9, 12, 27 ] ], 
      [ [ 9, 10, 4, 12 ], [ 7, 9, 13, 27 ] ], 
      [ [ 0, 6, 7, 14 ], [ 6, 9, 18, 27 ] ], 
      [ [ 0, 6, 9, 14 ], [ 0, 9, 24, 27 ] ], 
      [ [ 0, 6, 11, 14 ], [ 3, 9, 15, 27 ] ], 
      [ [ 1, 6, 8, 14 ], [ 7, 9, 19, 27 ] ], 
      [ [ 1, 6, 10, 14 ], [ 1, 9, 25, 27 ] ], 
      [ [ 1, 6, 12, 14 ], [ 4, 9, 16, 27 ] ], 
      [ [ 2, 6, 9, 14 ], [ 8, 9, 20, 27 ] ], 
      [ [ 2, 6, 11, 14 ], [ 2, 9, 26, 27 ] ], 
      [ [ 2, 6, 13, 14 ], [ 5, 9, 17, 27 ] ], 
      [ [ 3, 6, 0, 14 ], [ 3, 9, 9, 27 ] ], 
      [ [ 3, 6, 2, 14 ], [ 6, 9, 0, 27 ] ], 
      [ [ 3, 6, 4, 14 ], [ 0, 9, 6, 27 ] ], 
      [ [ 4, 6, 1, 14 ], [ 4, 9, 10, 27 ] ], 
      [ [ 4, 6, 3, 14 ], [ 7, 9, 1, 27 ] ], 
      [ [ 4, 6, 5, 14 ], [ 1, 9, 7, 27 ] ], 
      [ [ 5, 6, 2, 14 ], [ 5, 9, 11, 27 ] ], 
      [ [ 5, 6, 4, 14 ], [ 8, 9, 2, 27 ] ], 
      [ [ 5, 6, 6, 14 ], [ 2, 9, 8, 27 ] ], 
      [ [ 0, 12, 7, 14 ], [ 3, 9, 9, 27 ] ], 
      [ [ 0, 12, 9, 14 ], [ 0, 9, 24, 27 ] ], 
      [ [ 1, 12, 8, 14 ], [ 4, 9, 10, 27 ] ], 
      [ [ 1, 12, 10, 14 ], [ 1, 9, 25, 27 ] ], 
      [ [ 2, 12, 9, 14 ], [ 5, 9, 11, 27 ] ], 
      [ [ 2, 12, 11, 14 ], [ 2, 9, 26, 27 ] ], 
      [ [ 3, 12, 10, 14 ], [ 6, 9, 12, 27 ] ], 
      [ [ 4, 12, 11, 14 ], [ 7, 9, 13, 27 ] ], 
      [ [ 5, 12, 12, 14 ], [ 8, 9, 14, 27 ] ], 
      [ [ 6, 12, 1, 14 ], [ 0, 9, 12, 27 ] ], 
      [ [ 7, 12, 2, 14 ], [ 1, 9, 13, 27 ] ], 
      [ [ 8, 12, 3, 14 ], [ 2, 9, 14, 27 ] ], 
      [ [ 9, 12, 2, 14 ], [ 6, 9, 0, 27 ] ], 
      [ [ 9, 12, 4, 14 ], [ 3, 9, 15, 27 ] ], 
      [ [ 10, 12, 3, 14 ], [ 7, 9, 1, 27 ] ], 
      [ [ 10, 12, 5, 14 ], [ 4, 9, 16, 27 ] ], 
      [ [ 11, 12, 4, 14 ], [ 8, 9, 2, 27 ] ], 
      [ [ 11, 12, 6, 14 ], [ 5, 9, 17, 27 ] ], 
      [ [ 0, 6, 11, 16 ], [ 6, 9, 12, 27 ] ], 
      [ [ 0, 6, 13, 16 ], [ 3, 9, 15, 27 ] ], 
      [ [ 1, 6, 12, 16 ], [ 7, 9, 13, 27 ] ], 
      [ [ 1, 6, 14, 16 ], [ 4, 9, 16, 27 ] ], 
      [ [ 2, 6, 13, 16 ], [ 8, 9, 14, 27 ] ], 
      [ [ 2, 6, 15, 16 ], [ 5, 9, 17, 27 ] ], 
      [ [ 3, 6, 0, 16 ], [ 3, 9, 9, 27 ] ], 
      [ [ 3, 6, 2, 16 ], [ 0, 9, 12, 27 ] ], 
      [ [ 4, 6, 1, 16 ], [ 4, 9, 10, 27 ] ], 
      [ [ 4, 6, 3, 16 ], [ 1, 9, 13, 27 ] ], 
      [ [ 5, 6, 2, 16 ], [ 5, 9, 11, 27 ] ], 
      [ [ 5, 6, 4, 16 ], [ 2, 9, 14, 27 ] ], 
      [ [ 3, 12, 13, 16 ], [ 0, 9, 6, 27 ] ], 
      [ [ 4, 12, 14, 16 ], [ 1, 9, 7, 27 ] ], 
      [ [ 5, 12, 15, 16 ], [ 2, 9, 8, 27 ] ], 
      [ [ 6, 12, 0, 16 ], [ 6, 9, 18, 27 ] ], 
      [ [ 7, 12, 1, 16 ], [ 7, 9, 19, 27 ] ], 
      [ [ 8, 12, 2, 16 ], [ 8, 9, 20, 27 ] ], 
      [ [ 0, 6, 13, 20 ], [ 6, 9, 12, 27 ] ], 
      [ [ 0, 6, 17, 20 ], [ 3, 9, 15, 27 ] ], 
      [ [ 0, 6, 19, 20 ], [ 6, 9, 0, 27 ] ], 
      [ [ 1, 6, 14, 20 ], [ 7, 9, 13, 27 ] ], 
      [ [ 1, 6, 18, 20 ], [ 4, 9, 16, 27 ] ], 
      [ [ 2, 6, 15, 20 ], [ 8, 9, 14, 27 ] ], 
      [ [ 2, 6, 19, 20 ], [ 5, 9, 17, 27 ] ], 
      [ [ 3, 6, 0, 20 ], [ 3, 9, 9, 27 ] ], 
      [ [ 3, 6, 4, 20 ], [ 0, 9, 12, 27 ] ], 
      [ [ 4, 6, 1, 20 ], [ 4, 9, 10, 27 ] ], 
      [ [ 4, 6, 5, 20 ], [ 1, 9, 13, 27 ] ], 
      [ [ 5, 6, 0, 20 ], [ 2, 9, 26, 27 ] ], 
      [ [ 5, 6, 2, 20 ], [ 5, 9, 11, 27 ] ], 
      [ [ 5, 6, 6, 20 ], [ 2, 9, 14, 27 ] ], 
      [ [ 0, 12, 10, 20 ], [ 3, 9, 9, 27 ] ], 
      [ [ 0, 12, 18, 20 ], [ 0, 9, 24, 27 ] ], 
      [ [ 1, 12, 11, 20 ], [ 4, 9, 10, 27 ] ], 
      [ [ 1, 12, 19, 20 ], [ 1, 9, 25, 27 ] ], 
      [ [ 2, 12, 12, 20 ], [ 5, 9, 11, 27 ] ], 
      [ [ 3, 12, 13, 20 ], [ 6, 9, 12, 27 ] ], 
      [ [ 3, 12, 17, 20 ], [ 0, 9, 6, 27 ] ], 
      [ [ 4, 12, 14, 20 ], [ 7, 9, 13, 27 ] ], 
      [ [ 4, 12, 18, 20 ], [ 1, 9, 7, 27 ] ], 
      [ [ 5, 12, 15, 20 ], [ 8, 9, 14, 27 ] ], 
      [ [ 5, 12, 19, 20 ], [ 2, 9, 8, 27 ] ], 
      [ [ 6, 12, 0, 20 ], [ 6, 9, 18, 27 ] ], 
      [ [ 6, 12, 4, 20 ], [ 0, 9, 12, 27 ] ], 
      [ [ 7, 12, 1, 20 ], [ 7, 9, 19, 27 ] ], 
      [ [ 7, 12, 5, 20 ], [ 1, 9, 13, 27 ] ], 
      [ [ 8, 12, 2, 20 ], [ 8, 9, 20, 27 ] ], 
      [ [ 8, 12, 6, 20 ], [ 2, 9, 14, 27 ] ], 
      [ [ 9, 12, 7, 20 ], [ 3, 9, 15, 27 ] ], 
      [ [ 10, 12, 0, 20 ], [ 7, 9, 1, 27 ] ], 
      [ [ 10, 12, 8, 20 ], [ 4, 9, 16, 27 ] ], 
      [ [ 11, 12, 1, 20 ], [ 8, 9, 2, 27 ] ], 
      [ [ 11, 12, 9, 20 ], [ 5, 9, 17, 27 ] ], 
      [ [ 0, 6, 11, 22 ], [ 6, 9, 18, 27 ] ], 
      [ [ 0, 6, 19, 22 ], [ 3, 9, 15, 27 ] ], 
      [ [ 0, 6, 21, 22 ], [ 0, 9, 24, 27 ] ], 
      [ [ 1, 6, 12, 22 ], [ 7, 9, 19, 27 ] ], 
      [ [ 1, 6, 20, 22 ], [ 4, 9, 16, 27 ] ], 
      [ [ 2, 6, 13, 22 ], [ 8, 9, 20, 27 ] ], 
      [ [ 2, 6, 21, 22 ], [ 5, 9, 17, 27 ] ], 
      [ [ 3, 6, 0, 22 ], [ 3, 9, 9, 27 ] ], 
      [ [ 3, 6, 8, 22 ], [ 0, 9, 6, 27 ] ], 
      [ [ 4, 6, 1, 22 ], [ 4, 9, 10, 27 ] ], 
      [ [ 4, 6, 9, 22 ], [ 1, 9, 7, 27 ] ], 
      [ [ 5, 6, 0, 22 ], [ 8, 9, 2, 27 ] ], 
      [ [ 5, 6, 2, 22 ], [ 5, 9, 11, 27 ] ], 
      [ [ 5, 6, 10, 22 ], [ 2, 9, 8, 27 ] ], 
      [ [ 0, 12, 11, 22 ], [ 3, 9, 9, 27 ] ], 
      [ [ 0, 12, 21, 22 ], [ 0, 9, 24, 27 ] ], 
      [ [ 1, 12, 12, 22 ], [ 4, 9, 10, 27 ] ], 
      [ [ 2, 12, 13, 22 ], [ 5, 9, 11, 27 ] ], 
      [ [ 3, 12, 14, 22 ], [ 6, 9, 12, 27 ] ], 
      [ [ 3, 12, 20, 22 ], [ 6, 9, 0, 27 ] ], 
      [ [ 4, 12, 15, 22 ], [ 7, 9, 13, 27 ] ], 
      [ [ 4, 12, 21, 22 ], [ 7, 9, 1, 27 ] ], 
      [ [ 5, 12, 16, 22 ], [ 8, 9, 14, 27 ] ], 
      [ [ 6, 12, 5, 22 ], [ 0, 9, 12, 27 ] ], 
      [ [ 7, 12, 0, 22 ], [ 1, 9, 25, 27 ] ], 
      [ [ 7, 12, 6, 22 ], [ 1, 9, 13, 27 ] ], 
      [ [ 8, 12, 1, 22 ], [ 2, 9, 26, 27 ] ], 
      [ [ 8, 12, 7, 22 ], [ 2, 9, 14, 27 ] ], 
      [ [ 9, 12, 8, 22 ], [ 3, 9, 15, 27 ] ], 
      [ [ 10, 12, 9, 22 ], [ 4, 9, 16, 27 ] ], 
      [ [ 11, 12, 0, 22 ], [ 8, 9, 2, 27 ] ], 
      [ [ 11, 12, 10, 22 ], [ 5, 9, 17, 27 ] ], 
      [ [ 0, 2, 1, 24 ], [ 4, 9, 10, 27 ] ], 
      [ [ 0, 2, 7, 24 ], [ 1, 9, 13, 27 ] ], 
      [ [ 0, 2, 9, 24 ], [ 0, 9, 6, 27 ] ], 
      [ [ 0, 2, 11, 24 ], [ 8, 9, 2, 27 ] ], 
      [ [ 0, 2, 13, 24 ], [ 7, 9, 19, 27 ] ], 
      [ [ 0, 2, 15, 24 ], [ 6, 9, 12, 27 ] ], 
      [ [ 0, 2, 21, 24 ], [ 3, 9, 15, 27 ] ], 
      [ [ 0, 2, 23, 24 ], [ 2, 9, 8, 27 ] ], 
      [ [ 1, 2, 0, 24 ], [ 6, 9, 18, 27 ] ], 
      [ [ 1, 2, 2, 24 ], [ 5, 9, 11, 27 ] ], 
      [ [ 1, 2, 8, 24 ], [ 2, 9, 14, 27 ] ], 
      [ [ 1, 2, 10, 24 ], [ 1, 9, 7, 27 ] ], 
      [ [ 1, 2, 12, 24 ], [ 0, 9, 24, 27 ] ], 
      [ [ 1, 2, 14, 24 ], [ 8, 9, 20, 27 ] ], 
      [ [ 1, 2, 16, 24 ], [ 7, 9, 13, 27 ] ], 
      [ [ 1, 2, 22, 24 ], [ 4, 9, 16, 27 ] ], 
      [ [ 0, 4, 2, 24 ], [ 5, 9, 11, 27 ] ], 
      [ [ 0, 4, 10, 24 ], [ 7, 9, 1, 27 ] ], 
      [ [ 0, 4, 14, 24 ], [ 8, 9, 20, 27 ] ], 
      [ [ 0, 4, 18, 24 ], [ 0, 9, 12, 27 ] ], 
      [ [ 0, 4, 22, 24 ], [ 1, 9, 7, 27 ] ], 
      [ [ 1, 4, 3, 24 ], [ 6, 9, 12, 27 ] ], 
      [ [ 1, 4, 11, 24 ], [ 8, 9, 2, 27 ] ], 
      [ [ 1, 4, 19, 24 ], [ 1, 9, 13, 27 ] ], 
      [ [ 1, 4, 23, 24 ], [ 2, 9, 8, 27 ] ], 
      [ [ 2, 4, 0, 24 ], [ 6, 9, 18, 27 ] ], 
      [ [ 2, 4, 4, 24 ], [ 7, 9, 13, 27 ] ], 
      [ [ 2, 4, 12, 24 ], [ 0, 9, 24, 27 ] ], 
      [ [ 2, 4, 20, 24 ], [ 2, 9, 14, 27 ] ], 
      [ [ 3, 4, 1, 24 ], [ 7, 9, 19, 27 ] ], 
      [ [ 3, 4, 5, 24 ], [ 8, 9, 14, 27 ] ], 
      [ [ 3, 4, 9, 24 ], [ 0, 9, 6, 27 ] ], 
      [ [ 3, 4, 13, 24 ], [ 1, 9, 25, 27 ] ], 
      [ [ 3, 4, 21, 24 ], [ 3, 9, 15, 27 ] ], 
      [ [ 0, 8, 4, 24 ], [ 7, 9, 13, 27 ] ], 
      [ [ 0, 8, 12, 24 ], [ 3, 9, 9, 27 ] ], 
      [ [ 1, 8, 5, 24 ], [ 8, 9, 14, 27 ] ], 
      [ [ 1, 8, 13, 24 ], [ 4, 9, 10, 27 ] ], 
      [ [ 1, 8, 21, 24 ], [ 0, 9, 6, 27 ] ], 
      [ [ 2, 8, 6, 24 ], [ 0, 9, 12, 27 ] ], 
      [ [ 2, 8, 14, 24 ], [ 5, 9, 11, 27 ] ], 
      [ [ 2, 8, 22, 24 ], [ 1, 9, 7, 27 ] ], 
      [ [ 3, 8, 7, 24 ], [ 1, 9, 13, 27 ] ], 
      [ [ 3, 8, 15, 24 ], [ 6, 9, 12, 27 ] ], 
      [ [ 3, 8, 23, 24 ], [ 2, 9, 8, 27 ] ], 
      [ [ 4, 8, 0, 24 ], [ 6, 9, 18, 27 ] ], 
      [ [ 4, 8, 8, 24 ], [ 2, 9, 14, 27 ] ], 
      [ [ 4, 8, 16, 24 ], [ 7, 9, 13, 27 ] ], 
      [ [ 5, 8, 1, 24 ], [ 7, 9, 19, 27 ] ], 
      [ [ 5, 8, 9, 24 ], [ 3, 9, 15, 27 ] ], 
      [ [ 5, 8, 17, 24 ], [ 8, 9, 14, 27 ] ], 
      [ [ 6, 8, 2, 24 ], [ 8, 9, 20, 27 ] ], 
      [ [ 6, 8, 10, 24 ], [ 4, 9, 16, 27 ] ], 
      [ [ 6, 8, 18, 24 ], [ 0, 9, 12, 27 ] ], 
      [ [ 7, 8, 11, 24 ], [ 5, 9, 17, 27 ] ], 
      [ [ 7, 8, 19, 24 ], [ 1, 9, 13, 27 ] ], 
      [ [ 0, 10, 5, 24 ], [ 8, 9, 14, 27 ] ], 
      [ [ 2, 10, 21, 24 ], [ 0, 9, 6, 27 ] ], 
      [ [ 3, 10, 0, 24 ], [ 0, 9, 24, 27 ] ], 
      [ [ 3, 10, 22, 24 ], [ 1, 9, 7, 27 ] ], 
      [ [ 4, 10, 1, 24 ], [ 1, 9, 25, 27 ] ], 
      [ [ 4, 10, 21, 24 ], [ 6, 9, 0, 27 ] ], 
      [ [ 4, 10, 23, 24 ], [ 2, 9, 8, 27 ] ], 
      [ [ 5, 10, 0, 24 ], [ 6, 9, 18, 27 ] ], 
      [ [ 5, 10, 2, 24 ], [ 2, 9, 26, 27 ] ], 
      [ [ 5, 10, 22, 24 ], [ 7, 9, 1, 27 ] ], 
      [ [ 6, 10, 1, 24 ], [ 7, 9, 19, 27 ] ], 
      [ [ 6, 10, 23, 24 ], [ 8, 9, 2, 27 ] ], 
      [ [ 7, 10, 2, 24 ], [ 8, 9, 20, 27 ] ], 
      [ [ 9, 10, 18, 24 ], [ 0, 9, 12, 27 ] ], 
      [ [ 2, 14, 21, 24 ], [ 6, 9, 0, 27 ] ], 
      [ [ 3, 14, 22, 24 ], [ 7, 9, 1, 27 ] ], 
      [ [ 4, 14, 21, 24 ], [ 0, 9, 6, 27 ] ], 
      [ [ 4, 14, 23, 24 ], [ 8, 9, 2, 27 ] ], 
      [ [ 5, 14, 22, 24 ], [ 1, 9, 7, 27 ] ], 
      [ [ 6, 14, 23, 24 ], [ 2, 9, 8, 27 ] ], 
      [ [ 7, 14, 0, 24 ], [ 6, 9, 18, 27 ] ], 
      [ [ 8, 14, 1, 24 ], [ 7, 9, 19, 27 ] ], 
      [ [ 9, 14, 0, 24 ], [ 0, 9, 24, 27 ] ], 
      [ [ 9, 14, 2, 24 ], [ 8, 9, 20, 27 ] ], 
      [ [ 10, 14, 1, 24 ], [ 1, 9, 25, 27 ] ], 
      [ [ 11, 14, 2, 24 ], [ 2, 9, 26, 27 ] ], 
      [ [ 0, 16, 12, 24 ], [ 3, 9, 9, 27 ] ], 
      [ [ 1, 16, 13, 24 ], [ 4, 9, 10, 27 ] ], 
      [ [ 1, 16, 21, 24 ], [ 6, 9, 0, 27 ] ], 
      [ [ 2, 16, 14, 24 ], [ 5, 9, 11, 27 ] ], 
      [ [ 2, 16, 22, 24 ], [ 7, 9, 1, 27 ] ], 
      [ [ 3, 16, 15, 24 ], [ 6, 9, 12, 27 ] ], 
      [ [ 3, 16, 23, 24 ], [ 8, 9, 2, 27 ] ], 
      [ [ 4, 16, 16, 24 ], [ 7, 9, 13, 27 ] ], 
      [ [ 5, 16, 17, 24 ], [ 8, 9, 14, 27 ] ], 
      [ [ 10, 16, 6, 24 ], [ 0, 9, 12, 27 ] ], 
      [ [ 11, 16, 7, 24 ], [ 1, 9, 13, 27 ] ], 
      [ [ 12, 16, 0, 24 ], [ 0, 9, 24, 27 ] ], 
      [ [ 12, 16, 8, 24 ], [ 2, 9, 14, 27 ] ], 
      [ [ 13, 16, 1, 24 ], [ 1, 9, 25, 27 ] ], 
      [ [ 13, 16, 9, 24 ], [ 3, 9, 15, 27 ] ], 
      [ [ 14, 16, 2, 24 ], [ 2, 9, 26, 27 ] ], 
      [ [ 14, 16, 10, 24 ], [ 4, 9, 16, 27 ] ], 
      [ [ 15, 16, 11, 24 ], [ 5, 9, 17, 27 ] ], 
      [ [ 0, 20, 14, 24 ], [ 2, 9, 26, 27 ] ], 
      [ [ 0, 20, 22, 24 ], [ 7, 9, 1, 27 ] ], 
      [ [ 1, 20, 23, 24 ], [ 8, 9, 2, 27 ] ], 
      [ [ 7, 20, 21, 24 ], [ 0, 9, 6, 27 ] ], 
      [ [ 8, 20, 22, 24 ], [ 1, 9, 7, 27 ] ], 
      [ [ 9, 20, 23, 24 ], [ 2, 9, 8, 27 ] ], 
      [ [ 10, 20, 0, 24 ], [ 6, 9, 18, 27 ] ], 
      [ [ 11, 20, 1, 24 ], [ 7, 9, 19, 27 ] ], 
      [ [ 12, 20, 2, 24 ], [ 8, 9, 20, 27 ] ], 
      [ [ 18, 20, 0, 24 ], [ 0, 9, 24, 27 ] ], 
      [ [ 19, 20, 1, 24 ], [ 1, 9, 25, 27 ] ], 
      [ [ 19, 20, 9, 24 ], [ 6, 9, 0, 27 ] ], 
      [ [ 0, 22, 13, 24 ], [ 1, 9, 25, 27 ] ], 
      [ [ 0, 22, 23, 24 ], [ 8, 9, 2, 27 ] ], 
      [ [ 1, 22, 14, 24 ], [ 2, 9, 26, 27 ] ], 
      [ [ 8, 22, 21, 24 ], [ 0, 9, 6, 27 ] ], 
      [ [ 9, 22, 22, 24 ], [ 1, 9, 7, 27 ] ], 
      [ [ 10, 22, 23, 24 ], [ 2, 9, 8, 27 ] ], 
      [ [ 11, 22, 0, 24 ], [ 6, 9, 18, 27 ] ], 
      [ [ 12, 22, 1, 24 ], [ 7, 9, 19, 27 ] ], 
      [ [ 13, 22, 2, 24 ], [ 8, 9, 20, 27 ] ], 
      [ [ 20, 22, 9, 24 ], [ 6, 9, 0, 27 ] ], 
      [ [ 21, 22, 0, 24 ], [ 0, 9, 24, 27 ] ], 
      [ [ 21, 22, 10, 24 ], [ 7, 9, 1, 27 ] ], 
      [ [ 0, 6, 13, 26 ], [ 6, 9, 18, 27 ] ], 
      [ [ 0, 6, 23, 26 ], [ 3, 9, 15, 27 ] ], 
      [ [ 1, 6, 14, 26 ], [ 7, 9, 19, 27 ] ], 
      [ [ 1, 6, 24, 26 ], [ 4, 9, 16, 27 ] ], 
      [ [ 2, 6, 15, 26 ], [ 8, 9, 20, 27 ] ], 
      [ [ 2, 6, 25, 26 ], [ 5, 9, 17, 27 ] ], 
      [ [ 3, 6, 0, 26 ], [ 3, 9, 9, 27 ] ], 
      [ [ 3, 6, 10, 26 ], [ 0, 9, 6, 27 ] ], 
      [ [ 4, 6, 1, 26 ], [ 4, 9, 10, 27 ] ], 
      [ [ 4, 6, 11, 26 ], [ 1, 9, 7, 27 ] ], 
      [ [ 5, 6, 2, 26 ], [ 5, 9, 11, 27 ] ], 
      [ [ 5, 6, 12, 26 ], [ 2, 9, 8, 27 ] ], 
      [ [ 0, 12, 13, 26 ], [ 3, 9, 9, 27 ] ], 
      [ [ 1, 12, 14, 26 ], [ 4, 9, 10, 27 ] ], 
      [ [ 2, 12, 15, 26 ], [ 5, 9, 11, 27 ] ], 
      [ [ 3, 12, 16, 26 ], [ 6, 9, 12, 27 ] ], 
      [ [ 3, 12, 22, 26 ], [ 6, 9, 0, 27 ] ], 
      [ [ 4, 12, 17, 26 ], [ 7, 9, 13, 27 ] ], 
      [ [ 4, 12, 23, 26 ], [ 7, 9, 1, 27 ] ], 
      [ [ 5, 12, 18, 26 ], [ 8, 9, 14, 27 ] ], 
      [ [ 5, 12, 24, 26 ], [ 8, 9, 2, 27 ] ], 
      [ [ 6, 12, 1, 26 ], [ 0, 9, 24, 27 ] ], 
      [ [ 6, 12, 7, 26 ], [ 0, 9, 12, 27 ] ], 
      [ [ 7, 12, 2, 26 ], [ 1, 9, 25, 27 ] ], 
      [ [ 7, 12, 8, 26 ], [ 1, 9, 13, 27 ] ], 
      [ [ 8, 12, 3, 26 ], [ 2, 9, 26, 27 ] ], 
      [ [ 8, 12, 9, 26 ], [ 2, 9, 14, 27 ] ], 
      [ [ 9, 12, 10, 26 ], [ 3, 9, 15, 27 ] ], 
      [ [ 10, 12, 11, 26 ], [ 4, 9, 16, 27 ] ], 
      [ [ 11, 12, 12, 26 ], [ 5, 9, 17, 27 ] ], 
      [ [ 0, 24, 13, 26 ], [ 6, 9, 18, 27 ] ], 
      [ [ 1, 24, 14, 26 ], [ 7, 9, 19, 27 ] ], 
      [ [ 2, 24, 15, 26 ], [ 8, 9, 20, 27 ] ], 
      [ [ 9, 24, 22, 26 ], [ 6, 9, 0, 27 ] ], 
      [ [ 10, 24, 23, 26 ], [ 7, 9, 1, 27 ] ], 
      [ [ 11, 24, 24, 26 ], [ 8, 9, 2, 27 ] ], 
      [ [ 12, 24, 1, 26 ], [ 0, 9, 24, 27 ] ], 
      [ [ 13, 24, 2, 26 ], [ 1, 9, 25, 27 ] ], 
      [ [ 14, 24, 3, 26 ], [ 2, 9, 26, 27 ] ], 
      [ [ 21, 24, 10, 26 ], [ 0, 9, 6, 27 ] ], 
      [ [ 22, 24, 11, 26 ], [ 1, 9, 7, 27 ] ], 
      [ [ 23, 24, 12, 26 ], [ 2, 9, 8, 27 ] ], 
      [ [ 0, 4, 6, 16 ], [ 4, 18, 16, 27 ] ], 
      [ [ 0, 4, 6, 16 ], [ 10, 18, 7, 27 ] ], 
      [ [ 0, 4, 6, 16 ], [ 10, 18, 25, 27 ] ], 
      [ [ 1, 4, 7, 16 ], [ 5, 18, 17, 27 ] ], 
      [ [ 1, 4, 7, 16 ], [ 11, 18, 8, 27 ] ], 
      [ [ 1, 4, 7, 16 ], [ 11, 18, 26, 27 ] ], 
      [ [ 2, 4, 8, 16 ], [ 6, 18, 0, 27 ] ], 
      [ [ 2, 4, 8, 16 ], [ 6, 18, 18, 27 ] ], 
      [ [ 2, 4, 8, 16 ], [ 12, 18, 9, 27 ] ], 
      [ [ 3, 4, 9, 16 ], [ 7, 18, 1, 27 ] ], 
      [ [ 3, 4, 9, 16 ], [ 7, 18, 19, 27 ] ], 
      [ [ 3, 4, 9, 16 ], [ 13, 18, 10, 27 ] ], 
      [ [ 0, 2, 3, 18 ], [ 3, 27, 21, 27 ] ], 
      [ [ 0, 2, 5, 18 ], [ 5, 27, 23, 27 ] ], 
      [ [ 0, 2, 11, 18 ], [ 2, 27, 20, 27 ] ], 
      [ [ 0, 2, 13, 18 ], [ 4, 27, 22, 27 ] ], 
      [ [ 0, 2, 17, 18 ], [ 8, 27, 26, 27 ] ], 
      [ [ 1, 2, 0, 18 ], [ 0, 27, 18, 27 ] ], 
      [ [ 1, 2, 4, 18 ], [ 4, 27, 22, 27 ] ], 
      [ [ 1, 2, 6, 18 ], [ 6, 27, 24, 27 ] ], 
      [ [ 1, 2, 12, 18 ], [ 3, 27, 21, 27 ] ], 
      [ [ 1, 2, 14, 18 ], [ 5, 27, 23, 27 ] ], 
      [ [ 0, 6, 15, 18 ], [ 6, 27, 24, 27 ] ], 
      [ [ 1, 6, 16, 18 ], [ 7, 27, 25, 27 ] ], 
      [ [ 2, 6, 17, 18 ], [ 8, 27, 26, 27 ] ], 
      [ [ 3, 6, 0, 18 ], [ 0, 27, 18, 27 ] ], 
      [ [ 4, 6, 1, 18 ], [ 1, 27, 19, 27 ] ], 
      [ [ 5, 6, 2, 18 ], [ 2, 27, 20, 27 ] ], 
      [ [ 0, 3, 1, 6 ], [ 3, 4, 9, 28 ] ], 
      [ [ 0, 3, 1, 6 ], [ 3, 4, 21, 28 ] ], 
      [ [ 0, 3, 2, 6 ], [ 2, 4, 8, 28 ] ], 
      [ [ 0, 3, 2, 6 ], [ 2, 4, 20, 28 ] ], 
      [ [ 0, 3, 4, 6 ], [ 0, 4, 6, 28 ] ], 
      [ [ 0, 3, 4, 6 ], [ 0, 4, 18, 28 ] ], 
      [ [ 0, 3, 5, 6 ], [ 3, 4, 9, 28 ] ], 
      [ [ 0, 3, 5, 6 ], [ 3, 4, 21, 28 ] ], 
      [ [ 1, 3, 0, 6 ], [ 2, 4, 8, 28 ] ], 
      [ [ 1, 3, 0, 6 ], [ 2, 4, 20, 28 ] ], 
      [ [ 1, 3, 2, 6 ], [ 0, 4, 6, 28 ] ], 
      [ [ 1, 3, 2, 6 ], [ 0, 4, 18, 28 ] ], 
      [ [ 1, 3, 3, 6 ], [ 3, 4, 9, 28 ] ], 
      [ [ 1, 3, 3, 6 ], [ 3, 4, 21, 28 ] ], 
      [ [ 1, 3, 5, 6 ], [ 1, 4, 7, 28 ] ], 
      [ [ 1, 3, 5, 6 ], [ 1, 4, 19, 28 ] ], 
      [ [ 2, 3, 0, 6 ], [ 0, 4, 6, 28 ] ], 
      [ [ 2, 3, 0, 6 ], [ 0, 4, 18, 28 ] ], 
      [ [ 2, 3, 1, 6 ], [ 3, 4, 9, 28 ] ], 
      [ [ 2, 3, 1, 6 ], [ 3, 4, 21, 28 ] ], 
      [ [ 2, 3, 3, 6 ], [ 1, 4, 7, 28 ] ], 
      [ [ 2, 3, 3, 6 ], [ 1, 4, 19, 28 ] ], 
      [ [ 2, 3, 4, 6 ], [ 0, 4, 6, 28 ] ], 
      [ [ 2, 3, 4, 6 ], [ 0, 4, 18, 28 ] ], 
      [ [ 0, 6, 1, 9 ], [ 2, 4, 8, 28 ] ], 
      [ [ 0, 6, 2, 9 ], [ 0, 4, 6, 28 ] ], 
      [ [ 0, 6, 5, 9 ], [ 2, 4, 20, 28 ] ], 
      [ [ 0, 6, 7, 9 ], [ 2, 4, 8, 28 ] ], 
      [ [ 0, 6, 8, 9 ], [ 0, 4, 6, 28 ] ], 
      [ [ 1, 6, 0, 9 ], [ 3, 4, 21, 28 ] ], 
      [ [ 1, 6, 2, 9 ], [ 3, 4, 9, 28 ] ], 
      [ [ 1, 6, 3, 9 ], [ 1, 4, 7, 28 ] ], 
      [ [ 1, 6, 6, 9 ], [ 3, 4, 21, 28 ] ], 
      [ [ 1, 6, 8, 9 ], [ 3, 4, 9, 28 ] ], 
      [ [ 2, 6, 3, 9 ], [ 0, 4, 18, 28 ] ], 
      [ [ 2, 6, 4, 9 ], [ 2, 4, 8, 28 ] ], 
      [ [ 3, 6, 4, 9 ], [ 1, 4, 19, 28 ] ], 
      [ [ 3, 6, 5, 9 ], [ 3, 4, 9, 28 ] ], 
      [ [ 4, 6, 0, 9 ], [ 0, 4, 18, 28 ] ], 
      [ [ 4, 6, 2, 9 ], [ 0, 4, 6, 28 ] ], 
      [ [ 4, 6, 5, 9 ], [ 2, 4, 20, 28 ] ], 
      [ [ 4, 6, 6, 9 ], [ 0, 4, 18, 28 ] ], 
      [ [ 4, 6, 8, 9 ], [ 0, 4, 6, 28 ] ], 
      [ [ 5, 6, 0, 9 ], [ 3, 4, 21, 28 ] ], 
      [ [ 5, 6, 1, 9 ], [ 1, 4, 19, 28 ] ], 
      [ [ 5, 6, 3, 9 ], [ 1, 4, 7, 28 ] ], 
      [ [ 5, 6, 6, 9 ], [ 3, 4, 21, 28 ] ], 
      [ [ 5, 6, 7, 9 ], [ 1, 4, 19, 28 ] ], 
      [ [ 0, 6, 1, 15 ], [ 2, 4, 8, 28 ] ], 
      [ [ 0, 6, 2, 15 ], [ 0, 4, 18, 28 ] ], 
      [ [ 0, 6, 4, 15 ], [ 0, 4, 6, 28 ] ], 
      [ [ 0, 6, 11, 15 ], [ 2, 4, 8, 28 ] ], 
      [ [ 0, 6, 14, 15 ], [ 0, 4, 6, 28 ] ], 
      [ [ 1, 6, 0, 15 ], [ 3, 4, 21, 28 ] ], 
      [ [ 1, 6, 2, 15 ], [ 3, 4, 9, 28 ] ], 
      [ [ 1, 6, 3, 15 ], [ 1, 4, 19, 28 ] ], 
      [ [ 1, 6, 5, 15 ], [ 1, 4, 7, 28 ] ], 
      [ [ 1, 6, 12, 15 ], [ 3, 4, 9, 28 ] ], 
      [ [ 2, 6, 4, 15 ], [ 2, 4, 20, 28 ] ], 
      [ [ 2, 6, 6, 15 ], [ 2, 4, 8, 28 ] ], 
      [ [ 2, 6, 7, 15 ], [ 0, 4, 18, 28 ] ], 
      [ [ 2, 6, 9, 15 ], [ 0, 4, 6, 28 ] ], 
      [ [ 3, 6, 5, 15 ], [ 3, 4, 21, 28 ] ], 
      [ [ 3, 6, 7, 15 ], [ 3, 4, 9, 28 ] ], 
      [ [ 3, 6, 8, 15 ], [ 1, 4, 19, 28 ] ], 
      [ [ 3, 6, 10, 15 ], [ 1, 4, 7, 28 ] ], 
      [ [ 4, 6, 2, 15 ], [ 0, 4, 18, 28 ] ], 
      [ [ 4, 6, 9, 15 ], [ 2, 4, 20, 28 ] ], 
      [ [ 4, 6, 11, 15 ], [ 2, 4, 8, 28 ] ], 
      [ [ 4, 6, 12, 15 ], [ 0, 4, 18, 28 ] ], 
      [ [ 4, 6, 14, 15 ], [ 0, 4, 6, 28 ] ], 
      [ [ 5, 6, 0, 15 ], [ 3, 4, 21, 28 ] ], 
      [ [ 5, 6, 3, 15 ], [ 1, 4, 19, 28 ] ], 
      [ [ 5, 6, 10, 15 ], [ 3, 4, 21, 28 ] ], 
      [ [ 5, 6, 12, 15 ], [ 3, 4, 9, 28 ] ], 
      [ [ 5, 6, 13, 15 ], [ 1, 4, 19, 28 ] ], 
      [ [ 0, 3, 2, 18 ], [ 2, 4, 20, 28 ] ], 
      [ [ 0, 3, 5, 18 ], [ 3, 4, 9, 28 ] ], 
      [ [ 0, 3, 7, 18 ], [ 1, 4, 19, 28 ] ], 
      [ [ 0, 3, 8, 18 ], [ 0, 4, 6, 28 ] ], 
      [ [ 0, 3, 10, 18 ], [ 2, 4, 8, 28 ] ], 
      [ [ 0, 3, 14, 18 ], [ 2, 4, 20, 28 ] ], 
      [ [ 0, 3, 17, 18 ], [ 3, 4, 9, 28 ] ], 
      [ [ 1, 3, 2, 18 ], [ 0, 4, 6, 28 ] ], 
      [ [ 1, 3, 3, 18 ], [ 3, 4, 21, 28 ] ], 
      [ [ 1, 3, 6, 18 ], [ 0, 4, 18, 28 ] ], 
      [ [ 1, 3, 8, 18 ], [ 2, 4, 20, 28 ] ], 
      [ [ 1, 3, 9, 18 ], [ 1, 4, 7, 28 ] ], 
      [ [ 1, 3, 11, 18 ], [ 3, 4, 9, 28 ] ], 
      [ [ 1, 3, 14, 18 ], [ 0, 4, 6, 28 ] ], 
      [ [ 1, 3, 15, 18 ], [ 3, 4, 21, 28 ] ], 
      [ [ 2, 3, 0, 18 ], [ 0, 4, 18, 28 ] ], 
      [ [ 2, 3, 3, 18 ], [ 1, 4, 7, 28 ] ], 
      [ [ 2, 3, 7, 18 ], [ 1, 4, 19, 28 ] ], 
      [ [ 2, 3, 9, 18 ], [ 3, 4, 21, 28 ] ], 
      [ [ 2, 3, 10, 18 ], [ 2, 4, 8, 28 ] ], 
      [ [ 2, 3, 12, 18 ], [ 0, 4, 18, 28 ] ], 
      [ [ 2, 3, 15, 18 ], [ 1, 4, 7, 28 ] ], 
      [ [ 0, 9, 3, 18 ], [ 1, 4, 7, 28 ] ], 
      [ [ 0, 9, 12, 18 ], [ 0, 4, 18, 28 ] ], 
      [ [ 0, 9, 15, 18 ], [ 1, 4, 7, 28 ] ], 
      [ [ 1, 9, 4, 18 ], [ 2, 4, 8, 28 ] ], 
      [ [ 1, 9, 13, 18 ], [ 1, 4, 19, 28 ] ], 
      [ [ 1, 9, 16, 18 ], [ 2, 4, 8, 28 ] ], 
      [ [ 2, 9, 5, 18 ], [ 3, 4, 9, 28 ] ], 
      [ [ 2, 9, 8, 18 ], [ 0, 4, 6, 28 ] ], 
      [ [ 2, 9, 14, 18 ], [ 2, 4, 20, 28 ] ], 
      [ [ 2, 9, 17, 18 ], [ 3, 4, 9, 28 ] ], 
      [ [ 3, 9, 6, 18 ], [ 0, 4, 18, 28 ] ], 
      [ [ 3, 9, 9, 18 ], [ 1, 4, 7, 28 ] ], 
      [ [ 3, 9, 15, 18 ], [ 3, 4, 21, 28 ] ], 
      [ [ 4, 9, 7, 18 ], [ 1, 4, 19, 28 ] ], 
      [ [ 4, 9, 10, 18 ], [ 2, 4, 8, 28 ] ], 
      [ [ 5, 9, 2, 18 ], [ 0, 4, 6, 28 ] ], 
      [ [ 5, 9, 8, 18 ], [ 2, 4, 20, 28 ] ], 
      [ [ 5, 9, 11, 18 ], [ 3, 4, 9, 28 ] ], 
      [ [ 6, 9, 0, 18 ], [ 0, 4, 18, 28 ] ], 
      [ [ 6, 9, 3, 18 ], [ 1, 4, 7, 28 ] ], 
      [ [ 6, 9, 9, 18 ], [ 3, 4, 21, 28 ] ], 
      [ [ 6, 9, 12, 18 ], [ 0, 4, 18, 28 ] ], 
      [ [ 7, 9, 1, 18 ], [ 1, 4, 19, 28 ] ], 
      [ [ 7, 9, 4, 18 ], [ 2, 4, 8, 28 ] ], 
      [ [ 7, 9, 13, 18 ], [ 1, 4, 19, 28 ] ], 
      [ [ 8, 9, 2, 18 ], [ 2, 4, 20, 28 ] ], 
      [ [ 8, 9, 5, 18 ], [ 3, 4, 9, 28 ] ], 
      [ [ 8, 9, 14, 18 ], [ 2, 4, 20, 28 ] ], 
      [ [ 2, 15, 0, 18 ], [ 0, 4, 18, 28 ] ], 
      [ [ 2, 15, 12, 18 ], [ 0, 4, 18, 28 ] ], 
      [ [ 3, 15, 1, 18 ], [ 1, 4, 19, 28 ] ], 
      [ [ 3, 15, 13, 18 ], [ 1, 4, 19, 28 ] ], 
      [ [ 4, 15, 2, 18 ], [ 2, 4, 20, 28 ] ], 
      [ [ 4, 15, 8, 18 ], [ 0, 4, 6, 28 ] ], 
      [ [ 4, 15, 14, 18 ], [ 2, 4, 20, 28 ] ], 
      [ [ 5, 15, 3, 18 ], [ 3, 4, 21, 28 ] ], 
      [ [ 5, 15, 9, 18 ], [ 1, 4, 7, 28 ] ], 
      [ [ 5, 15, 15, 18 ], [ 3, 4, 21, 28 ] ], 
      [ [ 6, 15, 10, 18 ], [ 2, 4, 8, 28 ] ], 
      [ [ 7, 15, 6, 18 ], [ 0, 4, 18, 28 ] ], 
      [ [ 7, 15, 11, 18 ], [ 3, 4, 9, 28 ] ], 
      [ [ 8, 15, 7, 18 ], [ 1, 4, 19, 28 ] ], 
      [ [ 9, 15, 2, 18 ], [ 0, 4, 6, 28 ] ], 
      [ [ 9, 15, 8, 18 ], [ 2, 4, 20, 28 ] ], 
      [ [ 9, 15, 14, 18 ], [ 0, 4, 6, 28 ] ], 
      [ [ 10, 15, 3, 18 ], [ 1, 4, 7, 28 ] ], 
      [ [ 10, 15, 9, 18 ], [ 3, 4, 21, 28 ] ], 
      [ [ 10, 15, 15, 18 ], [ 1, 4, 7, 28 ] ], 
      [ [ 11, 15, 4, 18 ], [ 2, 4, 8, 28 ] ], 
      [ [ 11, 15, 16, 18 ], [ 2, 4, 8, 28 ] ], 
      [ [ 12, 15, 5, 18 ], [ 3, 4, 9, 28 ] ], 
      [ [ 12, 15, 17, 18 ], [ 3, 4, 9, 28 ] ], 
      [ [ 0, 6, 1, 27 ], [ 2, 4, 8, 28 ] ], 
      [ [ 0, 6, 8, 27 ], [ 0, 4, 6, 28 ] ], 
      [ [ 0, 6, 17, 27 ], [ 2, 4, 20, 28 ] ], 
      [ [ 0, 6, 19, 27 ], [ 2, 4, 8, 28 ] ], 
      [ [ 0, 6, 26, 27 ], [ 0, 4, 6, 28 ] ], 
      [ [ 1, 6, 0, 27 ], [ 3, 4, 21, 28 ] ], 
      [ [ 1, 6, 2, 27 ], [ 3, 4, 9, 28 ] ], 
      [ [ 1, 6, 9, 27 ], [ 1, 4, 7, 28 ] ], 
      [ [ 1, 6, 18, 27 ], [ 3, 4, 21, 28 ] ], 
      [ [ 1, 6, 20, 27 ], [ 3, 4, 9, 28 ] ], 
      [ [ 2, 6, 10, 27 ], [ 2, 4, 8, 28 ] ], 
      [ [ 2, 6, 15, 27 ], [ 0, 4, 18, 28 ] ], 
      [ [ 3, 6, 11, 27 ], [ 3, 4, 9, 28 ] ], 
      [ [ 3, 6, 16, 27 ], [ 1, 4, 19, 28 ] ], 
      [ [ 4, 6, 6, 27 ], [ 0, 4, 18, 28 ] ], 
      [ [ 4, 6, 8, 27 ], [ 0, 4, 6, 28 ] ], 
      [ [ 4, 6, 17, 27 ], [ 2, 4, 20, 28 ] ], 
      [ [ 4, 6, 24, 27 ], [ 0, 4, 18, 28 ] ], 
      [ [ 4, 6, 26, 27 ], [ 0, 4, 6, 28 ] ], 
      [ [ 5, 6, 0, 27 ], [ 3, 4, 21, 28 ] ], 
      [ [ 5, 6, 7, 27 ], [ 1, 4, 19, 28 ] ], 
      [ [ 5, 6, 9, 27 ], [ 1, 4, 7, 28 ] ], 
      [ [ 5, 6, 18, 27 ], [ 3, 4, 21, 28 ] ], 
      [ [ 5, 6, 25, 27 ], [ 1, 4, 19, 28 ] ], 
      [ [ 0, 18, 6, 27 ], [ 0, 4, 18, 28 ] ], 
      [ [ 0, 18, 24, 27 ], [ 0, 4, 18, 28 ] ], 
      [ [ 1, 18, 7, 27 ], [ 1, 4, 19, 28 ] ], 
      [ [ 1, 18, 25, 27 ], [ 1, 4, 19, 28 ] ], 
      [ [ 2, 18, 8, 27 ], [ 2, 4, 20, 28 ] ], 
      [ [ 2, 18, 17, 27 ], [ 0, 4, 6, 28 ] ], 
      [ [ 2, 18, 26, 27 ], [ 2, 4, 20, 28 ] ], 
      [ [ 3, 18, 0, 27 ], [ 1, 4, 7, 28 ] ], 
      [ [ 3, 18, 9, 27 ], [ 3, 4, 21, 28 ] ], 
      [ [ 3, 18, 18, 27 ], [ 1, 4, 7, 28 ] ], 
      [ [ 4, 18, 1, 27 ], [ 2, 4, 8, 28 ] ], 
      [ [ 4, 18, 19, 27 ], [ 2, 4, 8, 28 ] ], 
      [ [ 5, 18, 2, 27 ], [ 3, 4, 9, 28 ] ], 
      [ [ 5, 18, 20, 27 ], [ 3, 4, 9, 28 ] ], 
      [ [ 12, 18, 6, 27 ], [ 0, 4, 18, 28 ] ], 
      [ [ 12, 18, 24, 27 ], [ 0, 4, 18, 28 ] ], 
      [ [ 13, 18, 7, 27 ], [ 1, 4, 19, 28 ] ], 
      [ [ 13, 18, 25, 27 ], [ 1, 4, 19, 28 ] ], 
      [ [ 14, 18, 8, 27 ], [ 2, 4, 20, 28 ] ], 
      [ [ 14, 18, 17, 27 ], [ 0, 4, 6, 28 ] ], 
      [ [ 14, 18, 26, 27 ], [ 2, 4, 20, 28 ] ], 
      [ [ 15, 18, 0, 27 ], [ 1, 4, 7, 28 ] ], 
      [ [ 15, 18, 9, 27 ], [ 3, 4, 21, 28 ] ], 
      [ [ 15, 18, 18, 27 ], [ 1, 4, 7, 28 ] ], 
      [ [ 16, 18, 1, 27 ], [ 2, 4, 8, 28 ] ], 
      [ [ 16, 18, 19, 27 ], [ 2, 4, 8, 28 ] ], 
      [ [ 17, 18, 2, 27 ], [ 3, 4, 9, 28 ] ], 
      [ [ 17, 18, 20, 27 ], [ 3, 4, 9, 28 ] ], 
      [ [ 0, 9, 12, 27 ], [ 3, 6, 8, 28 ] ], 
      [ [ 0, 9, 24, 27 ], [ 3, 6, 2, 28 ] ], 
      [ [ 1, 9, 13, 27 ], [ 4, 6, 9, 28 ] ], 
      [ [ 1, 9, 25, 27 ], [ 4, 6, 3, 28 ] ], 
      [ [ 2, 9, 14, 27 ], [ 5, 6, 10, 28 ] ], 
      [ [ 2, 9, 26, 27 ], [ 5, 6, 4, 28 ] ], 
      [ [ 3, 9, 9, 27 ], [ 3, 6, 0, 28 ] ], 
      [ [ 3, 9, 15, 27 ], [ 0, 6, 25, 28 ] ], 
      [ [ 4, 9, 10, 27 ], [ 4, 6, 1, 28 ] ], 
      [ [ 4, 9, 16, 27 ], [ 1, 6, 26, 28 ] ], 
      [ [ 5, 9, 11, 27 ], [ 5, 6, 2, 28 ] ], 
      [ [ 5, 9, 17, 27 ], [ 2, 6, 27, 28 ] ], 
      [ [ 6, 9, 0, 27 ], [ 0, 6, 23, 28 ] ], 
      [ [ 6, 9, 12, 27 ], [ 0, 6, 17, 28 ] ], 
      [ [ 7, 9, 1, 27 ], [ 1, 6, 24, 28 ] ], 
      [ [ 7, 9, 13, 27 ], [ 1, 6, 18, 28 ] ], 
      [ [ 8, 9, 2, 27 ], [ 2, 6, 25, 28 ] ], 
      [ [ 8, 9, 14, 27 ], [ 2, 6, 19, 28 ] ], 
      [ [ 0, 9, 6, 27 ], [ 3, 12, 25, 28 ] ], 
      [ [ 0, 9, 12, 27 ], [ 6, 12, 8, 28 ] ], 
      [ [ 1, 9, 7, 27 ], [ 4, 12, 26, 28 ] ], 
      [ [ 1, 9, 13, 27 ], [ 7, 12, 9, 28 ] ], 
      [ [ 2, 9, 8, 27 ], [ 5, 12, 27, 28 ] ], 
      [ [ 2, 9, 14, 27 ], [ 8, 12, 10, 28 ] ], 
      [ [ 3, 9, 9, 27 ], [ 0, 12, 14, 28 ] ], 
      [ [ 3, 9, 15, 27 ], [ 9, 12, 11, 28 ] ], 
      [ [ 4, 9, 10, 27 ], [ 1, 12, 15, 28 ] ], 
      [ [ 4, 9, 16, 27 ], [ 10, 12, 12, 28 ] ], 
      [ [ 5, 9, 11, 27 ], [ 2, 12, 16, 28 ] ], 
      [ [ 5, 9, 17, 27 ], [ 11, 12, 13, 28 ] ], 
      [ [ 6, 9, 12, 27 ], [ 3, 12, 17, 28 ] ], 
      [ [ 6, 9, 18, 27 ], [ 6, 12, 0, 28 ] ], 
      [ [ 7, 9, 13, 27 ], [ 4, 12, 18, 28 ] ], 
      [ [ 7, 9, 19, 27 ], [ 7, 12, 1, 28 ] ], 
      [ [ 8, 9, 14, 27 ], [ 5, 12, 19, 28 ] ], 
      [ [ 8, 9, 20, 27 ], [ 8, 12, 2, 28 ] ], 
      [ [ 0, 9, 6, 27 ], [ 21, 24, 11, 28 ] ], 
      [ [ 0, 9, 24, 27 ], [ 12, 24, 2, 28 ] ], 
      [ [ 1, 9, 7, 27 ], [ 22, 24, 12, 28 ] ], 
      [ [ 1, 9, 25, 27 ], [ 13, 24, 3, 28 ] ], 
      [ [ 2, 9, 8, 27 ], [ 23, 24, 13, 28 ] ], 
      [ [ 2, 9, 26, 27 ], [ 14, 24, 4, 28 ] ], 
      [ [ 6, 9, 0, 27 ], [ 9, 24, 23, 28 ] ], 
      [ [ 6, 9, 18, 27 ], [ 0, 24, 14, 28 ] ], 
      [ [ 7, 9, 1, 27 ], [ 10, 24, 24, 28 ] ], 
      [ [ 7, 9, 19, 27 ], [ 1, 24, 15, 28 ] ], 
      [ [ 8, 9, 2, 27 ], [ 11, 24, 25, 28 ] ], 
      [ [ 8, 9, 20, 27 ], [ 2, 24, 16, 28 ] ], 
      [ [ 0, 3, 13, 21 ], [ 6, 28, 27, 28 ] ], 
      [ [ 0, 3, 19, 21 ], [ 5, 28, 26, 28 ] ], 
      [ [ 1, 3, 0, 21 ], [ 0, 28, 21, 28 ] ], 
      [ [ 1, 3, 20, 21 ], [ 6, 28, 27, 28 ] ], 
      [ [ 2, 3, 1, 21 ], [ 1, 28, 22, 28 ] ], 
      [ [ 2, 3, 7, 21 ], [ 0, 28, 21, 28 ] ], 
      [ [ 0, 3, 7, 24 ], [ 3, 28, 27, 28 ] ], 
      [ [ 0, 3, 14, 24 ], [ 2, 28, 26, 28 ] ], 
      [ [ 1, 3, 8, 24 ], [ 0, 28, 24, 28 ] ], 
      [ [ 1, 3, 15, 24 ], [ 3, 28, 27, 28 ] ], 
      [ [ 2, 3, 9, 24 ], [ 1, 28, 25, 28 ] ], 
      [ [ 2, 3, 16, 24 ], [ 0, 28, 24, 28 ] ], 
      [ [ 0, 9, 6, 27 ], [ 0, 2, 27, 30 ] ], 
      [ [ 0, 9, 12, 27 ], [ 0, 2, 9, 30 ] ], 
      [ [ 0, 9, 12, 27 ], [ 1, 2, 24, 30 ] ], 
      [ [ 1, 9, 7, 27 ], [ 0, 2, 13, 30 ] ], 
      [ [ 1, 9, 7, 27 ], [ 1, 2, 28, 30 ] ], 
      [ [ 1, 9, 13, 27 ], [ 1, 2, 10, 30 ] ], 
      [ [ 2, 9, 8, 27 ], [ 1, 2, 14, 30 ] ], 
      [ [ 3, 9, 9, 27 ], [ 1, 2, 0, 30 ] ], 
      [ [ 5, 9, 17, 27 ], [ 0, 2, 29, 30 ] ], 
      [ [ 6, 9, 18, 27 ], [ 0, 2, 15, 30 ] ], 
      [ [ 7, 9, 13, 27 ], [ 0, 2, 19, 30 ] ], 
      [ [ 7, 9, 19, 27 ], [ 0, 2, 1, 30 ] ], 
      [ [ 7, 9, 19, 27 ], [ 1, 2, 16, 30 ] ], 
      [ [ 8, 9, 14, 27 ], [ 0, 2, 5, 30 ] ], 
      [ [ 8, 9, 14, 27 ], [ 1, 2, 20, 30 ] ], 
      [ [ 8, 9, 20, 27 ], [ 1, 2, 2, 30 ] ], 
      [ [ 0, 4, 6, 16 ], [ 0, 3, 8, 30 ] ], 
      [ [ 0, 4, 6, 16 ], [ 0, 3, 28, 30 ] ], 
      [ [ 0, 4, 6, 16 ], [ 1, 3, 18, 30 ] ], 
      [ [ 0, 4, 6, 16 ], [ 2, 3, 28, 30 ] ], 
      [ [ 1, 4, 7, 16 ], [ 0, 3, 19, 30 ] ], 
      [ [ 1, 4, 7, 16 ], [ 1, 3, 9, 30 ] ], 
      [ [ 1, 4, 7, 16 ], [ 1, 3, 29, 30 ] ], 
      [ [ 1, 4, 7, 16 ], [ 2, 3, 19, 30 ] ], 
      [ [ 2, 4, 8, 16 ], [ 0, 3, 10, 30 ] ], 
      [ [ 2, 4, 8, 16 ], [ 1, 3, 0, 30 ] ], 
      [ [ 2, 4, 8, 16 ], [ 1, 3, 20, 30 ] ], 
      [ [ 2, 4, 8, 16 ], [ 2, 3, 10, 30 ] ], 
      [ [ 3, 4, 9, 16 ], [ 0, 3, 1, 30 ] ], 
      [ [ 3, 4, 9, 16 ], [ 1, 3, 11, 30 ] ], 
      [ [ 3, 4, 9, 16 ], [ 2, 3, 1, 30 ] ], 
      [ [ 3, 4, 9, 16 ], [ 2, 3, 21, 30 ] ], 
      [ [ 0, 4, 6, 28 ], [ 0, 3, 4, 30 ] ], 
      [ [ 0, 4, 6, 28 ], [ 1, 3, 14, 30 ] ], 
      [ [ 0, 4, 6, 28 ], [ 2, 3, 4, 30 ] ], 
      [ [ 0, 4, 6, 28 ], [ 2, 3, 24, 30 ] ], 
      [ [ 0, 4, 18, 28 ], [ 1, 3, 2, 30 ] ], 
      [ [ 0, 4, 18, 28 ], [ 2, 3, 12, 30 ] ], 
      [ [ 1, 4, 7, 28 ], [ 1, 3, 5, 30 ] ], 
      [ [ 1, 4, 7, 28 ], [ 2, 3, 15, 30 ] ], 
      [ [ 1, 4, 19, 28 ], [ 0, 3, 23, 30 ] ], 
      [ [ 1, 4, 19, 28 ], [ 2, 3, 3, 30 ] ], 
      [ [ 2, 4, 8, 28 ], [ 0, 3, 26, 30 ] ], 
      [ [ 2, 4, 8, 28 ], [ 2, 3, 6, 30 ] ], 
      [ [ 2, 4, 20, 28 ], [ 0, 3, 14, 30 ] ], 
      [ [ 2, 4, 20, 28 ], [ 1, 3, 24, 30 ] ], 
      [ [ 3, 4, 9, 28 ], [ 0, 3, 17, 30 ] ], 
      [ [ 3, 4, 9, 28 ], [ 1, 3, 27, 30 ] ], 
      [ [ 3, 4, 21, 28 ], [ 0, 3, 5, 30 ] ], 
      [ [ 3, 4, 21, 28 ], [ 0, 3, 25, 30 ] ], 
      [ [ 3, 4, 21, 28 ], [ 1, 3, 15, 30 ] ], 
      [ [ 3, 4, 21, 28 ], [ 2, 3, 25, 30 ] ], 
      [ [ 0, 9, 6, 27 ], [ 1, 4, 12, 30 ] ], 
      [ [ 0, 9, 12, 27 ], [ 0, 4, 9, 30 ] ], 
      [ [ 1, 9, 7, 27 ], [ 2, 4, 13, 30 ] ], 
      [ [ 1, 9, 13, 27 ], [ 1, 4, 10, 30 ] ], 
      [ [ 2, 9, 8, 27 ], [ 3, 4, 14, 30 ] ], 
      [ [ 2, 9, 14, 27 ], [ 2, 4, 11, 30 ] ], 
      [ [ 2, 9, 26, 27 ], [ 0, 4, 5, 30 ] ], 
      [ [ 3, 9, 15, 27 ], [ 3, 4, 12, 30 ] ], 
      [ [ 5, 9, 11, 27 ], [ 0, 4, 17, 30 ] ], 
      [ [ 6, 9, 0, 27 ], [ 3, 4, 24, 30 ] ], 
      [ [ 6, 9, 12, 27 ], [ 1, 4, 18, 30 ] ], 
      [ [ 6, 9, 18, 27 ], [ 0, 4, 15, 30 ] ], 
      [ [ 7, 9, 13, 27 ], [ 2, 4, 19, 30 ] ], 
      [ [ 7, 9, 19, 27 ], [ 1, 4, 16, 30 ] ], 
      [ [ 8, 9, 14, 27 ], [ 3, 4, 20, 30 ] ], 
      [ [ 8, 9, 20, 27 ], [ 2, 4, 17, 30 ] ], 
      [ [ 0, 9, 6, 27 ], [ 5, 8, 12, 30 ] ], 
      [ [ 0, 9, 12, 27 ], [ 6, 8, 9, 30 ] ], 
      [ [ 1, 9, 7, 27 ], [ 6, 8, 13, 30 ] ], 
      [ [ 1, 9, 13, 27 ], [ 7, 8, 10, 30 ] ], 
      [ [ 2, 9, 8, 27 ], [ 7, 8, 14, 30 ] ], 
      [ [ 6, 9, 18, 27 ], [ 0, 8, 15, 30 ] ], 
      [ [ 7, 9, 13, 27 ], [ 0, 8, 19, 30 ] ], 
      [ [ 7, 9, 19, 27 ], [ 1, 8, 16, 30 ] ], 
      [ [ 8, 9, 14, 27 ], [ 1, 8, 20, 30 ] ], 
      [ [ 8, 9, 20, 27 ], [ 2, 8, 17, 30 ] ], 
      [ [ 0, 4, 6, 16 ], [ 1, 9, 18, 30 ] ], 
      [ [ 0, 4, 6, 16 ], [ 4, 9, 8, 30 ] ], 
      [ [ 0, 4, 6, 16 ], [ 7, 9, 18, 30 ] ], 
      [ [ 1, 4, 7, 16 ], [ 2, 9, 19, 30 ] ], 
      [ [ 1, 4, 7, 16 ], [ 5, 9, 9, 30 ] ], 
      [ [ 1, 4, 7, 16 ], [ 8, 9, 19, 30 ] ], 
      [ [ 2, 4, 8, 16 ], [ 0, 9, 10, 30 ] ], 
      [ [ 2, 4, 8, 16 ], [ 3, 9, 20, 30 ] ], 
      [ [ 2, 4, 8, 16 ], [ 6, 9, 10, 30 ] ], 
      [ [ 3, 4, 9, 16 ], [ 1, 9, 11, 30 ] ], 
      [ [ 3, 4, 9, 16 ], [ 4, 9, 21, 30 ] ], 
      [ [ 3, 4, 9, 16 ], [ 7, 9, 11, 30 ] ], 
      [ [ 0, 4, 6, 28 ], [ 2, 9, 4, 30 ] ], 
      [ [ 0, 4, 6, 28 ], [ 2, 9, 24, 30 ] ], 
      [ [ 0, 4, 6, 28 ], [ 8, 9, 4, 30 ] ], 
      [ [ 0, 4, 6, 28 ], [ 8, 9, 24, 30 ] ], 
      [ [ 0, 4, 18, 28 ], [ 3, 9, 2, 30 ] ], 
      [ [ 0, 4, 18, 28 ], [ 3, 9, 22, 30 ] ], 
      [ [ 1, 4, 7, 28 ], [ 3, 9, 5, 30 ] ], 
      [ [ 1, 4, 7, 28 ], [ 3, 9, 25, 30 ] ], 
      [ [ 1, 4, 19, 28 ], [ 4, 9, 3, 30 ] ], 
      [ [ 1, 4, 19, 28 ], [ 4, 9, 23, 30 ] ], 
      [ [ 2, 4, 8, 28 ], [ 4, 9, 6, 30 ] ], 
      [ [ 2, 4, 8, 28 ], [ 4, 9, 26, 30 ] ], 
      [ [ 2, 4, 20, 28 ], [ 5, 9, 4, 30 ] ], 
      [ [ 2, 4, 20, 28 ], [ 5, 9, 24, 30 ] ], 
      [ [ 3, 4, 9, 28 ], [ 5, 9, 7, 30 ] ], 
      [ [ 3, 4, 9, 28 ], [ 5, 9, 27, 30 ] ], 
      [ [ 3, 4, 21, 28 ], [ 0, 9, 5, 30 ] ], 
      [ [ 3, 4, 21, 28 ], [ 0, 9, 25, 30 ] ], 
      [ [ 3, 4, 21, 28 ], [ 6, 9, 5, 30 ] ], 
      [ [ 3, 4, 21, 28 ], [ 6, 9, 25, 30 ] ], 
      [ [ 0, 9, 6, 27 ], [ 7, 10, 12, 30 ] ], 
      [ [ 0, 9, 24, 27 ], [ 3, 10, 18, 30 ] ], 
      [ [ 1, 9, 7, 27 ], [ 8, 10, 13, 30 ] ], 
      [ [ 1, 9, 13, 27 ], [ 0, 10, 25, 30 ] ], 
      [ [ 1, 9, 25, 27 ], [ 4, 10, 19, 30 ] ], 
      [ [ 2, 9, 8, 27 ], [ 9, 10, 14, 30 ] ], 
      [ [ 2, 9, 14, 27 ], [ 1, 10, 26, 30 ] ], 
      [ [ 2, 9, 26, 27 ], [ 0, 10, 5, 30 ] ], 
      [ [ 2, 9, 26, 27 ], [ 5, 10, 20, 30 ] ], 
      [ [ 3, 9, 9, 27 ], [ 5, 10, 0, 30 ] ], 
      [ [ 3, 9, 15, 27 ], [ 2, 10, 27, 30 ] ], 
      [ [ 4, 9, 10, 27 ], [ 6, 10, 1, 30 ] ], 
      [ [ 4, 9, 16, 27 ], [ 3, 10, 28, 30 ] ], 
      [ [ 5, 9, 11, 27 ], [ 7, 10, 2, 30 ] ], 
      [ [ 5, 9, 17, 27 ], [ 4, 10, 29, 30 ] ], 
      [ [ 6, 9, 0, 27 ], [ 4, 10, 9, 30 ] ], 
      [ [ 6, 9, 0, 27 ], [ 9, 10, 24, 30 ] ], 
      [ [ 6, 9, 12, 27 ], [ 8, 10, 3, 30 ] ], 
      [ [ 6, 9, 18, 27 ], [ 0, 10, 15, 30 ] ], 
      [ [ 7, 9, 1, 27 ], [ 5, 10, 10, 30 ] ], 
      [ [ 7, 9, 13, 27 ], [ 9, 10, 4, 30 ] ], 
      [ [ 7, 9, 19, 27 ], [ 1, 10, 16, 30 ] ], 
      [ [ 8, 9, 2, 27 ], [ 6, 10, 11, 30 ] ], 
      [ [ 8, 9, 20, 27 ], [ 2, 10, 17, 30 ] ], 
      [ [ 0, 9, 6, 27 ], [ 11, 14, 12, 30 ] ], 
      [ [ 0, 9, 12, 27 ], [ 1, 14, 24, 30 ] ], 
      [ [ 0, 9, 24, 27 ], [ 2, 14, 3, 30 ] ], 
      [ [ 0, 9, 24, 27 ], [ 9, 14, 18, 30 ] ], 
      [ [ 1, 9, 7, 27 ], [ 12, 14, 13, 30 ] ], 
      [ [ 1, 9, 13, 27 ], [ 2, 14, 25, 30 ] ], 
      [ [ 1, 9, 25, 27 ], [ 3, 14, 4, 30 ] ], 
      [ [ 1, 9, 25, 27 ], [ 10, 14, 19, 30 ] ], 
      [ [ 2, 9, 8, 27 ], [ 13, 14, 14, 30 ] ], 
      [ [ 2, 9, 14, 27 ], [ 3, 14, 26, 30 ] ], 
      [ [ 2, 9, 26, 27 ], [ 4, 14, 5, 30 ] ], 
      [ [ 2, 9, 26, 27 ], [ 11, 14, 20, 30 ] ], 
      [ [ 3, 9, 9, 27 ], [ 7, 14, 0, 30 ] ], 
      [ [ 3, 9, 15, 27 ], [ 4, 14, 27, 30 ] ], 
      [ [ 4, 9, 10, 27 ], [ 8, 14, 1, 30 ] ], 
      [ [ 4, 9, 16, 27 ], [ 5, 14, 28, 30 ] ], 
      [ [ 5, 9, 11, 27 ], [ 9, 14, 2, 30 ] ], 
      [ [ 5, 9, 17, 27 ], [ 6, 14, 29, 30 ] ], 
      [ [ 6, 9, 0, 27 ], [ 2, 14, 9, 30 ] ], 
      [ [ 6, 9, 0, 27 ], [ 9, 14, 24, 30 ] ], 
      [ [ 6, 9, 12, 27 ], [ 10, 14, 3, 30 ] ], 
      [ [ 6, 9, 18, 27 ], [ 0, 14, 15, 30 ] ], 
      [ [ 7, 9, 1, 27 ], [ 3, 14, 10, 30 ] ], 
      [ [ 7, 9, 1, 27 ], [ 10, 14, 25, 30 ] ], 
      [ [ 7, 9, 13, 27 ], [ 11, 14, 4, 30 ] ], 
      [ [ 7, 9, 19, 27 ], [ 1, 14, 16, 30 ] ], 
      [ [ 8, 9, 2, 27 ], [ 4, 14, 11, 30 ] ], 
      [ [ 8, 9, 2, 27 ], [ 11, 14, 26, 30 ] ], 
      [ [ 8, 9, 14, 27 ], [ 12, 14, 5, 30 ] ], 
      [ [ 8, 9, 20, 27 ], [ 2, 14, 17, 30 ] ], 
      [ [ 0, 4, 6, 16 ], [ 8, 15, 28, 30 ] ], 
      [ [ 0, 4, 6, 16 ], [ 13, 15, 18, 30 ] ], 
      [ [ 1, 4, 7, 16 ], [ 9, 15, 29, 30 ] ], 
      [ [ 1, 4, 7, 16 ], [ 14, 15, 19, 30 ] ], 
      [ [ 2, 4, 8, 16 ], [ 0, 15, 10, 30 ] ], 
      [ [ 2, 4, 8, 16 ], [ 5, 15, 0, 30 ] ], 
      [ [ 3, 4, 9, 16 ], [ 1, 15, 11, 30 ] ], 
      [ [ 3, 4, 9, 16 ], [ 6, 15, 1, 30 ] ], 
      [ [ 0, 4, 6, 28 ], [ 4, 15, 24, 30 ] ], 
      [ [ 0, 4, 6, 28 ], [ 9, 15, 14, 30 ] ], 
      [ [ 0, 4, 6, 28 ], [ 14, 15, 4, 30 ] ], 
      [ [ 0, 4, 6, 28 ], [ 14, 15, 24, 30 ] ], 
      [ [ 0, 4, 18, 28 ], [ 2, 15, 12, 30 ] ], 
      [ [ 0, 4, 18, 28 ], [ 7, 15, 2, 30 ] ], 
      [ [ 1, 4, 7, 28 ], [ 5, 15, 25, 30 ] ], 
      [ [ 1, 4, 7, 28 ], [ 10, 15, 15, 30 ] ], 
      [ [ 1, 4, 19, 28 ], [ 3, 15, 13, 30 ] ], 
      [ [ 1, 4, 19, 28 ], [ 8, 15, 3, 30 ] ], 
      [ [ 2, 4, 8, 28 ], [ 6, 15, 26, 30 ] ], 
      [ [ 2, 4, 8, 28 ], [ 11, 15, 16, 30 ] ], 
      [ [ 2, 4, 20, 28 ], [ 4, 15, 14, 30 ] ], 
      [ [ 2, 4, 20, 28 ], [ 9, 15, 4, 30 ] ], 
      [ [ 3, 4, 9, 28 ], [ 7, 15, 27, 30 ] ], 
      [ [ 3, 4, 9, 28 ], [ 12, 15, 17, 30 ] ], 
      [ [ 3, 4, 21, 28 ], [ 0, 15, 5, 30 ] ], 
      [ [ 3, 4, 21, 28 ], [ 0, 15, 25, 30 ] ], 
      [ [ 3, 4, 21, 28 ], [ 5, 15, 15, 30 ] ], 
      [ [ 3, 4, 21, 28 ], [ 10, 15, 5, 30 ] ], 
      [ [ 0, 9, 6, 27 ], [ 13, 16, 12, 30 ] ], 
      [ [ 0, 9, 24, 27 ], [ 4, 16, 3, 30 ] ], 
      [ [ 1, 9, 7, 27 ], [ 14, 16, 13, 30 ] ], 
      [ [ 1, 9, 25, 27 ], [ 5, 16, 4, 30 ] ], 
      [ [ 2, 9, 8, 27 ], [ 15, 16, 14, 30 ] ], 
      [ [ 2, 9, 26, 27 ], [ 6, 16, 5, 30 ] ], 
      [ [ 6, 9, 0, 27 ], [ 9, 16, 24, 30 ] ], 
      [ [ 6, 9, 18, 27 ], [ 0, 16, 15, 30 ] ], 
      [ [ 7, 9, 1, 27 ], [ 10, 16, 25, 30 ] ], 
      [ [ 7, 9, 19, 27 ], [ 1, 16, 16, 30 ] ], 
      [ [ 8, 9, 2, 27 ], [ 11, 16, 26, 30 ] ], 
      [ [ 8, 9, 20, 27 ], [ 2, 16, 17, 30 ] ], 
      [ [ 0, 9, 6, 27 ], [ 17, 20, 12, 30 ] ], 
      [ [ 0, 9, 24, 27 ], [ 8, 20, 3, 30 ] ], 
      [ [ 1, 9, 7, 27 ], [ 18, 20, 13, 30 ] ], 
      [ [ 1, 9, 25, 27 ], [ 9, 20, 4, 30 ] ], 
      [ [ 2, 9, 8, 27 ], [ 19, 20, 14, 30 ] ], 
      [ [ 2, 9, 26, 27 ], [ 10, 20, 5, 30 ] ], 
      [ [ 6, 9, 0, 27 ], [ 9, 20, 24, 30 ] ], 
      [ [ 6, 9, 18, 27 ], [ 0, 20, 15, 30 ] ], 
      [ [ 7, 9, 1, 27 ], [ 10, 20, 25, 30 ] ], 
      [ [ 7, 9, 19, 27 ], [ 1, 20, 16, 30 ] ], 
      [ [ 8, 9, 2, 27 ], [ 11, 20, 26, 30 ] ], 
      [ [ 8, 9, 20, 27 ], [ 2, 20, 17, 30 ] ], 
      [ [ 0, 4, 6, 16 ], [ 5, 21, 18, 30 ] ], 
      [ [ 0, 4, 6, 16 ], [ 12, 21, 8, 30 ] ], 
      [ [ 0, 4, 6, 16 ], [ 12, 21, 28, 30 ] ], 
      [ [ 0, 4, 6, 16 ], [ 19, 21, 18, 30 ] ], 
      [ [ 1, 4, 7, 16 ], [ 6, 21, 19, 30 ] ], 
      [ [ 1, 4, 7, 16 ], [ 13, 21, 9, 30 ] ], 
      [ [ 1, 4, 7, 16 ], [ 13, 21, 29, 30 ] ], 
      [ [ 1, 4, 7, 16 ], [ 20, 21, 19, 30 ] ], 
      [ [ 2, 4, 8, 16 ], [ 0, 21, 10, 30 ] ], 
      [ [ 2, 4, 8, 16 ], [ 7, 21, 0, 30 ] ], 
      [ [ 2, 4, 8, 16 ], [ 7, 21, 20, 30 ] ], 
      [ [ 2, 4, 8, 16 ], [ 14, 21, 10, 30 ] ], 
      [ [ 3, 4, 9, 16 ], [ 1, 21, 11, 30 ] ], 
      [ [ 3, 4, 9, 16 ], [ 8, 21, 1, 30 ] ], 
      [ [ 3, 4, 9, 16 ], [ 8, 21, 21, 30 ] ], 
      [ [ 3, 4, 9, 16 ], [ 15, 21, 11, 30 ] ], 
      [ [ 0, 9, 6, 27 ], [ 19, 22, 12, 30 ] ], 
      [ [ 0, 9, 12, 27 ], [ 5, 22, 24, 30 ] ], 
      [ [ 0, 9, 24, 27 ], [ 10, 22, 3, 30 ] ], 
      [ [ 0, 9, 24, 27 ], [ 21, 22, 18, 30 ] ], 
      [ [ 1, 9, 7, 27 ], [ 20, 22, 13, 30 ] ], 
      [ [ 1, 9, 13, 27 ], [ 6, 22, 25, 30 ] ], 
      [ [ 1, 9, 25, 27 ], [ 11, 22, 4, 30 ] ], 
      [ [ 2, 9, 8, 27 ], [ 21, 22, 14, 30 ] ], 
      [ [ 2, 9, 14, 27 ], [ 7, 22, 26, 30 ] ], 
      [ [ 2, 9, 26, 27 ], [ 12, 22, 5, 30 ] ], 
      [ [ 3, 9, 9, 27 ], [ 11, 22, 0, 30 ] ], 
      [ [ 3, 9, 15, 27 ], [ 8, 22, 27, 30 ] ], 
      [ [ 4, 9, 10, 27 ], [ 12, 22, 1, 30 ] ], 
      [ [ 4, 9, 16, 27 ], [ 9, 22, 28, 30 ] ], 
      [ [ 5, 9, 11, 27 ], [ 13, 22, 2, 30 ] ], 
      [ [ 5, 9, 17, 27 ], [ 10, 22, 29, 30 ] ], 
      [ [ 6, 9, 0, 27 ], [ 9, 22, 24, 30 ] ], 
      [ [ 6, 9, 12, 27 ], [ 14, 22, 3, 30 ] ], 
      [ [ 6, 9, 18, 27 ], [ 0, 22, 15, 30 ] ], 
      [ [ 7, 9, 1, 27 ], [ 10, 22, 25, 30 ] ], 
      [ [ 7, 9, 13, 27 ], [ 15, 22, 4, 30 ] ], 
      [ [ 7, 9, 19, 27 ], [ 1, 22, 16, 30 ] ], 
      [ [ 8, 9, 2, 27 ], [ 0, 22, 11, 30 ] ], 
      [ [ 8, 9, 2, 27 ], [ 11, 22, 26, 30 ] ], 
      [ [ 8, 9, 14, 27 ], [ 16, 22, 5, 30 ] ], 
      [ [ 8, 9, 20, 27 ], [ 2, 22, 17, 30 ] ], 
      [ [ 0, 9, 6, 27 ], [ 23, 26, 12, 30 ] ], 
      [ [ 0, 9, 12, 27 ], [ 7, 26, 24, 30 ] ], 
      [ [ 0, 9, 24, 27 ], [ 14, 26, 3, 30 ] ], 
      [ [ 1, 9, 7, 27 ], [ 24, 26, 13, 30 ] ], 
      [ [ 1, 9, 13, 27 ], [ 8, 26, 25, 30 ] ], 
      [ [ 1, 9, 25, 27 ], [ 15, 26, 4, 30 ] ], 
      [ [ 2, 9, 8, 27 ], [ 25, 26, 14, 30 ] ], 
      [ [ 2, 9, 14, 27 ], [ 9, 26, 26, 30 ] ], 
      [ [ 2, 9, 26, 27 ], [ 16, 26, 5, 30 ] ], 
      [ [ 3, 9, 9, 27 ], [ 13, 26, 0, 30 ] ], 
      [ [ 3, 9, 15, 27 ], [ 10, 26, 27, 30 ] ], 
      [ [ 4, 9, 10, 27 ], [ 14, 26, 1, 30 ] ], 
      [ [ 4, 9, 16, 27 ], [ 11, 26, 28, 30 ] ], 
      [ [ 5, 9, 11, 27 ], [ 15, 26, 2, 30 ] ], 
      [ [ 5, 9, 17, 27 ], [ 12, 26, 29, 30 ] ], 
      [ [ 6, 9, 0, 27 ], [ 9, 26, 24, 30 ] ], 
      [ [ 6, 9, 12, 27 ], [ 16, 26, 3, 30 ] ], 
      [ [ 6, 9, 18, 27 ], [ 0, 26, 15, 30 ] ], 
      [ [ 7, 9, 1, 27 ], [ 10, 26, 25, 30 ] ], 
      [ [ 7, 9, 13, 27 ], [ 17, 26, 4, 30 ] ], 
      [ [ 7, 9, 19, 27 ], [ 1, 26, 16, 30 ] ], 
      [ [ 8, 9, 2, 27 ], [ 11, 26, 26, 30 ] ], 
      [ [ 8, 9, 14, 27 ], [ 18, 26, 5, 30 ] ], 
      [ [ 8, 9, 20, 27 ], [ 2, 26, 17, 30 ] ], 
      [ [ 0, 4, 6, 16 ], [ 7, 27, 18, 30 ] ], 
      [ [ 0, 4, 6, 16 ], [ 16, 27, 8, 30 ] ], 
      [ [ 0, 4, 6, 16 ], [ 25, 27, 18, 30 ] ], 
      [ [ 1, 4, 7, 16 ], [ 8, 27, 19, 30 ] ], 
      [ [ 1, 4, 7, 16 ], [ 17, 27, 9, 30 ] ], 
      [ [ 1, 4, 7, 16 ], [ 26, 27, 19, 30 ] ], 
      [ [ 2, 4, 8, 16 ], [ 0, 27, 10, 30 ] ], 
      [ [ 2, 4, 8, 16 ], [ 9, 27, 20, 30 ] ], 
      [ [ 2, 4, 8, 16 ], [ 18, 27, 10, 30 ] ], 
      [ [ 3, 4, 9, 16 ], [ 1, 27, 11, 30 ] ], 
      [ [ 3, 4, 9, 16 ], [ 10, 27, 21, 30 ] ], 
      [ [ 3, 4, 9, 16 ], [ 19, 27, 11, 30 ] ], 
      [ [ 0, 4, 6, 28 ], [ 8, 27, 4, 30 ] ], 
      [ [ 0, 4, 6, 28 ], [ 8, 27, 24, 30 ] ], 
      [ [ 0, 4, 6, 28 ], [ 26, 27, 4, 30 ] ], 
      [ [ 0, 4, 6, 28 ], [ 26, 27, 24, 30 ] ], 
      [ [ 0, 4, 18, 28 ], [ 15, 27, 2, 30 ] ], 
      [ [ 0, 4, 18, 28 ], [ 15, 27, 22, 30 ] ], 
      [ [ 1, 4, 7, 28 ], [ 9, 27, 5, 30 ] ], 
      [ [ 1, 4, 7, 28 ], [ 9, 27, 25, 30 ] ], 
      [ [ 1, 4, 19, 28 ], [ 16, 27, 3, 30 ] ], 
      [ [ 1, 4, 19, 28 ], [ 16, 27, 23, 30 ] ], 
      [ [ 2, 4, 8, 28 ], [ 10, 27, 6, 30 ] ], 
      [ [ 2, 4, 8, 28 ], [ 10, 27, 26, 30 ] ], 
      [ [ 2, 4, 20, 28 ], [ 17, 27, 4, 30 ] ], 
      [ [ 2, 4, 20, 28 ], [ 17, 27, 24, 30 ] ], 
      [ [ 3, 4, 9, 28 ], [ 11, 27, 7, 30 ] ], 
      [ [ 3, 4, 9, 28 ], [ 11, 27, 27, 30 ] ], 
      [ [ 3, 4, 21, 28 ], [ 0, 27, 5, 30 ] ], 
      [ [ 3, 4, 21, 28 ], [ 0, 27, 25, 30 ] ], 
      [ [ 3, 4, 21, 28 ], [ 18, 27, 5, 30 ] ], 
      [ [ 3, 4, 21, 28 ], [ 18, 27, 25, 30 ] ], 
      [ [ 0, 9, 6, 27 ], [ 25, 28, 12, 30 ] ], 
      [ [ 0, 9, 24, 27 ], [ 16, 28, 3, 30 ] ], 
      [ [ 1, 9, 7, 27 ], [ 26, 28, 13, 30 ] ], 
      [ [ 1, 9, 25, 27 ], [ 17, 28, 4, 30 ] ], 
      [ [ 2, 9, 8, 27 ], [ 27, 28, 14, 30 ] ], 
      [ [ 2, 9, 26, 27 ], [ 18, 28, 5, 30 ] ], 
      [ [ 6, 9, 0, 27 ], [ 9, 28, 24, 30 ] ], 
      [ [ 6, 9, 18, 27 ], [ 0, 28, 15, 30 ] ], 
      [ [ 7, 9, 1, 27 ], [ 10, 28, 25, 30 ] ], 
      [ [ 7, 9, 19, 27 ], [ 1, 28, 16, 30 ] ], 
      [ [ 8, 9, 2, 27 ], [ 11, 28, 26, 30 ] ], 
      [ [ 8, 9, 20, 27 ], [ 2, 28, 17, 30 ] ], 
      [ [ 0, 4, 18, 20 ], [ 8, 30, 28, 30 ] ], 
      [ [ 1, 4, 19, 20 ], [ 9, 30, 29, 30 ] ], 
      [ [ 2, 4, 0, 20 ], [ 0, 30, 20, 30 ] ], 
      [ [ 3, 4, 1, 20 ], [ 1, 30, 21, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 4, 30, 28, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 5, 30, 29, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 0, 30, 24, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 1, 30, 25, 30 ] ], 
      [ [ 0, 7, 1, 14 ], [ 3, 4, 17, 32 ] ], 
      [ [ 0, 7, 2, 14 ], [ 2, 4, 16, 32 ] ], 
      [ [ 0, 7, 3, 14 ], [ 1, 4, 15, 32 ] ], 
      [ [ 0, 7, 4, 14 ], [ 0, 4, 14, 32 ] ], 
      [ [ 0, 7, 5, 14 ], [ 3, 4, 17, 32 ] ], 
      [ [ 0, 7, 6, 14 ], [ 2, 4, 16, 32 ] ], 
      [ [ 0, 7, 8, 14 ], [ 0, 4, 14, 32 ] ], 
      [ [ 0, 7, 9, 14 ], [ 3, 4, 17, 32 ] ], 
      [ [ 0, 7, 10, 14 ], [ 2, 4, 16, 32 ] ], 
      [ [ 0, 7, 11, 14 ], [ 1, 4, 15, 32 ] ], 
      [ [ 0, 7, 12, 14 ], [ 0, 4, 14, 32 ] ], 
      [ [ 0, 7, 13, 14 ], [ 3, 4, 17, 32 ] ], 
      [ [ 1, 7, 0, 14 ], [ 2, 4, 16, 32 ] ], 
      [ [ 1, 7, 2, 14 ], [ 0, 4, 14, 32 ] ], 
      [ [ 1, 7, 3, 14 ], [ 3, 4, 17, 32 ] ], 
      [ [ 1, 7, 4, 14 ], [ 2, 4, 16, 32 ] ], 
      [ [ 1, 7, 5, 14 ], [ 1, 4, 15, 32 ] ], 
      [ [ 1, 7, 6, 14 ], [ 0, 4, 14, 32 ] ], 
      [ [ 1, 7, 7, 14 ], [ 3, 4, 17, 32 ] ], 
      [ [ 1, 7, 9, 14 ], [ 1, 4, 15, 32 ] ], 
      [ [ 1, 7, 10, 14 ], [ 0, 4, 14, 32 ] ], 
      [ [ 1, 7, 11, 14 ], [ 3, 4, 17, 32 ] ], 
      [ [ 1, 7, 12, 14 ], [ 2, 4, 16, 32 ] ], 
      [ [ 1, 7, 13, 14 ], [ 1, 4, 15, 32 ] ], 
      [ [ 2, 7, 0, 14 ], [ 0, 4, 14, 32 ] ], 
      [ [ 2, 7, 1, 14 ], [ 3, 4, 17, 32 ] ], 
      [ [ 2, 7, 3, 14 ], [ 1, 4, 15, 32 ] ], 
      [ [ 2, 7, 4, 14 ], [ 0, 4, 14, 32 ] ], 
      [ [ 2, 7, 5, 14 ], [ 3, 4, 17, 32 ] ], 
      [ [ 2, 7, 6, 14 ], [ 2, 4, 16, 32 ] ], 
      [ [ 2, 7, 7, 14 ], [ 1, 4, 15, 32 ] ], 
      [ [ 2, 7, 8, 14 ], [ 0, 4, 14, 32 ] ], 
      [ [ 2, 7, 10, 14 ], [ 2, 4, 16, 32 ] ], 
      [ [ 2, 7, 11, 14 ], [ 1, 4, 15, 32 ] ], 
      [ [ 2, 7, 12, 14 ], [ 0, 4, 14, 32 ] ], 
      [ [ 2, 7, 13, 14 ], [ 3, 4, 17, 32 ] ], 
      [ [ 3, 7, 0, 14 ], [ 2, 4, 16, 32 ] ], 
      [ [ 3, 7, 1, 14 ], [ 1, 4, 15, 32 ] ], 
      [ [ 3, 7, 2, 14 ], [ 0, 4, 14, 32 ] ], 
      [ [ 3, 7, 4, 14 ], [ 2, 4, 16, 32 ] ], 
      [ [ 3, 7, 5, 14 ], [ 1, 4, 15, 32 ] ], 
      [ [ 3, 7, 6, 14 ], [ 0, 4, 14, 32 ] ], 
      [ [ 3, 7, 7, 14 ], [ 3, 4, 17, 32 ] ], 
      [ [ 3, 7, 8, 14 ], [ 2, 4, 16, 32 ] ], 
      [ [ 3, 7, 9, 14 ], [ 1, 4, 15, 32 ] ], 
      [ [ 3, 7, 11, 14 ], [ 3, 4, 17, 32 ] ], 
      [ [ 3, 7, 12, 14 ], [ 2, 4, 16, 32 ] ], 
      [ [ 3, 7, 13, 14 ], [ 1, 4, 15, 32 ] ], 
      [ [ 4, 7, 0, 14 ], [ 0, 4, 14, 32 ] ], 
      [ [ 4, 7, 1, 14 ], [ 3, 4, 17, 32 ] ], 
      [ [ 4, 7, 2, 14 ], [ 2, 4, 16, 32 ] ], 
      [ [ 4, 7, 3, 14 ], [ 1, 4, 15, 32 ] ], 
      [ [ 4, 7, 5, 14 ], [ 3, 4, 17, 32 ] ], 
      [ [ 4, 7, 6, 14 ], [ 2, 4, 16, 32 ] ], 
      [ [ 4, 7, 7, 14 ], [ 1, 4, 15, 32 ] ], 
      [ [ 4, 7, 8, 14 ], [ 0, 4, 14, 32 ] ], 
      [ [ 4, 7, 9, 14 ], [ 3, 4, 17, 32 ] ], 
      [ [ 4, 7, 10, 14 ], [ 2, 4, 16, 32 ] ], 
      [ [ 4, 7, 12, 14 ], [ 0, 4, 14, 32 ] ], 
      [ [ 4, 7, 13, 14 ], [ 3, 4, 17, 32 ] ], 
      [ [ 5, 7, 0, 14 ], [ 2, 4, 16, 32 ] ], 
      [ [ 5, 7, 1, 14 ], [ 1, 4, 15, 32 ] ], 
      [ [ 5, 7, 2, 14 ], [ 0, 4, 14, 32 ] ], 
      [ [ 5, 7, 3, 14 ], [ 3, 4, 17, 32 ] ], 
      [ [ 5, 7, 4, 14 ], [ 2, 4, 16, 32 ] ], 
      [ [ 5, 7, 6, 14 ], [ 0, 4, 14, 32 ] ], 
      [ [ 5, 7, 7, 14 ], [ 3, 4, 17, 32 ] ], 
      [ [ 5, 7, 8, 14 ], [ 2, 4, 16, 32 ] ], 
      [ [ 5, 7, 9, 14 ], [ 1, 4, 15, 32 ] ], 
      [ [ 5, 7, 10, 14 ], [ 0, 4, 14, 32 ] ], 
      [ [ 5, 7, 11, 14 ], [ 3, 4, 17, 32 ] ], 
      [ [ 5, 7, 13, 14 ], [ 1, 4, 15, 32 ] ], 
      [ [ 6, 7, 0, 14 ], [ 0, 4, 14, 32 ] ], 
      [ [ 6, 7, 1, 14 ], [ 3, 4, 17, 32 ] ], 
      [ [ 6, 7, 2, 14 ], [ 2, 4, 16, 32 ] ], 
      [ [ 6, 7, 3, 14 ], [ 1, 4, 15, 32 ] ], 
      [ [ 6, 7, 4, 14 ], [ 0, 4, 14, 32 ] ], 
      [ [ 6, 7, 5, 14 ], [ 3, 4, 17, 32 ] ], 
      [ [ 6, 7, 7, 14 ], [ 1, 4, 15, 32 ] ], 
      [ [ 6, 7, 8, 14 ], [ 0, 4, 14, 32 ] ], 
      [ [ 6, 7, 9, 14 ], [ 3, 4, 17, 32 ] ], 
      [ [ 6, 7, 10, 14 ], [ 2, 4, 16, 32 ] ], 
      [ [ 6, 7, 11, 14 ], [ 1, 4, 15, 32 ] ], 
      [ [ 6, 7, 12, 14 ], [ 0, 4, 14, 32 ] ], 
      [ [ 0, 14, 3, 21 ], [ 2, 4, 16, 32 ] ], 
      [ [ 0, 14, 4, 21 ], [ 0, 4, 14, 32 ] ], 
      [ [ 0, 14, 9, 21 ], [ 2, 4, 16, 32 ] ], 
      [ [ 0, 14, 10, 21 ], [ 0, 4, 14, 32 ] ], 
      [ [ 0, 14, 15, 21 ], [ 2, 4, 16, 32 ] ], 
      [ [ 0, 14, 16, 21 ], [ 0, 4, 14, 32 ] ], 
      [ [ 1, 14, 4, 21 ], [ 3, 4, 17, 32 ] ], 
      [ [ 1, 14, 5, 21 ], [ 1, 4, 15, 32 ] ], 
      [ [ 1, 14, 10, 21 ], [ 3, 4, 17, 32 ] ], 
      [ [ 1, 14, 11, 21 ], [ 1, 4, 15, 32 ] ], 
      [ [ 1, 14, 16, 21 ], [ 3, 4, 17, 32 ] ], 
      [ [ 1, 14, 17, 21 ], [ 1, 4, 15, 32 ] ], 
      [ [ 2, 14, 0, 21 ], [ 2, 4, 16, 32 ] ], 
      [ [ 2, 14, 1, 21 ], [ 0, 4, 14, 32 ] ], 
      [ [ 2, 14, 6, 21 ], [ 2, 4, 16, 32 ] ], 
      [ [ 2, 14, 7, 21 ], [ 0, 4, 14, 32 ] ], 
      [ [ 2, 14, 12, 21 ], [ 2, 4, 16, 32 ] ], 
      [ [ 2, 14, 13, 21 ], [ 0, 4, 14, 32 ] ], 
      [ [ 2, 14, 18, 21 ], [ 2, 4, 16, 32 ] ], 
      [ [ 2, 14, 19, 21 ], [ 0, 4, 14, 32 ] ], 
      [ [ 3, 14, 1, 21 ], [ 3, 4, 17, 32 ] ], 
      [ [ 3, 14, 2, 21 ], [ 1, 4, 15, 32 ] ], 
      [ [ 3, 14, 7, 21 ], [ 3, 4, 17, 32 ] ], 
      [ [ 3, 14, 8, 21 ], [ 1, 4, 15, 32 ] ], 
      [ [ 3, 14, 13, 21 ], [ 3, 4, 17, 32 ] ], 
      [ [ 3, 14, 14, 21 ], [ 1, 4, 15, 32 ] ], 
      [ [ 3, 14, 19, 21 ], [ 3, 4, 17, 32 ] ], 
      [ [ 3, 14, 20, 21 ], [ 1, 4, 15, 32 ] ], 
      [ [ 4, 14, 3, 21 ], [ 2, 4, 16, 32 ] ], 
      [ [ 4, 14, 9, 21 ], [ 2, 4, 16, 32 ] ], 
      [ [ 4, 14, 10, 21 ], [ 0, 4, 14, 32 ] ], 
      [ [ 4, 14, 15, 21 ], [ 2, 4, 16, 32 ] ], 
      [ [ 4, 14, 16, 21 ], [ 0, 4, 14, 32 ] ], 
      [ [ 5, 14, 4, 21 ], [ 3, 4, 17, 32 ] ], 
      [ [ 5, 14, 10, 21 ], [ 3, 4, 17, 32 ] ], 
      [ [ 5, 14, 11, 21 ], [ 1, 4, 15, 32 ] ], 
      [ [ 5, 14, 16, 21 ], [ 3, 4, 17, 32 ] ], 
      [ [ 5, 14, 17, 21 ], [ 1, 4, 15, 32 ] ], 
      [ [ 6, 14, 0, 21 ], [ 2, 4, 16, 32 ] ], 
      [ [ 6, 14, 1, 21 ], [ 0, 4, 14, 32 ] ], 
      [ [ 6, 14, 7, 21 ], [ 0, 4, 14, 32 ] ], 
      [ [ 6, 14, 12, 21 ], [ 2, 4, 16, 32 ] ], 
      [ [ 6, 14, 18, 21 ], [ 2, 4, 16, 32 ] ], 
      [ [ 6, 14, 19, 21 ], [ 0, 4, 14, 32 ] ], 
      [ [ 7, 14, 1, 21 ], [ 3, 4, 17, 32 ] ], 
      [ [ 7, 14, 2, 21 ], [ 1, 4, 15, 32 ] ], 
      [ [ 7, 14, 8, 21 ], [ 1, 4, 15, 32 ] ], 
      [ [ 7, 14, 13, 21 ], [ 3, 4, 17, 32 ] ], 
      [ [ 7, 14, 19, 21 ], [ 3, 4, 17, 32 ] ], 
      [ [ 7, 14, 20, 21 ], [ 1, 4, 15, 32 ] ], 
      [ [ 8, 14, 3, 21 ], [ 2, 4, 16, 32 ] ], 
      [ [ 8, 14, 4, 21 ], [ 0, 4, 14, 32 ] ], 
      [ [ 8, 14, 9, 21 ], [ 2, 4, 16, 32 ] ], 
      [ [ 8, 14, 10, 21 ], [ 0, 4, 14, 32 ] ], 
      [ [ 8, 14, 16, 21 ], [ 0, 4, 14, 32 ] ], 
      [ [ 9, 14, 4, 21 ], [ 3, 4, 17, 32 ] ], 
      [ [ 9, 14, 5, 21 ], [ 1, 4, 15, 32 ] ], 
      [ [ 9, 14, 10, 21 ], [ 3, 4, 17, 32 ] ], 
      [ [ 9, 14, 11, 21 ], [ 1, 4, 15, 32 ] ], 
      [ [ 9, 14, 17, 21 ], [ 1, 4, 15, 32 ] ], 
      [ [ 10, 14, 0, 21 ], [ 2, 4, 16, 32 ] ], 
      [ [ 10, 14, 1, 21 ], [ 0, 4, 14, 32 ] ], 
      [ [ 10, 14, 6, 21 ], [ 2, 4, 16, 32 ] ], 
      [ [ 10, 14, 7, 21 ], [ 0, 4, 14, 32 ] ], 
      [ [ 10, 14, 12, 21 ], [ 2, 4, 16, 32 ] ], 
      [ [ 10, 14, 13, 21 ], [ 0, 4, 14, 32 ] ], 
      [ [ 10, 14, 18, 21 ], [ 2, 4, 16, 32 ] ], 
      [ [ 10, 14, 19, 21 ], [ 0, 4, 14, 32 ] ], 
      [ [ 11, 14, 1, 21 ], [ 3, 4, 17, 32 ] ], 
      [ [ 11, 14, 2, 21 ], [ 1, 4, 15, 32 ] ], 
      [ [ 11, 14, 7, 21 ], [ 3, 4, 17, 32 ] ], 
      [ [ 11, 14, 8, 21 ], [ 1, 4, 15, 32 ] ], 
      [ [ 11, 14, 13, 21 ], [ 3, 4, 17, 32 ] ], 
      [ [ 11, 14, 14, 21 ], [ 1, 4, 15, 32 ] ], 
      [ [ 11, 14, 19, 21 ], [ 3, 4, 17, 32 ] ], 
      [ [ 11, 14, 20, 21 ], [ 1, 4, 15, 32 ] ], 
      [ [ 12, 14, 3, 21 ], [ 2, 4, 16, 32 ] ], 
      [ [ 12, 14, 4, 21 ], [ 0, 4, 14, 32 ] ], 
      [ [ 12, 14, 9, 21 ], [ 2, 4, 16, 32 ] ], 
      [ [ 12, 14, 10, 21 ], [ 0, 4, 14, 32 ] ], 
      [ [ 12, 14, 15, 21 ], [ 2, 4, 16, 32 ] ], 
      [ [ 12, 14, 16, 21 ], [ 0, 4, 14, 32 ] ], 
      [ [ 13, 14, 4, 21 ], [ 3, 4, 17, 32 ] ], 
      [ [ 13, 14, 5, 21 ], [ 1, 4, 15, 32 ] ], 
      [ [ 13, 14, 10, 21 ], [ 3, 4, 17, 32 ] ], 
      [ [ 13, 14, 11, 21 ], [ 1, 4, 15, 32 ] ], 
      [ [ 13, 14, 16, 21 ], [ 3, 4, 17, 32 ] ], 
      [ [ 13, 14, 17, 21 ], [ 1, 4, 15, 32 ] ], 
      [ [ 0, 9, 12, 27 ], [ 3, 6, 10, 32 ] ], 
      [ [ 0, 9, 24, 27 ], [ 3, 6, 4, 32 ] ], 
      [ [ 1, 9, 13, 27 ], [ 4, 6, 11, 32 ] ], 
      [ [ 1, 9, 25, 27 ], [ 4, 6, 5, 32 ] ], 
      [ [ 2, 9, 14, 27 ], [ 5, 6, 12, 32 ] ], 
      [ [ 2, 9, 26, 27 ], [ 5, 6, 6, 32 ] ], 
      [ [ 3, 9, 9, 27 ], [ 3, 6, 0, 32 ] ], 
      [ [ 3, 9, 15, 27 ], [ 0, 6, 29, 32 ] ], 
      [ [ 4, 9, 10, 27 ], [ 4, 6, 1, 32 ] ], 
      [ [ 4, 9, 16, 27 ], [ 1, 6, 30, 32 ] ], 
      [ [ 5, 9, 11, 27 ], [ 5, 6, 2, 32 ] ], 
      [ [ 5, 9, 17, 27 ], [ 2, 6, 31, 32 ] ], 
      [ [ 6, 9, 0, 27 ], [ 0, 6, 25, 32 ] ], 
      [ [ 6, 9, 12, 27 ], [ 0, 6, 19, 32 ] ], 
      [ [ 7, 9, 1, 27 ], [ 1, 6, 26, 32 ] ], 
      [ [ 7, 9, 13, 27 ], [ 1, 6, 20, 32 ] ], 
      [ [ 8, 9, 2, 27 ], [ 2, 6, 27, 32 ] ], 
      [ [ 8, 9, 14, 27 ], [ 2, 6, 21, 32 ] ], 
      [ [ 0, 3, 1, 6 ], [ 7, 8, 19, 32 ] ], 
      [ [ 0, 3, 2, 6 ], [ 6, 8, 18, 32 ] ], 
      [ [ 0, 3, 4, 6 ], [ 4, 8, 16, 32 ] ], 
      [ [ 0, 3, 5, 6 ], [ 3, 8, 15, 32 ] ], 
      [ [ 1, 3, 0, 6 ], [ 2, 8, 14, 32 ] ], 
      [ [ 1, 3, 2, 6 ], [ 0, 8, 12, 32 ] ], 
      [ [ 1, 3, 3, 6 ], [ 7, 8, 19, 32 ] ], 
      [ [ 1, 3, 5, 6 ], [ 5, 8, 17, 32 ] ], 
      [ [ 2, 3, 0, 6 ], [ 4, 8, 16, 32 ] ], 
      [ [ 2, 3, 1, 6 ], [ 3, 8, 15, 32 ] ], 
      [ [ 2, 3, 3, 6 ], [ 1, 8, 13, 32 ] ], 
      [ [ 2, 3, 4, 6 ], [ 0, 8, 12, 32 ] ], 
      [ [ 0, 6, 5, 9 ], [ 6, 8, 18, 32 ] ], 
      [ [ 0, 6, 7, 9 ], [ 2, 8, 14, 32 ] ], 
      [ [ 0, 6, 8, 9 ], [ 0, 8, 12, 32 ] ], 
      [ [ 1, 6, 6, 9 ], [ 7, 8, 19, 32 ] ], 
      [ [ 1, 6, 8, 9 ], [ 3, 8, 15, 32 ] ], 
      [ [ 4, 6, 0, 9 ], [ 4, 8, 16, 32 ] ], 
      [ [ 4, 6, 2, 9 ], [ 0, 8, 12, 32 ] ], 
      [ [ 5, 6, 0, 9 ], [ 7, 8, 19, 32 ] ], 
      [ [ 5, 6, 1, 9 ], [ 5, 8, 17, 32 ] ], 
      [ [ 5, 6, 3, 9 ], [ 1, 8, 13, 32 ] ], 
      [ [ 0, 3, 1, 12 ], [ 5, 8, 17, 32 ] ], 
      [ [ 0, 3, 2, 12 ], [ 2, 8, 14, 32 ] ], 
      [ [ 0, 3, 4, 12 ], [ 4, 8, 16, 32 ] ], 
      [ [ 0, 3, 5, 12 ], [ 1, 8, 13, 32 ] ], 
      [ [ 0, 3, 7, 12 ], [ 3, 8, 15, 32 ] ], 
      [ [ 0, 3, 8, 12 ], [ 0, 8, 12, 32 ] ], 
      [ [ 0, 3, 10, 12 ], [ 2, 8, 14, 32 ] ], 
      [ [ 0, 3, 11, 12 ], [ 7, 8, 19, 32 ] ], 
      [ [ 1, 3, 0, 12 ], [ 4, 8, 16, 32 ] ], 
      [ [ 1, 3, 2, 12 ], [ 6, 8, 18, 32 ] ], 
      [ [ 1, 3, 3, 12 ], [ 3, 8, 15, 32 ] ], 
      [ [ 1, 3, 5, 12 ], [ 5, 8, 17, 32 ] ], 
      [ [ 1, 3, 6, 12 ], [ 2, 8, 14, 32 ] ], 
      [ [ 1, 3, 8, 12 ], [ 4, 8, 16, 32 ] ], 
      [ [ 1, 3, 9, 12 ], [ 1, 8, 13, 32 ] ], 
      [ [ 1, 3, 11, 12 ], [ 3, 8, 15, 32 ] ], 
      [ [ 2, 3, 0, 12 ], [ 0, 8, 12, 32 ] ], 
      [ [ 2, 3, 1, 12 ], [ 5, 8, 17, 32 ] ], 
      [ [ 2, 3, 3, 12 ], [ 7, 8, 19, 32 ] ], 
      [ [ 2, 3, 4, 12 ], [ 4, 8, 16, 32 ] ], 
      [ [ 2, 3, 6, 12 ], [ 6, 8, 18, 32 ] ], 
      [ [ 2, 3, 7, 12 ], [ 3, 8, 15, 32 ] ], 
      [ [ 2, 3, 9, 12 ], [ 5, 8, 17, 32 ] ], 
      [ [ 2, 3, 10, 12 ], [ 2, 8, 14, 32 ] ], 
      [ [ 0, 6, 2, 12 ], [ 6, 8, 18, 32 ] ], 
      [ [ 0, 6, 4, 12 ], [ 4, 8, 16, 32 ] ], 
      [ [ 0, 6, 8, 12 ], [ 0, 8, 12, 32 ] ], 
      [ [ 0, 6, 10, 12 ], [ 6, 8, 18, 32 ] ], 
      [ [ 1, 6, 3, 12 ], [ 7, 8, 19, 32 ] ], 
      [ [ 1, 6, 5, 12 ], [ 5, 8, 17, 32 ] ], 
      [ [ 1, 6, 9, 12 ], [ 1, 8, 13, 32 ] ], 
      [ [ 1, 6, 11, 12 ], [ 7, 8, 19, 32 ] ], 
      [ [ 2, 6, 0, 12 ], [ 4, 8, 16, 32 ] ], 
      [ [ 2, 6, 4, 12 ], [ 0, 8, 12, 32 ] ], 
      [ [ 2, 6, 6, 12 ], [ 6, 8, 18, 32 ] ], 
      [ [ 2, 6, 10, 12 ], [ 2, 8, 14, 32 ] ], 
      [ [ 3, 6, 1, 12 ], [ 5, 8, 17, 32 ] ], 
      [ [ 3, 6, 5, 12 ], [ 1, 8, 13, 32 ] ], 
      [ [ 3, 6, 7, 12 ], [ 7, 8, 19, 32 ] ], 
      [ [ 3, 6, 11, 12 ], [ 3, 8, 15, 32 ] ], 
      [ [ 4, 6, 0, 12 ], [ 0, 8, 12, 32 ] ], 
      [ [ 4, 6, 2, 12 ], [ 6, 8, 18, 32 ] ], 
      [ [ 4, 6, 6, 12 ], [ 2, 8, 14, 32 ] ], 
      [ [ 4, 6, 8, 12 ], [ 0, 8, 12, 32 ] ], 
      [ [ 5, 6, 1, 12 ], [ 1, 8, 13, 32 ] ], 
      [ [ 5, 6, 3, 12 ], [ 7, 8, 19, 32 ] ], 
      [ [ 5, 6, 7, 12 ], [ 3, 8, 15, 32 ] ], 
      [ [ 5, 6, 9, 12 ], [ 1, 8, 13, 32 ] ], 
      [ [ 0, 9, 4, 12 ], [ 4, 8, 16, 32 ] ], 
      [ [ 0, 9, 5, 12 ], [ 1, 8, 13, 32 ] ], 
      [ [ 0, 9, 11, 12 ], [ 7, 8, 19, 32 ] ], 
      [ [ 1, 9, 5, 12 ], [ 5, 8, 17, 32 ] ], 
      [ [ 1, 9, 6, 12 ], [ 2, 8, 14, 32 ] ], 
      [ [ 2, 9, 0, 12 ], [ 0, 8, 12, 32 ] ], 
      [ [ 2, 9, 6, 12 ], [ 6, 8, 18, 32 ] ], 
      [ [ 2, 9, 7, 12 ], [ 3, 8, 15, 32 ] ], 
      [ [ 3, 9, 1, 12 ], [ 1, 8, 13, 32 ] ], 
      [ [ 3, 9, 7, 12 ], [ 7, 8, 19, 32 ] ], 
      [ [ 3, 9, 8, 12 ], [ 4, 8, 16, 32 ] ], 
      [ [ 4, 9, 2, 12 ], [ 2, 8, 14, 32 ] ], 
      [ [ 4, 9, 9, 12 ], [ 5, 8, 17, 32 ] ], 
      [ [ 5, 9, 3, 12 ], [ 3, 8, 15, 32 ] ], 
      [ [ 5, 9, 4, 12 ], [ 0, 8, 12, 32 ] ], 
      [ [ 5, 9, 10, 12 ], [ 6, 8, 18, 32 ] ], 
      [ [ 6, 9, 4, 12 ], [ 4, 8, 16, 32 ] ], 
      [ [ 6, 9, 5, 12 ], [ 1, 8, 13, 32 ] ], 
      [ [ 6, 9, 11, 12 ], [ 7, 8, 19, 32 ] ], 
      [ [ 7, 9, 5, 12 ], [ 5, 8, 17, 32 ] ], 
      [ [ 7, 9, 6, 12 ], [ 2, 8, 14, 32 ] ], 
      [ [ 8, 9, 0, 12 ], [ 0, 8, 12, 32 ] ], 
      [ [ 8, 9, 6, 12 ], [ 6, 8, 18, 32 ] ], 
      [ [ 8, 9, 7, 12 ], [ 3, 8, 15, 32 ] ], 
      [ [ 0, 6, 7, 15 ], [ 6, 8, 18, 32 ] ], 
      [ [ 0, 6, 10, 15 ], [ 4, 8, 16, 32 ] ], 
      [ [ 0, 6, 13, 15 ], [ 2, 8, 14, 32 ] ], 
      [ [ 1, 6, 8, 15 ], [ 7, 8, 19, 32 ] ], 
      [ [ 1, 6, 11, 15 ], [ 5, 8, 17, 32 ] ], 
      [ [ 1, 6, 14, 15 ], [ 3, 8, 15, 32 ] ], 
      [ [ 2, 6, 1, 15 ], [ 0, 8, 12, 32 ] ], 
      [ [ 2, 6, 12, 15 ], [ 6, 8, 18, 32 ] ], 
      [ [ 3, 6, 2, 15 ], [ 1, 8, 13, 32 ] ], 
      [ [ 3, 6, 13, 15 ], [ 7, 8, 19, 32 ] ], 
      [ [ 4, 6, 0, 15 ], [ 4, 8, 16, 32 ] ], 
      [ [ 4, 6, 3, 15 ], [ 2, 8, 14, 32 ] ], 
      [ [ 4, 6, 6, 15 ], [ 0, 8, 12, 32 ] ], 
      [ [ 5, 6, 1, 15 ], [ 5, 8, 17, 32 ] ], 
      [ [ 5, 6, 4, 15 ], [ 3, 8, 15, 32 ] ], 
      [ [ 5, 6, 7, 15 ], [ 1, 8, 13, 32 ] ], 
      [ [ 0, 12, 5, 15 ], [ 4, 8, 16, 32 ] ], 
      [ [ 1, 12, 6, 15 ], [ 5, 8, 17, 32 ] ], 
      [ [ 2, 12, 7, 15 ], [ 6, 8, 18, 32 ] ], 
      [ [ 3, 12, 8, 15 ], [ 7, 8, 19, 32 ] ], 
      [ [ 4, 12, 0, 15 ], [ 4, 8, 16, 32 ] ], 
      [ [ 4, 12, 11, 15 ], [ 0, 8, 12, 32 ] ], 
      [ [ 5, 12, 1, 15 ], [ 5, 8, 17, 32 ] ], 
      [ [ 5, 12, 12, 15 ], [ 1, 8, 13, 32 ] ], 
      [ [ 6, 12, 2, 15 ], [ 6, 8, 18, 32 ] ], 
      [ [ 6, 12, 13, 15 ], [ 2, 8, 14, 32 ] ], 
      [ [ 7, 12, 3, 15 ], [ 7, 8, 19, 32 ] ], 
      [ [ 7, 12, 14, 15 ], [ 3, 8, 15, 32 ] ], 
      [ [ 8, 12, 6, 15 ], [ 0, 8, 12, 32 ] ], 
      [ [ 9, 12, 7, 15 ], [ 1, 8, 13, 32 ] ], 
      [ [ 10, 12, 8, 15 ], [ 2, 8, 14, 32 ] ], 
      [ [ 11, 12, 9, 15 ], [ 3, 8, 15, 32 ] ], 
      [ [ 0, 3, 2, 18 ], [ 6, 8, 18, 32 ] ], 
      [ [ 0, 3, 7, 18 ], [ 5, 8, 17, 32 ] ], 
      [ [ 0, 3, 8, 18 ], [ 0, 8, 12, 32 ] ], 
      [ [ 0, 3, 17, 18 ], [ 3, 8, 15, 32 ] ], 
      [ [ 1, 3, 3, 18 ], [ 7, 8, 19, 32 ] ], 
      [ [ 1, 3, 8, 18 ], [ 6, 8, 18, 32 ] ], 
      [ [ 1, 3, 9, 18 ], [ 1, 8, 13, 32 ] ], 
      [ [ 1, 3, 14, 18 ], [ 0, 8, 12, 32 ] ], 
      [ [ 2, 3, 0, 18 ], [ 4, 8, 16, 32 ] ], 
      [ [ 2, 3, 9, 18 ], [ 7, 8, 19, 32 ] ], 
      [ [ 2, 3, 10, 18 ], [ 2, 8, 14, 32 ] ], 
      [ [ 2, 3, 15, 18 ], [ 1, 8, 13, 32 ] ], 
      [ [ 0, 9, 12, 18 ], [ 4, 8, 16, 32 ] ], 
      [ [ 0, 9, 15, 18 ], [ 1, 8, 13, 32 ] ], 
      [ [ 1, 9, 13, 18 ], [ 5, 8, 17, 32 ] ], 
      [ [ 1, 9, 16, 18 ], [ 2, 8, 14, 32 ] ], 
      [ [ 2, 9, 14, 18 ], [ 6, 8, 18, 32 ] ], 
      [ [ 2, 9, 17, 18 ], [ 3, 8, 15, 32 ] ], 
      [ [ 3, 9, 15, 18 ], [ 7, 8, 19, 32 ] ], 
      [ [ 5, 9, 2, 18 ], [ 0, 8, 12, 32 ] ], 
      [ [ 6, 9, 0, 18 ], [ 4, 8, 16, 32 ] ], 
      [ [ 6, 9, 3, 18 ], [ 1, 8, 13, 32 ] ], 
      [ [ 7, 9, 1, 18 ], [ 5, 8, 17, 32 ] ], 
      [ [ 7, 9, 4, 18 ], [ 2, 8, 14, 32 ] ], 
      [ [ 8, 9, 2, 18 ], [ 6, 8, 18, 32 ] ], 
      [ [ 8, 9, 5, 18 ], [ 3, 8, 15, 32 ] ], 
      [ [ 0, 12, 8, 18 ], [ 0, 8, 12, 32 ] ], 
      [ [ 1, 12, 9, 18 ], [ 1, 8, 13, 32 ] ], 
      [ [ 2, 12, 10, 18 ], [ 2, 8, 14, 32 ] ], 
      [ [ 3, 12, 11, 18 ], [ 3, 8, 15, 32 ] ], 
      [ [ 4, 12, 0, 18 ], [ 4, 8, 16, 32 ] ], 
      [ [ 4, 12, 2, 18 ], [ 0, 8, 12, 32 ] ], 
      [ [ 4, 12, 12, 18 ], [ 4, 8, 16, 32 ] ], 
      [ [ 4, 12, 14, 18 ], [ 0, 8, 12, 32 ] ], 
      [ [ 5, 12, 1, 18 ], [ 5, 8, 17, 32 ] ], 
      [ [ 5, 12, 3, 18 ], [ 1, 8, 13, 32 ] ], 
      [ [ 5, 12, 13, 18 ], [ 5, 8, 17, 32 ] ], 
      [ [ 5, 12, 15, 18 ], [ 1, 8, 13, 32 ] ], 
      [ [ 6, 12, 2, 18 ], [ 6, 8, 18, 32 ] ], 
      [ [ 6, 12, 4, 18 ], [ 2, 8, 14, 32 ] ], 
      [ [ 6, 12, 14, 18 ], [ 6, 8, 18, 32 ] ], 
      [ [ 6, 12, 16, 18 ], [ 2, 8, 14, 32 ] ], 
      [ [ 7, 12, 3, 18 ], [ 7, 8, 19, 32 ] ], 
      [ [ 7, 12, 5, 18 ], [ 3, 8, 15, 32 ] ], 
      [ [ 7, 12, 15, 18 ], [ 7, 8, 19, 32 ] ], 
      [ [ 7, 12, 17, 18 ], [ 3, 8, 15, 32 ] ], 
      [ [ 8, 12, 6, 18 ], [ 4, 8, 16, 32 ] ], 
      [ [ 9, 12, 7, 18 ], [ 5, 8, 17, 32 ] ], 
      [ [ 10, 12, 8, 18 ], [ 6, 8, 18, 32 ] ], 
      [ [ 11, 12, 9, 18 ], [ 7, 8, 19, 32 ] ], 
      [ [ 1, 15, 14, 18 ], [ 0, 8, 12, 32 ] ], 
      [ [ 2, 15, 15, 18 ], [ 1, 8, 13, 32 ] ], 
      [ [ 3, 15, 16, 18 ], [ 2, 8, 14, 32 ] ], 
      [ [ 4, 15, 17, 18 ], [ 3, 8, 15, 32 ] ], 
      [ [ 10, 15, 0, 18 ], [ 4, 8, 16, 32 ] ], 
      [ [ 11, 15, 1, 18 ], [ 5, 8, 17, 32 ] ], 
      [ [ 12, 15, 2, 18 ], [ 6, 8, 18, 32 ] ], 
      [ [ 13, 15, 3, 18 ], [ 7, 8, 19, 32 ] ], 
      [ [ 0, 6, 14, 21 ], [ 4, 8, 16, 32 ] ], 
      [ [ 0, 6, 19, 21 ], [ 2, 8, 14, 32 ] ], 
      [ [ 1, 6, 15, 21 ], [ 5, 8, 17, 32 ] ], 
      [ [ 1, 6, 20, 21 ], [ 3, 8, 15, 32 ] ], 
      [ [ 2, 6, 3, 21 ], [ 0, 8, 12, 32 ] ], 
      [ [ 2, 6, 16, 21 ], [ 6, 8, 18, 32 ] ], 
      [ [ 3, 6, 4, 21 ], [ 1, 8, 13, 32 ] ], 
      [ [ 3, 6, 17, 21 ], [ 7, 8, 19, 32 ] ], 
      [ [ 4, 6, 0, 21 ], [ 4, 8, 16, 32 ] ], 
      [ [ 4, 6, 5, 21 ], [ 2, 8, 14, 32 ] ], 
      [ [ 5, 6, 1, 21 ], [ 5, 8, 17, 32 ] ], 
      [ [ 5, 6, 6, 21 ], [ 3, 8, 15, 32 ] ], 
      [ [ 0, 12, 7, 21 ], [ 4, 8, 16, 32 ] ], 
      [ [ 0, 12, 10, 21 ], [ 0, 8, 12, 32 ] ], 
      [ [ 1, 12, 8, 21 ], [ 5, 8, 17, 32 ] ], 
      [ [ 1, 12, 11, 21 ], [ 1, 8, 13, 32 ] ], 
      [ [ 2, 12, 9, 21 ], [ 6, 8, 18, 32 ] ], 
      [ [ 2, 12, 12, 21 ], [ 2, 8, 14, 32 ] ], 
      [ [ 3, 12, 10, 21 ], [ 7, 8, 19, 32 ] ], 
      [ [ 3, 12, 13, 21 ], [ 3, 8, 15, 32 ] ], 
      [ [ 4, 12, 0, 21 ], [ 4, 8, 16, 32 ] ], 
      [ [ 4, 12, 3, 21 ], [ 0, 8, 12, 32 ] ], 
      [ [ 4, 12, 14, 21 ], [ 4, 8, 16, 32 ] ], 
      [ [ 4, 12, 17, 21 ], [ 0, 8, 12, 32 ] ], 
      [ [ 5, 12, 1, 21 ], [ 5, 8, 17, 32 ] ], 
      [ [ 5, 12, 4, 21 ], [ 1, 8, 13, 32 ] ], 
      [ [ 5, 12, 15, 21 ], [ 5, 8, 17, 32 ] ], 
      [ [ 5, 12, 18, 21 ], [ 1, 8, 13, 32 ] ], 
      [ [ 6, 12, 2, 21 ], [ 6, 8, 18, 32 ] ], 
      [ [ 6, 12, 5, 21 ], [ 2, 8, 14, 32 ] ], 
      [ [ 6, 12, 16, 21 ], [ 6, 8, 18, 32 ] ], 
      [ [ 6, 12, 19, 21 ], [ 2, 8, 14, 32 ] ], 
      [ [ 7, 12, 3, 21 ], [ 7, 8, 19, 32 ] ], 
      [ [ 7, 12, 6, 21 ], [ 3, 8, 15, 32 ] ], 
      [ [ 7, 12, 17, 21 ], [ 7, 8, 19, 32 ] ], 
      [ [ 7, 12, 20, 21 ], [ 3, 8, 15, 32 ] ], 
      [ [ 8, 12, 7, 21 ], [ 4, 8, 16, 32 ] ], 
      [ [ 8, 12, 10, 21 ], [ 0, 8, 12, 32 ] ], 
      [ [ 9, 12, 8, 21 ], [ 5, 8, 17, 32 ] ], 
      [ [ 9, 12, 11, 21 ], [ 1, 8, 13, 32 ] ], 
      [ [ 10, 12, 9, 21 ], [ 6, 8, 18, 32 ] ], 
      [ [ 10, 12, 12, 21 ], [ 2, 8, 14, 32 ] ], 
      [ [ 11, 12, 10, 21 ], [ 7, 8, 19, 32 ] ], 
      [ [ 11, 12, 13, 21 ], [ 3, 8, 15, 32 ] ], 
      [ [ 0, 18, 14, 21 ], [ 4, 8, 16, 32 ] ], 
      [ [ 1, 18, 15, 21 ], [ 5, 8, 17, 32 ] ], 
      [ [ 2, 18, 16, 21 ], [ 6, 8, 18, 32 ] ], 
      [ [ 3, 18, 17, 21 ], [ 7, 8, 19, 32 ] ], 
      [ [ 14, 18, 3, 21 ], [ 0, 8, 12, 32 ] ], 
      [ [ 15, 18, 4, 21 ], [ 1, 8, 13, 32 ] ], 
      [ [ 16, 18, 5, 21 ], [ 2, 8, 14, 32 ] ], 
      [ [ 17, 18, 6, 21 ], [ 3, 8, 15, 32 ] ], 
      [ [ 0, 6, 11, 27 ], [ 6, 8, 18, 32 ] ], 
      [ [ 0, 6, 25, 27 ], [ 2, 8, 14, 32 ] ], 
      [ [ 1, 6, 12, 27 ], [ 7, 8, 19, 32 ] ], 
      [ [ 1, 6, 26, 27 ], [ 3, 8, 15, 32 ] ], 
      [ [ 4, 6, 0, 27 ], [ 4, 8, 16, 32 ] ], 
      [ [ 4, 6, 14, 27 ], [ 0, 8, 12, 32 ] ], 
      [ [ 5, 6, 1, 27 ], [ 5, 8, 17, 32 ] ], 
      [ [ 5, 6, 15, 27 ], [ 1, 8, 13, 32 ] ], 
      [ [ 0, 12, 14, 27 ], [ 0, 8, 12, 32 ] ], 
      [ [ 1, 12, 15, 27 ], [ 1, 8, 13, 32 ] ], 
      [ [ 2, 12, 16, 27 ], [ 2, 8, 14, 32 ] ], 
      [ [ 3, 12, 17, 27 ], [ 3, 8, 15, 32 ] ], 
      [ [ 4, 12, 0, 27 ], [ 4, 8, 16, 32 ] ], 
      [ [ 4, 12, 5, 27 ], [ 0, 8, 12, 32 ] ], 
      [ [ 4, 12, 18, 27 ], [ 4, 8, 16, 32 ] ], 
      [ [ 4, 12, 23, 27 ], [ 0, 8, 12, 32 ] ], 
      [ [ 5, 12, 1, 27 ], [ 5, 8, 17, 32 ] ], 
      [ [ 5, 12, 6, 27 ], [ 1, 8, 13, 32 ] ], 
      [ [ 5, 12, 19, 27 ], [ 5, 8, 17, 32 ] ], 
      [ [ 5, 12, 24, 27 ], [ 1, 8, 13, 32 ] ], 
      [ [ 6, 12, 2, 27 ], [ 6, 8, 18, 32 ] ], 
      [ [ 6, 12, 7, 27 ], [ 2, 8, 14, 32 ] ], 
      [ [ 6, 12, 20, 27 ], [ 6, 8, 18, 32 ] ], 
      [ [ 6, 12, 25, 27 ], [ 2, 8, 14, 32 ] ], 
      [ [ 7, 12, 3, 27 ], [ 7, 8, 19, 32 ] ], 
      [ [ 7, 12, 8, 27 ], [ 3, 8, 15, 32 ] ], 
      [ [ 7, 12, 21, 27 ], [ 7, 8, 19, 32 ] ], 
      [ [ 7, 12, 26, 27 ], [ 3, 8, 15, 32 ] ], 
      [ [ 8, 12, 9, 27 ], [ 4, 8, 16, 32 ] ], 
      [ [ 9, 12, 10, 27 ], [ 5, 8, 17, 32 ] ], 
      [ [ 10, 12, 11, 27 ], [ 6, 8, 18, 32 ] ], 
      [ [ 11, 12, 12, 27 ], [ 7, 8, 19, 32 ] ], 
      [ [ 2, 18, 23, 27 ], [ 0, 8, 12, 32 ] ], 
      [ [ 3, 18, 24, 27 ], [ 1, 8, 13, 32 ] ], 
      [ [ 4, 18, 25, 27 ], [ 2, 8, 14, 32 ] ], 
      [ [ 5, 18, 26, 27 ], [ 3, 8, 15, 32 ] ], 
      [ [ 12, 18, 0, 27 ], [ 4, 8, 16, 32 ] ], 
      [ [ 13, 18, 1, 27 ], [ 5, 8, 17, 32 ] ], 
      [ [ 14, 18, 2, 27 ], [ 6, 8, 18, 32 ] ], 
      [ [ 15, 18, 3, 27 ], [ 7, 8, 19, 32 ] ], 
      [ [ 0, 3, 2, 30 ], [ 6, 8, 18, 32 ] ], 
      [ [ 0, 3, 7, 30 ], [ 1, 8, 13, 32 ] ], 
      [ [ 0, 3, 11, 30 ], [ 5, 8, 17, 32 ] ], 
      [ [ 0, 3, 16, 30 ], [ 0, 8, 12, 32 ] ], 
      [ [ 0, 3, 20, 30 ], [ 4, 8, 16, 32 ] ], 
      [ [ 0, 3, 29, 30 ], [ 3, 8, 15, 32 ] ], 
      [ [ 1, 3, 3, 30 ], [ 7, 8, 19, 32 ] ], 
      [ [ 1, 3, 8, 30 ], [ 2, 8, 14, 32 ] ], 
      [ [ 1, 3, 12, 30 ], [ 6, 8, 18, 32 ] ], 
      [ [ 1, 3, 17, 30 ], [ 1, 8, 13, 32 ] ], 
      [ [ 1, 3, 21, 30 ], [ 5, 8, 17, 32 ] ], 
      [ [ 1, 3, 26, 30 ], [ 0, 8, 12, 32 ] ], 
      [ [ 2, 3, 0, 30 ], [ 4, 8, 16, 32 ] ], 
      [ [ 2, 3, 9, 30 ], [ 3, 8, 15, 32 ] ], 
      [ [ 2, 3, 13, 30 ], [ 7, 8, 19, 32 ] ], 
      [ [ 2, 3, 18, 30 ], [ 2, 8, 14, 32 ] ], 
      [ [ 2, 3, 22, 30 ], [ 6, 8, 18, 32 ] ], 
      [ [ 2, 3, 27, 30 ], [ 1, 8, 13, 32 ] ], 
      [ [ 0, 9, 13, 30 ], [ 7, 8, 19, 32 ] ], 
      [ [ 0, 9, 20, 30 ], [ 4, 8, 16, 32 ] ], 
      [ [ 1, 9, 21, 30 ], [ 5, 8, 17, 32 ] ], 
      [ [ 2, 9, 22, 30 ], [ 6, 8, 18, 32 ] ], 
      [ [ 3, 9, 23, 30 ], [ 7, 8, 19, 32 ] ], 
      [ [ 5, 9, 6, 30 ], [ 0, 8, 12, 32 ] ], 
      [ [ 6, 9, 7, 30 ], [ 1, 8, 13, 32 ] ], 
      [ [ 7, 9, 8, 30 ], [ 2, 8, 14, 32 ] ], 
      [ [ 8, 9, 9, 30 ], [ 3, 8, 15, 32 ] ], 
      [ [ 8, 9, 16, 30 ], [ 0, 8, 12, 32 ] ], 
      [ [ 0, 12, 10, 30 ], [ 4, 8, 16, 32 ] ], 
      [ [ 0, 12, 16, 30 ], [ 0, 8, 12, 32 ] ], 
      [ [ 1, 12, 11, 30 ], [ 5, 8, 17, 32 ] ], 
      [ [ 1, 12, 17, 30 ], [ 1, 8, 13, 32 ] ], 
      [ [ 2, 12, 12, 30 ], [ 6, 8, 18, 32 ] ], 
      [ [ 2, 12, 18, 30 ], [ 2, 8, 14, 32 ] ], 
      [ [ 3, 12, 13, 30 ], [ 7, 8, 19, 32 ] ], 
      [ [ 3, 12, 19, 30 ], [ 3, 8, 15, 32 ] ], 
      [ [ 4, 12, 0, 30 ], [ 4, 8, 16, 32 ] ], 
      [ [ 4, 12, 6, 30 ], [ 0, 8, 12, 32 ] ], 
      [ [ 4, 12, 20, 30 ], [ 4, 8, 16, 32 ] ], 
      [ [ 4, 12, 26, 30 ], [ 0, 8, 12, 32 ] ], 
      [ [ 5, 12, 1, 30 ], [ 5, 8, 17, 32 ] ], 
      [ [ 5, 12, 7, 30 ], [ 1, 8, 13, 32 ] ], 
      [ [ 5, 12, 21, 30 ], [ 5, 8, 17, 32 ] ], 
      [ [ 5, 12, 27, 30 ], [ 1, 8, 13, 32 ] ], 
      [ [ 6, 12, 2, 30 ], [ 6, 8, 18, 32 ] ], 
      [ [ 6, 12, 8, 30 ], [ 2, 8, 14, 32 ] ], 
      [ [ 6, 12, 22, 30 ], [ 6, 8, 18, 32 ] ], 
      [ [ 6, 12, 28, 30 ], [ 2, 8, 14, 32 ] ], 
      [ [ 7, 12, 3, 30 ], [ 7, 8, 19, 32 ] ], 
      [ [ 7, 12, 9, 30 ], [ 3, 8, 15, 32 ] ], 
      [ [ 7, 12, 23, 30 ], [ 7, 8, 19, 32 ] ], 
      [ [ 7, 12, 29, 30 ], [ 3, 8, 15, 32 ] ], 
      [ [ 8, 12, 10, 30 ], [ 4, 8, 16, 32 ] ], 
      [ [ 8, 12, 16, 30 ], [ 0, 8, 12, 32 ] ], 
      [ [ 9, 12, 11, 30 ], [ 5, 8, 17, 32 ] ], 
      [ [ 9, 12, 17, 30 ], [ 1, 8, 13, 32 ] ], 
      [ [ 10, 12, 12, 30 ], [ 6, 8, 18, 32 ] ], 
      [ [ 10, 12, 18, 30 ], [ 2, 8, 14, 32 ] ], 
      [ [ 11, 12, 13, 30 ], [ 7, 8, 19, 32 ] ], 
      [ [ 11, 12, 19, 30 ], [ 3, 8, 15, 32 ] ], 
      [ [ 0, 15, 20, 30 ], [ 4, 8, 16, 32 ] ], 
      [ [ 1, 15, 21, 30 ], [ 5, 8, 17, 32 ] ], 
      [ [ 1, 15, 26, 30 ], [ 0, 8, 12, 32 ] ], 
      [ [ 2, 15, 22, 30 ], [ 6, 8, 18, 32 ] ], 
      [ [ 2, 15, 27, 30 ], [ 1, 8, 13, 32 ] ], 
      [ [ 3, 15, 23, 30 ], [ 7, 8, 19, 32 ] ], 
      [ [ 3, 15, 28, 30 ], [ 2, 8, 14, 32 ] ], 
      [ [ 4, 15, 29, 30 ], [ 3, 8, 15, 32 ] ], 
      [ [ 10, 15, 0, 30 ], [ 4, 8, 16, 32 ] ], 
      [ [ 11, 15, 1, 30 ], [ 5, 8, 17, 32 ] ], 
      [ [ 11, 15, 6, 30 ], [ 0, 8, 12, 32 ] ], 
      [ [ 12, 15, 2, 30 ], [ 6, 8, 18, 32 ] ], 
      [ [ 12, 15, 7, 30 ], [ 1, 8, 13, 32 ] ], 
      [ [ 13, 15, 3, 30 ], [ 7, 8, 19, 32 ] ], 
      [ [ 13, 15, 8, 30 ], [ 2, 8, 14, 32 ] ], 
      [ [ 14, 15, 9, 30 ], [ 3, 8, 15, 32 ] ], 
      [ [ 0, 21, 20, 30 ], [ 4, 8, 16, 32 ] ], 
      [ [ 1, 21, 21, 30 ], [ 5, 8, 17, 32 ] ], 
      [ [ 2, 21, 22, 30 ], [ 6, 8, 18, 32 ] ], 
      [ [ 3, 21, 23, 30 ], [ 7, 8, 19, 32 ] ], 
      [ [ 3, 21, 26, 30 ], [ 0, 8, 12, 32 ] ], 
      [ [ 4, 21, 27, 30 ], [ 1, 8, 13, 32 ] ], 
      [ [ 5, 21, 28, 30 ], [ 2, 8, 14, 32 ] ], 
      [ [ 6, 21, 29, 30 ], [ 3, 8, 15, 32 ] ], 
      [ [ 14, 21, 0, 30 ], [ 4, 8, 16, 32 ] ], 
      [ [ 15, 21, 1, 30 ], [ 5, 8, 17, 32 ] ], 
      [ [ 16, 21, 2, 30 ], [ 6, 8, 18, 32 ] ], 
      [ [ 17, 21, 3, 30 ], [ 7, 8, 19, 32 ] ], 
      [ [ 17, 21, 6, 30 ], [ 0, 8, 12, 32 ] ], 
      [ [ 18, 21, 7, 30 ], [ 1, 8, 13, 32 ] ], 
      [ [ 19, 21, 8, 30 ], [ 2, 8, 14, 32 ] ], 
      [ [ 20, 21, 9, 30 ], [ 3, 8, 15, 32 ] ], 
      [ [ 0, 27, 20, 30 ], [ 4, 8, 16, 32 ] ], 
      [ [ 1, 27, 21, 30 ], [ 5, 8, 17, 32 ] ], 
      [ [ 2, 27, 22, 30 ], [ 6, 8, 18, 32 ] ], 
      [ [ 3, 27, 23, 30 ], [ 7, 8, 19, 32 ] ], 
      [ [ 23, 27, 6, 30 ], [ 0, 8, 12, 32 ] ], 
      [ [ 24, 27, 7, 30 ], [ 1, 8, 13, 32 ] ], 
      [ [ 25, 27, 8, 30 ], [ 2, 8, 14, 32 ] ], 
      [ [ 26, 27, 9, 30 ], [ 3, 8, 15, 32 ] ], 
      [ [ 0, 9, 6, 27 ], [ 3, 12, 29, 32 ] ], 
      [ [ 0, 9, 24, 27 ], [ 6, 12, 4, 32 ] ], 
      [ [ 1, 9, 7, 27 ], [ 4, 12, 30, 32 ] ], 
      [ [ 1, 9, 25, 27 ], [ 7, 12, 5, 32 ] ], 
      [ [ 2, 9, 8, 27 ], [ 5, 12, 31, 32 ] ], 
      [ [ 2, 9, 26, 27 ], [ 8, 12, 6, 32 ] ], 
      [ [ 6, 9, 0, 27 ], [ 3, 12, 25, 32 ] ], 
      [ [ 6, 9, 18, 27 ], [ 6, 12, 0, 32 ] ], 
      [ [ 7, 9, 1, 27 ], [ 4, 12, 26, 32 ] ], 
      [ [ 7, 9, 19, 27 ], [ 7, 12, 1, 32 ] ], 
      [ [ 8, 9, 2, 27 ], [ 5, 12, 27, 32 ] ], 
      [ [ 8, 9, 20, 27 ], [ 8, 12, 2, 32 ] ], 
      [ [ 0, 9, 12, 27 ], [ 6, 24, 26, 32 ] ], 
      [ [ 1, 9, 13, 27 ], [ 7, 24, 27, 32 ] ], 
      [ [ 2, 9, 14, 27 ], [ 8, 24, 28, 32 ] ], 
      [ [ 3, 9, 9, 27 ], [ 12, 24, 0, 32 ] ], 
      [ [ 3, 9, 15, 27 ], [ 9, 24, 29, 32 ] ], 
      [ [ 4, 9, 10, 27 ], [ 13, 24, 1, 32 ] ], 
      [ [ 4, 9, 16, 27 ], [ 10, 24, 30, 32 ] ], 
      [ [ 5, 9, 11, 27 ], [ 14, 24, 2, 32 ] ], 
      [ [ 5, 9, 17, 27 ], [ 11, 24, 31, 32 ] ], 
      [ [ 6, 9, 12, 27 ], [ 15, 24, 3, 32 ] ], 
      [ [ 7, 9, 13, 27 ], [ 16, 24, 4, 32 ] ], 
      [ [ 8, 9, 14, 27 ], [ 17, 24, 5, 32 ] ], 
      [ [ 0, 9, 6, 27 ], [ 12, 30, 29, 32 ] ], 
      [ [ 1, 9, 7, 27 ], [ 13, 30, 30, 32 ] ], 
      [ [ 2, 9, 8, 27 ], [ 14, 30, 31, 32 ] ], 
      [ [ 6, 9, 18, 27 ], [ 15, 30, 0, 32 ] ], 
      [ [ 7, 9, 19, 27 ], [ 16, 30, 1, 32 ] ], 
      [ [ 8, 9, 20, 27 ], [ 17, 30, 2, 32 ] ], 
      [ [ 0, 3, 11, 12 ], [ 7, 32, 31, 32 ] ], 
      [ [ 2, 3, 0, 12 ], [ 0, 32, 24, 32 ] ], 
      [ [ 0, 3, 4, 24 ], [ 4, 32, 28, 32 ] ], 
      [ [ 0, 3, 7, 24 ], [ 7, 32, 31, 32 ] ], 
      [ [ 0, 3, 10, 24 ], [ 2, 32, 26, 32 ] ], 
      [ [ 0, 3, 11, 24 ], [ 3, 32, 27, 32 ] ], 
      [ [ 0, 3, 14, 24 ], [ 6, 32, 30, 32 ] ], 
      [ [ 0, 3, 17, 24 ], [ 1, 32, 25, 32 ] ], 
      [ [ 0, 3, 22, 24 ], [ 6, 32, 30, 32 ] ], 
      [ [ 1, 3, 0, 24 ], [ 0, 32, 24, 32 ] ], 
      [ [ 1, 3, 5, 24 ], [ 5, 32, 29, 32 ] ], 
      [ [ 1, 3, 8, 24 ], [ 0, 32, 24, 32 ] ], 
      [ [ 1, 3, 11, 24 ], [ 3, 32, 27, 32 ] ], 
      [ [ 1, 3, 12, 24 ], [ 4, 32, 28, 32 ] ], 
      [ [ 1, 3, 15, 24 ], [ 7, 32, 31, 32 ] ], 
      [ [ 1, 3, 18, 24 ], [ 2, 32, 26, 32 ] ], 
      [ [ 1, 3, 23, 24 ], [ 7, 32, 31, 32 ] ], 
      [ [ 2, 3, 1, 24 ], [ 1, 32, 25, 32 ] ], 
      [ [ 2, 3, 6, 24 ], [ 6, 32, 30, 32 ] ], 
      [ [ 2, 3, 9, 24 ], [ 1, 32, 25, 32 ] ], 
      [ [ 2, 3, 12, 24 ], [ 4, 32, 28, 32 ] ], 
      [ [ 2, 3, 13, 24 ], [ 5, 32, 29, 32 ] ], 
      [ [ 2, 3, 16, 24 ], [ 0, 32, 24, 32 ] ], 
      [ [ 2, 3, 19, 24 ], [ 3, 32, 27, 32 ] ], 
      [ [ 0, 6, 14, 24 ], [ 6, 32, 30, 32 ] ], 
      [ [ 0, 6, 20, 24 ], [ 4, 32, 28, 32 ] ], 
      [ [ 1, 6, 15, 24 ], [ 7, 32, 31, 32 ] ], 
      [ [ 1, 6, 21, 24 ], [ 5, 32, 29, 32 ] ], 
      [ [ 2, 6, 0, 24 ], [ 0, 32, 24, 32 ] ], 
      [ [ 2, 6, 22, 24 ], [ 6, 32, 30, 32 ] ], 
      [ [ 3, 6, 1, 24 ], [ 1, 32, 25, 32 ] ], 
      [ [ 3, 6, 23, 24 ], [ 7, 32, 31, 32 ] ], 
      [ [ 4, 6, 2, 24 ], [ 2, 32, 26, 32 ] ], 
      [ [ 4, 6, 8, 24 ], [ 0, 32, 24, 32 ] ], 
      [ [ 5, 6, 3, 24 ], [ 3, 32, 27, 32 ] ], 
      [ [ 5, 6, 9, 24 ], [ 1, 32, 25, 32 ] ] ],,,,,,,,,,,,
  ,,,, 
  [ [ [ 0, 3, 1, 6 ], [ 1, 8, 19, 20 ] ], 
      [ [ 0, 3, 2, 6 ], [ 0, 8, 18, 20 ] ], 
      [ [ 1, 3, 2, 6 ], [ 6, 8, 0, 20 ] ], 
      [ [ 1, 3, 3, 6 ], [ 1, 8, 19, 20 ] ], 
      [ [ 2, 3, 3, 6 ], [ 7, 8, 1, 20 ] ], 
      [ [ 2, 3, 4, 6 ], [ 6, 8, 0, 20 ] ], 
      [ [ 0, 6, 10, 15 ], [ 6, 8, 0, 20 ] ], 
      [ [ 1, 6, 11, 15 ], [ 7, 8, 1, 20 ] ], 
      [ [ 4, 6, 3, 15 ], [ 0, 8, 18, 20 ] ], 
      [ [ 5, 6, 4, 15 ], [ 1, 8, 19, 20 ] ], 
      [ [ 0, 8, 18, 20 ], [ 4, 6, 9, 21 ] ], 
      [ [ 1, 8, 19, 20 ], [ 5, 6, 10, 21 ] ], 
      [ [ 6, 8, 0, 20 ], [ 0, 6, 10, 21 ] ], 
      [ [ 7, 8, 1, 20 ], [ 1, 6, 11, 21 ] ], 
      [ [ 0, 8, 18, 20 ], [ 2, 6, 6, 27 ] ], 
      [ [ 0, 8, 18, 20 ], [ 4, 6, 15, 27 ] ], 
      [ [ 1, 8, 19, 20 ], [ 3, 6, 7, 27 ] ], 
      [ [ 1, 8, 19, 20 ], [ 5, 6, 16, 27 ] ], 
      [ [ 6, 8, 0, 20 ], [ 0, 6, 10, 27 ] ], 
      [ [ 6, 8, 0, 20 ], [ 2, 6, 19, 27 ] ], 
      [ [ 7, 8, 1, 20 ], [ 1, 6, 11, 27 ] ], 
      [ [ 7, 8, 1, 20 ], [ 3, 6, 20, 27 ] ], 
      [ [ 0, 3, 11, 18 ], [ 3, 4, 9, 28 ] ], 
      [ [ 0, 3, 16, 18 ], [ 2, 4, 8, 28 ] ], 
      [ [ 1, 3, 0, 18 ], [ 0, 4, 18, 28 ] ], 
      [ [ 1, 3, 17, 18 ], [ 3, 4, 9, 28 ] ], 
      [ [ 2, 3, 1, 18 ], [ 1, 4, 19, 28 ] ], 
      [ [ 2, 3, 6, 18 ], [ 0, 4, 18, 28 ] ], 
      [ [ 0, 3, 1, 6 ], [ 9, 16, 27, 28 ] ], 
      [ [ 0, 3, 2, 6 ], [ 8, 16, 26, 28 ] ], 
      [ [ 0, 3, 4, 6 ], [ 6, 16, 24, 28 ] ], 
      [ [ 0, 3, 5, 6 ], [ 5, 16, 23, 28 ] ], 
      [ [ 1, 3, 0, 6 ], [ 8, 16, 2, 28 ] ], 
      [ [ 1, 3, 2, 6 ], [ 6, 16, 0, 28 ] ], 
      [ [ 1, 3, 3, 6 ], [ 9, 16, 27, 28 ] ], 
      [ [ 1, 3, 5, 6 ], [ 7, 16, 25, 28 ] ], 
      [ [ 2, 3, 0, 6 ], [ 10, 16, 4, 28 ] ], 
      [ [ 2, 3, 1, 6 ], [ 9, 16, 3, 28 ] ], 
      [ [ 2, 3, 3, 6 ], [ 7, 16, 1, 28 ] ], 
      [ [ 2, 3, 4, 6 ], [ 6, 16, 0, 28 ] ], 
      [ [ 0, 6, 1, 15 ], [ 0, 16, 18, 28 ] ], 
      [ [ 0, 6, 2, 15 ], [ 14, 16, 8, 28 ] ], 
      [ [ 0, 6, 8, 15 ], [ 10, 16, 4, 28 ] ], 
      [ [ 0, 6, 11, 15 ], [ 8, 16, 2, 28 ] ], 
      [ [ 1, 6, 2, 15 ], [ 1, 16, 19, 28 ] ], 
      [ [ 1, 6, 3, 15 ], [ 15, 16, 9, 28 ] ], 
      [ [ 1, 6, 9, 15 ], [ 11, 16, 5, 28 ] ], 
      [ [ 1, 6, 12, 15 ], [ 9, 16, 3, 28 ] ], 
      [ [ 2, 6, 0, 15 ], [ 4, 16, 22, 28 ] ], 
      [ [ 2, 6, 3, 15 ], [ 2, 16, 20, 28 ] ], 
      [ [ 2, 6, 10, 15 ], [ 12, 16, 6, 28 ] ], 
      [ [ 2, 6, 13, 15 ], [ 10, 16, 4, 28 ] ], 
      [ [ 3, 6, 1, 15 ], [ 5, 16, 23, 28 ] ], 
      [ [ 3, 6, 4, 15 ], [ 3, 16, 21, 28 ] ], 
      [ [ 3, 6, 11, 15 ], [ 13, 16, 7, 28 ] ], 
      [ [ 3, 6, 14, 15 ], [ 11, 16, 5, 28 ] ], 
      [ [ 4, 6, 2, 15 ], [ 6, 16, 24, 28 ] ], 
      [ [ 4, 6, 5, 15 ], [ 4, 16, 22, 28 ] ], 
      [ [ 4, 6, 11, 15 ], [ 0, 16, 18, 28 ] ], 
      [ [ 4, 6, 12, 15 ], [ 14, 16, 8, 28 ] ], 
      [ [ 5, 6, 3, 15 ], [ 7, 16, 25, 28 ] ], 
      [ [ 5, 6, 6, 15 ], [ 5, 16, 23, 28 ] ], 
      [ [ 5, 6, 12, 15 ], [ 1, 16, 19, 28 ] ], 
      [ [ 5, 6, 13, 15 ], [ 15, 16, 9, 28 ] ], 
      [ [ 0, 3, 7, 18 ], [ 15, 16, 21, 28 ] ], 
      [ [ 0, 3, 11, 18 ], [ 15, 16, 9, 28 ] ], 
      [ [ 0, 3, 16, 18 ], [ 14, 16, 8, 28 ] ], 
      [ [ 0, 3, 17, 18 ], [ 13, 16, 19, 28 ] ], 
      [ [ 1, 3, 0, 18 ], [ 0, 16, 18, 28 ] ], 
      [ [ 1, 3, 17, 18 ], [ 15, 16, 9, 28 ] ], 
      [ [ 2, 3, 0, 18 ], [ 2, 16, 8, 28 ] ], 
      [ [ 2, 3, 1, 18 ], [ 1, 16, 19, 28 ] ], 
      [ [ 2, 3, 6, 18 ], [ 0, 16, 18, 28 ] ], 
      [ [ 2, 3, 10, 18 ], [ 0, 16, 6, 28 ] ], 
      [ [ 0, 6, 4, 21 ], [ 10, 16, 4, 28 ] ], 
      [ [ 0, 6, 11, 21 ], [ 0, 16, 18, 28 ] ], 
      [ [ 1, 6, 5, 21 ], [ 11, 16, 5, 28 ] ], 
      [ [ 1, 6, 12, 21 ], [ 1, 16, 19, 28 ] ], 
      [ [ 2, 6, 6, 21 ], [ 12, 16, 6, 28 ] ], 
      [ [ 2, 6, 13, 21 ], [ 2, 16, 20, 28 ] ], 
      [ [ 3, 6, 7, 21 ], [ 13, 16, 7, 28 ] ], 
      [ [ 3, 6, 14, 21 ], [ 3, 16, 21, 28 ] ], 
      [ [ 4, 6, 8, 21 ], [ 14, 16, 8, 28 ] ], 
      [ [ 4, 6, 15, 21 ], [ 4, 16, 22, 28 ] ], 
      [ [ 5, 6, 9, 21 ], [ 15, 16, 9, 28 ] ], 
      [ [ 5, 6, 16, 21 ], [ 5, 16, 23, 28 ] ], 
      [ [ 0, 6, 7, 27 ], [ 8, 16, 2, 28 ] ], 
      [ [ 0, 6, 14, 27 ], [ 2, 16, 20, 28 ] ], 
      [ [ 1, 6, 8, 27 ], [ 9, 16, 3, 28 ] ], 
      [ [ 1, 6, 15, 27 ], [ 3, 16, 21, 28 ] ], 
      [ [ 2, 6, 9, 27 ], [ 10, 16, 4, 28 ] ], 
      [ [ 2, 6, 16, 27 ], [ 4, 16, 22, 28 ] ], 
      [ [ 3, 6, 10, 27 ], [ 11, 16, 5, 28 ] ], 
      [ [ 3, 6, 17, 27 ], [ 5, 16, 23, 28 ] ], 
      [ [ 4, 6, 11, 27 ], [ 12, 16, 6, 28 ] ], 
      [ [ 4, 6, 18, 27 ], [ 6, 16, 24, 28 ] ], 
      [ [ 5, 6, 12, 27 ], [ 13, 16, 7, 28 ] ], 
      [ [ 5, 6, 19, 27 ], [ 7, 16, 25, 28 ] ], 
      [ [ 0, 16, 6, 28 ], [ 0, 3, 2, 30 ] ], 
      [ [ 0, 16, 6, 28 ], [ 1, 3, 12, 30 ] ], 
      [ [ 0, 16, 6, 28 ], [ 2, 3, 22, 30 ] ], 
      [ [ 1, 16, 7, 28 ], [ 1, 3, 3, 30 ] ], 
      [ [ 1, 16, 7, 28 ], [ 2, 3, 13, 30 ] ], 
      [ [ 2, 16, 8, 28 ], [ 2, 3, 4, 30 ] ], 
      [ [ 13, 16, 19, 28 ], [ 0, 3, 25, 30 ] ], 
      [ [ 14, 16, 20, 28 ], [ 0, 3, 16, 30 ] ], 
      [ [ 14, 16, 20, 28 ], [ 1, 3, 26, 30 ] ], 
      [ [ 15, 16, 21, 28 ], [ 0, 3, 7, 30 ] ], 
      [ [ 15, 16, 21, 28 ], [ 1, 3, 17, 30 ] ], 
      [ [ 15, 16, 21, 28 ], [ 2, 3, 27, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 0, 5, 4, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 0, 5, 16, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 0, 5, 28, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 1, 5, 10, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 1, 5, 22, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 2, 5, 4, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 2, 5, 16, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 2, 5, 28, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 3, 5, 10, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 3, 5, 22, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 4, 5, 16, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 4, 5, 28, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 0, 5, 11, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 0, 5, 23, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 1, 5, 5, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 1, 5, 17, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 1, 5, 29, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 2, 5, 11, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 2, 5, 23, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 3, 5, 5, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 3, 5, 17, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 3, 5, 29, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 4, 5, 11, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 4, 5, 23, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 0, 5, 6, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 0, 5, 18, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 1, 5, 0, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 1, 5, 12, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 1, 5, 24, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 2, 5, 6, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 2, 5, 18, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 3, 5, 0, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 3, 5, 12, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 3, 5, 24, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 4, 5, 6, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 4, 5, 18, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 0, 5, 1, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 0, 5, 13, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 1, 5, 7, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 1, 5, 19, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 2, 5, 1, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 2, 5, 13, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 2, 5, 25, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 3, 5, 7, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 3, 5, 19, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 4, 5, 1, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 4, 5, 13, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 4, 5, 25, 30 ] ], 
      [ [ 0, 8, 10, 28 ], [ 4, 5, 2, 30 ] ], 
      [ [ 7, 8, 17, 28 ], [ 0, 5, 27, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 3, 25, 10, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 3, 25, 22, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 8, 25, 4, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 8, 25, 16, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 13, 25, 10, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 13, 25, 22, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 18, 25, 4, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 18, 25, 16, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 23, 25, 10, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 23, 25, 22, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 4, 25, 11, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 4, 25, 23, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 9, 25, 5, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 9, 25, 17, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 14, 25, 11, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 14, 25, 23, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 19, 25, 5, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 19, 25, 17, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 24, 25, 11, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 24, 25, 23, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 0, 25, 6, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 0, 25, 18, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 5, 25, 12, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 5, 25, 24, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 10, 25, 6, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 10, 25, 18, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 15, 25, 12, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 15, 25, 24, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 20, 25, 6, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 20, 25, 18, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 1, 25, 7, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 1, 25, 19, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 6, 25, 13, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 6, 25, 25, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 11, 25, 7, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 11, 25, 19, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 16, 25, 13, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 16, 25, 25, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 21, 25, 7, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 21, 25, 19, 30 ] ], 
      [ [ 0, 5, 1, 10 ], [ 11, 12, 1, 32 ] ], 
      [ [ 0, 5, 1, 10 ], [ 11, 12, 21, 32 ] ], 
      [ [ 0, 5, 2, 10 ], [ 10, 12, 0, 32 ] ], 
      [ [ 0, 5, 2, 10 ], [ 10, 12, 20, 32 ] ], 
      [ [ 0, 5, 3, 10 ], [ 9, 12, 19, 32 ] ], 
      [ [ 0, 5, 4, 10 ], [ 8, 12, 18, 32 ] ], 
      [ [ 0, 5, 6, 10 ], [ 6, 12, 16, 32 ] ], 
      [ [ 0, 5, 7, 10 ], [ 5, 12, 15, 32 ] ], 
      [ [ 0, 5, 8, 10 ], [ 4, 12, 14, 32 ] ], 
      [ [ 0, 5, 9, 10 ], [ 3, 12, 13, 32 ] ], 
      [ [ 1, 5, 0, 10 ], [ 2, 12, 12, 32 ] ], 
      [ [ 1, 5, 2, 10 ], [ 0, 12, 10, 32 ] ], 
      [ [ 1, 5, 2, 10 ], [ 0, 12, 30, 32 ] ], 
      [ [ 1, 5, 3, 10 ], [ 11, 12, 1, 32 ] ], 
      [ [ 1, 5, 3, 10 ], [ 11, 12, 21, 32 ] ], 
      [ [ 1, 5, 4, 10 ], [ 10, 12, 20, 32 ] ], 
      [ [ 1, 5, 5, 10 ], [ 9, 12, 19, 32 ] ], 
      [ [ 1, 5, 7, 10 ], [ 7, 12, 17, 32 ] ], 
      [ [ 1, 5, 8, 10 ], [ 6, 12, 16, 32 ] ], 
      [ [ 1, 5, 9, 10 ], [ 5, 12, 15, 32 ] ], 
      [ [ 2, 5, 0, 10 ], [ 4, 12, 14, 32 ] ], 
      [ [ 2, 5, 1, 10 ], [ 3, 12, 13, 32 ] ], 
      [ [ 2, 5, 3, 10 ], [ 1, 12, 11, 32 ] ], 
      [ [ 2, 5, 3, 10 ], [ 1, 12, 31, 32 ] ], 
      [ [ 2, 5, 4, 10 ], [ 0, 12, 10, 32 ] ], 
      [ [ 2, 5, 5, 10 ], [ 11, 12, 21, 32 ] ], 
      [ [ 2, 5, 6, 10 ], [ 10, 12, 0, 32 ] ], 
      [ [ 2, 5, 6, 10 ], [ 10, 12, 20, 32 ] ], 
      [ [ 2, 5, 8, 10 ], [ 8, 12, 18, 32 ] ], 
      [ [ 2, 5, 9, 10 ], [ 7, 12, 17, 32 ] ], 
      [ [ 3, 5, 0, 10 ], [ 6, 12, 16, 32 ] ], 
      [ [ 3, 5, 1, 10 ], [ 5, 12, 15, 32 ] ], 
      [ [ 3, 5, 2, 10 ], [ 4, 12, 14, 32 ] ], 
      [ [ 3, 5, 4, 10 ], [ 2, 12, 12, 32 ] ], 
      [ [ 3, 5, 5, 10 ], [ 1, 12, 11, 32 ] ], 
      [ [ 3, 5, 6, 10 ], [ 0, 12, 10, 32 ] ], 
      [ [ 3, 5, 6, 10 ], [ 0, 12, 30, 32 ] ], 
      [ [ 3, 5, 7, 10 ], [ 11, 12, 1, 32 ] ], 
      [ [ 3, 5, 7, 10 ], [ 11, 12, 21, 32 ] ], 
      [ [ 3, 5, 9, 10 ], [ 9, 12, 19, 32 ] ], 
      [ [ 4, 5, 0, 10 ], [ 8, 12, 18, 32 ] ], 
      [ [ 4, 5, 1, 10 ], [ 7, 12, 17, 32 ] ], 
      [ [ 4, 5, 2, 10 ], [ 6, 12, 16, 32 ] ], 
      [ [ 4, 5, 3, 10 ], [ 5, 12, 15, 32 ] ], 
      [ [ 4, 5, 5, 10 ], [ 3, 12, 13, 32 ] ], 
      [ [ 4, 5, 6, 10 ], [ 2, 12, 12, 32 ] ], 
      [ [ 4, 5, 7, 10 ], [ 1, 12, 11, 32 ] ], 
      [ [ 4, 5, 7, 10 ], [ 1, 12, 31, 32 ] ], 
      [ [ 4, 5, 8, 10 ], [ 0, 12, 10, 32 ] ], 
      [ [ 4, 5, 8, 10 ], [ 0, 12, 30, 32 ] ], 
      [ [ 0, 10, 8, 15 ], [ 8, 12, 18, 32 ] ], 
      [ [ 0, 10, 9, 15 ], [ 6, 12, 16, 32 ] ], 
      [ [ 1, 10, 9, 15 ], [ 9, 12, 19, 32 ] ], 
      [ [ 1, 10, 10, 15 ], [ 7, 12, 17, 32 ] ], 
      [ [ 2, 10, 3, 15 ], [ 0, 12, 30, 32 ] ], 
      [ [ 2, 10, 4, 15 ], [ 10, 12, 0, 32 ] ], 
      [ [ 2, 10, 10, 15 ], [ 10, 12, 20, 32 ] ], 
      [ [ 2, 10, 11, 15 ], [ 8, 12, 18, 32 ] ], 
      [ [ 3, 10, 4, 15 ], [ 1, 12, 31, 32 ] ], 
      [ [ 3, 10, 5, 15 ], [ 11, 12, 1, 32 ] ], 
      [ [ 3, 10, 11, 15 ], [ 11, 12, 21, 32 ] ], 
      [ [ 3, 10, 12, 15 ], [ 9, 12, 19, 32 ] ], 
      [ [ 4, 10, 0, 15 ], [ 0, 12, 10, 32 ] ], 
      [ [ 4, 10, 6, 15 ], [ 0, 12, 30, 32 ] ], 
      [ [ 4, 10, 7, 15 ], [ 10, 12, 0, 32 ] ], 
      [ [ 4, 10, 13, 15 ], [ 10, 12, 20, 32 ] ], 
      [ [ 5, 10, 1, 15 ], [ 1, 12, 11, 32 ] ], 
      [ [ 5, 10, 7, 15 ], [ 1, 12, 31, 32 ] ], 
      [ [ 5, 10, 8, 15 ], [ 11, 12, 1, 32 ] ], 
      [ [ 5, 10, 14, 15 ], [ 11, 12, 21, 32 ] ], 
      [ [ 6, 10, 2, 15 ], [ 2, 12, 12, 32 ] ], 
      [ [ 6, 10, 3, 15 ], [ 0, 12, 10, 32 ] ], 
      [ [ 6, 10, 9, 15 ], [ 0, 12, 30, 32 ] ], 
      [ [ 6, 10, 10, 15 ], [ 10, 12, 0, 32 ] ], 
      [ [ 7, 10, 3, 15 ], [ 3, 12, 13, 32 ] ], 
      [ [ 7, 10, 4, 15 ], [ 1, 12, 11, 32 ] ], 
      [ [ 7, 10, 10, 15 ], [ 1, 12, 31, 32 ] ], 
      [ [ 7, 10, 11, 15 ], [ 11, 12, 1, 32 ] ], 
      [ [ 8, 10, 4, 15 ], [ 4, 12, 14, 32 ] ], 
      [ [ 8, 10, 5, 15 ], [ 2, 12, 12, 32 ] ], 
      [ [ 9, 10, 5, 15 ], [ 5, 12, 15, 32 ] ], 
      [ [ 9, 10, 6, 15 ], [ 3, 12, 13, 32 ] ], 
      [ [ 0, 10, 12, 25 ], [ 8, 12, 18, 32 ] ], 
      [ [ 0, 10, 18, 25 ], [ 4, 12, 14, 32 ] ], 
      [ [ 1, 10, 13, 25 ], [ 9, 12, 19, 32 ] ], 
      [ [ 1, 10, 19, 25 ], [ 5, 12, 15, 32 ] ], 
      [ [ 2, 10, 14, 25 ], [ 10, 12, 20, 32 ] ], 
      [ [ 2, 10, 20, 25 ], [ 6, 12, 16, 32 ] ], 
      [ [ 3, 10, 0, 25 ], [ 1, 12, 11, 32 ] ], 
      [ [ 3, 10, 15, 25 ], [ 11, 12, 21, 32 ] ], 
      [ [ 3, 10, 21, 25 ], [ 7, 12, 17, 32 ] ], 
      [ [ 4, 10, 1, 25 ], [ 2, 12, 12, 32 ] ], 
      [ [ 4, 10, 1, 25 ], [ 10, 12, 0, 32 ] ], 
      [ [ 4, 10, 22, 25 ], [ 0, 12, 30, 32 ] ], 
      [ [ 4, 10, 22, 25 ], [ 8, 12, 18, 32 ] ], 
      [ [ 5, 10, 2, 25 ], [ 3, 12, 13, 32 ] ], 
      [ [ 5, 10, 2, 25 ], [ 11, 12, 1, 32 ] ], 
      [ [ 5, 10, 23, 25 ], [ 1, 12, 31, 32 ] ], 
      [ [ 5, 10, 23, 25 ], [ 9, 12, 19, 32 ] ], 
      [ [ 6, 10, 3, 25 ], [ 4, 12, 14, 32 ] ], 
      [ [ 6, 10, 9, 25 ], [ 0, 12, 10, 32 ] ], 
      [ [ 6, 10, 24, 25 ], [ 10, 12, 20, 32 ] ], 
      [ [ 7, 10, 4, 25 ], [ 5, 12, 15, 32 ] ], 
      [ [ 7, 10, 10, 25 ], [ 1, 12, 11, 32 ] ], 
      [ [ 8, 10, 5, 25 ], [ 6, 12, 16, 32 ] ], 
      [ [ 8, 10, 11, 25 ], [ 2, 12, 12, 32 ] ], 
      [ [ 9, 10, 6, 25 ], [ 7, 12, 17, 32 ] ], 
      [ [ 9, 10, 12, 25 ], [ 3, 12, 13, 32 ] ], 
      [ [ 0, 3, 1, 6 ], [ 19, 20, 1, 32 ] ], 
      [ [ 0, 3, 1, 6 ], [ 19, 20, 13, 32 ] ], 
      [ [ 0, 3, 2, 6 ], [ 18, 20, 12, 32 ] ], 
      [ [ 0, 3, 2, 6 ], [ 18, 20, 24, 32 ] ], 
      [ [ 0, 3, 4, 6 ], [ 16, 20, 10, 32 ] ], 
      [ [ 0, 3, 5, 6 ], [ 15, 20, 9, 32 ] ], 
      [ [ 0, 3, 5, 6 ], [ 15, 20, 21, 32 ] ], 
      [ [ 1, 3, 0, 6 ], [ 2, 20, 20, 32 ] ], 
      [ [ 1, 3, 2, 6 ], [ 0, 20, 6, 32 ] ], 
      [ [ 1, 3, 2, 6 ], [ 0, 20, 18, 32 ] ], 
      [ [ 1, 3, 3, 6 ], [ 19, 20, 13, 32 ] ], 
      [ [ 1, 3, 3, 6 ], [ 19, 20, 25, 32 ] ], 
      [ [ 1, 3, 5, 6 ], [ 17, 20, 11, 32 ] ], 
      [ [ 2, 3, 0, 6 ], [ 4, 20, 10, 32 ] ], 
      [ [ 2, 3, 0, 6 ], [ 4, 20, 22, 32 ] ], 
      [ [ 2, 3, 1, 6 ], [ 3, 20, 21, 32 ] ], 
      [ [ 2, 3, 3, 6 ], [ 1, 20, 7, 32 ] ], 
      [ [ 2, 3, 3, 6 ], [ 1, 20, 19, 32 ] ], 
      [ [ 2, 3, 4, 6 ], [ 0, 20, 18, 32 ] ], 
      [ [ 2, 3, 4, 6 ], [ 0, 20, 30, 32 ] ], 
      [ [ 0, 6, 2, 9 ], [ 16, 20, 10, 32 ] ], 
      [ [ 0, 6, 5, 9 ], [ 10, 20, 4, 32 ] ], 
      [ [ 1, 6, 3, 9 ], [ 17, 20, 11, 32 ] ], 
      [ [ 1, 6, 6, 9 ], [ 11, 20, 5, 32 ] ], 
      [ [ 2, 6, 0, 9 ], [ 6, 20, 24, 32 ] ], 
      [ [ 2, 6, 3, 9 ], [ 0, 20, 18, 32 ] ], 
      [ [ 2, 6, 4, 9 ], [ 18, 20, 12, 32 ] ], 
      [ [ 2, 6, 7, 9 ], [ 12, 20, 6, 32 ] ], 
      [ [ 3, 6, 1, 9 ], [ 7, 20, 25, 32 ] ], 
      [ [ 3, 6, 4, 9 ], [ 1, 20, 19, 32 ] ], 
      [ [ 3, 6, 5, 9 ], [ 19, 20, 13, 32 ] ], 
      [ [ 3, 6, 8, 9 ], [ 13, 20, 7, 32 ] ], 
      [ [ 4, 6, 2, 9 ], [ 8, 20, 26, 32 ] ], 
      [ [ 4, 6, 5, 9 ], [ 2, 20, 20, 32 ] ], 
      [ [ 5, 6, 3, 9 ], [ 9, 20, 27, 32 ] ], 
      [ [ 5, 6, 6, 9 ], [ 3, 20, 21, 32 ] ], 
      [ [ 0, 6, 5, 15 ], [ 10, 20, 28, 32 ] ], 
      [ [ 0, 6, 13, 15 ], [ 18, 20, 24, 32 ] ], 
      [ [ 0, 6, 14, 15 ], [ 4, 20, 22, 32 ] ], 
      [ [ 1, 6, 6, 15 ], [ 11, 20, 29, 32 ] ], 
      [ [ 1, 6, 14, 15 ], [ 19, 20, 25, 32 ] ], 
      [ [ 2, 6, 6, 15 ], [ 6, 20, 0, 32 ] ], 
      [ [ 2, 6, 7, 15 ], [ 12, 20, 30, 32 ] ], 
      [ [ 3, 6, 7, 15 ], [ 7, 20, 1, 32 ] ], 
      [ [ 3, 6, 8, 15 ], [ 13, 20, 31, 32 ] ], 
      [ [ 4, 6, 0, 15 ], [ 0, 20, 6, 32 ] ], 
      [ [ 4, 6, 8, 15 ], [ 8, 20, 2, 32 ] ], 
      [ [ 5, 6, 0, 15 ], [ 15, 20, 9, 32 ] ], 
      [ [ 5, 6, 1, 15 ], [ 1, 20, 7, 32 ] ], 
      [ [ 5, 6, 9, 15 ], [ 9, 20, 3, 32 ] ], 
      [ [ 0, 3, 5, 18 ], [ 3, 20, 9, 32 ] ], 
      [ [ 0, 3, 5, 18 ], [ 7, 20, 1, 32 ] ], 
      [ [ 0, 3, 5, 18 ], [ 11, 20, 29, 32 ] ], 
      [ [ 0, 3, 5, 18 ], [ 15, 20, 21, 32 ] ], 
      [ [ 0, 3, 5, 18 ], [ 19, 20, 13, 32 ] ], 
      [ [ 0, 3, 10, 18 ], [ 2, 20, 8, 32 ] ], 
      [ [ 0, 3, 10, 18 ], [ 6, 20, 0, 32 ] ], 
      [ [ 0, 3, 10, 18 ], [ 10, 20, 28, 32 ] ], 
      [ [ 0, 3, 10, 18 ], [ 14, 20, 20, 32 ] ], 
      [ [ 0, 3, 10, 18 ], [ 18, 20, 12, 32 ] ], 
      [ [ 1, 3, 6, 18 ], [ 0, 20, 18, 32 ] ], 
      [ [ 1, 3, 6, 18 ], [ 4, 20, 10, 32 ] ], 
      [ [ 1, 3, 6, 18 ], [ 8, 20, 2, 32 ] ], 
      [ [ 1, 3, 6, 18 ], [ 12, 20, 30, 32 ] ], 
      [ [ 1, 3, 6, 18 ], [ 16, 20, 22, 32 ] ], 
      [ [ 1, 3, 11, 18 ], [ 3, 20, 9, 32 ] ], 
      [ [ 1, 3, 11, 18 ], [ 7, 20, 1, 32 ] ], 
      [ [ 1, 3, 11, 18 ], [ 11, 20, 29, 32 ] ], 
      [ [ 1, 3, 11, 18 ], [ 15, 20, 21, 32 ] ], 
      [ [ 1, 3, 11, 18 ], [ 19, 20, 13, 32 ] ], 
      [ [ 2, 3, 7, 18 ], [ 1, 20, 19, 32 ] ], 
      [ [ 2, 3, 7, 18 ], [ 5, 20, 11, 32 ] ], 
      [ [ 2, 3, 7, 18 ], [ 9, 20, 3, 32 ] ], 
      [ [ 2, 3, 7, 18 ], [ 13, 20, 31, 32 ] ], 
      [ [ 2, 3, 7, 18 ], [ 17, 20, 23, 32 ] ], 
      [ [ 2, 3, 12, 18 ], [ 0, 20, 18, 32 ] ], 
      [ [ 2, 3, 12, 18 ], [ 4, 20, 10, 32 ] ], 
      [ [ 2, 3, 12, 18 ], [ 8, 20, 2, 32 ] ], 
      [ [ 2, 3, 12, 18 ], [ 12, 20, 30, 32 ] ], 
      [ [ 2, 3, 12, 18 ], [ 16, 20, 22, 32 ] ], 
      [ [ 0, 6, 20, 21 ], [ 16, 20, 22, 32 ] ], 
      [ [ 5, 6, 0, 21 ], [ 3, 20, 9, 32 ] ], 
      [ [ 0, 6, 17, 27 ], [ 18, 20, 24, 32 ] ], 
      [ [ 0, 6, 25, 27 ], [ 10, 20, 28, 32 ] ], 
      [ [ 1, 6, 18, 27 ], [ 19, 20, 25, 32 ] ], 
      [ [ 1, 6, 26, 27 ], [ 11, 20, 29, 32 ] ], 
      [ [ 4, 6, 0, 27 ], [ 8, 20, 2, 32 ] ], 
      [ [ 4, 6, 8, 27 ], [ 0, 20, 6, 32 ] ], 
      [ [ 5, 6, 1, 27 ], [ 9, 20, 3, 32 ] ], 
      [ [ 5, 6, 9, 27 ], [ 1, 20, 7, 32 ] ] ],,,,,,,,,,,,,
  ,,, 
  [ [ [ 0, 10, 3, 15 ], [ 2, 4, 12, 24 ] ], 
      [ [ 0, 10, 4, 15 ], [ 0, 4, 10, 24 ] ], 
      [ [ 0, 10, 9, 15 ], [ 2, 4, 12, 24 ] ], 
      [ [ 1, 10, 4, 15 ], [ 3, 4, 13, 24 ] ], 
      [ [ 1, 10, 5, 15 ], [ 1, 4, 11, 24 ] ], 
      [ [ 1, 10, 10, 15 ], [ 3, 4, 13, 24 ] ], 
      [ [ 2, 10, 0, 15 ], [ 2, 4, 12, 24 ] ], 
      [ [ 2, 10, 1, 15 ], [ 0, 4, 10, 24 ] ], 
      [ [ 2, 10, 6, 15 ], [ 2, 4, 12, 24 ] ], 
      [ [ 2, 10, 13, 15 ], [ 0, 4, 10, 24 ] ], 
      [ [ 3, 10, 1, 15 ], [ 3, 4, 13, 24 ] ], 
      [ [ 3, 10, 2, 15 ], [ 1, 4, 11, 24 ] ], 
      [ [ 3, 10, 7, 15 ], [ 3, 4, 13, 24 ] ], 
      [ [ 3, 10, 14, 15 ], [ 1, 4, 11, 24 ] ], 
      [ [ 4, 10, 3, 15 ], [ 2, 4, 12, 24 ] ], 
      [ [ 4, 10, 10, 15 ], [ 0, 4, 10, 24 ] ], 
      [ [ 5, 10, 4, 15 ], [ 3, 4, 13, 24 ] ], 
      [ [ 5, 10, 11, 15 ], [ 1, 4, 11, 24 ] ], 
      [ [ 6, 10, 0, 15 ], [ 2, 4, 12, 24 ] ], 
      [ [ 6, 10, 7, 15 ], [ 0, 4, 10, 24 ] ], 
      [ [ 6, 10, 12, 15 ], [ 2, 4, 12, 24 ] ], 
      [ [ 6, 10, 13, 15 ], [ 0, 4, 10, 24 ] ], 
      [ [ 7, 10, 1, 15 ], [ 3, 4, 13, 24 ] ], 
      [ [ 7, 10, 8, 15 ], [ 1, 4, 11, 24 ] ], 
      [ [ 7, 10, 13, 15 ], [ 3, 4, 13, 24 ] ], 
      [ [ 7, 10, 14, 15 ], [ 1, 4, 11, 24 ] ], 
      [ [ 8, 10, 4, 15 ], [ 0, 4, 10, 24 ] ], 
      [ [ 8, 10, 9, 15 ], [ 2, 4, 12, 24 ] ], 
      [ [ 8, 10, 10, 15 ], [ 0, 4, 10, 24 ] ], 
      [ [ 9, 10, 5, 15 ], [ 1, 4, 11, 24 ] ], 
      [ [ 9, 10, 10, 15 ], [ 3, 4, 13, 24 ] ], 
      [ [ 9, 10, 11, 15 ], [ 1, 4, 11, 24 ] ], 
      [ [ 0, 6, 1, 21 ], [ 2, 4, 8, 28 ] ], 
      [ [ 0, 6, 4, 21 ], [ 0, 4, 18, 28 ] ], 
      [ [ 0, 6, 13, 21 ], [ 2, 4, 20, 28 ] ], 
      [ [ 0, 6, 20, 21 ], [ 0, 4, 6, 28 ] ], 
      [ [ 1, 6, 0, 21 ], [ 3, 4, 21, 28 ] ], 
      [ [ 1, 6, 2, 21 ], [ 3, 4, 9, 28 ] ], 
      [ [ 1, 6, 5, 21 ], [ 1, 4, 19, 28 ] ], 
      [ [ 1, 6, 14, 21 ], [ 3, 4, 21, 28 ] ], 
      [ [ 2, 6, 6, 21 ], [ 2, 4, 20, 28 ] ], 
      [ [ 2, 6, 13, 21 ], [ 0, 4, 6, 28 ] ], 
      [ [ 3, 6, 7, 21 ], [ 3, 4, 21, 28 ] ], 
      [ [ 3, 6, 14, 21 ], [ 1, 4, 7, 28 ] ], 
      [ [ 4, 6, 6, 21 ], [ 0, 4, 6, 28 ] ], 
      [ [ 4, 6, 15, 21 ], [ 2, 4, 8, 28 ] ], 
      [ [ 4, 6, 18, 21 ], [ 0, 4, 18, 28 ] ], 
      [ [ 4, 6, 20, 21 ], [ 0, 4, 6, 28 ] ], 
      [ [ 5, 6, 0, 21 ], [ 3, 4, 21, 28 ] ], 
      [ [ 5, 6, 7, 21 ], [ 1, 4, 7, 28 ] ], 
      [ [ 5, 6, 16, 21 ], [ 3, 4, 9, 28 ] ], 
      [ [ 5, 6, 19, 21 ], [ 1, 4, 19, 28 ] ], 
      [ [ 0, 18, 4, 21 ], [ 0, 4, 18, 28 ] ], 
      [ [ 1, 18, 5, 21 ], [ 1, 4, 19, 28 ] ], 
      [ [ 2, 18, 6, 21 ], [ 2, 4, 20, 28 ] ], 
      [ [ 2, 18, 13, 21 ], [ 0, 4, 6, 28 ] ], 
      [ [ 3, 18, 7, 21 ], [ 3, 4, 21, 28 ] ], 
      [ [ 3, 18, 14, 21 ], [ 1, 4, 7, 28 ] ], 
      [ [ 4, 18, 15, 21 ], [ 2, 4, 8, 28 ] ], 
      [ [ 5, 18, 16, 21 ], [ 3, 4, 9, 28 ] ], 
      [ [ 6, 18, 11, 21 ], [ 0, 4, 18, 28 ] ], 
      [ [ 7, 18, 12, 21 ], [ 1, 4, 19, 28 ] ], 
      [ [ 8, 18, 6, 21 ], [ 0, 4, 6, 28 ] ], 
      [ [ 8, 18, 13, 21 ], [ 2, 4, 20, 28 ] ], 
      [ [ 9, 18, 7, 21 ], [ 1, 4, 7, 28 ] ], 
      [ [ 9, 18, 14, 21 ], [ 3, 4, 21, 28 ] ], 
      [ [ 10, 18, 8, 21 ], [ 2, 4, 8, 28 ] ], 
      [ [ 11, 18, 9, 21 ], [ 3, 4, 9, 28 ] ], 
      [ [ 12, 18, 4, 21 ], [ 0, 4, 18, 28 ] ], 
      [ [ 13, 18, 5, 21 ], [ 1, 4, 19, 28 ] ], 
      [ [ 14, 18, 6, 21 ], [ 2, 4, 20, 28 ] ], 
      [ [ 14, 18, 13, 21 ], [ 0, 4, 6, 28 ] ], 
      [ [ 15, 18, 7, 21 ], [ 3, 4, 21, 28 ] ], 
      [ [ 15, 18, 14, 21 ], [ 1, 4, 7, 28 ] ], 
      [ [ 16, 18, 15, 21 ], [ 2, 4, 8, 28 ] ], 
      [ [ 17, 18, 16, 21 ], [ 3, 4, 9, 28 ] ], 
      [ [ 0, 4, 6, 28 ], [ 6, 21, 4, 30 ] ], 
      [ [ 0, 4, 6, 28 ], [ 13, 21, 14, 30 ] ], 
      [ [ 0, 4, 6, 28 ], [ 20, 21, 4, 30 ] ], 
      [ [ 0, 4, 6, 28 ], [ 20, 21, 24, 30 ] ], 
      [ [ 0, 4, 18, 28 ], [ 4, 21, 12, 30 ] ], 
      [ [ 0, 4, 18, 28 ], [ 11, 21, 22, 30 ] ], 
      [ [ 1, 4, 7, 28 ], [ 7, 21, 5, 30 ] ], 
      [ [ 1, 4, 7, 28 ], [ 14, 21, 15, 30 ] ], 
      [ [ 1, 4, 19, 28 ], [ 5, 21, 13, 30 ] ], 
      [ [ 1, 4, 19, 28 ], [ 12, 21, 23, 30 ] ], 
      [ [ 2, 4, 8, 28 ], [ 8, 21, 6, 30 ] ], 
      [ [ 2, 4, 8, 28 ], [ 15, 21, 16, 30 ] ], 
      [ [ 2, 4, 20, 28 ], [ 6, 21, 14, 30 ] ], 
      [ [ 2, 4, 20, 28 ], [ 13, 21, 24, 30 ] ], 
      [ [ 3, 4, 9, 28 ], [ 9, 21, 7, 30 ] ], 
      [ [ 3, 4, 9, 28 ], [ 16, 21, 17, 30 ] ], 
      [ [ 3, 4, 21, 28 ], [ 0, 21, 5, 30 ] ], 
      [ [ 3, 4, 21, 28 ], [ 0, 21, 25, 30 ] ], 
      [ [ 3, 4, 21, 28 ], [ 7, 21, 15, 30 ] ], 
      [ [ 3, 4, 21, 28 ], [ 14, 21, 25, 30 ] ] ],, 
  [ [ [ 0, 4, 9, 10 ], [ 0, 3, 4, 15 ] ], 
      [ [ 0, 4, 9, 10 ], [ 1, 3, 9, 15 ] ], 
      [ [ 3, 4, 0, 10 ], [ 1, 3, 5, 15 ] ], 
      [ [ 3, 4, 0, 10 ], [ 2, 3, 10, 15 ] ], 
      [ [ 0, 2, 5, 12 ], [ 0, 5, 14, 15 ] ], 
      [ [ 0, 2, 5, 12 ], [ 4, 5, 2, 15 ] ], 
      [ [ 1, 2, 6, 12 ], [ 0, 5, 12, 15 ] ], 
      [ [ 1, 2, 6, 12 ], [ 4, 5, 0, 15 ] ], 
      [ [ 0, 3, 4, 15 ], [ 1, 2, 4, 20 ] ], 
      [ [ 0, 3, 8, 15 ], [ 0, 2, 3, 20 ] ], 
      [ [ 1, 3, 5, 15 ], [ 0, 2, 15, 20 ] ], 
      [ [ 1, 3, 9, 15 ], [ 1, 2, 4, 20 ] ], 
      [ [ 2, 3, 6, 15 ], [ 1, 2, 16, 20 ] ], 
      [ [ 2, 3, 10, 15 ], [ 0, 2, 15, 20 ] ], 
      [ [ 0, 9, 14, 15 ], [ 0, 2, 9, 20 ] ], 
      [ [ 1, 9, 9, 15 ], [ 0, 2, 9, 20 ] ], 
      [ [ 2, 9, 10, 15 ], [ 1, 2, 10, 20 ] ], 
      [ [ 4, 9, 0, 15 ], [ 1, 2, 10, 20 ] ], 
      [ [ 4, 9, 14, 15 ], [ 0, 2, 9, 20 ] ], 
      [ [ 6, 9, 4, 15 ], [ 0, 2, 9, 20 ] ], 
      [ [ 7, 9, 5, 15 ], [ 1, 2, 10, 20 ] ], 
      [ [ 8, 9, 0, 15 ], [ 1, 2, 10, 20 ] ], 
      [ [ 0, 3, 4, 15 ], [ 1, 8, 19, 20 ] ], 
      [ [ 0, 3, 4, 15 ], [ 7, 8, 4, 20 ] ], 
      [ [ 0, 3, 8, 15 ], [ 0, 8, 18, 20 ] ], 
      [ [ 0, 3, 8, 15 ], [ 6, 8, 3, 20 ] ], 
      [ [ 1, 3, 5, 15 ], [ 0, 8, 15, 20 ] ], 
      [ [ 1, 3, 5, 15 ], [ 6, 8, 0, 20 ] ], 
      [ [ 1, 3, 9, 15 ], [ 1, 8, 19, 20 ] ], 
      [ [ 1, 3, 9, 15 ], [ 7, 8, 4, 20 ] ], 
      [ [ 2, 3, 6, 15 ], [ 1, 8, 16, 20 ] ], 
      [ [ 2, 3, 6, 15 ], [ 7, 8, 1, 20 ] ], 
      [ [ 2, 3, 10, 15 ], [ 0, 8, 15, 20 ] ], 
      [ [ 2, 3, 10, 15 ], [ 6, 8, 0, 20 ] ], 
      [ [ 0, 3, 4, 15 ], [ 13, 14, 4, 20 ] ], 
      [ [ 0, 3, 8, 15 ], [ 12, 14, 3, 20 ] ], 
      [ [ 1, 3, 5, 15 ], [ 0, 14, 15, 20 ] ], 
      [ [ 1, 3, 9, 15 ], [ 13, 14, 4, 20 ] ], 
      [ [ 2, 3, 6, 15 ], [ 1, 14, 16, 20 ] ], 
      [ [ 2, 3, 10, 15 ], [ 0, 14, 15, 20 ] ], 
      [ [ 0, 2, 3, 14 ], [ 0, 3, 10, 21 ] ], 
      [ [ 0, 2, 3, 14 ], [ 1, 3, 3, 21 ] ], 
      [ [ 0, 2, 3, 14 ], [ 1, 3, 17, 21 ] ], 
      [ [ 0, 2, 3, 14 ], [ 2, 3, 10, 21 ] ], 
      [ [ 0, 2, 9, 14 ], [ 0, 3, 2, 21 ] ], 
      [ [ 0, 2, 9, 14 ], [ 0, 3, 16, 21 ] ], 
      [ [ 0, 2, 9, 14 ], [ 1, 3, 9, 21 ] ], 
      [ [ 0, 2, 9, 14 ], [ 2, 3, 16, 21 ] ], 
      [ [ 1, 2, 4, 14 ], [ 0, 3, 4, 21 ] ], 
      [ [ 1, 2, 4, 14 ], [ 1, 3, 11, 21 ] ], 
      [ [ 1, 2, 4, 14 ], [ 2, 3, 4, 21 ] ], 
      [ [ 1, 2, 4, 14 ], [ 2, 3, 18, 21 ] ], 
      [ [ 1, 2, 10, 14 ], [ 0, 3, 10, 21 ] ], 
      [ [ 1, 2, 10, 14 ], [ 1, 3, 3, 21 ] ], 
      [ [ 1, 2, 10, 14 ], [ 1, 3, 17, 21 ] ], 
      [ [ 1, 2, 10, 14 ], [ 2, 3, 10, 21 ] ], 
      [ [ 0, 8, 9, 14 ], [ 0, 3, 16, 21 ] ], 
      [ [ 1, 8, 10, 14 ], [ 0, 3, 10, 21 ] ], 
      [ [ 1, 8, 10, 14 ], [ 1, 3, 17, 21 ] ], 
      [ [ 2, 8, 11, 14 ], [ 0, 3, 4, 21 ] ], 
      [ [ 2, 8, 11, 14 ], [ 1, 3, 11, 21 ] ], 
      [ [ 2, 8, 11, 14 ], [ 2, 3, 18, 21 ] ], 
      [ [ 3, 8, 0, 14 ], [ 0, 3, 14, 21 ] ], 
      [ [ 3, 8, 12, 14 ], [ 1, 3, 5, 21 ] ], 
      [ [ 3, 8, 12, 14 ], [ 2, 3, 12, 21 ] ], 
      [ [ 4, 8, 1, 14 ], [ 0, 3, 8, 21 ] ], 
      [ [ 4, 8, 1, 14 ], [ 1, 3, 15, 21 ] ], 
      [ [ 4, 8, 13, 14 ], [ 2, 3, 6, 21 ] ], 
      [ [ 5, 8, 2, 14 ], [ 0, 3, 2, 21 ] ], 
      [ [ 5, 8, 2, 14 ], [ 1, 3, 9, 21 ] ], 
      [ [ 5, 8, 2, 14 ], [ 2, 3, 16, 21 ] ], 
      [ [ 6, 8, 3, 14 ], [ 1, 3, 3, 21 ] ], 
      [ [ 6, 8, 3, 14 ], [ 2, 3, 10, 21 ] ], 
      [ [ 7, 8, 4, 14 ], [ 2, 3, 4, 21 ] ], 
      [ [ 0, 14, 9, 20 ], [ 2, 3, 0, 21 ] ], 
      [ [ 13, 14, 10, 20 ], [ 0, 3, 20, 21 ] ], 
      [ [ 0, 2, 3, 14 ], [ 1, 9, 17, 21 ] ], 
      [ [ 0, 2, 3, 14 ], [ 7, 9, 3, 21 ] ], 
      [ [ 0, 2, 9, 14 ], [ 0, 9, 16, 21 ] ], 
      [ [ 0, 2, 9, 14 ], [ 6, 9, 2, 21 ] ], 
      [ [ 1, 2, 4, 14 ], [ 2, 9, 18, 21 ] ], 
      [ [ 1, 2, 4, 14 ], [ 8, 9, 4, 21 ] ], 
      [ [ 1, 2, 10, 14 ], [ 1, 9, 17, 21 ] ], 
      [ [ 1, 2, 10, 14 ], [ 7, 9, 3, 21 ] ], 
      [ [ 0, 2, 3, 14 ], [ 2, 15, 10, 21 ] ], 
      [ [ 0, 2, 3, 14 ], [ 7, 15, 3, 21 ] ], 
      [ [ 0, 2, 3, 14 ], [ 7, 15, 17, 21 ] ], 
      [ [ 0, 2, 3, 14 ], [ 12, 15, 10, 21 ] ], 
      [ [ 0, 2, 9, 14 ], [ 1, 15, 9, 21 ] ], 
      [ [ 0, 2, 9, 14 ], [ 6, 15, 2, 21 ] ], 
      [ [ 0, 2, 9, 14 ], [ 6, 15, 16, 21 ] ], 
      [ [ 0, 2, 9, 14 ], [ 11, 15, 9, 21 ] ], 
      [ [ 1, 2, 4, 14 ], [ 3, 15, 11, 21 ] ], 
      [ [ 1, 2, 4, 14 ], [ 8, 15, 4, 21 ] ], 
      [ [ 1, 2, 4, 14 ], [ 8, 15, 18, 21 ] ], 
      [ [ 1, 2, 4, 14 ], [ 13, 15, 11, 21 ] ], 
      [ [ 1, 2, 10, 14 ], [ 2, 15, 10, 21 ] ], 
      [ [ 1, 2, 10, 14 ], [ 7, 15, 3, 21 ] ], 
      [ [ 1, 2, 10, 14 ], [ 7, 15, 17, 21 ] ], 
      [ [ 1, 2, 10, 14 ], [ 12, 15, 10, 21 ] ], 
      [ [ 0, 2, 3, 20 ], [ 13, 15, 9, 21 ] ], 
      [ [ 0, 2, 15, 20 ], [ 0, 15, 10, 21 ] ], 
      [ [ 1, 2, 4, 20 ], [ 14, 15, 10, 21 ] ], 
      [ [ 1, 2, 16, 20 ], [ 1, 15, 11, 21 ] ], 
      [ [ 0, 2, 5, 12 ], [ 2, 15, 24, 25 ] ], 
      [ [ 1, 2, 6, 12 ], [ 12, 15, 0, 25 ] ], 
      [ [ 0, 3, 2, 21 ], [ 2, 14, 17, 26 ] ], 
      [ [ 0, 3, 4, 21 ], [ 11, 14, 8, 26 ] ], 
      [ [ 0, 3, 8, 21 ], [ 1, 14, 16, 26 ] ], 
      [ [ 0, 3, 10, 21 ], [ 10, 14, 7, 26 ] ], 
      [ [ 0, 3, 14, 21 ], [ 0, 14, 15, 26 ] ], 
      [ [ 0, 3, 16, 21 ], [ 9, 14, 6, 26 ] ], 
      [ [ 1, 3, 3, 21 ], [ 3, 14, 18, 26 ] ], 
      [ [ 1, 3, 5, 21 ], [ 12, 14, 9, 26 ] ], 
      [ [ 1, 3, 9, 21 ], [ 2, 14, 17, 26 ] ], 
      [ [ 1, 3, 11, 21 ], [ 11, 14, 8, 26 ] ], 
      [ [ 1, 3, 15, 21 ], [ 1, 14, 16, 26 ] ], 
      [ [ 1, 3, 17, 21 ], [ 10, 14, 7, 26 ] ], 
      [ [ 2, 3, 4, 21 ], [ 4, 14, 19, 26 ] ], 
      [ [ 2, 3, 6, 21 ], [ 13, 14, 10, 26 ] ], 
      [ [ 2, 3, 10, 21 ], [ 3, 14, 18, 26 ] ], 
      [ [ 2, 3, 12, 21 ], [ 12, 14, 9, 26 ] ], 
      [ [ 2, 3, 16, 21 ], [ 2, 14, 17, 26 ] ], 
      [ [ 2, 3, 18, 21 ], [ 11, 14, 8, 26 ] ], 
      [ [ 0, 3, 4, 15 ], [ 4, 20, 25, 26 ] ], 
      [ [ 0, 3, 8, 15 ], [ 3, 20, 24, 26 ] ], 
      [ [ 1, 3, 5, 15 ], [ 15, 20, 0, 26 ] ], 
      [ [ 1, 3, 9, 15 ], [ 4, 20, 25, 26 ] ], 
      [ [ 2, 3, 6, 15 ], [ 16, 20, 1, 26 ] ], 
      [ [ 2, 3, 10, 15 ], [ 15, 20, 0, 26 ] ], 
      [ [ 0, 2, 9, 20 ], [ 4, 15, 20, 27 ] ], 
      [ [ 0, 2, 9, 20 ], [ 9, 15, 5, 27 ] ], 
      [ [ 1, 2, 10, 20 ], [ 5, 15, 21, 27 ] ], 
      [ [ 1, 2, 10, 20 ], [ 10, 15, 6, 27 ] ], 
      [ [ 0, 2, 3, 14 ], [ 3, 21, 13, 27 ] ], 
      [ [ 0, 2, 3, 14 ], [ 17, 21, 13, 27 ] ], 
      [ [ 0, 2, 9, 14 ], [ 2, 21, 12, 27 ] ], 
      [ [ 0, 2, 9, 14 ], [ 16, 21, 12, 27 ] ], 
      [ [ 1, 2, 4, 14 ], [ 4, 21, 14, 27 ] ], 
      [ [ 1, 2, 4, 14 ], [ 18, 21, 14, 27 ] ], 
      [ [ 1, 2, 10, 14 ], [ 3, 21, 13, 27 ] ], 
      [ [ 1, 2, 10, 14 ], [ 17, 21, 13, 27 ] ], 
      [ [ 0, 3, 2, 21 ], [ 3, 4, 9, 28 ] ], 
      [ [ 0, 3, 4, 21 ], [ 0, 4, 18, 28 ] ], 
      [ [ 0, 3, 8, 21 ], [ 2, 4, 8, 28 ] ], 
      [ [ 0, 3, 14, 21 ], [ 1, 4, 7, 28 ] ], 
      [ [ 0, 3, 14, 21 ], [ 3, 4, 21, 28 ] ], 
      [ [ 0, 3, 20, 21 ], [ 0, 4, 6, 28 ] ], 
      [ [ 0, 3, 20, 21 ], [ 2, 4, 20, 28 ] ], 
      [ [ 1, 3, 5, 21 ], [ 1, 4, 19, 28 ] ], 
      [ [ 1, 3, 9, 21 ], [ 3, 4, 9, 28 ] ], 
      [ [ 1, 3, 11, 21 ], [ 0, 4, 18, 28 ] ], 
      [ [ 1, 3, 15, 21 ], [ 2, 4, 8, 28 ] ], 
      [ [ 2, 3, 0, 21 ], [ 1, 4, 7, 28 ] ], 
      [ [ 2, 3, 0, 21 ], [ 3, 4, 21, 28 ] ], 
      [ [ 2, 3, 6, 21 ], [ 0, 4, 6, 28 ] ], 
      [ [ 2, 3, 6, 21 ], [ 2, 4, 20, 28 ] ], 
      [ [ 2, 3, 12, 21 ], [ 1, 4, 19, 28 ] ], 
      [ [ 2, 3, 16, 21 ], [ 3, 4, 9, 28 ] ], 
      [ [ 2, 3, 18, 21 ], [ 0, 4, 18, 28 ] ], 
      [ [ 0, 9, 16, 21 ], [ 0, 4, 9, 28 ] ], 
      [ [ 0, 9, 16, 21 ], [ 1, 4, 16, 28 ] ], 
      [ [ 0, 9, 16, 21 ], [ 2, 4, 23, 28 ] ], 
      [ [ 0, 9, 20, 21 ], [ 0, 4, 27, 28 ] ], 
      [ [ 1, 9, 17, 21 ], [ 0, 4, 3, 28 ] ], 
      [ [ 1, 9, 17, 21 ], [ 1, 4, 10, 28 ] ], 
      [ [ 1, 9, 17, 21 ], [ 2, 4, 17, 28 ] ], 
      [ [ 1, 9, 17, 21 ], [ 3, 4, 24, 28 ] ], 
      [ [ 2, 9, 18, 21 ], [ 1, 4, 4, 28 ] ], 
      [ [ 2, 9, 18, 21 ], [ 2, 4, 11, 28 ] ], 
      [ [ 2, 9, 18, 21 ], [ 3, 4, 18, 28 ] ], 
      [ [ 3, 9, 19, 21 ], [ 2, 4, 5, 28 ] ], 
      [ [ 3, 9, 19, 21 ], [ 3, 4, 12, 28 ] ], 
      [ [ 4, 9, 0, 21 ], [ 0, 4, 21, 28 ] ], 
      [ [ 4, 9, 20, 21 ], [ 3, 4, 6, 28 ] ], 
      [ [ 5, 9, 1, 21 ], [ 0, 4, 15, 28 ] ], 
      [ [ 5, 9, 1, 21 ], [ 1, 4, 22, 28 ] ], 
      [ [ 6, 9, 2, 21 ], [ 0, 4, 9, 28 ] ], 
      [ [ 6, 9, 2, 21 ], [ 1, 4, 16, 28 ] ], 
      [ [ 6, 9, 2, 21 ], [ 2, 4, 23, 28 ] ], 
      [ [ 7, 9, 3, 21 ], [ 0, 4, 3, 28 ] ], 
      [ [ 7, 9, 3, 21 ], [ 1, 4, 10, 28 ] ], 
      [ [ 7, 9, 3, 21 ], [ 2, 4, 17, 28 ] ], 
      [ [ 7, 9, 3, 21 ], [ 3, 4, 24, 28 ] ], 
      [ [ 8, 9, 0, 21 ], [ 3, 4, 0, 28 ] ], 
      [ [ 8, 9, 4, 21 ], [ 1, 4, 4, 28 ] ], 
      [ [ 8, 9, 4, 21 ], [ 2, 4, 11, 28 ] ], 
      [ [ 8, 9, 4, 21 ], [ 3, 4, 18, 28 ] ], 
      [ [ 0, 15, 14, 21 ], [ 1, 4, 7, 28 ] ], 
      [ [ 0, 15, 14, 21 ], [ 3, 4, 21, 28 ] ], 
      [ [ 1, 15, 15, 21 ], [ 2, 4, 8, 28 ] ], 
      [ [ 2, 15, 16, 21 ], [ 3, 4, 9, 28 ] ], 
      [ [ 2, 15, 18, 21 ], [ 0, 4, 18, 28 ] ], 
      [ [ 3, 15, 19, 21 ], [ 1, 4, 19, 28 ] ], 
      [ [ 4, 15, 20, 21 ], [ 0, 4, 6, 28 ] ], 
      [ [ 4, 15, 20, 21 ], [ 2, 4, 20, 28 ] ], 
      [ [ 10, 15, 0, 21 ], [ 1, 4, 7, 28 ] ], 
      [ [ 10, 15, 0, 21 ], [ 3, 4, 21, 28 ] ], 
      [ [ 11, 15, 1, 21 ], [ 2, 4, 8, 28 ] ], 
      [ [ 12, 15, 2, 21 ], [ 3, 4, 9, 28 ] ], 
      [ [ 12, 15, 4, 21 ], [ 0, 4, 18, 28 ] ], 
      [ [ 13, 15, 5, 21 ], [ 1, 4, 19, 28 ] ], 
      [ [ 14, 15, 6, 21 ], [ 0, 4, 6, 28 ] ], 
      [ [ 14, 15, 6, 21 ], [ 2, 4, 20, 28 ] ], 
      [ [ 4, 21, 24, 27 ], [ 0, 4, 18, 28 ] ], 
      [ [ 5, 21, 25, 27 ], [ 1, 4, 19, 28 ] ], 
      [ [ 6, 21, 26, 27 ], [ 0, 4, 6, 28 ] ], 
      [ [ 6, 21, 26, 27 ], [ 2, 4, 20, 28 ] ], 
      [ [ 14, 21, 0, 27 ], [ 1, 4, 7, 28 ] ], 
      [ [ 14, 21, 0, 27 ], [ 3, 4, 21, 28 ] ], 
      [ [ 15, 21, 1, 27 ], [ 2, 4, 8, 28 ] ], 
      [ [ 16, 21, 2, 27 ], [ 3, 4, 9, 28 ] ], 
      [ [ 0, 3, 7, 24 ], [ 0, 7, 27, 28 ] ], 
      [ [ 0, 3, 7, 24 ], [ 6, 7, 3, 28 ] ], 
      [ [ 0, 3, 14, 24 ], [ 5, 7, 2, 28 ] ], 
      [ [ 1, 3, 8, 24 ], [ 0, 7, 24, 28 ] ], 
      [ [ 1, 3, 8, 24 ], [ 6, 7, 0, 28 ] ], 
      [ [ 1, 3, 15, 24 ], [ 0, 7, 27, 28 ] ], 
      [ [ 1, 3, 15, 24 ], [ 6, 7, 3, 28 ] ], 
      [ [ 2, 3, 9, 24 ], [ 1, 7, 25, 28 ] ], 
      [ [ 2, 3, 16, 24 ], [ 0, 7, 24, 28 ] ], 
      [ [ 2, 3, 16, 24 ], [ 6, 7, 0, 28 ] ], 
      [ [ 0, 3, 4, 15 ], [ 9, 10, 6, 28 ] ], 
      [ [ 0, 3, 8, 15 ], [ 8, 10, 5, 28 ] ], 
      [ [ 1, 3, 5, 15 ], [ 0, 10, 21, 28 ] ], 
      [ [ 1, 3, 9, 15 ], [ 9, 10, 6, 28 ] ], 
      [ [ 2, 3, 6, 15 ], [ 1, 10, 22, 28 ] ], 
      [ [ 2, 3, 10, 15 ], [ 0, 10, 21, 28 ] ], 
      [ [ 0, 3, 2, 21 ], [ 5, 16, 23, 28 ] ], 
      [ [ 0, 3, 4, 21 ], [ 10, 16, 4, 28 ] ], 
      [ [ 0, 3, 8, 21 ], [ 4, 16, 22, 28 ] ], 
      [ [ 0, 3, 10, 21 ], [ 9, 16, 3, 28 ] ], 
      [ [ 0, 3, 14, 21 ], [ 3, 16, 21, 28 ] ], 
      [ [ 0, 3, 16, 21 ], [ 8, 16, 2, 28 ] ], 
      [ [ 0, 3, 20, 21 ], [ 2, 16, 20, 28 ] ], 
      [ [ 1, 3, 3, 21 ], [ 6, 16, 24, 28 ] ], 
      [ [ 1, 3, 5, 21 ], [ 11, 16, 5, 28 ] ], 
      [ [ 1, 3, 9, 21 ], [ 5, 16, 23, 28 ] ], 
      [ [ 1, 3, 11, 21 ], [ 10, 16, 4, 28 ] ], 
      [ [ 1, 3, 15, 21 ], [ 4, 16, 22, 28 ] ], 
      [ [ 1, 3, 17, 21 ], [ 9, 16, 3, 28 ] ], 
      [ [ 2, 3, 0, 21 ], [ 13, 16, 7, 28 ] ], 
      [ [ 2, 3, 4, 21 ], [ 7, 16, 25, 28 ] ], 
      [ [ 2, 3, 6, 21 ], [ 12, 16, 6, 28 ] ], 
      [ [ 2, 3, 10, 21 ], [ 6, 16, 24, 28 ] ], 
      [ [ 2, 3, 12, 21 ], [ 11, 16, 5, 28 ] ], 
      [ [ 2, 3, 16, 21 ], [ 5, 16, 23, 28 ] ], 
      [ [ 2, 3, 18, 21 ], [ 10, 16, 4, 28 ] ], 
      [ [ 0, 3, 2, 21 ], [ 18, 22, 9, 28 ] ], 
      [ [ 0, 3, 4, 21 ], [ 3, 22, 18, 28 ] ], 
      [ [ 0, 3, 8, 21 ], [ 17, 22, 8, 28 ] ], 
      [ [ 0, 3, 10, 21 ], [ 2, 22, 17, 28 ] ], 
      [ [ 0, 3, 14, 21 ], [ 16, 22, 7, 28 ] ], 
      [ [ 0, 3, 16, 21 ], [ 1, 22, 16, 28 ] ], 
      [ [ 0, 3, 20, 21 ], [ 15, 22, 6, 28 ] ], 
      [ [ 1, 3, 3, 21 ], [ 19, 22, 10, 28 ] ], 
      [ [ 1, 3, 5, 21 ], [ 4, 22, 19, 28 ] ], 
      [ [ 1, 3, 9, 21 ], [ 18, 22, 9, 28 ] ], 
      [ [ 1, 3, 11, 21 ], [ 3, 22, 18, 28 ] ], 
      [ [ 1, 3, 15, 21 ], [ 17, 22, 8, 28 ] ], 
      [ [ 1, 3, 17, 21 ], [ 2, 22, 17, 28 ] ], 
      [ [ 2, 3, 0, 21 ], [ 6, 22, 21, 28 ] ], 
      [ [ 2, 3, 4, 21 ], [ 20, 22, 11, 28 ] ], 
      [ [ 2, 3, 6, 21 ], [ 5, 22, 20, 28 ] ], 
      [ [ 2, 3, 10, 21 ], [ 19, 22, 10, 28 ] ], 
      [ [ 2, 3, 12, 21 ], [ 4, 22, 19, 28 ] ], 
      [ [ 2, 3, 16, 21 ], [ 18, 22, 9, 28 ] ], 
      [ [ 2, 3, 18, 21 ], [ 3, 22, 18, 28 ] ], 
      [ [ 0, 7, 16, 21 ], [ 0, 2, 7, 30 ] ], 
      [ [ 0, 7, 16, 21 ], [ 1, 2, 22, 30 ] ], 
      [ [ 0, 7, 18, 21 ], [ 0, 2, 21, 30 ] ], 
      [ [ 1, 7, 17, 21 ], [ 1, 2, 8, 30 ] ], 
      [ [ 1, 7, 19, 21 ], [ 0, 2, 7, 30 ] ], 
      [ [ 1, 7, 19, 21 ], [ 1, 2, 22, 30 ] ], 
      [ [ 2, 7, 20, 21 ], [ 1, 2, 8, 30 ] ], 
      [ [ 4, 7, 0, 21 ], [ 0, 2, 21, 30 ] ], 
      [ [ 5, 7, 1, 21 ], [ 0, 2, 7, 30 ] ], 
      [ [ 5, 7, 1, 21 ], [ 1, 2, 22, 30 ] ], 
      [ [ 5, 7, 3, 21 ], [ 0, 2, 21, 30 ] ], 
      [ [ 6, 7, 2, 21 ], [ 1, 2, 8, 30 ] ], 
      [ [ 6, 7, 4, 21 ], [ 0, 2, 7, 30 ] ], 
      [ [ 6, 7, 4, 21 ], [ 1, 2, 22, 30 ] ], 
      [ [ 0, 8, 18, 20 ], [ 0, 6, 8, 30 ] ], 
      [ [ 0, 8, 18, 20 ], [ 2, 6, 18, 30 ] ], 
      [ [ 1, 8, 19, 20 ], [ 1, 6, 9, 30 ] ], 
      [ [ 1, 8, 19, 20 ], [ 3, 6, 19, 30 ] ], 
      [ [ 6, 8, 0, 20 ], [ 2, 6, 10, 30 ] ], 
      [ [ 6, 8, 0, 20 ], [ 4, 6, 20, 30 ] ], 
      [ [ 7, 8, 1, 20 ], [ 3, 6, 11, 30 ] ], 
      [ [ 7, 8, 1, 20 ], [ 5, 6, 21, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 0, 10, 28, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 8, 10, 4, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 1, 10, 29, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 9, 10, 5, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 0, 10, 24, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 8, 10, 0, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 1, 10, 25, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 9, 10, 1, 30 ] ], 
      [ [ 0, 3, 4, 15 ], [ 4, 20, 31, 32 ] ], 
      [ [ 0, 3, 8, 15 ], [ 3, 20, 30, 32 ] ], 
      [ [ 1, 3, 5, 15 ], [ 15, 20, 0, 32 ] ], 
      [ [ 1, 3, 9, 15 ], [ 4, 20, 31, 32 ] ], 
      [ [ 2, 3, 6, 15 ], [ 16, 20, 1, 32 ] ], 
      [ [ 2, 3, 10, 15 ], [ 15, 20, 0, 32 ] ] ],,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 
  [ [ [ 0, 8, 6, 20 ], [ 0, 3, 26, 30 ] ], 
      [ [ 0, 8, 18, 20 ], [ 1, 3, 8, 30 ] ], 
      [ [ 0, 8, 18, 20 ], [ 2, 3, 18, 30 ] ], 
      [ [ 1, 8, 7, 20 ], [ 0, 3, 17, 30 ] ], 
      [ [ 1, 8, 7, 20 ], [ 1, 3, 27, 30 ] ], 
      [ [ 1, 8, 19, 20 ], [ 0, 3, 29, 30 ] ], 
      [ [ 1, 8, 19, 20 ], [ 2, 3, 9, 30 ] ], 
      [ [ 2, 8, 8, 20 ], [ 0, 3, 8, 30 ] ], 
      [ [ 2, 8, 8, 20 ], [ 0, 3, 28, 30 ] ], 
      [ [ 2, 8, 8, 20 ], [ 1, 3, 18, 30 ] ], 
      [ [ 2, 8, 8, 20 ], [ 2, 3, 28, 30 ] ], 
      [ [ 3, 8, 9, 20 ], [ 0, 3, 19, 30 ] ], 
      [ [ 3, 8, 9, 20 ], [ 1, 3, 9, 30 ] ], 
      [ [ 3, 8, 9, 20 ], [ 1, 3, 29, 30 ] ], 
      [ [ 3, 8, 9, 20 ], [ 2, 3, 19, 30 ] ], 
      [ [ 4, 8, 10, 20 ], [ 0, 3, 10, 30 ] ], 
      [ [ 4, 8, 10, 20 ], [ 1, 3, 0, 30 ] ], 
      [ [ 4, 8, 10, 20 ], [ 1, 3, 20, 30 ] ], 
      [ [ 4, 8, 10, 20 ], [ 2, 3, 10, 30 ] ], 
      [ [ 5, 8, 11, 20 ], [ 0, 3, 1, 30 ] ], 
      [ [ 5, 8, 11, 20 ], [ 1, 3, 11, 30 ] ], 
      [ [ 5, 8, 11, 20 ], [ 2, 3, 1, 30 ] ], 
      [ [ 5, 8, 11, 20 ], [ 2, 3, 21, 30 ] ], 
      [ [ 6, 8, 0, 20 ], [ 0, 3, 20, 30 ] ], 
      [ [ 6, 8, 0, 20 ], [ 2, 3, 0, 30 ] ], 
      [ [ 6, 8, 12, 20 ], [ 1, 3, 2, 30 ] ], 
      [ [ 6, 8, 12, 20 ], [ 2, 3, 12, 30 ] ], 
      [ [ 7, 8, 1, 20 ], [ 0, 3, 11, 30 ] ], 
      [ [ 7, 8, 1, 20 ], [ 1, 3, 21, 30 ] ], 
      [ [ 7, 8, 13, 20 ], [ 2, 3, 3, 30 ] ], 
      [ [ 0, 8, 6, 20 ], [ 2, 9, 6, 30 ] ], 
      [ [ 0, 8, 6, 20 ], [ 5, 9, 16, 30 ] ], 
      [ [ 0, 8, 6, 20 ], [ 8, 9, 6, 30 ] ], 
      [ [ 0, 8, 18, 20 ], [ 3, 9, 8, 30 ] ], 
      [ [ 0, 8, 18, 20 ], [ 3, 9, 28, 30 ] ], 
      [ [ 1, 8, 7, 20 ], [ 0, 9, 17, 30 ] ], 
      [ [ 1, 8, 7, 20 ], [ 3, 9, 7, 30 ] ], 
      [ [ 1, 8, 7, 20 ], [ 6, 9, 17, 30 ] ], 
      [ [ 1, 8, 19, 20 ], [ 4, 9, 9, 30 ] ], 
      [ [ 1, 8, 19, 20 ], [ 4, 9, 29, 30 ] ], 
      [ [ 2, 8, 8, 20 ], [ 1, 9, 18, 30 ] ], 
      [ [ 2, 8, 8, 20 ], [ 4, 9, 8, 30 ] ], 
      [ [ 2, 8, 8, 20 ], [ 7, 9, 18, 30 ] ], 
      [ [ 3, 8, 9, 20 ], [ 2, 9, 19, 30 ] ], 
      [ [ 3, 8, 9, 20 ], [ 5, 9, 9, 30 ] ], 
      [ [ 3, 8, 9, 20 ], [ 8, 9, 19, 30 ] ], 
      [ [ 4, 8, 10, 20 ], [ 0, 9, 10, 30 ] ], 
      [ [ 4, 8, 10, 20 ], [ 3, 9, 20, 30 ] ], 
      [ [ 4, 8, 10, 20 ], [ 6, 9, 10, 30 ] ], 
      [ [ 5, 8, 11, 20 ], [ 1, 9, 11, 30 ] ], 
      [ [ 5, 8, 11, 20 ], [ 4, 9, 21, 30 ] ], 
      [ [ 5, 8, 11, 20 ], [ 7, 9, 11, 30 ] ], 
      [ [ 6, 8, 0, 20 ], [ 4, 9, 0, 30 ] ], 
      [ [ 6, 8, 0, 20 ], [ 4, 9, 20, 30 ] ], 
      [ [ 6, 8, 12, 20 ], [ 2, 9, 12, 30 ] ], 
      [ [ 6, 8, 12, 20 ], [ 5, 9, 22, 30 ] ], 
      [ [ 6, 8, 12, 20 ], [ 8, 9, 12, 30 ] ], 
      [ [ 7, 8, 1, 20 ], [ 5, 9, 1, 30 ] ], 
      [ [ 7, 8, 1, 20 ], [ 5, 9, 21, 30 ] ], 
      [ [ 7, 8, 13, 20 ], [ 0, 9, 23, 30 ] ], 
      [ [ 7, 8, 13, 20 ], [ 3, 9, 13, 30 ] ], 
      [ [ 7, 8, 13, 20 ], [ 6, 9, 23, 30 ] ], 
      [ [ 0, 8, 6, 20 ], [ 3, 21, 16, 30 ] ], 
      [ [ 0, 8, 6, 20 ], [ 10, 21, 6, 30 ] ], 
      [ [ 0, 8, 6, 20 ], [ 17, 21, 16, 30 ] ], 
      [ [ 0, 8, 18, 20 ], [ 9, 21, 8, 30 ] ], 
      [ [ 1, 8, 7, 20 ], [ 4, 21, 17, 30 ] ], 
      [ [ 1, 8, 7, 20 ], [ 11, 21, 7, 30 ] ], 
      [ [ 1, 8, 7, 20 ], [ 18, 21, 17, 30 ] ], 
      [ [ 1, 8, 19, 20 ], [ 10, 21, 9, 30 ] ], 
      [ [ 2, 8, 8, 20 ], [ 5, 21, 18, 30 ] ], 
      [ [ 2, 8, 8, 20 ], [ 12, 21, 8, 30 ] ], 
      [ [ 2, 8, 8, 20 ], [ 19, 21, 18, 30 ] ], 
      [ [ 3, 8, 9, 20 ], [ 6, 21, 19, 30 ] ], 
      [ [ 3, 8, 9, 20 ], [ 13, 21, 9, 30 ] ], 
      [ [ 3, 8, 9, 20 ], [ 20, 21, 19, 30 ] ], 
      [ [ 4, 8, 10, 20 ], [ 0, 21, 10, 30 ] ], 
      [ [ 4, 8, 10, 20 ], [ 7, 21, 20, 30 ] ], 
      [ [ 4, 8, 10, 20 ], [ 14, 21, 10, 30 ] ], 
      [ [ 5, 8, 11, 20 ], [ 1, 21, 11, 30 ] ], 
      [ [ 5, 8, 11, 20 ], [ 8, 21, 21, 30 ] ], 
      [ [ 5, 8, 11, 20 ], [ 15, 21, 11, 30 ] ], 
      [ [ 6, 8, 0, 20 ], [ 10, 21, 20, 30 ] ], 
      [ [ 6, 8, 12, 20 ], [ 2, 21, 12, 30 ] ], 
      [ [ 6, 8, 12, 20 ], [ 9, 21, 22, 30 ] ], 
      [ [ 6, 8, 12, 20 ], [ 16, 21, 12, 30 ] ], 
      [ [ 7, 8, 1, 20 ], [ 11, 21, 21, 30 ] ], 
      [ [ 7, 8, 13, 20 ], [ 3, 21, 13, 30 ] ], 
      [ [ 7, 8, 13, 20 ], [ 10, 21, 23, 30 ] ], 
      [ [ 7, 8, 13, 20 ], [ 17, 21, 13, 30 ] ], 
      [ [ 0, 8, 6, 20 ], [ 5, 27, 16, 30 ] ], 
      [ [ 0, 8, 6, 20 ], [ 14, 27, 6, 30 ] ], 
      [ [ 1, 8, 7, 20 ], [ 6, 27, 17, 30 ] ], 
      [ [ 1, 8, 7, 20 ], [ 15, 27, 7, 30 ] ], 
      [ [ 2, 8, 8, 20 ], [ 7, 27, 18, 30 ] ], 
      [ [ 2, 8, 8, 20 ], [ 16, 27, 8, 30 ] ], 
      [ [ 3, 8, 9, 20 ], [ 8, 27, 19, 30 ] ], 
      [ [ 3, 8, 9, 20 ], [ 17, 27, 9, 30 ] ], 
      [ [ 4, 8, 10, 20 ], [ 9, 27, 20, 30 ] ], 
      [ [ 4, 8, 10, 20 ], [ 18, 27, 10, 30 ] ], 
      [ [ 5, 8, 11, 20 ], [ 10, 27, 21, 30 ] ], 
      [ [ 5, 8, 11, 20 ], [ 19, 27, 11, 30 ] ], 
      [ [ 6, 8, 12, 20 ], [ 11, 27, 22, 30 ] ], 
      [ [ 6, 8, 12, 20 ], [ 20, 27, 12, 30 ] ], 
      [ [ 7, 8, 13, 20 ], [ 12, 27, 23, 30 ] ], 
      [ [ 7, 8, 13, 20 ], [ 21, 27, 13, 30 ] ], 
      [ [ 0, 5, 1, 30 ], [ 7, 12, 17, 32 ] ], 
      [ [ 0, 5, 4, 30 ], [ 4, 12, 14, 32 ] ], 
      [ [ 0, 5, 6, 30 ], [ 6, 12, 16, 32 ] ], 
      [ [ 0, 5, 7, 30 ], [ 1, 12, 31, 32 ] ], 
      [ [ 0, 5, 9, 30 ], [ 3, 12, 13, 32 ] ], 
      [ [ 0, 5, 11, 30 ], [ 5, 12, 15, 32 ] ], 
      [ [ 0, 5, 12, 30 ], [ 0, 12, 30, 32 ] ], 
      [ [ 0, 5, 14, 30 ], [ 2, 12, 12, 32 ] ], 
      [ [ 0, 5, 16, 30 ], [ 4, 12, 14, 32 ] ], 
      [ [ 0, 5, 17, 30 ], [ 11, 12, 1, 32 ] ], 
      [ [ 0, 5, 17, 30 ], [ 11, 12, 21, 32 ] ], 
      [ [ 0, 5, 19, 30 ], [ 1, 12, 11, 32 ] ], 
      [ [ 0, 5, 19, 30 ], [ 1, 12, 31, 32 ] ], 
      [ [ 0, 5, 21, 30 ], [ 3, 12, 13, 32 ] ], 
      [ [ 0, 5, 22, 30 ], [ 10, 12, 0, 32 ] ], 
      [ [ 0, 5, 22, 30 ], [ 10, 12, 20, 32 ] ], 
      [ [ 0, 5, 24, 30 ], [ 0, 12, 10, 32 ] ], 
      [ [ 0, 5, 24, 30 ], [ 0, 12, 30, 32 ] ], 
      [ [ 0, 5, 26, 30 ], [ 2, 12, 12, 32 ] ], 
      [ [ 0, 5, 27, 30 ], [ 9, 12, 19, 32 ] ], 
      [ [ 0, 5, 29, 30 ], [ 11, 12, 1, 32 ] ], 
      [ [ 1, 5, 0, 30 ], [ 6, 12, 16, 32 ] ], 
      [ [ 1, 5, 2, 30 ], [ 8, 12, 18, 32 ] ], 
      [ [ 1, 5, 4, 30 ], [ 10, 12, 0, 32 ] ], 
      [ [ 1, 5, 5, 30 ], [ 5, 12, 15, 32 ] ], 
      [ [ 1, 5, 7, 30 ], [ 7, 12, 17, 32 ] ], 
      [ [ 1, 5, 10, 30 ], [ 4, 12, 14, 32 ] ], 
      [ [ 1, 5, 12, 30 ], [ 6, 12, 16, 32 ] ], 
      [ [ 1, 5, 13, 30 ], [ 1, 12, 31, 32 ] ], 
      [ [ 1, 5, 15, 30 ], [ 3, 12, 13, 32 ] ], 
      [ [ 1, 5, 17, 30 ], [ 5, 12, 15, 32 ] ], 
      [ [ 1, 5, 18, 30 ], [ 0, 12, 30, 32 ] ], 
      [ [ 1, 5, 20, 30 ], [ 2, 12, 12, 32 ] ], 
      [ [ 1, 5, 22, 30 ], [ 4, 12, 14, 32 ] ], 
      [ [ 1, 5, 23, 30 ], [ 11, 12, 1, 32 ] ], 
      [ [ 1, 5, 23, 30 ], [ 11, 12, 21, 32 ] ], 
      [ [ 1, 5, 25, 30 ], [ 1, 12, 11, 32 ] ], 
      [ [ 1, 5, 25, 30 ], [ 1, 12, 31, 32 ] ], 
      [ [ 1, 5, 27, 30 ], [ 3, 12, 13, 32 ] ], 
      [ [ 1, 5, 28, 30 ], [ 10, 12, 0, 32 ] ], 
      [ [ 1, 5, 28, 30 ], [ 10, 12, 20, 32 ] ], 
      [ [ 2, 5, 0, 30 ], [ 0, 12, 10, 32 ] ], 
      [ [ 2, 5, 0, 30 ], [ 0, 12, 30, 32 ] ], 
      [ [ 2, 5, 1, 30 ], [ 7, 12, 17, 32 ] ], 
      [ [ 2, 5, 3, 30 ], [ 9, 12, 19, 32 ] ], 
      [ [ 2, 5, 5, 30 ], [ 11, 12, 1, 32 ] ], 
      [ [ 2, 5, 6, 30 ], [ 6, 12, 16, 32 ] ], 
      [ [ 2, 5, 8, 30 ], [ 8, 12, 18, 32 ] ], 
      [ [ 2, 5, 10, 30 ], [ 10, 12, 0, 32 ] ], 
      [ [ 2, 5, 11, 30 ], [ 5, 12, 15, 32 ] ], 
      [ [ 2, 5, 13, 30 ], [ 7, 12, 17, 32 ] ], 
      [ [ 2, 5, 16, 30 ], [ 4, 12, 14, 32 ] ], 
      [ [ 2, 5, 18, 30 ], [ 6, 12, 16, 32 ] ], 
      [ [ 2, 5, 19, 30 ], [ 1, 12, 31, 32 ] ], 
      [ [ 2, 5, 21, 30 ], [ 3, 12, 13, 32 ] ], 
      [ [ 2, 5, 23, 30 ], [ 5, 12, 15, 32 ] ], 
      [ [ 2, 5, 24, 30 ], [ 0, 12, 30, 32 ] ], 
      [ [ 2, 5, 26, 30 ], [ 2, 12, 12, 32 ] ], 
      [ [ 2, 5, 28, 30 ], [ 4, 12, 14, 32 ] ], 
      [ [ 2, 5, 29, 30 ], [ 11, 12, 1, 32 ] ], 
      [ [ 2, 5, 29, 30 ], [ 11, 12, 21, 32 ] ], 
      [ [ 3, 5, 1, 30 ], [ 1, 12, 11, 32 ] ], 
      [ [ 3, 5, 1, 30 ], [ 1, 12, 31, 32 ] ], 
      [ [ 3, 5, 2, 30 ], [ 8, 12, 18, 32 ] ], 
      [ [ 3, 5, 4, 30 ], [ 10, 12, 0, 32 ] ], 
      [ [ 3, 5, 4, 30 ], [ 10, 12, 20, 32 ] ], 
      [ [ 3, 5, 6, 30 ], [ 0, 12, 10, 32 ] ], 
      [ [ 3, 5, 6, 30 ], [ 0, 12, 30, 32 ] ], 
      [ [ 3, 5, 7, 30 ], [ 7, 12, 17, 32 ] ], 
      [ [ 3, 5, 9, 30 ], [ 9, 12, 19, 32 ] ], 
      [ [ 3, 5, 11, 30 ], [ 11, 12, 1, 32 ] ], 
      [ [ 3, 5, 12, 30 ], [ 6, 12, 16, 32 ] ], 
      [ [ 3, 5, 14, 30 ], [ 8, 12, 18, 32 ] ], 
      [ [ 3, 5, 16, 30 ], [ 10, 12, 0, 32 ] ], 
      [ [ 3, 5, 17, 30 ], [ 5, 12, 15, 32 ] ], 
      [ [ 3, 5, 19, 30 ], [ 7, 12, 17, 32 ] ], 
      [ [ 3, 5, 22, 30 ], [ 4, 12, 14, 32 ] ], 
      [ [ 3, 5, 24, 30 ], [ 6, 12, 16, 32 ] ], 
      [ [ 3, 5, 25, 30 ], [ 1, 12, 31, 32 ] ], 
      [ [ 3, 5, 27, 30 ], [ 3, 12, 13, 32 ] ], 
      [ [ 3, 5, 29, 30 ], [ 5, 12, 15, 32 ] ], 
      [ [ 4, 5, 0, 30 ], [ 0, 12, 30, 32 ] ], 
      [ [ 4, 5, 2, 30 ], [ 2, 12, 12, 32 ] ], 
      [ [ 4, 5, 3, 30 ], [ 9, 12, 19, 32 ] ], 
      [ [ 4, 5, 5, 30 ], [ 11, 12, 1, 32 ] ], 
      [ [ 4, 5, 5, 30 ], [ 11, 12, 21, 32 ] ], 
      [ [ 4, 5, 7, 30 ], [ 1, 12, 11, 32 ] ], 
      [ [ 4, 5, 7, 30 ], [ 1, 12, 31, 32 ] ], 
      [ [ 4, 5, 8, 30 ], [ 8, 12, 18, 32 ] ], 
      [ [ 4, 5, 10, 30 ], [ 10, 12, 0, 32 ] ], 
      [ [ 4, 5, 10, 30 ], [ 10, 12, 20, 32 ] ], 
      [ [ 4, 5, 12, 30 ], [ 0, 12, 10, 32 ] ], 
      [ [ 4, 5, 12, 30 ], [ 0, 12, 30, 32 ] ], 
      [ [ 4, 5, 13, 30 ], [ 7, 12, 17, 32 ] ], 
      [ [ 4, 5, 15, 30 ], [ 9, 12, 19, 32 ] ], 
      [ [ 4, 5, 17, 30 ], [ 11, 12, 1, 32 ] ], 
      [ [ 4, 5, 18, 30 ], [ 6, 12, 16, 32 ] ], 
      [ [ 4, 5, 20, 30 ], [ 8, 12, 18, 32 ] ], 
      [ [ 4, 5, 22, 30 ], [ 10, 12, 0, 32 ] ], 
      [ [ 4, 5, 23, 30 ], [ 5, 12, 15, 32 ] ], 
      [ [ 4, 5, 25, 30 ], [ 7, 12, 17, 32 ] ], 
      [ [ 4, 5, 28, 30 ], [ 4, 12, 14, 32 ] ], 
      [ [ 0, 3, 1, 30 ], [ 11, 20, 5, 32 ] ], 
      [ [ 0, 3, 1, 30 ], [ 11, 20, 17, 32 ] ], 
      [ [ 0, 3, 1, 30 ], [ 11, 20, 29, 32 ] ], 
      [ [ 0, 3, 4, 30 ], [ 4, 20, 22, 32 ] ], 
      [ [ 0, 3, 7, 30 ], [ 17, 20, 23, 32 ] ], 
      [ [ 0, 3, 8, 30 ], [ 8, 20, 2, 32 ] ], 
      [ [ 0, 3, 10, 30 ], [ 10, 20, 4, 32 ] ], 
      [ [ 0, 3, 10, 30 ], [ 10, 20, 16, 32 ] ], 
      [ [ 0, 3, 11, 30 ], [ 1, 20, 7, 32 ] ], 
      [ [ 0, 3, 13, 30 ], [ 3, 20, 21, 32 ] ], 
      [ [ 0, 3, 14, 30 ], [ 14, 20, 8, 32 ] ], 
      [ [ 0, 3, 16, 30 ], [ 16, 20, 22, 32 ] ], 
      [ [ 0, 3, 17, 30 ], [ 7, 20, 13, 32 ] ], 
      [ [ 0, 3, 17, 30 ], [ 7, 20, 25, 32 ] ], 
      [ [ 0, 3, 19, 30 ], [ 9, 20, 27, 32 ] ], 
      [ [ 0, 3, 20, 30 ], [ 0, 20, 6, 32 ] ], 
      [ [ 0, 3, 23, 30 ], [ 13, 20, 7, 32 ] ], 
      [ [ 0, 3, 23, 30 ], [ 13, 20, 31, 32 ] ], 
      [ [ 0, 3, 26, 30 ], [ 6, 20, 0, 32 ] ], 
      [ [ 0, 3, 26, 30 ], [ 6, 20, 12, 32 ] ], 
      [ [ 0, 3, 26, 30 ], [ 6, 20, 24, 32 ] ], 
      [ [ 0, 3, 28, 30 ], [ 8, 20, 2, 32 ] ], 
      [ [ 0, 3, 28, 30 ], [ 8, 20, 14, 32 ] ], 
      [ [ 0, 3, 28, 30 ], [ 8, 20, 26, 32 ] ], 
      [ [ 0, 3, 29, 30 ], [ 19, 20, 1, 32 ] ], 
      [ [ 0, 3, 29, 30 ], [ 19, 20, 13, 32 ] ], 
      [ [ 0, 3, 29, 30 ], [ 19, 20, 25, 32 ] ], 
      [ [ 1, 3, 0, 30 ], [ 10, 20, 4, 32 ] ], 
      [ [ 1, 3, 0, 30 ], [ 10, 20, 16, 32 ] ], 
      [ [ 1, 3, 0, 30 ], [ 10, 20, 28, 32 ] ], 
      [ [ 1, 3, 2, 30 ], [ 12, 20, 6, 32 ] ], 
      [ [ 1, 3, 2, 30 ], [ 12, 20, 18, 32 ] ], 
      [ [ 1, 3, 2, 30 ], [ 12, 20, 30, 32 ] ], 
      [ [ 1, 3, 5, 30 ], [ 5, 20, 23, 32 ] ], 
      [ [ 1, 3, 8, 30 ], [ 18, 20, 24, 32 ] ], 
      [ [ 1, 3, 9, 30 ], [ 9, 20, 3, 32 ] ], 
      [ [ 1, 3, 11, 30 ], [ 11, 20, 5, 32 ] ], 
      [ [ 1, 3, 11, 30 ], [ 11, 20, 17, 32 ] ], 
      [ [ 1, 3, 12, 30 ], [ 2, 20, 8, 32 ] ], 
      [ [ 1, 3, 14, 30 ], [ 4, 20, 22, 32 ] ], 
      [ [ 1, 3, 15, 30 ], [ 15, 20, 9, 32 ] ], 
      [ [ 1, 3, 17, 30 ], [ 17, 20, 23, 32 ] ], 
      [ [ 1, 3, 18, 30 ], [ 8, 20, 14, 32 ] ], 
      [ [ 1, 3, 18, 30 ], [ 8, 20, 26, 32 ] ], 
      [ [ 1, 3, 20, 30 ], [ 10, 20, 28, 32 ] ], 
      [ [ 1, 3, 21, 30 ], [ 1, 20, 7, 32 ] ], 
      [ [ 1, 3, 24, 30 ], [ 14, 20, 8, 32 ] ], 
      [ [ 1, 3, 27, 30 ], [ 7, 20, 1, 32 ] ], 
      [ [ 1, 3, 27, 30 ], [ 7, 20, 13, 32 ] ], 
      [ [ 1, 3, 27, 30 ], [ 7, 20, 25, 32 ] ], 
      [ [ 1, 3, 29, 30 ], [ 9, 20, 3, 32 ] ], 
      [ [ 1, 3, 29, 30 ], [ 9, 20, 15, 32 ] ], 
      [ [ 1, 3, 29, 30 ], [ 9, 20, 27, 32 ] ], 
      [ [ 2, 3, 0, 30 ], [ 0, 20, 6, 32 ] ], 
      [ [ 2, 3, 0, 30 ], [ 0, 20, 18, 32 ] ], 
      [ [ 2, 3, 0, 30 ], [ 0, 20, 30, 32 ] ], 
      [ [ 2, 3, 1, 30 ], [ 11, 20, 5, 32 ] ], 
      [ [ 2, 3, 1, 30 ], [ 11, 20, 17, 32 ] ], 
      [ [ 2, 3, 1, 30 ], [ 11, 20, 29, 32 ] ], 
      [ [ 2, 3, 3, 30 ], [ 13, 20, 7, 32 ] ], 
      [ [ 2, 3, 3, 30 ], [ 13, 20, 19, 32 ] ], 
      [ [ 2, 3, 3, 30 ], [ 13, 20, 31, 32 ] ], 
      [ [ 2, 3, 6, 30 ], [ 6, 20, 0, 32 ] ], 
      [ [ 2, 3, 6, 30 ], [ 6, 20, 24, 32 ] ], 
      [ [ 2, 3, 9, 30 ], [ 19, 20, 25, 32 ] ], 
      [ [ 2, 3, 10, 30 ], [ 10, 20, 4, 32 ] ], 
      [ [ 2, 3, 12, 30 ], [ 12, 20, 6, 32 ] ], 
      [ [ 2, 3, 12, 30 ], [ 12, 20, 18, 32 ] ], 
      [ [ 2, 3, 13, 30 ], [ 3, 20, 9, 32 ] ], 
      [ [ 2, 3, 15, 30 ], [ 5, 20, 23, 32 ] ], 
      [ [ 2, 3, 16, 30 ], [ 16, 20, 10, 32 ] ], 
      [ [ 2, 3, 18, 30 ], [ 18, 20, 24, 32 ] ], 
      [ [ 2, 3, 19, 30 ], [ 9, 20, 15, 32 ] ], 
      [ [ 2, 3, 19, 30 ], [ 9, 20, 27, 32 ] ], 
      [ [ 2, 3, 21, 30 ], [ 11, 20, 29, 32 ] ], 
      [ [ 2, 3, 22, 30 ], [ 2, 20, 8, 32 ] ], 
      [ [ 2, 3, 25, 30 ], [ 15, 20, 9, 32 ] ], 
      [ [ 2, 3, 28, 30 ], [ 8, 20, 2, 32 ] ], 
      [ [ 2, 3, 28, 30 ], [ 8, 20, 14, 32 ] ], 
      [ [ 2, 3, 28, 30 ], [ 8, 20, 26, 32 ] ], 
      [ [ 3, 9, 28, 30 ], [ 18, 20, 0, 32 ] ], 
      [ [ 4, 9, 0, 30 ], [ 0, 20, 30, 32 ] ], 
      [ [ 4, 9, 29, 30 ], [ 19, 20, 1, 32 ] ], 
      [ [ 5, 9, 1, 30 ], [ 1, 20, 31, 32 ] ], 
      [ [ 0, 21, 2, 30 ], [ 2, 20, 20, 32 ] ], 
      [ [ 0, 21, 7, 30 ], [ 17, 20, 23, 32 ] ], 
      [ [ 0, 21, 11, 30 ], [ 1, 20, 31, 32 ] ], 
      [ [ 1, 21, 3, 30 ], [ 3, 20, 21, 32 ] ], 
      [ [ 1, 21, 8, 30 ], [ 18, 20, 24, 32 ] ], 
      [ [ 2, 21, 4, 30 ], [ 4, 20, 22, 32 ] ], 
      [ [ 2, 21, 9, 30 ], [ 19, 20, 25, 32 ] ], 
      [ [ 3, 21, 5, 30 ], [ 5, 20, 23, 32 ] ], 
      [ [ 4, 21, 6, 30 ], [ 6, 20, 24, 32 ] ], 
      [ [ 4, 21, 20, 30 ], [ 0, 20, 6, 32 ] ], 
      [ [ 5, 21, 7, 30 ], [ 7, 20, 25, 32 ] ], 
      [ [ 5, 21, 21, 30 ], [ 1, 20, 7, 32 ] ], 
      [ [ 6, 21, 8, 30 ], [ 8, 20, 26, 32 ] ], 
      [ [ 6, 21, 22, 30 ], [ 2, 20, 8, 32 ] ], 
      [ [ 7, 21, 0, 30 ], [ 10, 20, 16, 32 ] ], 
      [ [ 7, 21, 9, 30 ], [ 9, 20, 27, 32 ] ], 
      [ [ 7, 21, 23, 30 ], [ 3, 20, 9, 32 ] ], 
      [ [ 8, 21, 1, 30 ], [ 11, 20, 17, 32 ] ], 
      [ [ 8, 21, 10, 30 ], [ 10, 20, 28, 32 ] ], 
      [ [ 8, 21, 24, 30 ], [ 4, 20, 10, 32 ] ], 
      [ [ 9, 21, 2, 30 ], [ 12, 20, 18, 32 ] ], 
      [ [ 9, 21, 11, 30 ], [ 11, 20, 29, 32 ] ], 
      [ [ 9, 21, 16, 30 ], [ 6, 20, 0, 32 ] ], 
      [ [ 9, 21, 25, 30 ], [ 5, 20, 11, 32 ] ], 
      [ [ 10, 21, 3, 30 ], [ 13, 20, 19, 32 ] ], 
      [ [ 10, 21, 12, 30 ], [ 12, 20, 30, 32 ] ], 
      [ [ 10, 21, 17, 30 ], [ 7, 20, 1, 32 ] ], 
      [ [ 10, 21, 26, 30 ], [ 6, 20, 12, 32 ] ], 
      [ [ 11, 21, 4, 30 ], [ 14, 20, 20, 32 ] ], 
      [ [ 11, 21, 13, 30 ], [ 13, 20, 31, 32 ] ], 
      [ [ 11, 21, 18, 30 ], [ 8, 20, 2, 32 ] ], 
      [ [ 11, 21, 27, 30 ], [ 7, 20, 13, 32 ] ], 
      [ [ 12, 21, 5, 30 ], [ 15, 20, 21, 32 ] ], 
      [ [ 12, 21, 19, 30 ], [ 9, 20, 3, 32 ] ], 
      [ [ 12, 21, 28, 30 ], [ 8, 20, 14, 32 ] ], 
      [ [ 13, 21, 6, 30 ], [ 16, 20, 22, 32 ] ], 
      [ [ 13, 21, 20, 30 ], [ 10, 20, 4, 32 ] ], 
      [ [ 13, 21, 29, 30 ], [ 9, 20, 15, 32 ] ], 
      [ [ 14, 21, 7, 30 ], [ 17, 20, 23, 32 ] ], 
      [ [ 14, 21, 21, 30 ], [ 11, 20, 5, 32 ] ], 
      [ [ 15, 21, 8, 30 ], [ 18, 20, 24, 32 ] ], 
      [ [ 15, 21, 22, 30 ], [ 12, 20, 6, 32 ] ], 
      [ [ 16, 21, 9, 30 ], [ 19, 20, 25, 32 ] ], 
      [ [ 16, 21, 23, 30 ], [ 13, 20, 7, 32 ] ], 
      [ [ 17, 21, 24, 30 ], [ 14, 20, 8, 32 ] ], 
      [ [ 18, 21, 20, 30 ], [ 0, 20, 6, 32 ] ], 
      [ [ 18, 21, 25, 30 ], [ 15, 20, 9, 32 ] ], 
      [ [ 19, 21, 21, 30 ], [ 1, 20, 7, 32 ] ], 
      [ [ 19, 21, 26, 30 ], [ 16, 20, 10, 32 ] ], 
      [ [ 20, 21, 18, 30 ], [ 18, 20, 0, 32 ] ], 
      [ [ 20, 21, 22, 30 ], [ 2, 20, 8, 32 ] ], 
      [ [ 20, 21, 27, 30 ], [ 17, 20, 11, 32 ] ] ],,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,, 
  [ [ [ 0, 4, 10, 24 ], [ 1, 15, 10, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 1, 15, 22, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 4, 15, 16, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 4, 15, 28, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 7, 15, 10, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 10, 15, 4, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 10, 15, 16, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 10, 15, 28, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 13, 15, 10, 30 ] ], 
      [ [ 0, 4, 10, 24 ], [ 13, 15, 22, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 2, 15, 11, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 2, 15, 23, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 5, 15, 17, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 5, 15, 29, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 8, 15, 11, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 11, 15, 5, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 11, 15, 17, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 11, 15, 29, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 14, 15, 11, 30 ] ], 
      [ [ 1, 4, 11, 24 ], [ 14, 15, 23, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 0, 15, 6, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 0, 15, 18, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 3, 15, 0, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 3, 15, 12, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 3, 15, 24, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 6, 15, 18, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 9, 15, 0, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 9, 15, 12, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 12, 15, 6, 30 ] ], 
      [ [ 2, 4, 12, 24 ], [ 12, 15, 18, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 1, 15, 7, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 1, 15, 19, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 4, 15, 1, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 4, 15, 13, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 4, 15, 25, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 7, 15, 19, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 10, 15, 1, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 10, 15, 13, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 13, 15, 7, 30 ] ], 
      [ [ 3, 4, 13, 24 ], [ 13, 15, 19, 30 ] ] ],,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 
  [ [ [ 0, 8, 6, 20 ], [ 2, 3, 6, 30 ] ], 
      [ [ 7, 8, 13, 20 ], [ 0, 3, 23, 30 ] ], 
      [ [ 0, 5, 2, 30 ], [ 2, 12, 12, 32 ] ], 
      [ [ 0, 5, 3, 30 ], [ 9, 12, 19, 32 ] ], 
      [ [ 0, 5, 7, 30 ], [ 1, 12, 11, 32 ] ], 
      [ [ 0, 5, 8, 30 ], [ 8, 12, 18, 32 ] ], 
      [ [ 0, 5, 12, 30 ], [ 0, 12, 10, 32 ] ], 
      [ [ 0, 5, 13, 30 ], [ 7, 12, 17, 32 ] ], 
      [ [ 0, 5, 18, 30 ], [ 6, 12, 16, 32 ] ], 
      [ [ 0, 5, 23, 30 ], [ 5, 12, 15, 32 ] ], 
      [ [ 0, 5, 28, 30 ], [ 4, 12, 14, 32 ] ], 
      [ [ 0, 5, 29, 30 ], [ 11, 12, 21, 32 ] ], 
      [ [ 1, 5, 3, 30 ], [ 3, 12, 13, 32 ] ], 
      [ [ 1, 5, 4, 30 ], [ 10, 12, 20, 32 ] ], 
      [ [ 1, 5, 8, 30 ], [ 2, 12, 12, 32 ] ], 
      [ [ 1, 5, 9, 30 ], [ 9, 12, 19, 32 ] ], 
      [ [ 1, 5, 13, 30 ], [ 1, 12, 11, 32 ] ], 
      [ [ 1, 5, 14, 30 ], [ 8, 12, 18, 32 ] ], 
      [ [ 1, 5, 18, 30 ], [ 0, 12, 10, 32 ] ], 
      [ [ 1, 5, 19, 30 ], [ 7, 12, 17, 32 ] ], 
      [ [ 1, 5, 24, 30 ], [ 6, 12, 16, 32 ] ], 
      [ [ 1, 5, 29, 30 ], [ 5, 12, 15, 32 ] ], 
      [ [ 2, 5, 4, 30 ], [ 4, 12, 14, 32 ] ], 
      [ [ 2, 5, 5, 30 ], [ 11, 12, 21, 32 ] ], 
      [ [ 2, 5, 9, 30 ], [ 3, 12, 13, 32 ] ], 
      [ [ 2, 5, 10, 30 ], [ 10, 12, 20, 32 ] ], 
      [ [ 2, 5, 14, 30 ], [ 2, 12, 12, 32 ] ], 
      [ [ 2, 5, 15, 30 ], [ 9, 12, 19, 32 ] ], 
      [ [ 2, 5, 19, 30 ], [ 1, 12, 11, 32 ] ], 
      [ [ 2, 5, 20, 30 ], [ 8, 12, 18, 32 ] ], 
      [ [ 2, 5, 24, 30 ], [ 0, 12, 10, 32 ] ], 
      [ [ 2, 5, 25, 30 ], [ 7, 12, 17, 32 ] ], 
      [ [ 3, 5, 0, 30 ], [ 6, 12, 16, 32 ] ], 
      [ [ 3, 5, 5, 30 ], [ 5, 12, 15, 32 ] ], 
      [ [ 3, 5, 10, 30 ], [ 4, 12, 14, 32 ] ], 
      [ [ 3, 5, 11, 30 ], [ 11, 12, 21, 32 ] ], 
      [ [ 3, 5, 15, 30 ], [ 3, 12, 13, 32 ] ], 
      [ [ 3, 5, 16, 30 ], [ 10, 12, 20, 32 ] ], 
      [ [ 3, 5, 20, 30 ], [ 2, 12, 12, 32 ] ], 
      [ [ 3, 5, 21, 30 ], [ 9, 12, 19, 32 ] ], 
      [ [ 3, 5, 25, 30 ], [ 1, 12, 11, 32 ] ], 
      [ [ 3, 5, 26, 30 ], [ 8, 12, 18, 32 ] ], 
      [ [ 4, 5, 0, 30 ], [ 0, 12, 10, 32 ] ], 
      [ [ 4, 5, 1, 30 ], [ 7, 12, 17, 32 ] ], 
      [ [ 4, 5, 6, 30 ], [ 6, 12, 16, 32 ] ], 
      [ [ 4, 5, 11, 30 ], [ 5, 12, 15, 32 ] ], 
      [ [ 4, 5, 16, 30 ], [ 4, 12, 14, 32 ] ], 
      [ [ 4, 5, 17, 30 ], [ 11, 12, 21, 32 ] ], 
      [ [ 4, 5, 21, 30 ], [ 3, 12, 13, 32 ] ], 
      [ [ 4, 5, 22, 30 ], [ 10, 12, 20, 32 ] ], 
      [ [ 4, 5, 26, 30 ], [ 2, 12, 12, 32 ] ], 
      [ [ 4, 5, 27, 30 ], [ 9, 12, 19, 32 ] ], 
      [ [ 0, 15, 18, 30 ], [ 6, 12, 16, 32 ] ], 
      [ [ 0, 15, 21, 30 ], [ 3, 12, 13, 32 ] ], 
      [ [ 0, 15, 24, 30 ], [ 0, 12, 10, 32 ] ], 
      [ [ 1, 15, 4, 30 ], [ 10, 12, 0, 32 ] ], 
      [ [ 1, 15, 19, 30 ], [ 7, 12, 17, 32 ] ], 
      [ [ 1, 15, 22, 30 ], [ 4, 12, 14, 32 ] ], 
      [ [ 1, 15, 25, 30 ], [ 1, 12, 11, 32 ] ], 
      [ [ 2, 15, 5, 30 ], [ 11, 12, 1, 32 ] ], 
      [ [ 2, 15, 20, 30 ], [ 8, 12, 18, 32 ] ], 
      [ [ 2, 15, 23, 30 ], [ 5, 12, 15, 32 ] ], 
      [ [ 2, 15, 26, 30 ], [ 2, 12, 12, 32 ] ], 
      [ [ 3, 15, 6, 30 ], [ 0, 12, 30, 32 ] ], 
      [ [ 3, 15, 21, 30 ], [ 9, 12, 19, 32 ] ], 
      [ [ 3, 15, 24, 30 ], [ 6, 12, 16, 32 ] ], 
      [ [ 3, 15, 27, 30 ], [ 3, 12, 13, 32 ] ], 
      [ [ 4, 15, 7, 30 ], [ 1, 12, 31, 32 ] ], 
      [ [ 4, 15, 10, 30 ], [ 10, 12, 0, 32 ] ], 
      [ [ 4, 15, 22, 30 ], [ 10, 12, 20, 32 ] ], 
      [ [ 4, 15, 25, 30 ], [ 7, 12, 17, 32 ] ], 
      [ [ 4, 15, 28, 30 ], [ 4, 12, 14, 32 ] ], 
      [ [ 5, 15, 11, 30 ], [ 11, 12, 1, 32 ] ], 
      [ [ 5, 15, 23, 30 ], [ 11, 12, 21, 32 ] ], 
      [ [ 5, 15, 26, 30 ], [ 8, 12, 18, 32 ] ], 
      [ [ 5, 15, 29, 30 ], [ 5, 12, 15, 32 ] ], 
      [ [ 6, 15, 0, 30 ], [ 0, 12, 10, 32 ] ], 
      [ [ 6, 15, 12, 30 ], [ 0, 12, 30, 32 ] ], 
      [ [ 6, 15, 27, 30 ], [ 9, 12, 19, 32 ] ], 
      [ [ 7, 15, 1, 30 ], [ 1, 12, 11, 32 ] ], 
      [ [ 7, 15, 13, 30 ], [ 1, 12, 31, 32 ] ], 
      [ [ 7, 15, 16, 30 ], [ 10, 12, 0, 32 ] ], 
      [ [ 7, 15, 28, 30 ], [ 10, 12, 20, 32 ] ], 
      [ [ 8, 15, 2, 30 ], [ 2, 12, 12, 32 ] ], 
      [ [ 8, 15, 17, 30 ], [ 11, 12, 1, 32 ] ], 
      [ [ 8, 15, 29, 30 ], [ 11, 12, 21, 32 ] ], 
      [ [ 9, 15, 0, 30 ], [ 6, 12, 16, 32 ] ], 
      [ [ 9, 15, 3, 30 ], [ 3, 12, 13, 32 ] ], 
      [ [ 9, 15, 6, 30 ], [ 0, 12, 10, 32 ] ], 
      [ [ 9, 15, 18, 30 ], [ 0, 12, 30, 32 ] ], 
      [ [ 10, 15, 1, 30 ], [ 7, 12, 17, 32 ] ], 
      [ [ 10, 15, 4, 30 ], [ 4, 12, 14, 32 ] ], 
      [ [ 10, 15, 7, 30 ], [ 1, 12, 11, 32 ] ], 
      [ [ 10, 15, 19, 30 ], [ 1, 12, 31, 32 ] ], 
      [ [ 10, 15, 22, 30 ], [ 10, 12, 0, 32 ] ], 
      [ [ 11, 15, 2, 30 ], [ 8, 12, 18, 32 ] ], 
      [ [ 11, 15, 5, 30 ], [ 5, 12, 15, 32 ] ], 
      [ [ 11, 15, 8, 30 ], [ 2, 12, 12, 32 ] ], 
      [ [ 11, 15, 23, 30 ], [ 11, 12, 1, 32 ] ], 
      [ [ 12, 15, 3, 30 ], [ 9, 12, 19, 32 ] ], 
      [ [ 12, 15, 6, 30 ], [ 6, 12, 16, 32 ] ], 
      [ [ 12, 15, 9, 30 ], [ 3, 12, 13, 32 ] ], 
      [ [ 12, 15, 24, 30 ], [ 0, 12, 30, 32 ] ], 
      [ [ 13, 15, 4, 30 ], [ 10, 12, 20, 32 ] ], 
      [ [ 13, 15, 7, 30 ], [ 7, 12, 17, 32 ] ], 
      [ [ 13, 15, 10, 30 ], [ 4, 12, 14, 32 ] ], 
      [ [ 13, 15, 25, 30 ], [ 1, 12, 31, 32 ] ], 
      [ [ 14, 15, 5, 30 ], [ 11, 12, 21, 32 ] ], 
      [ [ 14, 15, 8, 30 ], [ 8, 12, 18, 32 ] ], 
      [ [ 14, 15, 11, 30 ], [ 5, 12, 15, 32 ] ], 
      [ [ 0, 25, 17, 30 ], [ 11, 12, 21, 32 ] ], 
      [ [ 0, 25, 19, 30 ], [ 1, 12, 11, 32 ] ], 
      [ [ 1, 25, 20, 30 ], [ 2, 12, 12, 32 ] ], 
      [ [ 2, 25, 21, 30 ], [ 3, 12, 13, 32 ] ], 
      [ [ 2, 25, 24, 30 ], [ 0, 12, 30, 32 ] ], 
      [ [ 3, 25, 22, 30 ], [ 4, 12, 14, 32 ] ], 
      [ [ 3, 25, 25, 30 ], [ 1, 12, 31, 32 ] ], 
      [ [ 4, 25, 23, 30 ], [ 5, 12, 15, 32 ] ], 
      [ [ 5, 25, 24, 30 ], [ 6, 12, 16, 32 ] ], 
      [ [ 6, 25, 25, 30 ], [ 7, 12, 17, 32 ] ], 
      [ [ 7, 25, 26, 30 ], [ 8, 12, 18, 32 ] ], 
      [ [ 8, 25, 27, 30 ], [ 9, 12, 19, 32 ] ], 
      [ [ 9, 25, 28, 30 ], [ 10, 12, 20, 32 ] ], 
      [ [ 10, 25, 29, 30 ], [ 11, 12, 21, 32 ] ], 
      [ [ 11, 25, 28, 30 ], [ 10, 12, 0, 32 ] ], 
      [ [ 12, 25, 0, 30 ], [ 0, 12, 30, 32 ] ], 
      [ [ 12, 25, 29, 30 ], [ 11, 12, 1, 32 ] ], 
      [ [ 13, 25, 1, 30 ], [ 1, 12, 31, 32 ] ], 
      [ [ 14, 25, 0, 30 ], [ 0, 12, 10, 32 ] ], 
      [ [ 15, 25, 1, 30 ], [ 1, 12, 11, 32 ] ], 
      [ [ 16, 25, 2, 30 ], [ 2, 12, 12, 32 ] ], 
      [ [ 17, 25, 3, 30 ], [ 3, 12, 13, 32 ] ], 
      [ [ 18, 25, 4, 30 ], [ 4, 12, 14, 32 ] ], 
      [ [ 19, 25, 5, 30 ], [ 5, 12, 15, 32 ] ], 
      [ [ 20, 25, 6, 30 ], [ 6, 12, 16, 32 ] ], 
      [ [ 21, 25, 4, 30 ], [ 10, 12, 0, 32 ] ], 
      [ [ 21, 25, 7, 30 ], [ 7, 12, 17, 32 ] ], 
      [ [ 22, 25, 5, 30 ], [ 11, 12, 1, 32 ] ], 
      [ [ 22, 25, 8, 30 ], [ 8, 12, 18, 32 ] ], 
      [ [ 23, 25, 9, 30 ], [ 9, 12, 19, 32 ] ], 
      [ [ 24, 25, 10, 30 ], [ 10, 12, 20, 32 ] ], 
      [ [ 24, 25, 12, 30 ], [ 0, 12, 10, 32 ] ], 
      [ [ 0, 3, 2, 30 ], [ 2, 20, 20, 32 ] ], 
      [ [ 0, 3, 4, 30 ], [ 4, 20, 10, 32 ] ], 
      [ [ 0, 3, 5, 30 ], [ 15, 20, 21, 32 ] ], 
      [ [ 0, 3, 7, 30 ], [ 17, 20, 11, 32 ] ], 
      [ [ 0, 3, 11, 30 ], [ 1, 20, 19, 32 ] ], 
      [ [ 0, 3, 13, 30 ], [ 3, 20, 9, 32 ] ], 
      [ [ 0, 3, 14, 30 ], [ 14, 20, 20, 32 ] ], 
      [ [ 0, 3, 16, 30 ], [ 16, 20, 10, 32 ] ], 
      [ [ 0, 3, 20, 30 ], [ 0, 20, 18, 32 ] ], 
      [ [ 0, 3, 22, 30 ], [ 2, 20, 8, 32 ] ], 
      [ [ 0, 3, 23, 30 ], [ 13, 20, 19, 32 ] ], 
      [ [ 0, 3, 25, 30 ], [ 15, 20, 9, 32 ] ], 
      [ [ 1, 3, 3, 30 ], [ 3, 20, 21, 32 ] ], 
      [ [ 1, 3, 5, 30 ], [ 5, 20, 11, 32 ] ], 
      [ [ 1, 3, 6, 30 ], [ 16, 20, 22, 32 ] ], 
      [ [ 1, 3, 8, 30 ], [ 18, 20, 12, 32 ] ], 
      [ [ 1, 3, 12, 30 ], [ 2, 20, 20, 32 ] ], 
      [ [ 1, 3, 14, 30 ], [ 4, 20, 10, 32 ] ], 
      [ [ 1, 3, 15, 30 ], [ 15, 20, 21, 32 ] ], 
      [ [ 1, 3, 17, 30 ], [ 17, 20, 11, 32 ] ], 
      [ [ 1, 3, 21, 30 ], [ 1, 20, 19, 32 ] ], 
      [ [ 1, 3, 23, 30 ], [ 3, 20, 9, 32 ] ], 
      [ [ 1, 3, 24, 30 ], [ 14, 20, 20, 32 ] ], 
      [ [ 1, 3, 26, 30 ], [ 16, 20, 10, 32 ] ], 
      [ [ 2, 3, 4, 30 ], [ 4, 20, 22, 32 ] ], 
      [ [ 2, 3, 6, 30 ], [ 6, 20, 12, 32 ] ], 
      [ [ 2, 3, 7, 30 ], [ 17, 20, 23, 32 ] ], 
      [ [ 2, 3, 9, 30 ], [ 19, 20, 13, 32 ] ], 
      [ [ 2, 3, 13, 30 ], [ 3, 20, 21, 32 ] ], 
      [ [ 2, 3, 15, 30 ], [ 5, 20, 11, 32 ] ], 
      [ [ 2, 3, 16, 30 ], [ 16, 20, 22, 32 ] ], 
      [ [ 2, 3, 18, 30 ], [ 18, 20, 12, 32 ] ], 
      [ [ 2, 3, 22, 30 ], [ 2, 20, 20, 32 ] ], 
      [ [ 2, 3, 24, 30 ], [ 4, 20, 10, 32 ] ], 
      [ [ 2, 3, 25, 30 ], [ 15, 20, 21, 32 ] ], 
      [ [ 2, 3, 27, 30 ], [ 17, 20, 11, 32 ] ], 
      [ [ 0, 9, 1, 30 ], [ 11, 20, 5, 32 ] ], 
      [ [ 0, 9, 8, 30 ], [ 8, 20, 2, 32 ] ], 
      [ [ 0, 9, 13, 30 ], [ 3, 20, 21, 32 ] ], 
      [ [ 0, 9, 20, 30 ], [ 0, 20, 18, 32 ] ], 
      [ [ 0, 9, 29, 30 ], [ 19, 20, 25, 32 ] ], 
      [ [ 1, 9, 0, 30 ], [ 10, 20, 28, 32 ] ], 
      [ [ 1, 9, 2, 30 ], [ 12, 20, 6, 32 ] ], 
      [ [ 1, 9, 9, 30 ], [ 9, 20, 3, 32 ] ], 
      [ [ 1, 9, 14, 30 ], [ 4, 20, 22, 32 ] ], 
      [ [ 1, 9, 21, 30 ], [ 1, 20, 19, 32 ] ], 
      [ [ 2, 9, 1, 30 ], [ 11, 20, 29, 32 ] ], 
      [ [ 2, 9, 3, 30 ], [ 13, 20, 7, 32 ] ], 
      [ [ 2, 9, 10, 30 ], [ 10, 20, 4, 32 ] ], 
      [ [ 2, 9, 15, 30 ], [ 5, 20, 23, 32 ] ], 
      [ [ 2, 9, 22, 30 ], [ 2, 20, 20, 32 ] ], 
      [ [ 3, 9, 2, 30 ], [ 12, 20, 30, 32 ] ], 
      [ [ 3, 9, 4, 30 ], [ 14, 20, 8, 32 ] ], 
      [ [ 3, 9, 11, 30 ], [ 11, 20, 5, 32 ] ], 
      [ [ 3, 9, 16, 30 ], [ 6, 20, 24, 32 ] ], 
      [ [ 3, 9, 23, 30 ], [ 3, 20, 21, 32 ] ], 
      [ [ 4, 9, 3, 30 ], [ 13, 20, 31, 32 ] ], 
      [ [ 4, 9, 5, 30 ], [ 15, 20, 9, 32 ] ], 
      [ [ 4, 9, 12, 30 ], [ 12, 20, 6, 32 ] ], 
      [ [ 4, 9, 17, 30 ], [ 7, 20, 25, 32 ] ], 
      [ [ 4, 9, 24, 30 ], [ 4, 20, 22, 32 ] ], 
      [ [ 4, 9, 26, 30 ], [ 6, 20, 0, 32 ] ], 
      [ [ 5, 9, 6, 30 ], [ 16, 20, 10, 32 ] ], 
      [ [ 5, 9, 13, 30 ], [ 13, 20, 7, 32 ] ], 
      [ [ 5, 9, 18, 30 ], [ 8, 20, 26, 32 ] ], 
      [ [ 5, 9, 25, 30 ], [ 5, 20, 23, 32 ] ], 
      [ [ 5, 9, 27, 30 ], [ 7, 20, 1, 32 ] ], 
      [ [ 6, 9, 7, 30 ], [ 17, 20, 11, 32 ] ], 
      [ [ 6, 9, 14, 30 ], [ 14, 20, 8, 32 ] ], 
      [ [ 6, 9, 19, 30 ], [ 9, 20, 27, 32 ] ], 
      [ [ 6, 9, 26, 30 ], [ 6, 20, 24, 32 ] ], 
      [ [ 6, 9, 28, 30 ], [ 8, 20, 2, 32 ] ], 
      [ [ 7, 9, 8, 30 ], [ 18, 20, 12, 32 ] ], 
      [ [ 7, 9, 15, 30 ], [ 15, 20, 9, 32 ] ], 
      [ [ 7, 9, 20, 30 ], [ 10, 20, 28, 32 ] ], 
      [ [ 7, 9, 27, 30 ], [ 7, 20, 25, 32 ] ], 
      [ [ 7, 9, 29, 30 ], [ 9, 20, 3, 32 ] ], 
      [ [ 8, 9, 0, 30 ], [ 0, 20, 6, 32 ] ], 
      [ [ 8, 9, 9, 30 ], [ 19, 20, 13, 32 ] ], 
      [ [ 8, 9, 16, 30 ], [ 16, 20, 10, 32 ] ], 
      [ [ 8, 9, 21, 30 ], [ 11, 20, 29, 32 ] ], 
      [ [ 8, 9, 28, 30 ], [ 8, 20, 26, 32 ] ], 
      [ [ 0, 15, 25, 30 ], [ 15, 20, 9, 32 ] ], 
      [ [ 1, 15, 26, 30 ], [ 16, 20, 10, 32 ] ], 
      [ [ 2, 15, 27, 30 ], [ 17, 20, 11, 32 ] ], 
      [ [ 3, 15, 8, 30 ], [ 18, 20, 0, 32 ] ], 
      [ [ 3, 15, 28, 30 ], [ 18, 20, 12, 32 ] ], 
      [ [ 4, 15, 9, 30 ], [ 19, 20, 1, 32 ] ], 
      [ [ 4, 15, 29, 30 ], [ 19, 20, 13, 32 ] ], 
      [ [ 5, 15, 10, 30 ], [ 0, 20, 30, 32 ] ], 
      [ [ 6, 15, 11, 30 ], [ 1, 20, 31, 32 ] ], 
      [ [ 8, 15, 18, 30 ], [ 18, 20, 0, 32 ] ], 
      [ [ 9, 15, 19, 30 ], [ 19, 20, 1, 32 ] ], 
      [ [ 10, 15, 0, 30 ], [ 0, 20, 18, 32 ] ], 
      [ [ 10, 15, 20, 30 ], [ 0, 20, 30, 32 ] ], 
      [ [ 11, 15, 1, 30 ], [ 1, 20, 19, 32 ] ], 
      [ [ 11, 15, 21, 30 ], [ 1, 20, 31, 32 ] ], 
      [ [ 12, 15, 2, 30 ], [ 2, 20, 20, 32 ] ], 
      [ [ 13, 15, 3, 30 ], [ 3, 20, 21, 32 ] ], 
      [ [ 14, 15, 4, 30 ], [ 4, 20, 22, 32 ] ], 
      [ [ 0, 21, 29, 30 ], [ 19, 20, 1, 32 ] ], 
      [ [ 20, 21, 0, 30 ], [ 0, 20, 30, 32 ] ] ],,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,, 
  [ [ [ 0, 8, 6, 20 ], [ 6, 15, 26, 30 ] ], 
      [ [ 0, 8, 6, 20 ], [ 11, 15, 16, 30 ] ], 
      [ [ 0, 8, 18, 20 ], [ 3, 15, 8, 30 ] ], 
      [ [ 0, 8, 18, 20 ], [ 3, 15, 28, 30 ] ], 
      [ [ 0, 8, 18, 20 ], [ 8, 15, 18, 30 ] ], 
      [ [ 1, 8, 7, 20 ], [ 7, 15, 27, 30 ] ], 
      [ [ 1, 8, 7, 20 ], [ 12, 15, 17, 30 ] ], 
      [ [ 1, 8, 19, 20 ], [ 4, 15, 9, 30 ] ], 
      [ [ 1, 8, 19, 20 ], [ 4, 15, 29, 30 ] ], 
      [ [ 1, 8, 19, 20 ], [ 9, 15, 19, 30 ] ], 
      [ [ 2, 8, 8, 20 ], [ 8, 15, 28, 30 ] ], 
      [ [ 2, 8, 8, 20 ], [ 13, 15, 18, 30 ] ], 
      [ [ 3, 8, 9, 20 ], [ 9, 15, 29, 30 ] ], 
      [ [ 3, 8, 9, 20 ], [ 14, 15, 19, 30 ] ], 
      [ [ 4, 8, 10, 20 ], [ 0, 15, 10, 30 ] ], 
      [ [ 4, 8, 10, 20 ], [ 5, 15, 0, 30 ] ], 
      [ [ 5, 8, 11, 20 ], [ 1, 15, 11, 30 ] ], 
      [ [ 5, 8, 11, 20 ], [ 6, 15, 1, 30 ] ], 
      [ [ 6, 8, 0, 20 ], [ 5, 15, 10, 30 ] ], 
      [ [ 6, 8, 0, 20 ], [ 10, 15, 0, 30 ] ], 
      [ [ 6, 8, 0, 20 ], [ 10, 15, 20, 30 ] ], 
      [ [ 6, 8, 12, 20 ], [ 2, 15, 12, 30 ] ], 
      [ [ 6, 8, 12, 20 ], [ 7, 15, 2, 30 ] ], 
      [ [ 7, 8, 1, 20 ], [ 6, 15, 11, 30 ] ], 
      [ [ 7, 8, 1, 20 ], [ 11, 15, 1, 30 ] ], 
      [ [ 7, 8, 1, 20 ], [ 11, 15, 21, 30 ] ], 
      [ [ 7, 8, 13, 20 ], [ 3, 15, 13, 30 ] ], 
      [ [ 7, 8, 13, 20 ], [ 8, 15, 3, 30 ] ], 
      [ [ 0, 15, 3, 30 ], [ 9, 12, 19, 32 ] ], 
      [ [ 0, 15, 6, 30 ], [ 6, 12, 16, 32 ] ], 
      [ [ 0, 15, 12, 30 ], [ 0, 12, 30, 32 ] ], 
      [ [ 1, 15, 4, 30 ], [ 10, 12, 20, 32 ] ], 
      [ [ 1, 15, 7, 30 ], [ 7, 12, 17, 32 ] ], 
      [ [ 1, 15, 13, 30 ], [ 1, 12, 31, 32 ] ], 
      [ [ 2, 15, 5, 30 ], [ 11, 12, 21, 32 ] ], 
      [ [ 2, 15, 8, 30 ], [ 8, 12, 18, 32 ] ], 
      [ [ 3, 15, 0, 30 ], [ 6, 12, 16, 32 ] ], 
      [ [ 3, 15, 9, 30 ], [ 9, 12, 19, 32 ] ], 
      [ [ 4, 15, 1, 30 ], [ 7, 12, 17, 32 ] ], 
      [ [ 4, 15, 10, 30 ], [ 10, 12, 20, 32 ] ], 
      [ [ 4, 15, 22, 30 ], [ 10, 12, 0, 32 ] ], 
      [ [ 5, 15, 2, 30 ], [ 8, 12, 18, 32 ] ], 
      [ [ 5, 15, 11, 30 ], [ 11, 12, 21, 32 ] ], 
      [ [ 5, 15, 23, 30 ], [ 11, 12, 1, 32 ] ], 
      [ [ 6, 15, 3, 30 ], [ 9, 12, 19, 32 ] ], 
      [ [ 6, 15, 24, 30 ], [ 0, 12, 10, 32 ] ], 
      [ [ 7, 15, 4, 30 ], [ 10, 12, 20, 32 ] ], 
      [ [ 7, 15, 25, 30 ], [ 1, 12, 11, 32 ] ], 
      [ [ 8, 15, 5, 30 ], [ 11, 12, 21, 32 ] ], 
      [ [ 8, 15, 26, 30 ], [ 2, 12, 12, 32 ] ], 
      [ [ 9, 15, 6, 30 ], [ 0, 12, 30, 32 ] ], 
      [ [ 9, 15, 18, 30 ], [ 0, 12, 10, 32 ] ], 
      [ [ 9, 15, 27, 30 ], [ 3, 12, 13, 32 ] ], 
      [ [ 10, 15, 7, 30 ], [ 1, 12, 31, 32 ] ], 
      [ [ 10, 15, 19, 30 ], [ 1, 12, 11, 32 ] ], 
      [ [ 10, 15, 28, 30 ], [ 4, 12, 14, 32 ] ], 
      [ [ 11, 15, 20, 30 ], [ 2, 12, 12, 32 ] ], 
      [ [ 11, 15, 29, 30 ], [ 5, 12, 15, 32 ] ], 
      [ [ 12, 15, 21, 30 ], [ 3, 12, 13, 32 ] ], 
      [ [ 12, 15, 24, 30 ], [ 0, 12, 10, 32 ] ], 
      [ [ 13, 15, 16, 30 ], [ 10, 12, 0, 32 ] ], 
      [ [ 13, 15, 22, 30 ], [ 4, 12, 14, 32 ] ], 
      [ [ 13, 15, 25, 30 ], [ 1, 12, 11, 32 ] ], 
      [ [ 14, 15, 17, 30 ], [ 11, 12, 1, 32 ] ], 
      [ [ 14, 15, 23, 30 ], [ 5, 12, 15, 32 ] ], 
      [ [ 14, 15, 26, 30 ], [ 2, 12, 12, 32 ] ], 
      [ [ 0, 15, 5, 30 ], [ 15, 20, 21, 32 ] ], 
      [ [ 0, 15, 10, 30 ], [ 10, 20, 28, 32 ] ], 
      [ [ 0, 15, 20, 30 ], [ 0, 20, 6, 32 ] ], 
      [ [ 1, 15, 6, 30 ], [ 16, 20, 22, 32 ] ], 
      [ [ 1, 15, 11, 30 ], [ 11, 20, 29, 32 ] ], 
      [ [ 1, 15, 21, 30 ], [ 1, 20, 7, 32 ] ], 
      [ [ 2, 15, 7, 30 ], [ 17, 20, 23, 32 ] ], 
      [ [ 2, 15, 12, 30 ], [ 12, 20, 30, 32 ] ], 
      [ [ 2, 15, 22, 30 ], [ 2, 20, 8, 32 ] ], 
      [ [ 3, 15, 8, 30 ], [ 18, 20, 24, 32 ] ], 
      [ [ 3, 15, 13, 30 ], [ 13, 20, 31, 32 ] ], 
      [ [ 3, 15, 23, 30 ], [ 3, 20, 9, 32 ] ], 
      [ [ 4, 15, 9, 30 ], [ 19, 20, 25, 32 ] ], 
      [ [ 4, 15, 24, 30 ], [ 4, 20, 10, 32 ] ], 
      [ [ 5, 15, 0, 30 ], [ 10, 20, 16, 32 ] ], 
      [ [ 5, 15, 25, 30 ], [ 5, 20, 11, 32 ] ], 
      [ [ 6, 15, 1, 30 ], [ 11, 20, 17, 32 ] ], 
      [ [ 6, 15, 26, 30 ], [ 6, 20, 12, 32 ] ], 
      [ [ 7, 15, 2, 30 ], [ 12, 20, 18, 32 ] ], 
      [ [ 7, 15, 27, 30 ], [ 7, 20, 13, 32 ] ], 
      [ [ 8, 15, 3, 30 ], [ 13, 20, 19, 32 ] ], 
      [ [ 8, 15, 28, 30 ], [ 8, 20, 14, 32 ] ], 
      [ [ 9, 15, 4, 30 ], [ 14, 20, 20, 32 ] ], 
      [ [ 9, 15, 29, 30 ], [ 9, 20, 15, 32 ] ], 
      [ [ 10, 15, 5, 30 ], [ 15, 20, 21, 32 ] ], 
      [ [ 10, 15, 20, 30 ], [ 0, 20, 6, 32 ] ], 
      [ [ 11, 15, 6, 30 ], [ 16, 20, 22, 32 ] ], 
      [ [ 11, 15, 16, 30 ], [ 6, 20, 0, 32 ] ], 
      [ [ 11, 15, 21, 30 ], [ 1, 20, 7, 32 ] ], 
      [ [ 12, 15, 7, 30 ], [ 17, 20, 23, 32 ] ], 
      [ [ 12, 15, 17, 30 ], [ 7, 20, 1, 32 ] ], 
      [ [ 12, 15, 22, 30 ], [ 2, 20, 8, 32 ] ], 
      [ [ 13, 15, 8, 30 ], [ 18, 20, 24, 32 ] ], 
      [ [ 13, 15, 18, 30 ], [ 8, 20, 2, 32 ] ], 
      [ [ 13, 15, 23, 30 ], [ 3, 20, 9, 32 ] ], 
      [ [ 14, 15, 9, 30 ], [ 19, 20, 25, 32 ] ], 
      [ [ 14, 15, 19, 30 ], [ 9, 20, 3, 32 ] ], 
      [ [ 14, 15, 24, 30 ], [ 4, 20, 10, 32 ] ] ] ];

#############################################################################
##
#E  ctprods32.g . . . . . . . . . . . . . . . . . . . . . . . . . . ends here