/*
 * Decompiled with CFR 0.152.
 */
package io.sf.jclf.text;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class LocalStringList {
    private List<String> lista = new LinkedList<String>();
    private LocalStringList parent = null;
    private String locale;

    private LocalStringList(String locale, BufferedReader re) throws IOException {
        String s;
        this.locale = locale;
        while ((s = re.readLine()) != null) {
            this.lista.add(s);
        }
    }

    public String getLocaleName() {
        return this.locale;
    }

    public void setParent(LocalStringList parent) {
        this.parent = parent;
    }

    public boolean isEmpty() {
        return this.lista.isEmpty();
    }

    public boolean contains(String word) {
        return this.lista.contains(word);
    }

    public Iterator<String> iterator() {
        Iterator<String> it = this.parent != null ? new Iterator<String>(){
            private Iterator<String> myIt;
            private Iterator<String> parentIt;
            private String o;
            {
                this.myIt = LocalStringList.this.lista.iterator();
                this.parentIt = LocalStringList.this.parent.iterator();
                this.o = null;
            }

            @Override
            public boolean hasNext() {
                if (this.o == null) {
                    this.next();
                }
                return this.o != null;
            }

            @Override
            public String next() {
                String ret = this.o;
                if (this.myIt != null && this.myIt.hasNext()) {
                    this.o = this.myIt.next();
                } else {
                    this.myIt = null;
                    this.o = null;
                    while (this.o == null && this.parentIt.hasNext()) {
                        this.o = this.parentIt.next();
                    }
                }
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        } : this.lista.iterator();
        return it;
    }

    public static LocalStringList getLocalList(String baseName, String ext) throws IOException {
        return LocalStringList.getLocalList(baseName, ext, Locale.getDefault());
    }

    public static LocalStringList getLocalList(String baseName, String ext, Locale locale) throws IOException {
        String localeName;
        LocalStringList rb;
        String co = locale.getCountry();
        String la = locale.getLanguage();
        String va = locale.getVariant();
        if (la != null && (rb = LocalStringList.loadList(baseName, localeName = va != null ? '_' + co + '_' + la + '_' + va : '_' + co + '_' + la, ext)) != null) {
            return rb;
        }
        localeName = '_' + co;
        rb = LocalStringList.loadList(baseName, localeName, ext);
        if (rb != null) {
            return rb;
        }
        throw new FileNotFoundException("Can't find localized file for base name " + baseName + '_' + locale.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocalStringList loadList(String baseFileName, String localeName, String ext) {
        BufferedReader re;
        String resName = localeName != null ? baseFileName + localeName + '.' + ext : baseFileName + '.' + ext;
        try {
            re = new BufferedReader(new FileReader(resName));
        }
        catch (FileNotFoundException e) {
            return null;
        }
        if (re != null) {
            try {
                LocalStringList localStringList = new LocalStringList(localeName, re);
                return localStringList;
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    re.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }
}

