/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueItem;
import io.sf.carte.doc.style.css.property.ValueList;

class TransitionShorthandSetter
extends ShorthandSetter {
    private String cssText = null;
    private String minifiedCssText = null;
    private int transitionsCount = 0;
    private final ValueList lstProperty = ValueList.createCSValueList();
    private final ValueList lstDuration = ValueList.createCSValueList();
    private final ValueList lstTiming = ValueList.createCSValueList();
    private final ValueList lstDelay = ValueList.createCSValueList();

    TransitionShorthandSetter(BaseCSSStyleDeclaration style) {
        super(style, "transition");
    }

    @Override
    public void init(LexicalUnit shorthandValue, boolean important) {
        this.currentValue = shorthandValue;
        this.setPriority(important);
        this.setCssText(shorthandValue);
        this.countTransitions(shorthandValue);
    }

    private void setCssText(LexicalUnit value) {
        StringBuilder valueBuffer = new StringBuilder(64);
        StringBuilder miniValueBuffer = new StringBuilder(64);
        block5: do {
            switch (value.getLexicalUnitType()) {
                case OPERATOR_COMMA: {
                    valueBuffer.append(',');
                    miniValueBuffer.append(',');
                    break;
                }
                case OPERATOR_SLASH: {
                    valueBuffer.append('/');
                    miniValueBuffer.append('/');
                    break;
                }
                case OPERATOR_EXP: {
                    valueBuffer.append('^');
                    miniValueBuffer.append('^');
                    break;
                }
                default: {
                    ValueItem item = this.valueFactory.createCSSValueItem(value, true);
                    StyleValue cssVal = item.getCSSValue();
                    int len = valueBuffer.length();
                    if (len != 0) {
                        char c = valueBuffer.charAt(len - 1);
                        if (c != ',') {
                            miniValueBuffer.append(' ');
                        }
                        valueBuffer.append(' ');
                    }
                    valueBuffer.append(cssVal.getCssText());
                    miniValueBuffer.append(cssVal.getMinifiedCssText(this.getShorthandName()));
                    if (cssVal.getCssValueType() == CSSValue.CssType.TYPED) {
                        value = item.getNextLexicalUnit();
                        continue block5;
                    }
                    value = value.getNextLexicalUnit();
                    continue block5;
                }
            }
            value = value.getNextLexicalUnit();
        } while (value != null);
        this.cssText = valueBuffer.toString();
        this.minifiedCssText = miniValueBuffer.toString();
    }

    @Override
    public String getCssText() {
        return this.cssText;
    }

    @Override
    public String getMinifiedCssText() {
        return this.minifiedCssText;
    }

    private void countTransitions(LexicalUnit shorthandValue) {
        this.transitionsCount = 0;
        int valueCount = 0;
        for (LexicalUnit value = shorthandValue; value != null; value = value.getNextLexicalUnit()) {
            if (value.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                if (valueCount <= 0) continue;
                ++this.transitionsCount;
                valueCount = 0;
                continue;
            }
            ++valueCount;
        }
        if (valueCount > 0) {
            ++this.transitionsCount;
        }
    }

    @Override
    public short assignSubproperties() {
        int sz;
        int i = 0;
        block0: while (i < this.transitionsCount && this.currentValue != null) {
            boolean tpropUnset = true;
            boolean tdurUnset = true;
            boolean ttfUnset = true;
            boolean tdelayUnset = true;
            while (this.currentValue != null) {
                StyleValue value;
                LexicalUnit.LexicalType lut = this.currentValue.getLexicalUnitType();
                if (lut == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    ++i;
                    this.nextCurrentValue();
                    break;
                }
                LexicalUnit.LexicalType lutype = this.currentValue.getLexicalUnitType();
                if (lutype == LexicalUnit.LexicalType.INHERIT || lutype == LexicalUnit.LexicalType.REVERT) {
                    if (!(i == 0 && tpropUnset && tdurUnset && ttfUnset && tdelayUnset && this.currentValue.getNextLexicalUnit() == null)) {
                        this.reportDeclarationError("transition", "Found 'inherit' or 'revert' mixed with other values.");
                        return 2;
                    }
                    StyleValue keyword = this.valueFactory.createCSSValueItem(this.currentValue, true).getCSSValue();
                    this.addSingleValueLayer(keyword);
                    this.appendValueItemString(keyword);
                    break block0;
                }
                if (lutype == LexicalUnit.LexicalType.INITIAL || lutype == LexicalUnit.LexicalType.UNSET) {
                    LexicalUnit nlu;
                    if (!tpropUnset || !tdurUnset || !ttfUnset || !tdelayUnset || (nlu = this.currentValue.getNextLexicalUnit()) != null && nlu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        this.reportDeclarationError("transition", "Found a keyword mixed with other values.");
                        return 2;
                    }
                    this.nextCurrentValue();
                    continue;
                }
                if ((tdurUnset || tdelayUnset) && (ValueFactory.isTimeSACUnit(this.currentValue) || this.isCurrentValueZero())) {
                    if (tdurUnset) {
                        value = this.createCSSValue("transition-duration", this.currentValue);
                        if (value != null) {
                            this.lstDuration.add(value);
                            tdurUnset = false;
                            this.nextCurrentValue();
                            continue;
                        }
                    } else {
                        value = this.createCSSValue("transition-delay", this.currentValue);
                        if (value != null) {
                            this.lstDelay.add(value);
                            tdelayUnset = false;
                            this.nextCurrentValue();
                            continue;
                        }
                    }
                }
                if (ttfUnset) {
                    if (LexicalUnit.LexicalType.IDENT == lut) {
                        if (this.testIdentifiers("transition-timing-function")) {
                            value = this.createCSSValue("transition-timing-function", this.currentValue);
                            this.lstTiming.add(value);
                            ttfUnset = false;
                            this.nextCurrentValue();
                            continue;
                        }
                    } else if (this.currentValue.shallowMatch(SyntaxParser.createSimpleSyntax("easing-function")) == CSSValueSyntax.Match.TRUE && (value = this.createCSSValue("transition-timing-function", this.currentValue)) != null) {
                        this.lstTiming.add(value);
                        ttfUnset = false;
                        this.nextCurrentValue();
                        continue;
                    }
                }
                if (tpropUnset && (lut == LexicalUnit.LexicalType.IDENT || lut == LexicalUnit.LexicalType.STRING)) {
                    value = this.createCSSValue("transition-property", this.currentValue);
                    if (!"none".equals(value.getCssText()) || this.transitionsCount == 1) {
                        this.lstProperty.add(value);
                        tpropUnset = false;
                        this.nextCurrentValue();
                        continue;
                    }
                    this.reportDeclarationError("transition", "Found 'none' in a multiple declaration.");
                    return 2;
                }
                if (lut == LexicalUnit.LexicalType.PREFIXED_FUNCTION || lut == LexicalUnit.LexicalType.IDENT && this.isPrefixedIdentValue()) {
                    this.setPrefixedValue(this.currentValue);
                    return 1;
                }
                StyleDeclarationErrorHandler errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler();
                if (errHandler != null) {
                    if (lut == LexicalUnit.LexicalType.IDENT) {
                        errHandler.unknownIdentifier("transition", this.currentValue.getStringValue());
                    } else {
                        StyleValue val = this.createCSSValue("transition", this.currentValue);
                        errHandler.unassignedShorthandValue("transition", val.getCssText());
                    }
                }
                return 2;
            }
            if (tpropUnset) {
                this.lstProperty.add(this.defaultPropertyValue("transition-property"));
            }
            if (tdurUnset) {
                this.lstDuration.add(this.defaultPropertyValue("transition-duration"));
            }
            if (ttfUnset) {
                this.lstTiming.add(this.defaultPropertyValue("transition-timing-function"));
            }
            if (!tdelayUnset) continue;
            this.lstDelay.add(this.defaultPropertyValue("transition-delay"));
        }
        if ((sz = this.lstProperty.getLength()) > 1) {
            for (i = 1; i < sz; ++i) {
                StyleValue value = this.lstProperty.item(i);
                if (!"all".equals(value.getCssText())) continue;
                for (int j = i - 1; j != -1; --j) {
                    this.lstDuration.set(j, this.lstDuration.item(i));
                    this.lstTiming.set(j, this.lstTiming.item(i));
                    this.lstDelay.set(j, this.lstDelay.item(i));
                }
            }
        }
        this.setSubpropertyValueWListCheck("transition-property", this.lstProperty);
        this.setSubpropertyValueWListCheck("transition-duration", this.lstDuration);
        this.setSubpropertyValueWListCheck("transition-timing-function", this.lstTiming);
        this.setSubpropertyValueWListCheck("transition-delay", this.lstDelay);
        this.flush();
        return 0;
    }

    private void addSingleValueLayer(StyleValue keyword) {
        this.lstProperty.add(keyword);
        this.lstDuration.add(keyword);
        this.lstTiming.add(keyword);
        this.lstDelay.add(keyword);
    }

    @Override
    void reportDeclarationError(String propertyName, String message) {
        this.lstProperty.clear();
        this.lstDuration.clear();
        this.lstTiming.clear();
        this.lstDelay.clear();
        this.cssText = "";
        super.reportDeclarationError(propertyName, message);
    }
}

