// Populate the sidebar
//
// This is a script, and not included directly in the page, to control the total size of the book.
// The TOC contains an entry for each page, so if each page includes a copy of the TOC,
// the total size of the page becomes O(n**2).
class MDBookSidebarScrollbox extends HTMLElement {
    constructor() {
        super();
    }
    connectedCallback() {
        this.innerHTML = '<ol class="chapter"><li class="chapter-item expanded "><a href="introduction.html"><strong aria-hidden="true">1.</strong> Introduction</a></li><li class="chapter-item expanded "><a href="get-started.html"><strong aria-hidden="true">2.</strong> Get started</a></li><li class="chapter-item expanded "><a href="features.html"><strong aria-hidden="true">3.</strong> Features</a></li><li class="chapter-item expanded "><a href="installation.html"><strong aria-hidden="true">4.</strong> Installation</a></li><li class="chapter-item expanded "><a href="configuration.html"><strong aria-hidden="true">5.</strong> Configuration</a></li><li class="chapter-item expanded "><a href="environment-variables.html"><strong aria-hidden="true">6.</strong> Environment variables</a></li><li class="chapter-item expanded "><a href="how-delta-works.html"><strong aria-hidden="true">7.</strong> How delta works</a></li><li class="chapter-item expanded "><a href="usage.html"><strong aria-hidden="true">8.</strong> Usage</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="choosing-colors-styles.html"><strong aria-hidden="true">8.1.</strong> Choosing colors (styles)</a></li><li class="chapter-item expanded "><a href="line-numbers.html"><strong aria-hidden="true">8.2.</strong> Line numbers</a></li><li class="chapter-item expanded "><a href="hyperlinks.html"><strong aria-hidden="true">8.3.</strong> Hyperlinks</a></li><li class="chapter-item expanded "><a href="side-by-side-view.html"><strong aria-hidden="true">8.4.</strong> Side-by-side view</a></li><li class="chapter-item expanded "><a href="grep.html"><strong aria-hidden="true">8.5.</strong> Grep</a></li><li class="chapter-item expanded "><a href="features-named-groups-of-settings.html"><strong aria-hidden="true">8.6.</strong> &quot;Features&quot;: named groups of settings</a></li><li class="chapter-item expanded "><a href="custom-themes.html"><strong aria-hidden="true">8.7.</strong> Custom themes</a></li><li class="chapter-item expanded "><a href="diff-highlight-and-diff-so-fancy-emulation.html"><strong aria-hidden="true">8.8.</strong> diff-highlight and diff-so-fancy emulation</a></li><li class="chapter-item expanded "><a href="color-moved-support.html"><strong aria-hidden="true">8.9.</strong> --color-moved support</a></li><li class="chapter-item expanded "><a href="navigation-keybindings-for-large-diffs.html"><strong aria-hidden="true">8.10.</strong> Navigation keybindings for large diffs</a></li><li class="chapter-item expanded "><a href="merge-conflicts.html"><strong aria-hidden="true">8.11.</strong> Merge conflicts</a></li><li class="chapter-item expanded "><a href="git-blame.html"><strong aria-hidden="true">8.12.</strong> Git blame</a></li><li class="chapter-item expanded "><a href="supported-languages-and-themes.html"><strong aria-hidden="true">8.13.</strong> Supported languages and themes</a></li></ol></li><li class="chapter-item expanded "><a href="tips-and-tricks.html"><strong aria-hidden="true">9.</strong> Tips &amp; tricks</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="tips-and-tricks/toggling-delta-features.html"><strong aria-hidden="true">9.1.</strong> Toggling side-by-side and other delta features</a></li><li class="chapter-item expanded "><a href="tips-and-tricks/24-bit-color-truecolor.html"><strong aria-hidden="true">9.2.</strong> 24 bit color (truecolor)</a></li><li class="chapter-item expanded "><a href="tips-and-tricks/mouse-scrolling.html"><strong aria-hidden="true">9.3.</strong> Mouse scrolling</a></li><li class="chapter-item expanded "><a href="tips-and-tricks/export-to-html.html"><strong aria-hidden="true">9.4.</strong> Save output with colors to HTML/PDF etc</a></li><li class="chapter-item expanded "><a href="tips-and-tricks/using-delta-on-windows.html"><strong aria-hidden="true">9.5.</strong> Using Delta on Windows</a></li><li class="chapter-item expanded "><a href="tips-and-tricks/using-delta-with-gnu-screen.html"><strong aria-hidden="true">9.6.</strong> Using Delta with GNU Screen</a></li><li class="chapter-item expanded "><a href="tips-and-tricks/using-delta-with-magit.html"><strong aria-hidden="true">9.7.</strong> Using Delta with Magit</a></li><li class="chapter-item expanded "><a href="tips-and-tricks/using-delta-with-tmux.html"><strong aria-hidden="true">9.8.</strong> Using Delta with tmux</a></li><li class="chapter-item expanded "><a href="tips-and-tricks/using-delta-with-vscode.html"><strong aria-hidden="true">9.9.</strong> Using Delta with VSCode</a></li><li class="chapter-item expanded "><a href="tips-and-tricks/shell-completion.html"><strong aria-hidden="true">9.10.</strong> Generating shell completion files</a></li></ol></li><li class="chapter-item expanded "><a href="comparisons-with-other-tools.html"><strong aria-hidden="true">10.</strong> Comparisons with other tools</a></li><li class="chapter-item expanded "><a href="build-delta-from-source.html"><strong aria-hidden="true">11.</strong> Build delta from source</a></li><li class="chapter-item expanded "><a href="related-projects.html"><strong aria-hidden="true">12.</strong> Related projects</a></li><li class="chapter-item expanded "><a href="full---help-output.html"><strong aria-hidden="true">13.</strong> Full --help output</a></li><li class="chapter-item expanded "><a href="delta-configs-used-in-screenshots.html"><strong aria-hidden="true">14.</strong> Delta configs used in screenshots</a></li></ol>';
        // Set the current, active page, and reveal it if it's hidden
        let current_page = document.location.href.toString().split("#")[0].split("?")[0];
        if (current_page.endsWith("/")) {
            current_page += "index.html";
        }
        var links = Array.prototype.slice.call(this.querySelectorAll("a"));
        var l = links.length;
        for (var i = 0; i < l; ++i) {
            var link = links[i];
            var href = link.getAttribute("href");
            if (href && !href.startsWith("#") && !/^(?:[a-z+]+:)?\/\//.test(href)) {
                link.href = path_to_root + href;
            }
            // The "index" page is supposed to alias the first chapter in the book.
            if (link.href === current_page || (i === 0 && path_to_root === "" && current_page.endsWith("/index.html"))) {
                link.classList.add("active");
                var parent = link.parentElement;
                if (parent && parent.classList.contains("chapter-item")) {
                    parent.classList.add("expanded");
                }
                while (parent) {
                    if (parent.tagName === "LI" && parent.previousElementSibling) {
                        if (parent.previousElementSibling.classList.contains("chapter-item")) {
                            parent.previousElementSibling.classList.add("expanded");
                        }
                    }
                    parent = parent.parentElement;
                }
            }
        }
        // Track and set sidebar scroll position
        this.addEventListener('click', function(e) {
            if (e.target.tagName === 'A') {
                sessionStorage.setItem('sidebar-scroll', this.scrollTop);
            }
        }, { passive: true });
        var sidebarScrollTop = sessionStorage.getItem('sidebar-scroll');
        sessionStorage.removeItem('sidebar-scroll');
        if (sidebarScrollTop) {
            // preserve sidebar scroll position when navigating via links within sidebar
            this.scrollTop = sidebarScrollTop;
        } else {
            // scroll sidebar to current active section when navigating via "next/previous chapter" buttons
            var activeSection = document.querySelector('#sidebar .active');
            if (activeSection) {
                activeSection.scrollIntoView({ block: 'center' });
            }
        }
        // Toggle buttons
        var sidebarAnchorToggles = document.querySelectorAll('#sidebar a.toggle');
        function toggleSection(ev) {
            ev.currentTarget.parentElement.classList.toggle('expanded');
        }
        Array.from(sidebarAnchorToggles).forEach(function (el) {
            el.addEventListener('click', toggleSection);
        });
    }
}
window.customElements.define("mdbook-sidebar-scrollbox", MDBookSidebarScrollbox);
