---
stage: Runtime
group: Organizations
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: プロジェクトとグループを共有する
description: 招待、グループの継承、プロジェクトの表示レベル。
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 16.10で、`webui_members_inherited_users`[フラグ](../../../administration/feature_flags/_index.md)とともに、招待されたグループメンバーをメンバーページのメンバータブに表示するように[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/219230)されました。デフォルトでは無効になっています。
- GitLab 17.0の[GitLab.comとGitLab Self-Managed](https://gitlab.com/gitlab-org/gitlab/-/issues/219230)で`webui_members_inherited_users`機能フラグが有効になりました。
- 機能フラグ`webui_members_inherited_users`は、GitLab 17.4で[削除](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163627)されました。招待グループのメンバーは、デフォルトで表示されます。
- GitLab 18.0では、グループの招待はオーナーに制限されています。

{{< /history >}}

招待によって次を共有できます:

- グループとのプロジェクト。
- 別のグループとのグループ。

## プロジェクトを共有する {#sharing-projects}

グループにプロジェクトへのアクセスを許可する場合は、[グループ](../../group/_index.md)をプロジェクトに招待できます。グループの直接メンバーと継承されたメンバーはプロジェクトへのアクセス権を取得し、プロジェクトは**shared project**（共有プロジェクト）になります。

この場合、継承されたメンバーとは、親グループから招待されたグループに継承されたメンバーのことです。共有プロジェクトへのアクセス権を取得できるのは、招待されたグループのメンバーのみです。招待するグループのサブグループのメンバーにプロジェクトへのアクセス権を付与する場合は、サブグループを招待する必要があります。

次のテーブルに、共有プロジェクトへのアクセス権を取得するグループメンバーの概要を示します。

| グループメンバーのソース                                                 | 共有プロジェクトへのアクセス |
|---------------------------------------------------------------------|--------------------------|
| 招待されたグループの直接メンバー                           | {{< icon name="check-circle" >}}はい   |
| 招待されたグループの継承されたメンバー                        | {{< icon name="check-circle" >}}はい   |
| 招待されたグループの共有メンバー<sup>1</sup>              | {{< icon name="dotted-circle" >}}はい  |
| サブグループの直接メンバー。ただし、招待されたグループのメンバーではない    | {{< icon name="dotted-circle" >}}いいえ   |
| サブグループの継承されたメンバー。ただし、招待されたグループのメンバーではない | {{< icon name="dotted-circle" >}}いいえ   |

**Footnotes**（補足説明）:

1. GitLabは共有グループのメンバーへのプロジェクトアクセス権の拡張をサポートしていますが、この方法は推奨されていません。[エピック122](https://gitlab.com/groups/gitlab-org/-/epics/122)では、この動作の変更と、チームモデルに移行してグループを共有することが提案されています。

招待するグループの[表示レベル](../../public_access.md)を、プロジェクトよりも制限的にすることはできません。たとえば、次のように招待できます:

- **非公開**グループを**非公開**プロジェクトに招待する。
- **非公開**グループを**internal**（内部）プロジェクトに招待する。
- **非公開**グループを**public**（パブリック）プロジェクトに招待する。
- **internal**（内部）グループを**internal**（内部）プロジェクトに招待する。
- **internal**（内部）グループを**public**（パブリック）プロジェクトに招待する。
- **public**（パブリック）グループを**public**（パブリック）プロジェクトに招待する。

プロジェクトのトップレベルグループが、階層外でプロジェクトを共有することを許可していない場合、招待されたグループまたはサブグループは、プロジェクトの[ネームスペース](../../namespace/_index.md)に存在している必要があります。

### メンバーのアクセスとロール {#member-access-and-roles}

グループをプロジェクトに招待すると、次のメンバーがプロジェクトへのアクセス権を取得します:

- 直接グループメンバー。
- 継承されたグループメンバー。
- 招待されたグループと[共有されている他のグループのメンバー](sharing_projects_groups.md#invite-a-group-to-a-group)。

各メンバーのアクセス権は以下に依存します:

- グループでのロール。
- グループを招待するときに選択する最大のロール。

招待されたメンバーは、これら2つのロールのうち低い方を保持します。たとえば、メンバーがグループ内でゲストロールを持っていて、そのグループをメンテナーの最大ロールがあるプロジェクトに追加した場合、メンバーは、プロジェクト内でゲストロールを保持します。

さらに、次のようになります:

- グループのページでは、プロジェクトは**共有プロジェクト**タブにリストされています。
- プロジェクトの**メンバー**ページでは、グループは**グループ**タブにリストされています。このリストには、パブリックグループとプライベートグループの両方が含まれています。
- プロジェクトの**メンバー**ページでは、招待されたグループのメンバーは**メンバー**タブにリストされています。
- 使用量クォータページでは、プロファイルの横に**Project Invite**（プロジェクト招待）バッジが付いているメンバーは、共有プロジェクトのトップレベルグループの請求対象メンバーとしてカウントされます。

[GitLab 16.11以降](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144638)では、招待されたグループの名前とメンバーシップソースは、**メンバー**タブと**グループ**タブでマスクされます。ただし、次のいずれかに該当する場合を除きます:

- 招待グループが公開されている。
- 現在のユーザーが、招待されたグループのメンバーである。
- 現在のユーザーは、プロジェクトのオーナーです。

{{< alert type="note" >}}

招待されたグループの名前とメンバーシップソースは、招待されたグループへのアクセス権を持たないメンバーからはマスクされます。プロジェクトオーナーは、招待されたグループのメンバーシップの詳細を確認して、プロジェクトへのアクセスを管理できます。

{{< /alert >}}

### 例 {#examples}

ネームスペース`group/subgroup01/project`のプロジェクトの場合:

- `group/subgroup02`または`group/subgroup01/subgroup03`と共有できます。
- プロジェクトのトップレベルグループが階層外でプロジェクトを共有することを許可していない場合を除き、`group_abc`と共有できます。

`Group 1`によって作成されたプロジェクトの場合:

- `Group 1`のメンバーは、プロジェクトへのアクセス権を持っています。
- `Group 1`のオーナーは、`Group 2`をプロジェクトに招待できます。これにより、`Group 1`と`Group 2`の両方のメンバーが、共有プロジェクトへのアクセス権を持つようになります。

### プロジェクトへグループを招待する {#invite-a-group-to-a-project}

{{< history >}}

- GitLab 16.10で、`webui_members_inherited_users`[フラグ](../../../administration/feature_flags/_index.md)とともに、招待されたグループメンバーをメンバーページのメンバータブに表示するように[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/219230)されました。デフォルトでは無効になっています。
- 機能フラグ`webui_members_inherited_users`は、GitLab 17.0の[GitLab.comおよびGitLab Self-Managedで有効](https://gitlab.com/gitlab-org/gitlab/-/issues/219230)になりました。
- GitLab 17.4で、サブグループとプロジェクトの直接メンバーのアクセス有効期限が[削除](https://gitlab.com/gitlab-org/gitlab/-/issues/471051)され、`webui_members_inherited_users`機能フラグが[削除](https://gitlab.com/gitlab-org/gitlab/-/issues/364078)されました。

{{< /history >}}

前提要件:

- プロジェクトのオーナーロールが必要です。
- 他のグループとのプロジェクトの共有が禁止されていない状態である必要があります。
- 招待されたグループまたはサブグループのメンバーである必要があります。

グループをプロジェクトに招待するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **管理** > **メンバー**を選択します。
1. **グループを招待**を選択します。
1. **招待するグループを選択**リストで、招待するグループを選択します。
1. **最大のロールを選択**リストから、招待されたグループのメンバーがプロジェクト内で持つことができる[ロール](../../permissions.md)を選択します。招待されたメンバーは、以下のうち低い方のロールを受け取ります:
   - 選択した最大ロール
   - グループでの既存のロール

   招待されたグループのメンバーは、グループ内で持っているロールよりも高いロールをプロジェクト内で持つことはできません。詳細については、[メンバーのアクセスとロール](#member-access-and-roles)を参照してください。
1. オプション。**アクセス有効期限**を選択します。その日以降、招待されたグループはプロジェクトにアクセスできなくなります。
1. **招待**を選択します。

招待されたグループが**グループ**タブに表示されます。REST APIを使用して[プロジェクトの招待グループを一覧表示](../../../api/projects.md#list-a-projects-invited-groups)することもできます。

プライベートグループは次のとおりです:

- 承認されていないユーザーからマスクされます。
- 保護ブランチ、保護タグ、保護環境のプロジェクト設定に表示されます。

**メンバー**タブには、次が表示されます:

- プロジェクトに直接追加されたメンバー。
- プロジェクトが追加されたグループ[ネームスペース](../../namespace/_index.md)の継承されたメンバー。

招待されたグループのメンバーは、`webui_members_inherited_users`機能フラグが有効になっていない限り、**メンバー**タブには表示されません。

#### 例 {#examples-1}

名前が`project-01`のプロジェクトには、次の直接メンバーがいます:

- ユーザーA、オーナー
- ユーザーB、メンテナー

名前が`group-01`のグループには、次の直接メンバーがいます:

- ユーザーC、オーナー
- ユーザーD、メンテナー
- ユーザーE、レポーター

`group-01`が`project-01`に`Developer`権限で招待されると、ユーザーは次のロールを持ちます:

- ユーザーA、オーナー
- ユーザーB、メンテナー
- ユーザーC、デベロッパー
- ユーザーD、デベロッパー
- ユーザーE、レポーター

`group-01`が`project-01`に`Owner`権限で招待されると、ユーザーは次のロールを持ちます:

- ユーザーA、オーナー
- ユーザーB、メンテナー
- ユーザーC、オーナー
- ユーザーD、メンテナー
- ユーザーE、レポーター

### 共有プロジェクトを表示する {#view-shared-projects}

共有プロジェクトとは、[**グループを招待**](#invite-a-group-to-a-project)アクションを通じてグループメンバーにリソースへのアクセスを招待したプロジェクトのことです。

グループとアクセス権を共有しているプロジェクトを表示するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. グループページで、**共有プロジェクト**タブを選択します。

共有プロジェクトのリストが表示されます。REST APIを使用して、[グループの共有プロジェクトをリスト表示](../../../api/groups.md#list-shared-projects)することもできます。

### プロジェクトがグループと共有されないようにする {#prevent-a-project-from-being-shared-with-groups}

別のグループとプロジェクトを共有すると、プロジェクトにさらに多くのメンバーを招待できるユーザーの数が増えます。各（サブ）グループは、アクセス権限の追加ソースになる可能性があります。したがって、混乱しやすく、制御が難しくなる場合があります。

プロジェクトが他のグループと共有されないようにするには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. **設定** > **一般**を選択します。
1. **権限とグループ機能**セクションを展開します。
1. **Projects in `<group_name>` cannot be shared with other groups**（のプロジェクトを他のグループと共有できません）を選択します。
1. **変更を保存**を選択します。

この設定を有効にすると、次のようになります:

- グループオーナーによってオーバーライドされない限り、すべてのサブグループに適用されます。
- プロジェクトに既に追加されているグループは、プロジェクトへのアクセス権を失います。

この設定を無効にした場合:

- この設定は、このグループのみに適用され、そのサブグループには適用されません。
- この設定をすべてのサブグループに対して無効にするには、各サブグループを個別に更新する必要があります。

{{< alert type="note" >}}

[グループのユーザー上限を指定](../../group/manage.md#specify-a-user-cap-for-a-group)するか、[制限付きアクセスをオン](../../group/manage.md#turn-on-restricted-access)にした場合、この設定を無効にすることはできません。

{{< /alert >}}

## グループを共有する {#sharing-groups}

別のグループのメンバーに自分のグループへのアクセスを許可する場合は、[グループ](../../group/_index.md)を自分のグループに招待できます。グループの直接メンバーはグループへのアクセス権を取得し、グループは**shared group**（共有グループ）になります。

招待されたグループの直接メンバーのみが、共有グループへのアクセス権を取得できます。継承されたメンバー、共有メンバー、またはサブグループメンバーはアクセスできません。サブグループメンバーにアクセスを許可するには、サブグループを直接招待します。

次のテーブルに、共有グループへのアクセス権を取得するグループメンバーの概要を示します:

| グループメンバーのソース                                          | 共有グループへのアクセス |
|--------------------------------------------------------------|------------------------|
| 招待されたグループの直接メンバー                   | {{< icon name="check-circle" >}}はい    |
| 招待されたグループの継承されたメンバー                | {{< icon name="dotted-circle" >}}いいえ    |
| 招待されたグループの共有メンバー                   | {{< icon name="dotted-circle" >}}いいえ    |
| サブグループのメンバー。ただし、招待されたグループのメンバーではない   | {{< icon name="dotted-circle" >}}いいえ    |

### メンバーのアクセスとロール {#member-access-and-roles-1}

各メンバーのアクセス権は以下に依存します:

- 招待されたグループでのロール。
- グループを招待するときに選択する最大のロール。

招待されたメンバーは、これら2つのロールのうち低い方を保持します。たとえば、メンバーがグループ内でゲストロールを持っていて、そのグループをメンテナーの最大ロールがある別のグループに招待した場合、メンバーは、新しいグループ内でゲストロールを保持します。

グループをグループに招待した後は、次のようになります:

- グループの概要ページで、このグループと共有されているグループは**共有グループ**タブにリストされています。
- グループの**メンバー**ページでは、招待されたグループが**グループ**タブにリストされます。このリストには、パブリックグループとプライベートグループの両方が含まれています。
- グループの**メンバー**ページでは、招待されたグループのメンバーが**メンバー**タブにリストされます。
- グループの使用量クォータページでは、プロファイルの横に**Group Invite**（グループ招待）バッジが付いている招待されたグループの直接メンバーは、招待グループの請求対象メンバーとしてカウントされます。

[GitLab 16.11以降](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144638)では、招待されたグループの名前とメンバーシップソースは、**メンバー**タブと**グループ**タブでマスクされます。ただし、次のいずれかに該当する場合を除きます:

- 招待グループが公開されている。
- 現在のユーザーが、招待されたグループのメンバーである。
- 現在のユーザーは、プロジェクトのオーナーです。

{{< alert type="note" >}}

招待されたグループの名前とメンバーシップソースは、招待されたグループへのアクセス権を持たないメンバーからはマスクされます。ただし、グループオーナーがプライベート招待グループにアクセスできない場合でも、プライベート招待グループメンバーのソースを確認できます。この動作は、グループオーナーが所有するグループのメンバーシップをより適切に管理できるようにすることを目的としています。

{{< /alert >}}

### 例 {#examples-2}

`User A`は`Group 1`の直接メンバーであり、グループのメンテナーロールを持っています。`Group 2`は、デベロッパーロールで`Group 1`を招待します。`User A`は`Group 2`でデベロッパーロールを持っています。

`User B`は、`Group 1`の継承されたメンバーです。`Group 1`が招待されても、このユーザーは`Group 2`へのアクセス権を取得できません。

### グループにグループを招待する {#invite-a-group-to-a-group}

{{< history >}}

- GitLab 17.4で、サブグループおよびプロジェクトの直接メンバーのアクセス有効期限が[削除](https://gitlab.com/gitlab-org/gitlab/-/issues/471051)されました。

{{< /history >}}

グループをプロジェクトに招待する方法と同様に、グループを別のグループに招待できます。

前提要件: 

- 他のユーザーを招待するには、招待するグループのオーナーロールが必要です。
- 招待するグループにアクセスできる必要があります。

グループを自分のグループに招待するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. **管理** > **メンバー**を選択します。
1. **グループを招待**を選択します。
1. **招待するグループを選択**リストで、招待するグループを選択します。
1. **最大のロールを選択**リストから、招待されたグループのメンバーがグループ内で持つことができる[ロール](../../permissions.md)を選択します。招待されたメンバーは、以下のうち低い方のロールを受け取ります:
   - 選択した最大ロール
   - 招待されたグループでの既存のロール

   招待されたメンバーは、招待されたグループ内で持っているロールよりも高いロールを持つことはできません。詳細については、[メンバーのアクセスとロール](#member-access-and-roles-1)を参照してください。
1. グループのユーザーに最適な[ロール](../../permissions.md)または[カスタムロール](../../custom_roles/_index.md#assign-a-custom-role-to-an-invited-group)を選択します。
1. オプション。**アクセス有効期限**を選択します。その日以降、招待されたグループはグループにアクセスできなくなります。
1. **招待**を選択します。

### 招待されたグループを削除する {#remove-an-invited-group}

招待されたグループを削除するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. **管理** > **メンバー**を選択します。
1. **グループ**タブを選択します。
1. 削除するグループの右側にある**グループを削除する**（{{< icon name="remove" >}}）を選択します。

招待されたグループを自分のグループから削除すると、次のようになります:

- 招待されたグループのすべての直接メンバーは、自分のグループへのアクセス権を持たなくなります。
- 招待されたグループのメンバーは、グループの請求可能メンバーとしてカウントされなくなります。

### 共有グループを表示する {#view-shared-groups}

共有グループとは、[**グループを招待**](#invite-a-group-to-a-group)アクションを通じてグループメンバーにリソースへのアクセスを招待したグループのことです。

グループとアクセス権を共有しているグループを表示するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. グループページで、**共有グループ**タブを選択します。

共有グループのリストが表示されます。REST APIを使用して[グループの共有グループをリスト表示](../../../api/groups.md#list-shared-groups)することもできます。

### グループ階層外へのグループの招待を禁止する {#prevent-inviting-groups-outside-the-group-hierarchy}

トップレベルグループのサブグループとプロジェクトが、トップレベルグループの階層外の他のグループを招待できないように、トップレベルグループを設定できます。このオプションは、トップレベルグループでのみ利用できます。

たとえば、次のようなグループとプロジェクトの階層があるとします:

- **Animals**（動物） > **Dogs**（犬） > **Dog Project**（犬プロジェクト）
- **Animals**（動物） > **Cats**（猫）
- **Plants**（植物） > **Trees**（木）

この際、**Animals**（動物）グループの階層外へのグループの招待を禁止した場合、次のようになります:

- **Dogs**（犬）は**Cats**（猫）グループを招待できます。
- **Dogs**（犬）は**Trees**（木）グループを招待できません。
- **Dog Project**（犬プロジェクト）は**Cats**（猫）グループを招待できます。
- **Dog Project**（犬プロジェクト）は**Trees**（木）グループを招待できません。

グループの階層外へのグループの招待を禁止するには、次の手順を実行します:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. **設定** > **一般**を選択します。
1. **権限とグループ機能**を展開します。
1. **Members cannot invite groups outside of `<group_name>` and its subgroups**（メンバーは、とそのサブグループ以外のグループを招待できません）を選択します。
1. **変更を保存**を選択します。

## コラボレーションのためにグループを設定する {#setting-up-a-group-for-collaboration}

グループ内のプロジェクトで外部ユーザーとコラボレーションする場合は、次のベストプラクティスを検討してください:

- 組織のニーズに基づいて、グループとサブグループを論理的に構成します。不要なグループの作成は避けてください。
- 管理するユーザーが多い場合は、プロジェクトを編成するグループとは別に、ユーザーをグループに編成することを検討してください。これらのユーザーグループを、アクセスする必要があるグループとプロジェクトに共有します。
- プロジェクトに招待するグループを慎重に検討してください。共有の過剰を防ぎ、セキュリティを維持するために、アクセスする必要のあるグループのみを招待してください。
- グループを招待する場合は、次を行ってください:
  - 最大のロールを適切に設定します。最高のロールをデフォルトにするのではなく、必要な最小限の権限を割り当てることをお勧めします。
  - 招待されたグループのサブグループのメンバーに、プロジェクトへのアクセス権を付与しないようにします。代わりに、サブグループを個別に招待することをお勧めします。
- プロジェクトへのアクセス権限を持つ複数のグループに所属するユーザーの最大ロールを確認してください。意図しない高い権限を防ぐために、ユーザーのロールを変更することをお勧めします。
- 共有プロジェクトへのグループアクセスを定期的に確認し、必要に応じて更新してください。グループがプロジェクトへのアクセスを必要としなくなった場合は、削除します。
