// Code generated by Fiat Cryptography. DO NOT EDIT.
//
// Autogenerated: word_by_word_montgomery --lang Go --no-wide-int --cmovznz-by-mul --relax-primitive-carry-to-bitwidth 32,64 --internal-static --public-function-case camelCase --public-type-case camelCase --private-function-case camelCase --private-type-case camelCase --doc-text-before-function-name '' --doc-newline-before-package-declaration --doc-prepend-header 'Code generated by Fiat Cryptography. DO NOT EDIT.' --package-name fiat --no-prefix-fiat p224 64 '2^224 - 2^96 + 1' mul square add sub one from_montgomery to_montgomery selectznz to_bytes from_bytes
//
// curve description: p224
//
// machine_wordsize = 64 (from "64")
//
// requested operations: mul, square, add, sub, one, from_montgomery, to_montgomery, selectznz, to_bytes, from_bytes
//
// m = 0xffffffffffffffffffffffffffffffff000000000000000000000001 (from "2^224 - 2^96 + 1")
//
//
//
// NOTE: In addition to the bounds specified above each function, all
//
//   functions synthesized for this Montgomery arithmetic require the
//
//   input to be strictly less than the prime modulus (m), and also
//
//   require the input to be in the unique saturated representation.
//
//   All functions also ensure that these two properties are true of
//
//   return values.
//
//
//
// Computed values:
//
//   eval z = z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192)
//
//   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216)
//
//   twos_complement_eval z = let x1 := z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) in
//
//                            if x1 & (2^256-1) < 2^255 then x1 & (2^256-1) else (x1 & (2^256-1)) - 2^256

package fiat

import "math/bits"

type p224Uint1 uint64 // We use uint64 instead of a more narrow type for performance reasons; see https://github.com/mit-plv/fiat-crypto/pull/1006#issuecomment-892625927
type p224Int1 int64   // We use uint64 instead of a more narrow type for performance reasons; see https://github.com/mit-plv/fiat-crypto/pull/1006#issuecomment-892625927

// The type p224MontgomeryDomainFieldElement is a field element in the Montgomery domain.
//
// Bounds: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
type p224MontgomeryDomainFieldElement [4]uint64

// The type p224NonMontgomeryDomainFieldElement is a field element NOT in the Montgomery domain.
//
// Bounds: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
type p224NonMontgomeryDomainFieldElement [4]uint64

// p224CmovznzU64 is a single-word conditional move.
//
// Postconditions:
//
//	out1 = (if arg1 = 0 then arg2 else arg3)
//
// Input Bounds:
//
//	arg1: [0x0 ~> 0x1]
//	arg2: [0x0 ~> 0xffffffffffffffff]
//	arg3: [0x0 ~> 0xffffffffffffffff]
//
// Output Bounds:
//
//	out1: [0x0 ~> 0xffffffffffffffff]
func p224CmovznzU64(out1 *uint64, arg1 p224Uint1, arg2 uint64, arg3 uint64) {
	x1 := (uint64(arg1) * 0xffffffffffffffff)
	x2 := ((x1 & arg3) | ((^x1) & arg2))
	*out1 = x2
}

// p224Mul multiplies two field elements in the Montgomery domain.
//
// Preconditions:
//
//	0 ≤ eval arg1 < m
//	0 ≤ eval arg2 < m
//
// Postconditions:
//
//	eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
//	0 ≤ eval out1 < m
func p224Mul(out1 *p224MontgomeryDomainFieldElement, arg1 *p224MontgomeryDomainFieldElement, arg2 *p224MontgomeryDomainFieldElement) {
	x1 := arg1[1]
	x2 := arg1[2]
	x3 := arg1[3]
	x4 := arg1[0]
	var x5 uint64
	var x6 uint64
	x6, x5 = bits.Mul64(x4, arg2[3])
	var x7 uint64
	var x8 uint64
	x8, x7 = bits.Mul64(x4, arg2[2])
	var x9 uint64
	var x10 uint64
	x10, x9 = bits.Mul64(x4, arg2[1])
	var x11 uint64
	var x12 uint64
	x12, x11 = bits.Mul64(x4, arg2[0])
	var x13 uint64
	var x14 uint64
	x13, x14 = bits.Add64(x12, x9, uint64(0x0))
	var x15 uint64
	var x16 uint64
	x15, x16 = bits.Add64(x10, x7, uint64(p224Uint1(x14)))
	var x17 uint64
	var x18 uint64
	x17, x18 = bits.Add64(x8, x5, uint64(p224Uint1(x16)))
	x19 := (uint64(p224Uint1(x18)) + x6)
	var x20 uint64
	_, x20 = bits.Mul64(x11, 0xffffffffffffffff)
	var x22 uint64
	var x23 uint64
	x23, x22 = bits.Mul64(x20, 0xffffffff)
	var x24 uint64
	var x25 uint64
	x25, x24 = bits.Mul64(x20, 0xffffffffffffffff)
	var x26 uint64
	var x27 uint64
	x27, x26 = bits.Mul64(x20, 0xffffffff00000000)
	var x28 uint64
	var x29 uint64
	x28, x29 = bits.Add64(x27, x24, uint64(0x0))
	var x30 uint64
	var x31 uint64
	x30, x31 = bits.Add64(x25, x22, uint64(p224Uint1(x29)))
	x32 := (uint64(p224Uint1(x31)) + x23)
	var x34 uint64
	_, x34 = bits.Add64(x11, x20, uint64(0x0))
	var x35 uint64
	var x36 uint64
	x35, x36 = bits.Add64(x13, x26, uint64(p224Uint1(x34)))
	var x37 uint64
	var x38 uint64
	x37, x38 = bits.Add64(x15, x28, uint64(p224Uint1(x36)))
	var x39 uint64
	var x40 uint64
	x39, x40 = bits.Add64(x17, x30, uint64(p224Uint1(x38)))
	var x41 uint64
	var x42 uint64
	x41, x42 = bits.Add64(x19, x32, uint64(p224Uint1(x40)))
	var x43 uint64
	var x44 uint64
	x44, x43 = bits.Mul64(x1, arg2[3])
	var x45 uint64
	var x46 uint64
	x46, x45 = bits.Mul64(x1, arg2[2])
	var x47 uint64
	var x48 uint64
	x48, x47 = bits.Mul64(x1, arg2[1])
	var x49 uint64
	var x50 uint64
	x50, x49 = bits.Mul64(x1, arg2[0])
	var x51 uint64
	var x52 uint64
	x51, x52 = bits.Add64(x50, x47, uint64(0x0))
	var x53 uint64
	var x54 uint64
	x53, x54 = bits.Add64(x48, x45, uint64(p224Uint1(x52)))
	var x55 uint64
	var x56 uint64
	x55, x56 = bits.Add64(x46, x43, uint64(p224Uint1(x54)))
	x57 := (uint64(p224Uint1(x56)) + x44)
	var x58 uint64
	var x59 uint64
	x58, x59 = bits.Add64(x35, x49, uint64(0x0))
	var x60 uint64
	var x61 uint64
	x60, x61 = bits.Add64(x37, x51, uint64(p224Uint1(x59)))
	var x62 uint64
	var x63 uint64
	x62, x63 = bits.Add64(x39, x53, uint64(p224Uint1(x61)))
	var x64 uint64
	var x65 uint64
	x64, x65 = bits.Add64(x41, x55, uint64(p224Uint1(x63)))
	var x66 uint64
	var x67 uint64
	x66, x67 = bits.Add64(uint64(p224Uint1(x42)), x57, uint64(p224Uint1(x65)))
	var x68 uint64
	_, x68 = bits.Mul64(x58, 0xffffffffffffffff)
	var x70 uint64
	var x71 uint64
	x71, x70 = bits.Mul64(x68, 0xffffffff)
	var x72 uint64
	var x73 uint64
	x73, x72 = bits.Mul64(x68, 0xffffffffffffffff)
	var x74 uint64
	var x75 uint64
	x75, x74 = bits.Mul64(x68, 0xffffffff00000000)
	var x76 uint64
	var x77 uint64
	x76, x77 = bits.Add64(x75, x72, uint64(0x0))
	var x78 uint64
	var x79 uint64
	x78, x79 = bits.Add64(x73, x70, uint64(p224Uint1(x77)))
	x80 := (uint64(p224Uint1(x79)) + x71)
	var x82 uint64
	_, x82 = bits.Add64(x58, x68, uint64(0x0))
	var x83 uint64
	var x84 uint64
	x83, x84 = bits.Add64(x60, x74, uint64(p224Uint1(x82)))
	var x85 uint64
	var x86 uint64
	x85, x86 = bits.Add64(x62, x76, uint64(p224Uint1(x84)))
	var x87 uint64
	var x88 uint64
	x87, x88 = bits.Add64(x64, x78, uint64(p224Uint1(x86)))
	var x89 uint64
	var x90 uint64
	x89, x90 = bits.Add64(x66, x80, uint64(p224Uint1(x88)))
	x91 := (uint64(p224Uint1(x90)) + uint64(p224Uint1(x67)))
	var x92 uint64
	var x93 uint64
	x93, x92 = bits.Mul64(x2, arg2[3])
	var x94 uint64
	var x95 uint64
	x95, x94 = bits.Mul64(x2, arg2[2])
	var x96 uint64
	var x97 uint64
	x97, x96 = bits.Mul64(x2, arg2[1])
	var x98 uint64
	var x99 uint64
	x99, x98 = bits.Mul64(x2, arg2[0])
	var x100 uint64
	var x101 uint64
	x100, x101 = bits.Add64(x99, x96, uint64(0x0))
	var x102 uint64
	var x103 uint64
	x102, x103 = bits.Add64(x97, x94, uint64(p224Uint1(x101)))
	var x104 uint64
	var x105 uint64
	x104, x105 = bits.Add64(x95, x92, uint64(p224Uint1(x103)))
	x106 := (uint64(p224Uint1(x105)) + x93)
	var x107 uint64
	var x108 uint64
	x107, x108 = bits.Add64(x83, x98, uint64(0x0))
	var x109 uint64
	var x110 uint64
	x109, x110 = bits.Add64(x85, x100, uint64(p224Uint1(x108)))
	var x111 uint64
	var x112 uint64
	x111, x112 = bits.Add64(x87, x102, uint64(p224Uint1(x110)))
	var x113 uint64
	var x114 uint64
	x113, x114 = bits.Add64(x89, x104, uint64(p224Uint1(x112)))
	var x115 uint64
	var x116 uint64
	x115, x116 = bits.Add64(x91, x106, uint64(p224Uint1(x114)))
	var x117 uint64
	_, x117 = bits.Mul64(x107, 0xffffffffffffffff)
	var x119 uint64
	var x120 uint64
	x120, x119 = bits.Mul64(x117, 0xffffffff)
	var x121 uint64
	var x122 uint64
	x122, x121 = bits.Mul64(x117, 0xffffffffffffffff)
	var x123 uint64
	var x124 uint64
	x124, x123 = bits.Mul64(x117, 0xffffffff00000000)
	var x125 uint64
	var x126 uint64
	x125, x126 = bits.Add64(x124, x121, uint64(0x0))
	var x127 uint64
	var x128 uint64
	x127, x128 = bits.Add64(x122, x119, uint64(p224Uint1(x126)))
	x129 := (uint64(p224Uint1(x128)) + x120)
	var x131 uint64
	_, x131 = bits.Add64(x107, x117, uint64(0x0))
	var x132 uint64
	var x133 uint64
	x132, x133 = bits.Add64(x109, x123, uint64(p224Uint1(x131)))
	var x134 uint64
	var x135 uint64
	x134, x135 = bits.Add64(x111, x125, uint64(p224Uint1(x133)))
	var x136 uint64
	var x137 uint64
	x136, x137 = bits.Add64(x113, x127, uint64(p224Uint1(x135)))
	var x138 uint64
	var x139 uint64
	x138, x139 = bits.Add64(x115, x129, uint64(p224Uint1(x137)))
	x140 := (uint64(p224Uint1(x139)) + uint64(p224Uint1(x116)))
	var x141 uint64
	var x142 uint64
	x142, x141 = bits.Mul64(x3, arg2[3])
	var x143 uint64
	var x144 uint64
	x144, x143 = bits.Mul64(x3, arg2[2])
	var x145 uint64
	var x146 uint64
	x146, x145 = bits.Mul64(x3, arg2[1])
	var x147 uint64
	var x148 uint64
	x148, x147 = bits.Mul64(x3, arg2[0])
	var x149 uint64
	var x150 uint64
	x149, x150 = bits.Add64(x148, x145, uint64(0x0))
	var x151 uint64
	var x152 uint64
	x151, x152 = bits.Add64(x146, x143, uint64(p224Uint1(x150)))
	var x153 uint64
	var x154 uint64
	x153, x154 = bits.Add64(x144, x141, uint64(p224Uint1(x152)))
	x155 := (uint64(p224Uint1(x154)) + x142)
	var x156 uint64
	var x157 uint64
	x156, x157 = bits.Add64(x132, x147, uint64(0x0))
	var x158 uint64
	var x159 uint64
	x158, x159 = bits.Add64(x134, x149, uint64(p224Uint1(x157)))
	var x160 uint64
	var x161 uint64
	x160, x161 = bits.Add64(x136, x151, uint64(p224Uint1(x159)))
	var x162 uint64
	var x163 uint64
	x162, x163 = bits.Add64(x138, x153, uint64(p224Uint1(x161)))
	var x164 uint64
	var x165 uint64
	x164, x165 = bits.Add64(x140, x155, uint64(p224Uint1(x163)))
	var x166 uint64
	_, x166 = bits.Mul64(x156, 0xffffffffffffffff)
	var x168 uint64
	var x169 uint64
	x169, x168 = bits.Mul64(x166, 0xffffffff)
	var x170 uint64
	var x171 uint64
	x171, x170 = bits.Mul64(x166, 0xffffffffffffffff)
	var x172 uint64
	var x173 uint64
	x173, x172 = bits.Mul64(x166, 0xffffffff00000000)
	var x174 uint64
	var x175 uint64
	x174, x175 = bits.Add64(x173, x170, uint64(0x0))
	var x176 uint64
	var x177 uint64
	x176, x177 = bits.Add64(x171, x168, uint64(p224Uint1(x175)))
	x178 := (uint64(p224Uint1(x177)) + x169)
	var x180 uint64
	_, x180 = bits.Add64(x156, x166, uint64(0x0))
	var x181 uint64
	var x182 uint64
	x181, x182 = bits.Add64(x158, x172, uint64(p224Uint1(x180)))
	var x183 uint64
	var x184 uint64
	x183, x184 = bits.Add64(x160, x174, uint64(p224Uint1(x182)))
	var x185 uint64
	var x186 uint64
	x185, x186 = bits.Add64(x162, x176, uint64(p224Uint1(x184)))
	var x187 uint64
	var x188 uint64
	x187, x188 = bits.Add64(x164, x178, uint64(p224Uint1(x186)))
	x189 := (uint64(p224Uint1(x188)) + uint64(p224Uint1(x165)))
	var x190 uint64
	var x191 uint64
	x190, x191 = bits.Sub64(x181, uint64(0x1), uint64(0x0))
	var x192 uint64
	var x193 uint64
	x192, x193 = bits.Sub64(x183, 0xffffffff00000000, uint64(p224Uint1(x191)))
	var x194 uint64
	var x195 uint64
	x194, x195 = bits.Sub64(x185, 0xffffffffffffffff, uint64(p224Uint1(x193)))
	var x196 uint64
	var x197 uint64
	x196, x197 = bits.Sub64(x187, 0xffffffff, uint64(p224Uint1(x195)))
	var x199 uint64
	_, x199 = bits.Sub64(x189, uint64(0x0), uint64(p224Uint1(x197)))
	var x200 uint64
	p224CmovznzU64(&x200, p224Uint1(x199), x190, x181)
	var x201 uint64
	p224CmovznzU64(&x201, p224Uint1(x199), x192, x183)
	var x202 uint64
	p224CmovznzU64(&x202, p224Uint1(x199), x194, x185)
	var x203 uint64
	p224CmovznzU64(&x203, p224Uint1(x199), x196, x187)
	out1[0] = x200
	out1[1] = x201
	out1[2] = x202
	out1[3] = x203
}

// p224Square squares a field element in the Montgomery domain.
//
// Preconditions:
//
//	0 ≤ eval arg1 < m
//
// Postconditions:
//
//	eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
//	0 ≤ eval out1 < m
func p224Square(out1 *p224MontgomeryDomainFieldElement, arg1 *p224MontgomeryDomainFieldElement) {
	x1 := arg1[1]
	x2 := arg1[2]
	x3 := arg1[3]
	x4 := arg1[0]
	var x5 uint64
	var x6 uint64
	x6, x5 = bits.Mul64(x4, arg1[3])
	var x7 uint64
	var x8 uint64
	x8, x7 = bits.Mul64(x4, arg1[2])
	var x9 uint64
	var x10 uint64
	x10, x9 = bits.Mul64(x4, arg1[1])
	var x11 uint64
	var x12 uint64
	x12, x11 = bits.Mul64(x4, arg1[0])
	var x13 uint64
	var x14 uint64
	x13, x14 = bits.Add64(x12, x9, uint64(0x0))
	var x15 uint64
	var x16 uint64
	x15, x16 = bits.Add64(x10, x7, uint64(p224Uint1(x14)))
	var x17 uint64
	var x18 uint64
	x17, x18 = bits.Add64(x8, x5, uint64(p224Uint1(x16)))
	x19 := (uint64(p224Uint1(x18)) + x6)
	var x20 uint64
	_, x20 = bits.Mul64(x11, 0xffffffffffffffff)
	var x22 uint64
	var x23 uint64
	x23, x22 = bits.Mul64(x20, 0xffffffff)
	var x24 uint64
	var x25 uint64
	x25, x24 = bits.Mul64(x20, 0xffffffffffffffff)
	var x26 uint64
	var x27 uint64
	x27, x26 = bits.Mul64(x20, 0xffffffff00000000)
	var x28 uint64
	var x29 uint64
	x28, x29 = bits.Add64(x27, x24, uint64(0x0))
	var x30 uint64
	var x31 uint64
	x30, x31 = bits.Add64(x25, x22, uint64(p224Uint1(x29)))
	x32 := (uint64(p224Uint1(x31)) + x23)
	var x34 uint64
	_, x34 = bits.Add64(x11, x20, uint64(0x0))
	var x35 uint64
	var x36 uint64
	x35, x36 = bits.Add64(x13, x26, uint64(p224Uint1(x34)))
	var x37 uint64
	var x38 uint64
	x37, x38 = bits.Add64(x15, x28, uint64(p224Uint1(x36)))
	var x39 uint64
	var x40 uint64
	x39, x40 = bits.Add64(x17, x30, uint64(p224Uint1(x38)))
	var x41 uint64
	var x42 uint64
	x41, x42 = bits.Add64(x19, x32, uint64(p224Uint1(x40)))
	var x43 uint64
	var x44 uint64
	x44, x43 = bits.Mul64(x1, arg1[3])
	var x45 uint64
	var x46 uint64
	x46, x45 = bits.Mul64(x1, arg1[2])
	var x47 uint64
	var x48 uint64
	x48, x47 = bits.Mul64(x1, arg1[1])
	var x49 uint64
	var x50 uint64
	x50, x49 = bits.Mul64(x1, arg1[0])
	var x51 uint64
	var x52 uint64
	x51, x52 = bits.Add64(x50, x47, uint64(0x0))
	var x53 uint64
	var x54 uint64
	x53, x54 = bits.Add64(x48, x45, uint64(p224Uint1(x52)))
	var x55 uint64
	var x56 uint64
	x55, x56 = bits.Add64(x46, x43, uint64(p224Uint1(x54)))
	x57 := (uint64(p224Uint1(x56)) + x44)
	var x58 uint64
	var x59 uint64
	x58, x59 = bits.Add64(x35, x49, uint64(0x0))
	var x60 uint64
	var x61 uint64
	x60, x61 = bits.Add64(x37, x51, uint64(p224Uint1(x59)))
	var x62 uint64
	var x63 uint64
	x62, x63 = bits.Add64(x39, x53, uint64(p224Uint1(x61)))
	var x64 uint64
	var x65 uint64
	x64, x65 = bits.Add64(x41, x55, uint64(p224Uint1(x63)))
	var x66 uint64
	var x67 uint64
	x66, x67 = bits.Add64(uint64(p224Uint1(x42)), x57, uint64(p224Uint1(x65)))
	var x68 uint64
	_, x68 = bits.Mul64(x58, 0xffffffffffffffff)
	var x70 uint64
	var x71 uint64
	x71, x70 = bits.Mul64(x68, 0xffffffff)
	var x72 uint64
	var x73 uint64
	x73, x72 = bits.Mul64(x68, 0xffffffffffffffff)
	var x74 uint64
	var x75 uint64
	x75, x74 = bits.Mul64(x68, 0xffffffff00000000)
	var x76 uint64
	var x77 uint64
	x76, x77 = bits.Add64(x75, x72, uint64(0x0))
	var x78 uint64
	var x79 uint64
	x78, x79 = bits.Add64(x73, x70, uint64(p224Uint1(x77)))
	x80 := (uint64(p224Uint1(x79)) + x71)
	var x82 uint64
	_, x82 = bits.Add64(x58, x68, uint64(0x0))
	var x83 uint64
	var x84 uint64
	x83, x84 = bits.Add64(x60, x74, uint64(p224Uint1(x82)))
	var x85 uint64
	var x86 uint64
	x85, x86 = bits.Add64(x62, x76, uint64(p224Uint1(x84)))
	var x87 uint64
	var x88 uint64
	x87, x88 = bits.Add64(x64, x78, uint64(p224Uint1(x86)))
	var x89 uint64
	var x90 uint64
	x89, x90 = bits.Add64(x66, x80, uint64(p224Uint1(x88)))
	x91 := (uint64(p224Uint1(x90)) + uint64(p224Uint1(x67)))
	var x92 uint64
	var x93 uint64
	x93, x92 = bits.Mul64(x2, arg1[3])
	var x94 uint64
	var x95 uint64
	x95, x94 = bits.Mul64(x2, arg1[2])
	var x96 uint64
	var x97 uint64
	x97, x96 = bits.Mul64(x2, arg1[1])
	var x98 uint64
	var x99 uint64
	x99, x98 = bits.Mul64(x2, arg1[0])
	var x100 uint64
	var x101 uint64
	x100, x101 = bits.Add64(x99, x96, uint64(0x0))
	var x102 uint64
	var x103 uint64
	x102, x103 = bits.Add64(x97, x94, uint64(p224Uint1(x101)))
	var x104 uint64
	var x105 uint64
	x104, x105 = bits.Add64(x95, x92, uint64(p224Uint1(x103)))
	x106 := (uint64(p224Uint1(x105)) + x93)
	var x107 uint64
	var x108 uint64
	x107, x108 = bits.Add64(x83, x98, uint64(0x0))
	var x109 uint64
	var x110 uint64
	x109, x110 = bits.Add64(x85, x100, uint64(p224Uint1(x108)))
	var x111 uint64
	var x112 uint64
	x111, x112 = bits.Add64(x87, x102, uint64(p224Uint1(x110)))
	var x113 uint64
	var x114 uint64
	x113, x114 = bits.Add64(x89, x104, uint64(p224Uint1(x112)))
	var x115 uint64
	var x116 uint64
	x115, x116 = bits.Add64(x91, x106, uint64(p224Uint1(x114)))
	var x117 uint64
	_, x117 = bits.Mul64(x107, 0xffffffffffffffff)
	var x119 uint64
	var x120 uint64
	x120, x119 = bits.Mul64(x117, 0xffffffff)
	var x121 uint64
	var x122 uint64
	x122, x121 = bits.Mul64(x117, 0xffffffffffffffff)
	var x123 uint64
	var x124 uint64
	x124, x123 = bits.Mul64(x117, 0xffffffff00000000)
	var x125 uint64
	var x126 uint64
	x125, x126 = bits.Add64(x124, x121, uint64(0x0))
	var x127 uint64
	var x128 uint64
	x127, x128 = bits.Add64(x122, x119, uint64(p224Uint1(x126)))
	x129 := (uint64(p224Uint1(x128)) + x120)
	var x131 uint64
	_, x131 = bits.Add64(x107, x117, uint64(0x0))
	var x132 uint64
	var x133 uint64
	x132, x133 = bits.Add64(x109, x123, uint64(p224Uint1(x131)))
	var x134 uint64
	var x135 uint64
	x134, x135 = bits.Add64(x111, x125, uint64(p224Uint1(x133)))
	var x136 uint64
	var x137 uint64
	x136, x137 = bits.Add64(x113, x127, uint64(p224Uint1(x135)))
	var x138 uint64
	var x139 uint64
	x138, x139 = bits.Add64(x115, x129, uint64(p224Uint1(x137)))
	x140 := (uint64(p224Uint1(x139)) + uint64(p224Uint1(x116)))
	var x141 uint64
	var x142 uint64
	x142, x141 = bits.Mul64(x3, arg1[3])
	var x143 uint64
	var x144 uint64
	x144, x143 = bits.Mul64(x3, arg1[2])
	var x145 uint64
	var x146 uint64
	x146, x145 = bits.Mul64(x3, arg1[1])
	var x147 uint64
	var x148 uint64
	x148, x147 = bits.Mul64(x3, arg1[0])
	var x149 uint64
	var x150 uint64
	x149, x150 = bits.Add64(x148, x145, uint64(0x0))
	var x151 uint64
	var x152 uint64
	x151, x152 = bits.Add64(x146, x143, uint64(p224Uint1(x150)))
	var x153 uint64
	var x154 uint64
	x153, x154 = bits.Add64(x144, x141, uint64(p224Uint1(x152)))
	x155 := (uint64(p224Uint1(x154)) + x142)
	var x156 uint64
	var x157 uint64
	x156, x157 = bits.Add64(x132, x147, uint64(0x0))
	var x158 uint64
	var x159 uint64
	x158, x159 = bits.Add64(x134, x149, uint64(p224Uint1(x157)))
	var x160 uint64
	var x161 uint64
	x160, x161 = bits.Add64(x136, x151, uint64(p224Uint1(x159)))
	var x162 uint64
	var x163 uint64
	x162, x163 = bits.Add64(x138, x153, uint64(p224Uint1(x161)))
	var x164 uint64
	var x165 uint64
	x164, x165 = bits.Add64(x140, x155, uint64(p224Uint1(x163)))
	var x166 uint64
	_, x166 = bits.Mul64(x156, 0xffffffffffffffff)
	var x168 uint64
	var x169 uint64
	x169, x168 = bits.Mul64(x166, 0xffffffff)
	var x170 uint64
	var x171 uint64
	x171, x170 = bits.Mul64(x166, 0xffffffffffffffff)
	var x172 uint64
	var x173 uint64
	x173, x172 = bits.Mul64(x166, 0xffffffff00000000)
	var x174 uint64
	var x175 uint64
	x174, x175 = bits.Add64(x173, x170, uint64(0x0))
	var x176 uint64
	var x177 uint64
	x176, x177 = bits.Add64(x171, x168, uint64(p224Uint1(x175)))
	x178 := (uint64(p224Uint1(x177)) + x169)
	var x180 uint64
	_, x180 = bits.Add64(x156, x166, uint64(0x0))
	var x181 uint64
	var x182 uint64
	x181, x182 = bits.Add64(x158, x172, uint64(p224Uint1(x180)))
	var x183 uint64
	var x184 uint64
	x183, x184 = bits.Add64(x160, x174, uint64(p224Uint1(x182)))
	var x185 uint64
	var x186 uint64
	x185, x186 = bits.Add64(x162, x176, uint64(p224Uint1(x184)))
	var x187 uint64
	var x188 uint64
	x187, x188 = bits.Add64(x164, x178, uint64(p224Uint1(x186)))
	x189 := (uint64(p224Uint1(x188)) + uint64(p224Uint1(x165)))
	var x190 uint64
	var x191 uint64
	x190, x191 = bits.Sub64(x181, uint64(0x1), uint64(0x0))
	var x192 uint64
	var x193 uint64
	x192, x193 = bits.Sub64(x183, 0xffffffff00000000, uint64(p224Uint1(x191)))
	var x194 uint64
	var x195 uint64
	x194, x195 = bits.Sub64(x185, 0xffffffffffffffff, uint64(p224Uint1(x193)))
	var x196 uint64
	var x197 uint64
	x196, x197 = bits.Sub64(x187, 0xffffffff, uint64(p224Uint1(x195)))
	var x199 uint64
	_, x199 = bits.Sub64(x189, uint64(0x0), uint64(p224Uint1(x197)))
	var x200 uint64
	p224CmovznzU64(&x200, p224Uint1(x199), x190, x181)
	var x201 uint64
	p224CmovznzU64(&x201, p224Uint1(x199), x192, x183)
	var x202 uint64
	p224CmovznzU64(&x202, p224Uint1(x199), x194, x185)
	var x203 uint64
	p224CmovznzU64(&x203, p224Uint1(x199), x196, x187)
	out1[0] = x200
	out1[1] = x201
	out1[2] = x202
	out1[3] = x203
}

// p224Add adds two field elements in the Montgomery domain.
//
// Preconditions:
//
//	0 ≤ eval arg1 < m
//	0 ≤ eval arg2 < m
//
// Postconditions:
//
//	eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
//	0 ≤ eval out1 < m
func p224Add(out1 *p224MontgomeryDomainFieldElement, arg1 *p224MontgomeryDomainFieldElement, arg2 *p224MontgomeryDomainFieldElement) {
	var x1 uint64
	var x2 uint64
	x1, x2 = bits.Add64(arg1[0], arg2[0], uint64(0x0))
	var x3 uint64
	var x4 uint64
	x3, x4 = bits.Add64(arg1[1], arg2[1], uint64(p224Uint1(x2)))
	var x5 uint64
	var x6 uint64
	x5, x6 = bits.Add64(arg1[2], arg2[2], uint64(p224Uint1(x4)))
	var x7 uint64
	var x8 uint64
	x7, x8 = bits.Add64(arg1[3], arg2[3], uint64(p224Uint1(x6)))
	var x9 uint64
	var x10 uint64
	x9, x10 = bits.Sub64(x1, uint64(0x1), uint64(0x0))
	var x11 uint64
	var x12 uint64
	x11, x12 = bits.Sub64(x3, 0xffffffff00000000, uint64(p224Uint1(x10)))
	var x13 uint64
	var x14 uint64
	x13, x14 = bits.Sub64(x5, 0xffffffffffffffff, uint64(p224Uint1(x12)))
	var x15 uint64
	var x16 uint64
	x15, x16 = bits.Sub64(x7, 0xffffffff, uint64(p224Uint1(x14)))
	var x18 uint64
	_, x18 = bits.Sub64(uint64(p224Uint1(x8)), uint64(0x0), uint64(p224Uint1(x16)))
	var x19 uint64
	p224CmovznzU64(&x19, p224Uint1(x18), x9, x1)
	var x20 uint64
	p224CmovznzU64(&x20, p224Uint1(x18), x11, x3)
	var x21 uint64
	p224CmovznzU64(&x21, p224Uint1(x18), x13, x5)
	var x22 uint64
	p224CmovznzU64(&x22, p224Uint1(x18), x15, x7)
	out1[0] = x19
	out1[1] = x20
	out1[2] = x21
	out1[3] = x22
}

// p224Sub subtracts two field elements in the Montgomery domain.
//
// Preconditions:
//
//	0 ≤ eval arg1 < m
//	0 ≤ eval arg2 < m
//
// Postconditions:
//
//	eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
//	0 ≤ eval out1 < m
func p224Sub(out1 *p224MontgomeryDomainFieldElement, arg1 *p224MontgomeryDomainFieldElement, arg2 *p224MontgomeryDomainFieldElement) {
	var x1 uint64
	var x2 uint64
	x1, x2 = bits.Sub64(arg1[0], arg2[0], uint64(0x0))
	var x3 uint64
	var x4 uint64
	x3, x4 = bits.Sub64(arg1[1], arg2[1], uint64(p224Uint1(x2)))
	var x5 uint64
	var x6 uint64
	x5, x6 = bits.Sub64(arg1[2], arg2[2], uint64(p224Uint1(x4)))
	var x7 uint64
	var x8 uint64
	x7, x8 = bits.Sub64(arg1[3], arg2[3], uint64(p224Uint1(x6)))
	var x9 uint64
	p224CmovznzU64(&x9, p224Uint1(x8), uint64(0x0), 0xffffffffffffffff)
	var x10 uint64
	var x11 uint64
	x10, x11 = bits.Add64(x1, uint64((p224Uint1(x9) & 0x1)), uint64(0x0))
	var x12 uint64
	var x13 uint64
	x12, x13 = bits.Add64(x3, (x9 & 0xffffffff00000000), uint64(p224Uint1(x11)))
	var x14 uint64
	var x15 uint64
	x14, x15 = bits.Add64(x5, x9, uint64(p224Uint1(x13)))
	var x16 uint64
	x16, _ = bits.Add64(x7, (x9 & 0xffffffff), uint64(p224Uint1(x15)))
	out1[0] = x10
	out1[1] = x12
	out1[2] = x14
	out1[3] = x16
}

// p224SetOne returns the field element one in the Montgomery domain.
//
// Postconditions:
//
//	eval (from_montgomery out1) mod m = 1 mod m
//	0 ≤ eval out1 < m
func p224SetOne(out1 *p224MontgomeryDomainFieldElement) {
	out1[0] = 0xffffffff00000000
	out1[1] = 0xffffffffffffffff
	out1[2] = uint64(0x0)
	out1[3] = uint64(0x0)
}

// p224FromMontgomery translates a field element out of the Montgomery domain.
//
// Preconditions:
//
//	0 ≤ eval arg1 < m
//
// Postconditions:
//
//	eval out1 mod m = (eval arg1 * ((2^64)⁻¹ mod m)^4) mod m
//	0 ≤ eval out1 < m
func p224FromMontgomery(out1 *p224NonMontgomeryDomainFieldElement, arg1 *p224MontgomeryDomainFieldElement) {
	x1 := arg1[0]
	var x2 uint64
	_, x2 = bits.Mul64(x1, 0xffffffffffffffff)
	var x4 uint64
	var x5 uint64
	x5, x4 = bits.Mul64(x2, 0xffffffff)
	var x6 uint64
	var x7 uint64
	x7, x6 = bits.Mul64(x2, 0xffffffffffffffff)
	var x8 uint64
	var x9 uint64
	x9, x8 = bits.Mul64(x2, 0xffffffff00000000)
	var x10 uint64
	var x11 uint64
	x10, x11 = bits.Add64(x9, x6, uint64(0x0))
	var x12 uint64
	var x13 uint64
	x12, x13 = bits.Add64(x7, x4, uint64(p224Uint1(x11)))
	var x15 uint64
	_, x15 = bits.Add64(x1, x2, uint64(0x0))
	var x16 uint64
	var x17 uint64
	x16, x17 = bits.Add64(uint64(0x0), x8, uint64(p224Uint1(x15)))
	var x18 uint64
	var x19 uint64
	x18, x19 = bits.Add64(uint64(0x0), x10, uint64(p224Uint1(x17)))
	var x20 uint64
	var x21 uint64
	x20, x21 = bits.Add64(uint64(0x0), x12, uint64(p224Uint1(x19)))
	var x22 uint64
	var x23 uint64
	x22, x23 = bits.Add64(x16, arg1[1], uint64(0x0))
	var x24 uint64
	var x25 uint64
	x24, x25 = bits.Add64(x18, uint64(0x0), uint64(p224Uint1(x23)))
	var x26 uint64
	var x27 uint64
	x26, x27 = bits.Add64(x20, uint64(0x0), uint64(p224Uint1(x25)))
	var x28 uint64
	_, x28 = bits.Mul64(x22, 0xffffffffffffffff)
	var x30 uint64
	var x31 uint64
	x31, x30 = bits.Mul64(x28, 0xffffffff)
	var x32 uint64
	var x33 uint64
	x33, x32 = bits.Mul64(x28, 0xffffffffffffffff)
	var x34 uint64
	var x35 uint64
	x35, x34 = bits.Mul64(x28, 0xffffffff00000000)
	var x36 uint64
	var x37 uint64
	x36, x37 = bits.Add64(x35, x32, uint64(0x0))
	var x38 uint64
	var x39 uint64
	x38, x39 = bits.Add64(x33, x30, uint64(p224Uint1(x37)))
	var x41 uint64
	_, x41 = bits.Add64(x22, x28, uint64(0x0))
	var x42 uint64
	var x43 uint64
	x42, x43 = bits.Add64(x24, x34, uint64(p224Uint1(x41)))
	var x44 uint64
	var x45 uint64
	x44, x45 = bits.Add64(x26, x36, uint64(p224Uint1(x43)))
	var x46 uint64
	var x47 uint64
	x46, x47 = bits.Add64((uint64(p224Uint1(x27)) + (uint64(p224Uint1(x21)) + (uint64(p224Uint1(x13)) + x5))), x38, uint64(p224Uint1(x45)))
	var x48 uint64
	var x49 uint64
	x48, x49 = bits.Add64(x42, arg1[2], uint64(0x0))
	var x50 uint64
	var x51 uint64
	x50, x51 = bits.Add64(x44, uint64(0x0), uint64(p224Uint1(x49)))
	var x52 uint64
	var x53 uint64
	x52, x53 = bits.Add64(x46, uint64(0x0), uint64(p224Uint1(x51)))
	var x54 uint64
	_, x54 = bits.Mul64(x48, 0xffffffffffffffff)
	var x56 uint64
	var x57 uint64
	x57, x56 = bits.Mul64(x54, 0xffffffff)
	var x58 uint64
	var x59 uint64
	x59, x58 = bits.Mul64(x54, 0xffffffffffffffff)
	var x60 uint64
	var x61 uint64
	x61, x60 = bits.Mul64(x54, 0xffffffff00000000)
	var x62 uint64
	var x63 uint64
	x62, x63 = bits.Add64(x61, x58, uint64(0x0))
	var x64 uint64
	var x65 uint64
	x64, x65 = bits.Add64(x59, x56, uint64(p224Uint1(x63)))
	var x67 uint64
	_, x67 = bits.Add64(x48, x54, uint64(0x0))
	var x68 uint64
	var x69 uint64
	x68, x69 = bits.Add64(x50, x60, uint64(p224Uint1(x67)))
	var x70 uint64
	var x71 uint64
	x70, x71 = bits.Add64(x52, x62, uint64(p224Uint1(x69)))
	var x72 uint64
	var x73 uint64
	x72, x73 = bits.Add64((uint64(p224Uint1(x53)) + (uint64(p224Uint1(x47)) + (uint64(p224Uint1(x39)) + x31))), x64, uint64(p224Uint1(x71)))
	var x74 uint64
	var x75 uint64
	x74, x75 = bits.Add64(x68, arg1[3], uint64(0x0))
	var x76 uint64
	var x77 uint64
	x76, x77 = bits.Add64(x70, uint64(0x0), uint64(p224Uint1(x75)))
	var x78 uint64
	var x79 uint64
	x78, x79 = bits.Add64(x72, uint64(0x0), uint64(p224Uint1(x77)))
	var x80 uint64
	_, x80 = bits.Mul64(x74, 0xffffffffffffffff)
	var x82 uint64
	var x83 uint64
	x83, x82 = bits.Mul64(x80, 0xffffffff)
	var x84 uint64
	var x85 uint64
	x85, x84 = bits.Mul64(x80, 0xffffffffffffffff)
	var x86 uint64
	var x87 uint64
	x87, x86 = bits.Mul64(x80, 0xffffffff00000000)
	var x88 uint64
	var x89 uint64
	x88, x89 = bits.Add64(x87, x84, uint64(0x0))
	var x90 uint64
	var x91 uint64
	x90, x91 = bits.Add64(x85, x82, uint64(p224Uint1(x89)))
	var x93 uint64
	_, x93 = bits.Add64(x74, x80, uint64(0x0))
	var x94 uint64
	var x95 uint64
	x94, x95 = bits.Add64(x76, x86, uint64(p224Uint1(x93)))
	var x96 uint64
	var x97 uint64
	x96, x97 = bits.Add64(x78, x88, uint64(p224Uint1(x95)))
	var x98 uint64
	var x99 uint64
	x98, x99 = bits.Add64((uint64(p224Uint1(x79)) + (uint64(p224Uint1(x73)) + (uint64(p224Uint1(x65)) + x57))), x90, uint64(p224Uint1(x97)))
	x100 := (uint64(p224Uint1(x99)) + (uint64(p224Uint1(x91)) + x83))
	var x101 uint64
	var x102 uint64
	x101, x102 = bits.Sub64(x94, uint64(0x1), uint64(0x0))
	var x103 uint64
	var x104 uint64
	x103, x104 = bits.Sub64(x96, 0xffffffff00000000, uint64(p224Uint1(x102)))
	var x105 uint64
	var x106 uint64
	x105, x106 = bits.Sub64(x98, 0xffffffffffffffff, uint64(p224Uint1(x104)))
	var x107 uint64
	var x108 uint64
	x107, x108 = bits.Sub64(x100, 0xffffffff, uint64(p224Uint1(x106)))
	var x110 uint64
	_, x110 = bits.Sub64(uint64(0x0), uint64(0x0), uint64(p224Uint1(x108)))
	var x111 uint64
	p224CmovznzU64(&x111, p224Uint1(x110), x101, x94)
	var x112 uint64
	p224CmovznzU64(&x112, p224Uint1(x110), x103, x96)
	var x113 uint64
	p224CmovznzU64(&x113, p224Uint1(x110), x105, x98)
	var x114 uint64
	p224CmovznzU64(&x114, p224Uint1(x110), x107, x100)
	out1[0] = x111
	out1[1] = x112
	out1[2] = x113
	out1[3] = x114
}

// p224ToMontgomery translates a field element into the Montgomery domain.
//
// Preconditions:
//
//	0 ≤ eval arg1 < m
//
// Postconditions:
//
//	eval (from_montgomery out1) mod m = eval arg1 mod m
//	0 ≤ eval out1 < m
func p224ToMontgomery(out1 *p224MontgomeryDomainFieldElement, arg1 *p224NonMontgomeryDomainFieldElement) {
	x1 := arg1[1]
	x2 := arg1[2]
	x3 := arg1[3]
	x4 := arg1[0]
	var x5 uint64
	var x6 uint64
	x6, x5 = bits.Mul64(x4, 0xffffffff)
	var x7 uint64
	var x8 uint64
	x8, x7 = bits.Mul64(x4, 0xfffffffe00000000)
	var x9 uint64
	var x10 uint64
	x10, x9 = bits.Mul64(x4, 0xffffffff00000000)
	var x11 uint64
	var x12 uint64
	x12, x11 = bits.Mul64(x4, 0xffffffff00000001)
	var x13 uint64
	var x14 uint64
	x13, x14 = bits.Add64(x12, x9, uint64(0x0))
	var x15 uint64
	var x16 uint64
	x15, x16 = bits.Add64(x10, x7, uint64(p224Uint1(x14)))
	var x17 uint64
	var x18 uint64
	x17, x18 = bits.Add64(x8, x5, uint64(p224Uint1(x16)))
	var x19 uint64
	_, x19 = bits.Mul64(x11, 0xffffffffffffffff)
	var x21 uint64
	var x22 uint64
	x22, x21 = bits.Mul64(x19, 0xffffffff)
	var x23 uint64
	var x24 uint64
	x24, x23 = bits.Mul64(x19, 0xffffffffffffffff)
	var x25 uint64
	var x26 uint64
	x26, x25 = bits.Mul64(x19, 0xffffffff00000000)
	var x27 uint64
	var x28 uint64
	x27, x28 = bits.Add64(x26, x23, uint64(0x0))
	var x29 uint64
	var x30 uint64
	x29, x30 = bits.Add64(x24, x21, uint64(p224Uint1(x28)))
	var x32 uint64
	_, x32 = bits.Add64(x11, x19, uint64(0x0))
	var x33 uint64
	var x34 uint64
	x33, x34 = bits.Add64(x13, x25, uint64(p224Uint1(x32)))
	var x35 uint64
	var x36 uint64
	x35, x36 = bits.Add64(x15, x27, uint64(p224Uint1(x34)))
	var x37 uint64
	var x38 uint64
	x37, x38 = bits.Add64(x17, x29, uint64(p224Uint1(x36)))
	var x39 uint64
	var x40 uint64
	x40, x39 = bits.Mul64(x1, 0xffffffff)
	var x41 uint64
	var x42 uint64
	x42, x41 = bits.Mul64(x1, 0xfffffffe00000000)
	var x43 uint64
	var x44 uint64
	x44, x43 = bits.Mul64(x1, 0xffffffff00000000)
	var x45 uint64
	var x46 uint64
	x46, x45 = bits.Mul64(x1, 0xffffffff00000001)
	var x47 uint64
	var x48 uint64
	x47, x48 = bits.Add64(x46, x43, uint64(0x0))
	var x49 uint64
	var x50 uint64
	x49, x50 = bits.Add64(x44, x41, uint64(p224Uint1(x48)))
	var x51 uint64
	var x52 uint64
	x51, x52 = bits.Add64(x42, x39, uint64(p224Uint1(x50)))
	var x53 uint64
	var x54 uint64
	x53, x54 = bits.Add64(x33, x45, uint64(0x0))
	var x55 uint64
	var x56 uint64
	x55, x56 = bits.Add64(x35, x47, uint64(p224Uint1(x54)))
	var x57 uint64
	var x58 uint64
	x57, x58 = bits.Add64(x37, x49, uint64(p224Uint1(x56)))
	var x59 uint64
	var x60 uint64
	x59, x60 = bits.Add64(((uint64(p224Uint1(x38)) + (uint64(p224Uint1(x18)) + x6)) + (uint64(p224Uint1(x30)) + x22)), x51, uint64(p224Uint1(x58)))
	var x61 uint64
	_, x61 = bits.Mul64(x53, 0xffffffffffffffff)
	var x63 uint64
	var x64 uint64
	x64, x63 = bits.Mul64(x61, 0xffffffff)
	var x65 uint64
	var x66 uint64
	x66, x65 = bits.Mul64(x61, 0xffffffffffffffff)
	var x67 uint64
	var x68 uint64
	x68, x67 = bits.Mul64(x61, 0xffffffff00000000)
	var x69 uint64
	var x70 uint64
	x69, x70 = bits.Add64(x68, x65, uint64(0x0))
	var x71 uint64
	var x72 uint64
	x71, x72 = bits.Add64(x66, x63, uint64(p224Uint1(x70)))
	var x74 uint64
	_, x74 = bits.Add64(x53, x61, uint64(0x0))
	var x75 uint64
	var x76 uint64
	x75, x76 = bits.Add64(x55, x67, uint64(p224Uint1(x74)))
	var x77 uint64
	var x78 uint64
	x77, x78 = bits.Add64(x57, x69, uint64(p224Uint1(x76)))
	var x79 uint64
	var x80 uint64
	x79, x80 = bits.Add64(x59, x71, uint64(p224Uint1(x78)))
	var x81 uint64
	var x82 uint64
	x82, x81 = bits.Mul64(x2, 0xffffffff)
	var x83 uint64
	var x84 uint64
	x84, x83 = bits.Mul64(x2, 0xfffffffe00000000)
	var x85 uint64
	var x86 uint64
	x86, x85 = bits.Mul64(x2, 0xffffffff00000000)
	var x87 uint64
	var x88 uint64
	x88, x87 = bits.Mul64(x2, 0xffffffff00000001)
	var x89 uint64
	var x90 uint64
	x89, x90 = bits.Add64(x88, x85, uint64(0x0))
	var x91 uint64
	var x92 uint64
	x91, x92 = bits.Add64(x86, x83, uint64(p224Uint1(x90)))
	var x93 uint64
	var x94 uint64
	x93, x94 = bits.Add64(x84, x81, uint64(p224Uint1(x92)))
	var x95 uint64
	var x96 uint64
	x95, x96 = bits.Add64(x75, x87, uint64(0x0))
	var x97 uint64
	var x98 uint64
	x97, x98 = bits.Add64(x77, x89, uint64(p224Uint1(x96)))
	var x99 uint64
	var x100 uint64
	x99, x100 = bits.Add64(x79, x91, uint64(p224Uint1(x98)))
	var x101 uint64
	var x102 uint64
	x101, x102 = bits.Add64(((uint64(p224Uint1(x80)) + (uint64(p224Uint1(x60)) + (uint64(p224Uint1(x52)) + x40))) + (uint64(p224Uint1(x72)) + x64)), x93, uint64(p224Uint1(x100)))
	var x103 uint64
	_, x103 = bits.Mul64(x95, 0xffffffffffffffff)
	var x105 uint64
	var x106 uint64
	x106, x105 = bits.Mul64(x103, 0xffffffff)
	var x107 uint64
	var x108 uint64
	x108, x107 = bits.Mul64(x103, 0xffffffffffffffff)
	var x109 uint64
	var x110 uint64
	x110, x109 = bits.Mul64(x103, 0xffffffff00000000)
	var x111 uint64
	var x112 uint64
	x111, x112 = bits.Add64(x110, x107, uint64(0x0))
	var x113 uint64
	var x114 uint64
	x113, x114 = bits.Add64(x108, x105, uint64(p224Uint1(x112)))
	var x116 uint64
	_, x116 = bits.Add64(x95, x103, uint64(0x0))
	var x117 uint64
	var x118 uint64
	x117, x118 = bits.Add64(x97, x109, uint64(p224Uint1(x116)))
	var x119 uint64
	var x120 uint64
	x119, x120 = bits.Add64(x99, x111, uint64(p224Uint1(x118)))
	var x121 uint64
	var x122 uint64
	x121, x122 = bits.Add64(x101, x113, uint64(p224Uint1(x120)))
	var x123 uint64
	var x124 uint64
	x124, x123 = bits.Mul64(x3, 0xffffffff)
	var x125 uint64
	var x126 uint64
	x126, x125 = bits.Mul64(x3, 0xfffffffe00000000)
	var x127 uint64
	var x128 uint64
	x128, x127 = bits.Mul64(x3, 0xffffffff00000000)
	var x129 uint64
	var x130 uint64
	x130, x129 = bits.Mul64(x3, 0xffffffff00000001)
	var x131 uint64
	var x132 uint64
	x131, x132 = bits.Add64(x130, x127, uint64(0x0))
	var x133 uint64
	var x134 uint64
	x133, x134 = bits.Add64(x128, x125, uint64(p224Uint1(x132)))
	var x135 uint64
	var x136 uint64
	x135, x136 = bits.Add64(x126, x123, uint64(p224Uint1(x134)))
	var x137 uint64
	var x138 uint64
	x137, x138 = bits.Add64(x117, x129, uint64(0x0))
	var x139 uint64
	var x140 uint64
	x139, x140 = bits.Add64(x119, x131, uint64(p224Uint1(x138)))
	var x141 uint64
	var x142 uint64
	x141, x142 = bits.Add64(x121, x133, uint64(p224Uint1(x140)))
	var x143 uint64
	var x144 uint64
	x143, x144 = bits.Add64(((uint64(p224Uint1(x122)) + (uint64(p224Uint1(x102)) + (uint64(p224Uint1(x94)) + x82))) + (uint64(p224Uint1(x114)) + x106)), x135, uint64(p224Uint1(x142)))
	var x145 uint64
	_, x145 = bits.Mul64(x137, 0xffffffffffffffff)
	var x147 uint64
	var x148 uint64
	x148, x147 = bits.Mul64(x145, 0xffffffff)
	var x149 uint64
	var x150 uint64
	x150, x149 = bits.Mul64(x145, 0xffffffffffffffff)
	var x151 uint64
	var x152 uint64
	x152, x151 = bits.Mul64(x145, 0xffffffff00000000)
	var x153 uint64
	var x154 uint64
	x153, x154 = bits.Add64(x152, x149, uint64(0x0))
	var x155 uint64
	var x156 uint64
	x155, x156 = bits.Add64(x150, x147, uint64(p224Uint1(x154)))
	var x158 uint64
	_, x158 = bits.Add64(x137, x145, uint64(0x0))
	var x159 uint64
	var x160 uint64
	x159, x160 = bits.Add64(x139, x151, uint64(p224Uint1(x158)))
	var x161 uint64
	var x162 uint64
	x161, x162 = bits.Add64(x141, x153, uint64(p224Uint1(x160)))
	var x163 uint64
	var x164 uint64
	x163, x164 = bits.Add64(x143, x155, uint64(p224Uint1(x162)))
	x165 := ((uint64(p224Uint1(x164)) + (uint64(p224Uint1(x144)) + (uint64(p224Uint1(x136)) + x124))) + (uint64(p224Uint1(x156)) + x148))
	var x166 uint64
	var x167 uint64
	x166, x167 = bits.Sub64(x159, uint64(0x1), uint64(0x0))
	var x168 uint64
	var x169 uint64
	x168, x169 = bits.Sub64(x161, 0xffffffff00000000, uint64(p224Uint1(x167)))
	var x170 uint64
	var x171 uint64
	x170, x171 = bits.Sub64(x163, 0xffffffffffffffff, uint64(p224Uint1(x169)))
	var x172 uint64
	var x173 uint64
	x172, x173 = bits.Sub64(x165, 0xffffffff, uint64(p224Uint1(x171)))
	var x175 uint64
	_, x175 = bits.Sub64(uint64(0x0), uint64(0x0), uint64(p224Uint1(x173)))
	var x176 uint64
	p224CmovznzU64(&x176, p224Uint1(x175), x166, x159)
	var x177 uint64
	p224CmovznzU64(&x177, p224Uint1(x175), x168, x161)
	var x178 uint64
	p224CmovznzU64(&x178, p224Uint1(x175), x170, x163)
	var x179 uint64
	p224CmovznzU64(&x179, p224Uint1(x175), x172, x165)
	out1[0] = x176
	out1[1] = x177
	out1[2] = x178
	out1[3] = x179
}

// p224Selectznz is a multi-limb conditional select.
//
// Postconditions:
//
//	eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
//
// Input Bounds:
//
//	arg1: [0x0 ~> 0x1]
//	arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
//	arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
//
// Output Bounds:
//
//	out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
func p224Selectznz(out1 *[4]uint64, arg1 p224Uint1, arg2 *[4]uint64, arg3 *[4]uint64) {
	var x1 uint64
	p224CmovznzU64(&x1, arg1, arg2[0], arg3[0])
	var x2 uint64
	p224CmovznzU64(&x2, arg1, arg2[1], arg3[1])
	var x3 uint64
	p224CmovznzU64(&x3, arg1, arg2[2], arg3[2])
	var x4 uint64
	p224CmovznzU64(&x4, arg1, arg2[3], arg3[3])
	out1[0] = x1
	out1[1] = x2
	out1[2] = x3
	out1[3] = x4
}

// p224ToBytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.
//
// Preconditions:
//
//	0 ≤ eval arg1 < m
//
// Postconditions:
//
//	out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..27]
//
// Input Bounds:
//
//	arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffff]]
//
// Output Bounds:
//
//	out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
func p224ToBytes(out1 *[28]uint8, arg1 *[4]uint64) {
	x1 := arg1[3]
	x2 := arg1[2]
	x3 := arg1[1]
	x4 := arg1[0]
	x5 := (uint8(x4) & 0xff)
	x6 := (x4 >> 8)
	x7 := (uint8(x6) & 0xff)
	x8 := (x6 >> 8)
	x9 := (uint8(x8) & 0xff)
	x10 := (x8 >> 8)
	x11 := (uint8(x10) & 0xff)
	x12 := (x10 >> 8)
	x13 := (uint8(x12) & 0xff)
	x14 := (x12 >> 8)
	x15 := (uint8(x14) & 0xff)
	x16 := (x14 >> 8)
	x17 := (uint8(x16) & 0xff)
	x18 := uint8((x16 >> 8))
	x19 := (uint8(x3) & 0xff)
	x20 := (x3 >> 8)
	x21 := (uint8(x20) & 0xff)
	x22 := (x20 >> 8)
	x23 := (uint8(x22) & 0xff)
	x24 := (x22 >> 8)
	x25 := (uint8(x24) & 0xff)
	x26 := (x24 >> 8)
	x27 := (uint8(x26) & 0xff)
	x28 := (x26 >> 8)
	x29 := (uint8(x28) & 0xff)
	x30 := (x28 >> 8)
	x31 := (uint8(x30) & 0xff)
	x32 := uint8((x30 >> 8))
	x33 := (uint8(x2) & 0xff)
	x34 := (x2 >> 8)
	x35 := (uint8(x34) & 0xff)
	x36 := (x34 >> 8)
	x37 := (uint8(x36) & 0xff)
	x38 := (x36 >> 8)
	x39 := (uint8(x38) & 0xff)
	x40 := (x38 >> 8)
	x41 := (uint8(x40) & 0xff)
	x42 := (x40 >> 8)
	x43 := (uint8(x42) & 0xff)
	x44 := (x42 >> 8)
	x45 := (uint8(x44) & 0xff)
	x46 := uint8((x44 >> 8))
	x47 := (uint8(x1) & 0xff)
	x48 := (x1 >> 8)
	x49 := (uint8(x48) & 0xff)
	x50 := (x48 >> 8)
	x51 := (uint8(x50) & 0xff)
	x52 := uint8((x50 >> 8))
	out1[0] = x5
	out1[1] = x7
	out1[2] = x9
	out1[3] = x11
	out1[4] = x13
	out1[5] = x15
	out1[6] = x17
	out1[7] = x18
	out1[8] = x19
	out1[9] = x21
	out1[10] = x23
	out1[11] = x25
	out1[12] = x27
	out1[13] = x29
	out1[14] = x31
	out1[15] = x32
	out1[16] = x33
	out1[17] = x35
	out1[18] = x37
	out1[19] = x39
	out1[20] = x41
	out1[21] = x43
	out1[22] = x45
	out1[23] = x46
	out1[24] = x47
	out1[25] = x49
	out1[26] = x51
	out1[27] = x52
}

// p224FromBytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.
//
// Preconditions:
//
//	0 ≤ bytes_eval arg1 < m
//
// Postconditions:
//
//	eval out1 mod m = bytes_eval arg1 mod m
//	0 ≤ eval out1 < m
//
// Input Bounds:
//
//	arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
//
// Output Bounds:
//
//	out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffff]]
func p224FromBytes(out1 *[4]uint64, arg1 *[28]uint8) {
	x1 := (uint64(arg1[27]) << 24)
	x2 := (uint64(arg1[26]) << 16)
	x3 := (uint64(arg1[25]) << 8)
	x4 := arg1[24]
	x5 := (uint64(arg1[23]) << 56)
	x6 := (uint64(arg1[22]) << 48)
	x7 := (uint64(arg1[21]) << 40)
	x8 := (uint64(arg1[20]) << 32)
	x9 := (uint64(arg1[19]) << 24)
	x10 := (uint64(arg1[18]) << 16)
	x11 := (uint64(arg1[17]) << 8)
	x12 := arg1[16]
	x13 := (uint64(arg1[15]) << 56)
	x14 := (uint64(arg1[14]) << 48)
	x15 := (uint64(arg1[13]) << 40)
	x16 := (uint64(arg1[12]) << 32)
	x17 := (uint64(arg1[11]) << 24)
	x18 := (uint64(arg1[10]) << 16)
	x19 := (uint64(arg1[9]) << 8)
	x20 := arg1[8]
	x21 := (uint64(arg1[7]) << 56)
	x22 := (uint64(arg1[6]) << 48)
	x23 := (uint64(arg1[5]) << 40)
	x24 := (uint64(arg1[4]) << 32)
	x25 := (uint64(arg1[3]) << 24)
	x26 := (uint64(arg1[2]) << 16)
	x27 := (uint64(arg1[1]) << 8)
	x28 := arg1[0]
	x29 := (x27 + uint64(x28))
	x30 := (x26 + x29)
	x31 := (x25 + x30)
	x32 := (x24 + x31)
	x33 := (x23 + x32)
	x34 := (x22 + x33)
	x35 := (x21 + x34)
	x36 := (x19 + uint64(x20))
	x37 := (x18 + x36)
	x38 := (x17 + x37)
	x39 := (x16 + x38)
	x40 := (x15 + x39)
	x41 := (x14 + x40)
	x42 := (x13 + x41)
	x43 := (x11 + uint64(x12))
	x44 := (x10 + x43)
	x45 := (x9 + x44)
	x46 := (x8 + x45)
	x47 := (x7 + x46)
	x48 := (x6 + x47)
	x49 := (x5 + x48)
	x50 := (x3 + uint64(x4))
	x51 := (x2 + x50)
	x52 := (x1 + x51)
	out1[0] = x35
	out1[1] = x42
	out1[2] = x49
	out1[3] = x52
}
