/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.comparesegments;

import java.awt.GridLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.Distance;
import tim.prune.data.Unit;
import tim.prune.data.UnitSet;
import tim.prune.function.comparesegments.IntersectionResult;
import tim.prune.gui.DisplayUtils;

public class MatchesPanel
extends JPanel {
    private final JLabel _numMatches;
    private final JLabel _distance1;
    private final JLabel _distance2;
    private final JLabel _duration1;
    private final JLabel _duration2;
    private final JLabel _aveSpeed1;
    private final JLabel _aveSpeed2;

    public MatchesPanel() {
        this.setLayout(new GridLayout(0, 3, 6, 2));
        this.setBorder(BorderFactory.createTitledBorder(I18nManager.getText("dialog.comparesegments.matches")));
        JLabel jLabel = new JLabel(String.valueOf(I18nManager.getText("dialog.comparesegments.nummatches")) + ": ");
        jLabel.setHorizontalAlignment(4);
        this.add(jLabel);
        this._numMatches = new JLabel("1234");
        this.add(this._numMatches);
        this.add(new JLabel(""));
        JLabel jLabel2 = new JLabel(String.valueOf(I18nManager.getText("fieldname.distance")) + ": ");
        jLabel2.setHorizontalAlignment(4);
        this.add(jLabel2);
        this._distance1 = new JLabel("11.9 km");
        this.add(this._distance1);
        this._distance2 = new JLabel("12.9 km");
        this.add(this._distance2);
        JLabel jLabel3 = new JLabel(String.valueOf(I18nManager.getText("fieldname.duration")) + ": ");
        jLabel3.setHorizontalAlignment(4);
        this.add(jLabel3);
        this._duration1 = new JLabel("11m 12s");
        this.add(this._duration1);
        this._duration2 = new JLabel("12m 13s");
        this.add(this._duration2);
        JLabel jLabel4 = new JLabel(String.valueOf(I18nManager.getText("details.range.avespeed")) + ": ");
        jLabel4.setHorizontalAlignment(4);
        this.add(jLabel4);
        this._aveSpeed1 = new JLabel("11.3 km/h");
        this.add(this._aveSpeed1);
        this._aveSpeed2 = new JLabel("12.3 km/h");
        this.add(this._aveSpeed2);
    }

    public void setDetails(List<IntersectionResult> list, Config config) {
        this._numMatches.setText("" + list.size());
        if (list.size() < 2) {
            this.clearDetails();
            return;
        }
        UnitSet unitSet = config.getUnitSet();
        Unit unit = unitSet.getDistanceUnit();
        String string = I18nManager.getText(unit.getShortnameKey());
        IntersectionResult intersectionResult = list.get(0);
        IntersectionResult intersectionResult2 = list.get(list.size() - 1);
        double d = intersectionResult2.getFirstDistanceRadians(intersectionResult);
        double d2 = Distance.convertRadiansToDistance(d, unit);
        MatchesPanel.setDistance(d2, string, this._distance1);
        double d3 = intersectionResult2.getSecondDistanceRadians(intersectionResult);
        double d4 = Distance.convertRadiansToDistance(d3, unit);
        MatchesPanel.setDistance(d4, string, this._distance2);
        long l = intersectionResult2.getFirstDurationSeconds(intersectionResult);
        this._duration1.setText(DisplayUtils.buildDurationString(l));
        long l2 = intersectionResult2.getSecondDurationSeconds(intersectionResult);
        this._duration2.setText(DisplayUtils.buildDurationString(l2));
        String string2 = I18nManager.getText(unitSet.getSpeedUnit().getShortnameKey());
        this._aveSpeed1.setText(String.valueOf(DisplayUtils.roundedNumber(d2 / (double)l * 3600.0)) + " " + string2);
        this._aveSpeed2.setText(String.valueOf(DisplayUtils.roundedNumber(d4 / (double)l2 * 3600.0)) + " " + string2);
    }

    private void clearDetails() {
        this._distance1.setText("--.--");
        this._distance2.setText("--.--");
        this._duration1.setText("--.--");
        this._duration2.setText("--.--");
        this._aveSpeed1.setText("--.--");
        this._aveSpeed2.setText("--.--");
    }

    private static void setDistance(double d, String string, JLabel jLabel) {
        jLabel.setText(String.valueOf(DisplayUtils.roundedNumber(d)) + " " + string);
    }
}

