/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.colour;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JPanel;
import tim.prune.config.ColourUtils;
import tim.prune.gui.colour.ColourChangeListener;

public class ColourPatch
extends JPanel {
    private final ColourChangeListener _listener;

    public ColourPatch(Color color) {
        this(color, null);
    }

    public ColourPatch(Color color, ColourChangeListener colourChangeListener) {
        Dimension dimension = new Dimension(80, 50);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.setColour(color);
        this._listener = colourChangeListener;
    }

    public void setColour(Color color) {
        if (color != null) {
            super.setBackground(color);
            this.setToolTipText(ColourUtils.makeHexCode(color));
            if (this._listener != null) {
                this._listener.colourChanged();
            }
        }
    }
}

