/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.data.FileType;
import tim.prune.data.SourceInfo;
import tim.prune.load.BabelLoadFunction;
import tim.prune.load.babel.BabelFilterPanel;

public class BabelLoadFromGps
extends BabelLoadFunction {
    private JTextField _deviceField = null;
    private JTextField _formatField = null;

    public BabelLoadFromGps(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.loadfromgps";
    }

    @Override
    protected String getFilePath() {
        return this._deviceField.getText();
    }

    @Override
    protected SourceInfo getSourceInfo() {
        return new SourceInfo(this._deviceField.getText(), FileType.GPSBABEL);
    }

    @Override
    protected String getInputFormat() {
        return this._formatField.getText();
    }

    @Override
    protected boolean isInputOk() {
        return this._waypointCheckbox.isSelected() || this._trackCheckbox.isSelected();
    }

    @Override
    protected JPanel makeDialogComponents(JButton jButton) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 2, 10, 3));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.gpsload.device"));
        jLabel.setHorizontalAlignment(4);
        jPanel3.add(jLabel);
        this._deviceField = new JTextField(this.getConfig().getConfigString("prune.gpsdevice"), 12);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    BabelLoadFromGps.this._dialog.dispose();
                }
            }
        };
        this._deviceField.addKeyListener(keyAdapter);
        jPanel3.add(this._deviceField);
        JLabel jLabel2 = new JLabel(I18nManager.getText("dialog.gpsload.format"));
        jLabel2.setHorizontalAlignment(4);
        jPanel3.add(jLabel2);
        this._formatField = new JTextField(this.getConfig().getConfigString("prune.gpsformat"), 12);
        this._formatField.addKeyListener(keyAdapter);
        jPanel3.add(this._formatField);
        jPanel3.setAlignmentX(0.5f);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 20));
        jPanel2.add(jPanel3);
        ChangeListener changeListener = changeEvent -> this.enableOkButton();
        this._waypointCheckbox = new JCheckBox(I18nManager.getText("dialog.gpsload.getwaypoints"), true);
        this._waypointCheckbox.addChangeListener(changeListener);
        this._waypointCheckbox.setAlignmentX(0.5f);
        jPanel2.add(this._waypointCheckbox);
        this._trackCheckbox = new JCheckBox(I18nManager.getText("dialog.gpsload.gettracks"), true);
        this._trackCheckbox.addChangeListener(changeListener);
        this._trackCheckbox.setAlignmentX(0.5f);
        jPanel2.add(this._trackCheckbox);
        this._saveCheckbox = new JCheckBox(I18nManager.getText("dialog.gpsload.save"));
        this._saveCheckbox.setAlignmentX(0.5f);
        jPanel2.add(this._saveCheckbox);
        this._filterPanel = new BabelFilterPanel(this._parentFrame, this.getIconManager());
        String string = this.getConfig().getConfigString("prune.gpsbabelfilter");
        if (string != null) {
            this._filterPanel.setFilterString(string);
        }
        jPanel2.add(this._filterPanel);
        this._progressBar = new JProgressBar(0, 10);
        jPanel2.add(this._progressBar);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        this._deviceField.addActionListener(actionEvent -> this.okPressed());
        this._formatField.addActionListener(actionEvent -> this.okPressed());
        jPanel4.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.cancel"));
        jButton2.addActionListener(actionEvent -> {
            this._cancelled = true;
            this._dialog.dispose();
        });
        jPanel4.add(jButton2);
        jPanel.add((Component)jPanel4, "South");
        return jPanel;
    }

    @Override
    protected void saveConfigValues() {
        String string = this._deviceField.getText().trim();
        String string2 = this._formatField.getText().trim();
        String string3 = this._filterPanel.getFilterString();
        this.getConfig().setConfigString("prune.gpsdevice", string);
        this.getConfig().setConfigString("prune.gpsformat", string2);
        this.getConfig().setConfigString("prune.gpsbabelfilter", string3);
    }
}

