/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.utils;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtStubBasedElementTypes;
import org.jetbrains.kotlin.com.intellij.util.text.LiteralFormatUtil;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.stubs.ConstantValueKind;
import org.jetbrains.kotlin.psi.stubs.KotlinConstantExpressionStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.utils.NumberWithRadix;
import org.jetbrains.kotlin.utils.NumbersKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0001\u001a\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\f\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u0010\u001a\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u0013\u001a\u000e\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0001\u001a\u0016\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a*\u00020\u001d\u001a\u0016\u0010\u001e\u001a\u00020\u001d*\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a\"\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"hasLongNumericLiteralSuffix", "", "text", "", "hasUnsignedNumericLiteralSuffix", "hasUnsignedLongNumericLiteralSuffix", "hasFloatNumericLiteralSuffix", "parseNumericLiteral", "", "isFloatingPointLiteral", "parseLongNumericLiteral", "", "(Ljava/lang/String;)Ljava/lang/Long;", "parseDecimalNumberLiteral", "parseDouble", "", "(Ljava/lang/String;)Ljava/lang/Double;", "parseFloat", "", "(Ljava/lang/String;)Ljava/lang/Float;", "parseBooleanLiteral", "FP_LITERAL_PARTS", "Lkotlin/text/Regex;", "hasIllegallyPositionedUnderscore", "isFloatingPoint", "toConstantExpressionElementType", "Lorg/jetbrains/kotlin/psi/stubs/elements/KtStubElementType;", "Lorg/jetbrains/kotlin/psi/stubs/KotlinConstantExpressionStub;", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "Lorg/jetbrains/kotlin/psi/stubs/ConstantValueKind;", "toConstantValueKind", "psi-api"})
@JvmName(name="ConstantExpressionUtils")
@SourceDebugExtension(value={"SMAP\nConstantExpressionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstantExpressionUtils.kt\norg/jetbrains/kotlin/psi/utils/ConstantExpressionUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,184:1\n1761#2,3:185\n*S KotlinDebug\n*F\n+ 1 ConstantExpressionUtils.kt\norg/jetbrains/kotlin/psi/utils/ConstantExpressionUtils\n*L\n155#1:185,3\n*E\n"})
public final class ConstantExpressionUtils {
    @NotNull
    private static final Regex FP_LITERAL_PARTS = new Regex("([_\\d]*)\\.?([_\\d]*)e?[+-]?([_\\d]*)[f]?");

    public static final boolean hasLongNumericLiteralSuffix(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return StringsKt.endsWith$default((CharSequence)text, (char)'l', (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)text, (char)'L', (boolean)false, (int)2, null);
    }

    public static final boolean hasUnsignedNumericLiteralSuffix(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return StringsKt.endsWith$default((CharSequence)text, (char)'u', (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)text, (char)'U', (boolean)false, (int)2, null);
    }

    public static final boolean hasUnsignedLongNumericLiteralSuffix(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return StringsKt.endsWith$default((String)text, (String)"ul", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)text, (String)"uL", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)text, (String)"Ul", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)text, (String)"UL", (boolean)false, (int)2, null);
    }

    public static final boolean hasFloatNumericLiteralSuffix(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return StringsKt.endsWith$default((CharSequence)text, (char)'f', (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)text, (char)'F', (boolean)false, (int)2, null);
    }

    @Nullable
    public static final Number parseNumericLiteral(@NotNull String text, boolean isFloatingPointLiteral) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = LiteralFormatUtil.removeUnderscores(text);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"removeUnderscores(...)");
        String canonicalText = string;
        return isFloatingPointLiteral ? (Number)ConstantExpressionUtils.parseDecimalNumberLiteral(canonicalText) : (Number)ConstantExpressionUtils.parseLongNumericLiteral(canonicalText);
    }

    private static final Long parseLongNumericLiteral(String text) {
        Long l2;
        try {
            boolean isUnsigned = false;
            String numberWithoutSuffix = null;
            if (ConstantExpressionUtils.hasUnsignedLongNumericLiteralSuffix(text)) {
                isUnsigned = true;
                numberWithoutSuffix = ConstantExpressionUtils.parseLongNumericLiteral$removeSuffix(text, 2);
            } else if (ConstantExpressionUtils.hasUnsignedNumericLiteralSuffix(text)) {
                isUnsigned = true;
                numberWithoutSuffix = ConstantExpressionUtils.parseLongNumericLiteral$removeSuffix(text, 1);
            } else if (ConstantExpressionUtils.hasLongNumericLiteralSuffix(text)) {
                isUnsigned = false;
                numberWithoutSuffix = ConstantExpressionUtils.parseLongNumericLiteral$removeSuffix(text, 1);
            } else {
                isUnsigned = false;
                numberWithoutSuffix = text;
            }
            NumberWithRadix numberWithRadix = NumbersKt.extractRadix(numberWithoutSuffix);
            String number = numberWithRadix.component1();
            int radix = numberWithRadix.component2();
            l2 = isUnsigned ? Long.parseUnsignedLong(number, radix) : Long.parseLong(number, radix);
        }
        catch (NumberFormatException numberFormatException) {
            l2 = null;
        }
        return l2;
    }

    private static final Number parseDecimalNumberLiteral(String text) {
        if (ConstantExpressionUtils.hasFloatNumericLiteralSuffix(text)) {
            return ConstantExpressionUtils.parseFloat(text);
        }
        return ConstantExpressionUtils.parseDouble(text);
    }

    private static final Double parseDouble(String text) {
        Double d2;
        try {
            d2 = Double.parseDouble(text);
        }
        catch (NumberFormatException numberFormatException) {
            d2 = null;
        }
        return d2;
    }

    private static final Float parseFloat(String text) {
        Float f2;
        try {
            f2 = Float.valueOf(Float.parseFloat(text));
        }
        catch (NumberFormatException numberFormatException) {
            f2 = null;
        }
        return f2;
    }

    public static final boolean parseBooleanLiteral(@NotNull String text) throws IllegalStateException {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = text;
        if (Intrinsics.areEqual((Object)string, (Object)"true")) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)string, (Object)"false")) {
            bl = false;
        } else {
            throw new IllegalStateException('\'' + text + "' is not a valid boolean literal");
        }
        return bl;
    }

    public static final boolean hasIllegallyPositionedUnderscore(@NotNull String text, boolean isFloatingPoint) {
        boolean bl;
        block7: {
            List list;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            if (isFloatingPoint) {
                list = SequencesKt.toList((Sequence)SequencesKt.flatMapIterable((Sequence)Regex.findAll$default((Regex)FP_LITERAL_PARTS, (CharSequence)text, (int)0, (int)2, null), ConstantExpressionUtils::hasIllegallyPositionedUnderscore$lambda$0));
            } else {
                int start = 0;
                int end = text.length();
                if (StringsKt.startsWith((String)text, (String)"0x", (boolean)true) || StringsKt.startsWith((String)text, (String)"0b", (boolean)true)) {
                    start += 2;
                }
                if (StringsKt.endsWith((CharSequence)text, (char)'l', (boolean)true)) {
                    --end;
                }
                String string = text.substring(start, end);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                list = CollectionsKt.listOf((Object)string);
            }
            List parts = list;
            Iterable $this$any$iv = parts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(it != null && (StringsKt.startsWith$default((String)it, (String)"_", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it, (String)"_", (boolean)false, (int)2, null)))) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final KtStubElementType<KotlinConstantExpressionStub, KtConstantExpression> toConstantExpressionElementType(@NotNull ConstantValueKind $this$toConstantExpressionElementType) {
        KtStubElementType<KotlinConstantExpressionStub, KtConstantExpression> ktStubElementType;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toConstantExpressionElementType), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toConstantExpressionElementType.ordinal()]) {
            case 1: {
                ktStubElementType = KtStubBasedElementTypes.NULL;
                break;
            }
            case 2: {
                ktStubElementType = KtStubBasedElementTypes.BOOLEAN_CONSTANT;
                break;
            }
            case 3: {
                ktStubElementType = KtStubBasedElementTypes.FLOAT_CONSTANT;
                break;
            }
            case 4: {
                ktStubElementType = KtStubBasedElementTypes.CHARACTER_CONSTANT;
                break;
            }
            case 5: {
                ktStubElementType = KtStubBasedElementTypes.INTEGER_CONSTANT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return ktStubElementType;
    }

    @NotNull
    public static final ConstantValueKind toConstantValueKind(@NotNull KtStubElementType<KotlinConstantExpressionStub, KtConstantExpression> $this$toConstantValueKind) {
        ConstantValueKind constantValueKind;
        Intrinsics.checkNotNullParameter($this$toConstantValueKind, (String)"<this>");
        KtStubElementType<KotlinConstantExpressionStub, KtConstantExpression> ktStubElementType = $this$toConstantValueKind;
        if (Intrinsics.areEqual(ktStubElementType, KtStubBasedElementTypes.NULL)) {
            constantValueKind = ConstantValueKind.NULL;
        } else if (Intrinsics.areEqual(ktStubElementType, KtStubBasedElementTypes.BOOLEAN_CONSTANT)) {
            constantValueKind = ConstantValueKind.BOOLEAN_CONSTANT;
        } else if (Intrinsics.areEqual(ktStubElementType, KtStubBasedElementTypes.FLOAT_CONSTANT)) {
            constantValueKind = ConstantValueKind.FLOAT_CONSTANT;
        } else if (Intrinsics.areEqual(ktStubElementType, KtStubBasedElementTypes.CHARACTER_CONSTANT)) {
            constantValueKind = ConstantValueKind.CHARACTER_CONSTANT;
        } else if (Intrinsics.areEqual(ktStubElementType, KtStubBasedElementTypes.INTEGER_CONSTANT)) {
            constantValueKind = ConstantValueKind.INTEGER_CONSTANT;
        } else {
            throw new IllegalArgumentException("Unknown constant node type: " + $this$toConstantValueKind);
        }
        return constantValueKind;
    }

    private static final String parseLongNumericLiteral$removeSuffix(String $this$parseLongNumericLiteral_u24removeSuffix, int i2) {
        String string = $this$parseLongNumericLiteral_u24removeSuffix.substring(0, $this$parseLongNumericLiteral_u24removeSuffix.length() - i2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private static final Iterable hasIllegallyPositionedUnderscore$lambda$0(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getGroupValues();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConstantValueKind.values().length];
            try {
                nArray[ConstantValueKind.NULL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantValueKind.BOOLEAN_CONSTANT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantValueKind.FLOAT_CONSTANT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantValueKind.CHARACTER_CONSTANT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantValueKind.INTEGER_CONSTANT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

