/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.simple;

import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ModuleIdExclude;
import org.gradle.internal.component.model.IvyArtifactName;

final class DefaultModuleIdExclude
implements ModuleIdExclude {
    private final ModuleIdentifier moduleId;
    private final int hashCode;

    static ModuleIdExclude of(ModuleIdentifier id) {
        return new DefaultModuleIdExclude(id);
    }

    private DefaultModuleIdExclude(ModuleIdentifier moduleId) {
        this.moduleId = moduleId;
        this.hashCode = moduleId.hashCode();
    }

    @Override
    public ModuleIdentifier getModuleId() {
        return this.moduleId;
    }

    @Override
    public boolean excludes(ModuleIdentifier module) {
        return this.moduleId.equals(module);
    }

    @Override
    public boolean excludesArtifact(ModuleIdentifier module, IvyArtifactName artifactName) {
        return false;
    }

    @Override
    public boolean mayExcludeArtifacts() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultModuleIdExclude that = (DefaultModuleIdExclude)o;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        return this.moduleId.equals(that.moduleId);
    }

    public int hashCode() {
        return this.moduleId.hashCode();
    }

    public String toString() {
        return "{\"exclude module id\" : \"" + this.moduleId + "\"}";
    }
}

