/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts;

import java.util.List;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.Conflict;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.GraphValidationException;
import org.gradle.internal.exceptions.ResolutionProvider;

public class VersionConflictException
extends GraphValidationException
implements ResolutionProvider {
    private final List<String> resolutions;

    public VersionConflictException(Conflict conflict, List<String> resolutions) {
        super(VersionConflictException.buildMessage(conflict));
        this.resolutions = resolutions;
    }

    private static String buildMessage(Conflict conflict) {
        String conflictDescription = VersionConflictException.getConflictDescription(conflict);
        ModuleIdentifier moduleId = conflict.getModuleId();
        return "Conflict found for module '" + moduleId.getGroup() + ":" + moduleId.getName() + "': " + conflictDescription;
    }

    private static String getConflictDescription(Conflict conflict) {
        String conflictDescription = null;
        for (ComponentSelectionDescriptor description : conflict.getSelectionReason().getDescriptions()) {
            if (!description.getCause().equals((Object)ComponentSelectionCause.CONFLICT_RESOLUTION)) continue;
            conflictDescription = description.getDescription();
        }
        assert (conflictDescription != null);
        return conflictDescription;
    }

    public List<String> getResolutions() {
        return this.resolutions;
    }
}

