/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.metadata;

import java.util.List;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleDescriptorHashModuleSource;
import org.gradle.api.internal.artifacts.repositories.metadata.MetadataSource;
import org.gradle.api.internal.artifacts.repositories.metadata.MutableModuleMetadataFactory;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourcePattern;
import org.gradle.api.internal.artifacts.repositories.resolver.VersionLister;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleVersionListingResolveResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultArtifactMetadataSource
implements MetadataSource<MutableModuleComponentResolveMetadata> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalResourceResolver.class);
    private final MutableModuleMetadataFactory<? extends MutableModuleComponentResolveMetadata> mutableModuleMetadataFactory;

    public DefaultArtifactMetadataSource(MutableModuleMetadataFactory<? extends MutableModuleComponentResolveMetadata> mutableModuleMetadataFactory) {
        this.mutableModuleMetadataFactory = mutableModuleMetadataFactory;
    }

    @Override
    public MutableModuleComponentResolveMetadata create(String repositoryName, ComponentResolvers componentResolvers, ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata prescribedMetaData, ExternalResourceArtifactResolver artifactResolver, BuildableModuleComponentMetaDataResolveResult<ModuleComponentResolveMetadata> result) {
        IvyArtifactName artifact = DefaultArtifactMetadataSource.getPrimaryArtifact(moduleComponentIdentifier, prescribedMetaData);
        if (!artifactResolver.artifactExists(new DefaultModuleComponentArtifactMetadata(moduleComponentIdentifier, artifact), result)) {
            return null;
        }
        LOGGER.debug("Using default metadata for artifact in module '{}' and repository '{}'.", (Object)moduleComponentIdentifier, (Object)repositoryName);
        MutableModuleComponentResolveMetadata metadata = this.mutableModuleMetadataFactory.missing(moduleComponentIdentifier);
        HashCode descriptorHash = Hashing.md5().hashString((CharSequence)moduleComponentIdentifier.toString());
        metadata.getSources().add(new ModuleDescriptorHashModuleSource(descriptorHash, false));
        return metadata;
    }

    private static IvyArtifactName getPrimaryArtifact(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata overrideMetadata) {
        if (overrideMetadata.getArtifact() != null) {
            return overrideMetadata.getArtifact();
        }
        return new DefaultIvyArtifactName(moduleComponentIdentifier.getModule(), "jar", "jar");
    }

    @Override
    public void listModuleVersions(ModuleComponentSelector selector, ComponentOverrideMetadata overrideMetadata, List<ResourcePattern> ivyPatterns, List<ResourcePattern> artifactPatterns, VersionLister versionLister, BuildableModuleVersionListingResolveResult result) {
        IvyArtifactName dependencyArtifact = DefaultArtifactMetadataSource.getPrimaryArtifact(selector, overrideMetadata);
        versionLister.listVersions(selector.getModuleIdentifier(), dependencyArtifact, artifactPatterns, result);
    }

    private static IvyArtifactName getPrimaryArtifact(ModuleComponentSelector selector, ComponentOverrideMetadata overrideMetadata) {
        if (overrideMetadata.getArtifact() != null) {
            return overrideMetadata.getArtifact();
        }
        return new DefaultIvyArtifactName(selector.getModule(), "jar", "jar");
    }
}

