/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.bindingContextUtil;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000|\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\n\u001a\u00020\u000b*\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b\u001a\u0012\u0010\u000f\u001a\u00020\b*\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0011\u001a\u00020\b*\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0004\u001a*\u0010\u0012\u001a\u00020\u000b\"\u000e\b\u0000\u0010\u0013*\b\u0012\u0004\u0012\u0002H\u00130\u0014*\b\u0012\u0004\u0012\u0002H\u00130\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0010\u001a\u001c\u0010\u0016\u001a\u00020\u000b*\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\t\u001a\u0012\u0010\u001a\u001a\u00020\u001b*\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u0012\u0010\u001e\u001a\u00020\u001b*\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u0018\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 *\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\"\u001a\u0004\u0018\u00010#*\u00020$2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\"\u001a\u0004\u0018\u00010#*\u00020%2\u0006\u0010\u0003\u001a\u00020\u0004\u001a?\u0010&\u001a\u0004\u0018\u0001H'\"\b\b\u0000\u0010'*\u00020\u001d*\u00020\t2\"\u0010(\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u0002H'0*0)\"\n\u0012\u0006\b\u0001\u0012\u0002H'0*\u00a2\u0006\u0002\u0010+\u001a\u0016\u0010,\u001a\u00020!2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\t\u001a \u0010-\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010.\u001a\u00020\b\u001a\u0016\u0010/\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u00060"}, d2={"getTargetFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getTargetFunction", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "isUsedAsExpression", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "recordUsedAsExpression", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "value", "isUsedAsResultOfLambda", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isUsedAsStatement", "recordDataFlowInfo", "C", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "expression", "recordScope", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "element", "getDataFlowInfoAfter", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "position", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "getDataFlowInfoBefore", "getReferenceTargets", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getAbbreviatedTypeOrType", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "getParentOfTypeCodeFragmentAware", "T", "parentClasses", "", "Ljava/lang/Class;", "(Lorg/jetbrains/kotlin/psi/KtElement;[Ljava/lang/Class;)Lcom/intellij/psi/PsiElement;", "getEnclosingDescriptor", "getEnclosingFunctionDescriptor", "skipInlineFunctionLiterals", "isInlineableFunctionLiteral", "frontend"})
@SourceDebugExtension(value={"SMAP\nBindingContextUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BindingContextUtils.kt\norg/jetbrains/kotlin/resolve/bindingContextUtil/BindingContextUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,204:1\n1#2:205\n253#3:206\n1761#4,3:207\n*S KotlinDebug\n*F\n+ 1 BindingContextUtils.kt\norg/jetbrains/kotlin/resolve/bindingContextUtil/BindingContextUtilsKt\n*L\n48#1:206\n198#1:207,3\n*E\n"})
public final class BindingContextUtilsKt {
    @Nullable
    public static final FunctionDescriptor getTargetFunctionDescriptor(@NotNull KtReturnExpression $this$getTargetFunctionDescriptor, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$getTargetFunctionDescriptor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KtSimpleNameExpression targetLabel = $this$getTargetFunctionDescriptor.getTargetLabel();
        if (targetLabel != null) {
            SimpleFunctionDescriptor simpleFunctionDescriptor;
            PsiElement psiElement = (PsiElement)context2.get(BindingContext.LABEL_TARGET, targetLabel);
            if (psiElement != null) {
                PsiElement it = psiElement;
                boolean bl = false;
                simpleFunctionDescriptor = (SimpleFunctionDescriptor)context2.get(BindingContext.FUNCTION, it);
            } else {
                simpleFunctionDescriptor = null;
            }
            return simpleFunctionDescriptor;
        }
        PsiElement $this$getNonStrictParentOfType$iv = $this$getTargetFunctionDescriptor;
        boolean $i$f$getNonStrictParentOfType = false;
        DeclarationDescriptor declarationDescriptor = context2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv, KtDeclarationWithBody.class, false));
        FunctionDescriptor functionDescriptor = DescriptorUtils.getParentOfType(declarationDescriptor, FunctionDescriptor.class, false);
        if (functionDescriptor == null) {
            return null;
        }
        FunctionDescriptor containingFunctionDescriptor = functionDescriptor;
        return (FunctionDescriptor)SequencesKt.firstOrNull((Sequence)SequencesKt.dropWhile((Sequence)SequencesKt.generateSequence((Object)containingFunctionDescriptor, BindingContextUtilsKt::getTargetFunctionDescriptor$lambda$1), BindingContextUtilsKt::getTargetFunctionDescriptor$lambda$2));
    }

    @Nullable
    public static final KtCallableDeclaration getTargetFunction(@NotNull KtReturnExpression $this$getTargetFunction, @NotNull BindingContext context2) {
        KtCallableDeclaration ktCallableDeclaration;
        Intrinsics.checkNotNullParameter((Object)$this$getTargetFunction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FunctionDescriptor functionDescriptor = BindingContextUtilsKt.getTargetFunctionDescriptor($this$getTargetFunction, context2);
        if (functionDescriptor != null) {
            FunctionDescriptor it = functionDescriptor;
            boolean bl = false;
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(it);
            ktCallableDeclaration = psiElement instanceof KtCallableDeclaration ? (KtCallableDeclaration)psiElement : null;
        } else {
            ktCallableDeclaration = null;
        }
        return ktCallableDeclaration;
    }

    public static final boolean isUsedAsExpression(@NotNull KtElement $this$isUsedAsExpression, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$isUsedAsExpression, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Boolean bl = (Boolean)context2.get(BindingContext.USED_AS_EXPRESSION, $this$isUsedAsExpression);
        return bl != null ? bl : false;
    }

    public static final void recordUsedAsExpression(@NotNull KtElement $this$recordUsedAsExpression, @NotNull BindingTrace trace, boolean value2) {
        Intrinsics.checkNotNullParameter((Object)$this$recordUsedAsExpression, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        if (BindingContextUtilsKt.isUsedAsExpression($this$recordUsedAsExpression, bindingContext)) {
            return;
        }
        trace.record(BindingContext.USED_AS_EXPRESSION, $this$recordUsedAsExpression, value2);
    }

    public static final boolean isUsedAsResultOfLambda(@NotNull KtExpression $this$isUsedAsResultOfLambda, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$isUsedAsResultOfLambda, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object v2 = context2.get(BindingContext.USED_AS_RESULT_OF_LAMBDA, $this$isUsedAsResultOfLambda);
        Intrinsics.checkNotNull(v2);
        return (Boolean)v2;
    }

    public static final boolean isUsedAsStatement(@NotNull KtExpression $this$isUsedAsStatement, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$isUsedAsStatement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return !BindingContextUtilsKt.isUsedAsExpression($this$isUsedAsStatement, context2);
    }

    public static final <C extends ResolutionContext<C>> void recordDataFlowInfo(@NotNull ResolutionContext<C> $this$recordDataFlowInfo, @Nullable KtExpression expression2) {
        Intrinsics.checkNotNullParameter($this$recordDataFlowInfo, (String)"<this>");
        if (expression2 == null) {
            return;
        }
        KotlinTypeInfo typeInfo = (KotlinTypeInfo)$this$recordDataFlowInfo.trace.get(BindingContext.EXPRESSION_TYPE_INFO, expression2);
        if (typeInfo != null) {
            BindingTrace bindingTrace = $this$recordDataFlowInfo.trace;
            DataFlowInfo dataFlowInfo = $this$recordDataFlowInfo.dataFlowInfo;
            Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"dataFlowInfo");
            bindingTrace.record(BindingContext.EXPRESSION_TYPE_INFO, expression2, typeInfo.replaceDataFlowInfo(dataFlowInfo));
        } else if (!Intrinsics.areEqual((Object)$this$recordDataFlowInfo.dataFlowInfo, (Object)DataFlowInfo.Companion.getEMPTY())) {
            BindingTrace bindingTrace = $this$recordDataFlowInfo.trace;
            DataFlowInfo dataFlowInfo = $this$recordDataFlowInfo.dataFlowInfo;
            Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"dataFlowInfo");
            bindingTrace.record(BindingContext.EXPRESSION_TYPE_INFO, expression2, TypeInfoFactoryKt.noTypeInfo(dataFlowInfo));
        }
    }

    public static final void recordScope(@NotNull BindingTrace $this$recordScope, @NotNull LexicalScope scope2, @Nullable KtElement element) {
        Intrinsics.checkNotNullParameter((Object)$this$recordScope, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        if (element != null) {
            HierarchicalScope hierarchicalScope = ScopeUtilsKt.takeSnapshot(scope2);
            Intrinsics.checkNotNull((Object)hierarchicalScope, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.LexicalScope");
            $this$recordScope.record(BindingContext.LEXICAL_SCOPE, element, (LexicalScope)hierarchicalScope);
        }
    }

    @NotNull
    public static final DataFlowInfo getDataFlowInfoAfter(@NotNull BindingContext $this$getDataFlowInfoAfter, @NotNull PsiElement position) {
        Intrinsics.checkNotNullParameter((Object)$this$getDataFlowInfoAfter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        for (PsiElement element : PsiUtilsKt.getParentsWithSelf(position)) {
            KtExpression ktExpression = element instanceof KtExpression ? (KtExpression)element : null;
            if (ktExpression == null) continue;
            Object it = ktExpression;
            boolean bl = false;
            PsiElement parent2 = it.getParent();
            KotlinTypeInfo kotlinTypeInfo = parent2 instanceof KtQualifiedExpression && Intrinsics.areEqual((Object)it, (Object)((KtQualifiedExpression)parent2).getSelectorExpression()) ? null : (KotlinTypeInfo)$this$getDataFlowInfoAfter.get(BindingContext.EXPRESSION_TYPE_INFO, it);
            if (kotlinTypeInfo == null) continue;
            it = kotlinTypeInfo;
            boolean bl2 = false;
            return ((KotlinTypeInfo)it).getDataFlowInfo();
        }
        return DataFlowInfo.Companion.getEMPTY();
    }

    @NotNull
    public static final DataFlowInfo getDataFlowInfoBefore(@NotNull BindingContext $this$getDataFlowInfoBefore, @NotNull PsiElement position) {
        Intrinsics.checkNotNullParameter((Object)$this$getDataFlowInfoBefore, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        for (PsiElement element : PsiUtilsKt.getParentsWithSelf(position)) {
            KtExpression ktExpression = element instanceof KtExpression ? (KtExpression)element : null;
            if (ktExpression == null) continue;
            Object it = ktExpression;
            boolean bl = false;
            DataFlowInfo dataFlowInfo = (DataFlowInfo)$this$getDataFlowInfoBefore.get(BindingContext.DATA_FLOW_INFO_BEFORE, it);
            if (dataFlowInfo == null) continue;
            it = dataFlowInfo;
            boolean bl2 = false;
            return it;
        }
        return DataFlowInfo.Companion.getEMPTY();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Collection<DeclarationDescriptor> getReferenceTargets(@NotNull KtExpression $this$getReferenceTargets, @NotNull BindingContext context2) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)$this$getReferenceTargets, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        DeclarationDescriptor targetDescriptor = $this$getReferenceTargets instanceof KtReferenceExpression ? (DeclarationDescriptor)context2.get(BindingContext.REFERENCE_TARGET, $this$getReferenceTargets) : null;
        Object object = targetDescriptor;
        if (object != null) {
            DeclarationDescriptor it = object;
            boolean bl = false;
            List list = CollectionsKt.listOf((Object)it);
            object = list;
            if (list != null) {
                collection = (Collection)object;
                return collection;
            }
        }
        Collection collection2 = (Collection)context2.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, $this$getReferenceTargets);
        collection = collection2;
        if (collection2 != null) return collection;
        collection = CollectionsKt.emptyList();
        return collection;
    }

    @Nullable
    public static final KotlinType getAbbreviatedTypeOrType(@NotNull KtTypeReference $this$getAbbreviatedTypeOrType, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$getAbbreviatedTypeOrType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KotlinType kotlinType = (KotlinType)context2.get(BindingContext.ABBREVIATED_TYPE, $this$getAbbreviatedTypeOrType);
        if (kotlinType == null) {
            kotlinType = (KotlinType)context2.get(BindingContext.TYPE, $this$getAbbreviatedTypeOrType);
        }
        return kotlinType;
    }

    @Nullable
    public static final KotlinType getAbbreviatedTypeOrType(@NotNull KtTypeElement $this$getAbbreviatedTypeOrType, @NotNull BindingContext context2) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$getAbbreviatedTypeOrType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        PsiElement parent2 = $this$getAbbreviatedTypeOrType.getParent();
        if (parent2 instanceof KtTypeReference) {
            kotlinType = BindingContextUtilsKt.getAbbreviatedTypeOrType((KtTypeReference)parent2, context2);
        } else if (parent2 instanceof KtNullableType) {
            KotlinType outerType = BindingContextUtilsKt.getAbbreviatedTypeOrType((KtTypeElement)parent2, context2);
            if ($this$getAbbreviatedTypeOrType instanceof KtNullableType) {
                kotlinType = outerType;
            } else {
                KotlinType kotlinType2 = outerType;
                kotlinType = kotlinType2 != null ? TypeUtilsKt.makeNotNullable(kotlinType2) : null;
            }
        } else {
            kotlinType = null;
        }
        return kotlinType;
    }

    @Nullable
    public static final <T extends PsiElement> T getParentOfTypeCodeFragmentAware(@NotNull KtElement $this$getParentOfTypeCodeFragmentAware, Class<? extends T> ... parentClasses) {
        PsiElement context2;
        Intrinsics.checkNotNullParameter((Object)$this$getParentOfTypeCodeFragmentAware, (String)"<this>");
        Intrinsics.checkNotNullParameter(parentClasses, (String)"parentClasses");
        T t2 = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfTypeCodeFragmentAware, Arrays.copyOf(parentClasses, parentClasses.length));
        if (t2 != null) {
            T it = t2;
            boolean bl = false;
            return it;
        }
        PsiFile containingFile = $this$getParentOfTypeCodeFragmentAware.getContainingFile();
        if (containingFile instanceof KtCodeFragment && (context2 = ((KtCodeFragment)containingFile).getContext()) != null) {
            return PsiTreeUtil.getParentOfType(context2, Arrays.copyOf(parentClasses, parentClasses.length));
        }
        return null;
    }

    @NotNull
    public static final DeclarationDescriptor getEnclosingDescriptor(@NotNull BindingContext context2, @NotNull KtElement element) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Class[] classArray = new Class[]{KtNamedDeclaration.class};
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)BindingContextUtilsKt.getParentOfTypeCodeFragmentAware(element, classArray);
        if (ktNamedDeclaration == null) {
            throw new KotlinExceptionWithAttachments("No parent KtNamedDeclaration for of type " + element.getClass()).withPsiAttachment("element.kt", element);
        }
        KtNamedDeclaration declaration = ktNamedDeclaration;
        if (declaration instanceof KtFunctionLiteral) {
            declarationDescriptor = BindingContextUtilsKt.getEnclosingDescriptor(context2, declaration);
        } else {
            declarationDescriptor = context2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, declaration);
            if (declarationDescriptor == null) {
                throw new KotlinExceptionWithAttachments("No descriptor for named declaration of type " + declaration.getClass()).withPsiAttachment("declaration.kt", declaration);
            }
        }
        return declarationDescriptor;
    }

    @Nullable
    public static final FunctionDescriptor getEnclosingFunctionDescriptor(@NotNull BindingContext context2, @NotNull KtElement element, boolean skipInlineFunctionLiterals) {
        DeclarationDescriptor descriptor;
        block2: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtElement current = element;
                while (true) {
                    Class[] classArray = new Class[]{KtFunction.class, KtClassOrObject.class};
                    KtTypeParameterListOwner functionOrClass = (KtTypeParameterListOwner)BindingContextUtilsKt.getParentOfTypeCodeFragmentAware(current, classArray);
                    descriptor = context2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, functionOrClass);
                    if (!(functionOrClass instanceof KtFunction)) break block2;
                    if (!(descriptor instanceof FunctionDescriptor)) break block3;
                    if (!skipInlineFunctionLiterals) break;
                    KtTypeParameterListOwner ktTypeParameterListOwner = functionOrClass;
                    KtFunctionLiteral ktFunctionLiteral = ktTypeParameterListOwner instanceof KtFunctionLiteral ? (KtFunctionLiteral)ktTypeParameterListOwner : null;
                    PsiElement psiElement = ktFunctionLiteral != null ? ktFunctionLiteral.getParent() : null;
                    KtExpression ktExpression = psiElement instanceof KtExpression ? (KtExpression)psiElement : null;
                    if (ktExpression == null) {
                        ktExpression = functionOrClass;
                    }
                    if (!BindingContextUtilsKt.isInlineableFunctionLiteral(ktExpression, context2)) break;
                    current = functionOrClass;
                }
                return (FunctionDescriptor)descriptor;
            }
            return null;
        }
        return descriptor instanceof ClassDescriptor ? (FunctionDescriptor)((ClassDescriptor)descriptor).getUnsubstitutedPrimaryConstructor() : null;
    }

    public static final boolean isInlineableFunctionLiteral(@NotNull KtExpression expression2, @NotNull BindingContext context2) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(expression2 instanceof KtLambdaExpression || expression2 instanceof KtNamedFunction && ((KtNamedFunction)expression2).getName() == null)) {
            return false;
        }
        PsiElement wrapper = expression2;
        while (Intrinsics.areEqual((Object)KtPsiUtil.deparenthesizeOnce((psiElement = wrapper.getParent()) instanceof KtExpression ? (KtExpression)psiElement : null), (Object)wrapper)) {
            Intrinsics.checkNotNullExpressionValue((Object)wrapper.getParent(), (String)"getParent(...)");
        }
        PsiElement psiElement2 = wrapper.getParent();
        KtValueArgument ktValueArgument = psiElement2 instanceof KtValueArgument ? (KtValueArgument)psiElement2 : null;
        if (ktValueArgument == null) {
            return false;
        }
        KtValueArgument argument = ktValueArgument;
        Object object = argument.getParent();
        KtValueArgumentList ktValueArgumentList = object instanceof KtValueArgumentList ? (KtValueArgumentList)object : null;
        PsiElement psiElement3 = (ktValueArgumentList != null ? (KtElementImplStub)ktValueArgumentList : (KtElementImplStub)argument).getParent();
        KtCallExpression ktCallExpression = psiElement3 instanceof KtCallExpression ? (KtCallExpression)psiElement3 : null;
        if (ktCallExpression == null) {
            return false;
        }
        KtCallExpression call2 = ktCallExpression;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(call2, context2);
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        object = resolvedCall3.getResultingDescriptor();
        FunctionDescriptor functionDescriptor = object instanceof FunctionDescriptor ? (FunctionDescriptor)object : null;
        if (functionDescriptor == null) {
            return false;
        }
        FunctionDescriptor descriptor = functionDescriptor;
        if (descriptor.isInline()) {
            ValueParameterDescriptor valueParameterDescriptor;
            Object v7;
            block13: {
                Iterable iterable = resolvedCall3.getValueArguments().entrySet();
                for (Object t2 : iterable) {
                    boolean bl;
                    block12: {
                        Map.Entry entry = (Map.Entry)t2;
                        boolean bl2 = false;
                        ResolvedValueArgument valueArgument = (ResolvedValueArgument)entry.getValue();
                        List<ValueArgument> list = valueArgument.getArguments();
                        Intrinsics.checkNotNullExpressionValue(list, (String)"getArguments(...)");
                        Iterable $this$any$iv = list;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                ValueArgument it = (ValueArgument)element$iv;
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual((Object)it.asElement(), (Object)argument)) continue;
                                bl = true;
                                break block12;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    v7 = t2;
                    break block13;
                }
                v7 = null;
            }
            object = v7;
            if (object == null || (valueParameterDescriptor = (ValueParameterDescriptor)object.getKey()) == null) {
                return false;
            }
            ValueParameterDescriptor parameter = valueParameterDescriptor;
            return !parameter.isNoinline() && !parameter.isCrossinline();
        }
        return false;
    }

    private static final FunctionDescriptor getTargetFunctionDescriptor$lambda$1(FunctionDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DescriptorUtils.getParentOfType(it, FunctionDescriptor.class);
    }

    private static final boolean getTargetFunctionDescriptor$lambda$2(FunctionDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof AnonymousFunctionDescriptor;
    }
}

