/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/SelfCallInNestedObjectConstructorChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "Visitor", "frontend"})
public final class SelfCallInNestedObjectConstructorChecker
implements CallChecker {
    @NotNull
    public static final SelfCallInNestedObjectConstructorChecker INSTANCE = new SelfCallInNestedObjectConstructorChecker();

    private SelfCallInNestedObjectConstructorChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        block5: {
            Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
            Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Object obj = resolvedCall2.getCandidateDescriptor();
            Intrinsics.checkNotNullExpressionValue(obj, (String)"getCandidateDescriptor(...)");
            Object candidateDescriptor = obj;
            Call call2 = resolvedCall2.getCall();
            Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"getCall(...)");
            Call call3 = call2;
            if (!(candidateDescriptor instanceof ConstructorDescriptor) || !CallResolverUtilKt.isSuperOrDelegatingConstructorCall(call3)) {
                return;
            }
            DeclarationDescriptor declarationDescriptor = context2.getResolutionContext().scope.getOwnerDescriptor().getContainingDeclaration();
            ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
            if (classDescriptor == null) {
                return;
            }
            ClassDescriptor constructedObject = classDescriptor;
            if (constructedObject.getKind() != ClassKind.OBJECT) {
                return;
            }
            DeclarationDescriptor declarationDescriptor2 = constructedObject.getContainingDeclaration();
            ClassDescriptor classDescriptor2 = declarationDescriptor2 instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor2 : null;
            if (classDescriptor2 == null) {
                return;
            }
            ClassDescriptor containingClass = classDescriptor2;
            if (!Intrinsics.areEqual((Object)((ConstructorDescriptor)candidateDescriptor).getConstructedClass(), (Object)containingClass)) break block5;
            Visitor visitor2 = new Visitor(containingClass, context2.getTrace(), context2.getLanguageVersionSettings());
            KtValueArgumentList ktValueArgumentList = resolvedCall2.getCall().getValueArgumentList();
            if (ktValueArgumentList != null) {
                ktValueArgumentList.accept(visitor2);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\u001a\u0010\u0019\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/SelfCallInNestedObjectConstructorChecker$Visitor;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "containingClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "<init>", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "getContainingClass", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getTrace", "()Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "visitKtElement", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "visitExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkArgument", "argumentExpression", "checkReceiver", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "argument", "frontend"})
    private static final class Visitor
    extends KtVisitorVoid {
        @NotNull
        private final ClassDescriptor containingClass;
        @NotNull
        private final BindingTrace trace;
        @NotNull
        private final LanguageVersionSettings languageVersionSettings;

        public Visitor(@NotNull ClassDescriptor containingClass, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings) {
            Intrinsics.checkNotNullParameter((Object)containingClass, (String)"containingClass");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
            this.containingClass = containingClass;
            this.trace = trace;
            this.languageVersionSettings = languageVersionSettings;
        }

        @NotNull
        public final ClassDescriptor getContainingClass() {
            return this.containingClass;
        }

        @NotNull
        public final BindingTrace getTrace() {
            return this.trace;
        }

        @NotNull
        public final LanguageVersionSettings getLanguageVersionSettings() {
            return this.languageVersionSettings;
        }

        @Override
        public void visitKtElement(@NotNull KtElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            element.acceptChildren(this, null);
        }

        @Override
        public void visitExpression(@NotNull KtExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.checkArgument(expression2);
            expression2.acceptChildren(this, null);
        }

        private final void checkArgument(KtExpression argumentExpression) {
            KtElement ktElement = argumentExpression;
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
            Call call2 = CallUtilKt.getCall(ktElement, bindingContext);
            if (call2 == null) {
                return;
            }
            Call call3 = call2;
            BindingContext bindingContext2 = this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext2, (String)"getBindingContext(...)");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(call3, bindingContext2);
            if (resolvedCall2 == null) {
                return;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            this.checkReceiver(resolvedCall3.getDispatchReceiver(), argumentExpression);
        }

        private final void checkReceiver(ReceiverValue receiver, KtExpression argument) {
            Object object = receiver;
            if (object == null || (object = object.getType()) == null) {
                return;
            }
            Object receiverType = object;
            ClassifierDescriptor classifierDescriptor = ((KotlinType)receiverType).getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
            if (classDescriptor == null) {
                return;
            }
            ClassDescriptor receiverClass = classDescriptor;
            if (DescriptorUtils.isSubclass(receiverClass, this.containingClass)) {
                this.trace.report(Errors.SELF_CALL_IN_NESTED_OBJECT_CONSTRUCTOR.on(this.languageVersionSettings, (KtExpression)((PsiElement)argument)));
            }
        }
    }
}

