/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.logging.events.EndOutputEvent;
import org.gradle.internal.logging.events.InteractiveEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.UpdateNowEvent;
import org.gradle.internal.time.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottlingOutputEventListener
implements OutputEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThrottlingOutputEventListener.class);
    private final OutputEventListener listener;
    private final ScheduledExecutorService executor;
    private final Clock clock;
    private final int throttleMs;
    private final Object lock = new Object();
    private final List<OutputEvent> queue = new ArrayList<OutputEvent>();

    public ThrottlingOutputEventListener(OutputEventListener listener, Clock clock) {
        this(listener, Integer.getInteger("org.gradle.internal.console.throttle", 100), Executors.newSingleThreadScheduledExecutor(), clock);
    }

    ThrottlingOutputEventListener(OutputEventListener listener, int throttleMs, ScheduledExecutorService executor, Clock clock) {
        this.throttleMs = throttleMs;
        this.listener = listener;
        this.executor = executor;
        this.clock = clock;
        this.scheduleUpdateNow();
    }

    private void scheduleUpdateNow() {
        ScheduledFuture<?> ignored = this.executor.scheduleAtFixedRate(() -> {
            try {
                this.onOutput(new UpdateNowEvent(this.clock.getCurrentTime()));
            }
            catch (Throwable t) {
                LOGGER.debug("Exception while displaying output", t);
            }
        }, this.throttleMs, this.throttleMs, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOutput(OutputEvent newEvent) {
        Object object = this.lock;
        synchronized (object) {
            this.queue.add(newEvent);
            if (this.queue.size() == 10000) {
                this.renderNow();
                return;
            }
            if (newEvent instanceof InteractiveEvent) {
                this.renderNow();
                return;
            }
            if (newEvent instanceof EndOutputEvent) {
                this.renderNow();
                this.executor.shutdown();
            }
        }
    }

    private void renderNow() {
        while (!this.queue.isEmpty()) {
            OutputEvent event = this.queue.remove(0);
            this.listener.onOutput(event);
        }
    }
}

