/*
 * Copyright 2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.initialization;

import org.gradle.internal.DisplayName;

/**
 * Details about the origin of the contents of the ClassLoader scope.
 */
public interface ClassLoaderScopeOrigin {
    class Script implements ClassLoaderScopeOrigin {
        private final String fileName;
        private final DisplayName longDisplayName;
        private final DisplayName shortDisplayName;

        public Script(String fileName, DisplayName longDisplayName, DisplayName shortDisplayName) {
            this.fileName = fileName;
            this.longDisplayName = longDisplayName;
            this.shortDisplayName = shortDisplayName;
        }

        public String getFileName() {
            return fileName;
        }

        public DisplayName getLongDisplayName() {
            return longDisplayName;
        }

        public DisplayName getShortDisplayName() {
            return shortDisplayName;
        }

        @Override
        public int hashCode() {
            return fileName.hashCode() ^ longDisplayName.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != getClass()) {
                return false;
            }
            Script other = (Script) obj;
            return fileName.equals(other.fileName) && longDisplayName.equals(other.longDisplayName);
        }
    }
}
