/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import java.lang.reflect.Modifier;
import org.codehaus.groovy.reflection.CachedField;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class MetaBeanProperty
extends MetaProperty {
    private MetaMethod getter;
    private MetaMethod setter;
    private CachedField field;

    public MetaBeanProperty(String name, Class type, MetaMethod getter, MetaMethod setter) {
        super(name, type);
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public int getModifiers() {
        int modifiers;
        MetaMethod getter = this.getGetter();
        MetaMethod setter = this.getSetter();
        int staticAndVisibility = 15;
        if (getter == null) {
            modifiers = setter.getModifiers() & 0xF;
        } else if (setter == null) {
            modifiers = getter.getModifiers() & 0xF;
            CachedField field = this.getField();
            if (field == null || field.isFinal()) {
                modifiers |= 0x10;
            }
        } else {
            modifiers = getter.getModifiers() & 0xF | setter.getModifiers() & 0xF;
            if (Modifier.isPublic(modifiers)) {
                modifiers &= 0xFFFFFFF9;
            }
            if (Modifier.isProtected(modifiers)) {
                modifiers &= 0xFFFFFFFD;
            }
        }
        return modifiers;
    }

    @Override
    public Object getProperty(Object object) {
        MetaMethod getter = this.getGetter();
        if (getter == null) {
            if (this.getField() != null) {
                return this.getField().getProperty(object);
            }
            throw new GroovyRuntimeException("Cannot read write-only property: " + this.name);
        }
        return getter.invoke(object, MetaClassHelper.EMPTY_ARRAY);
    }

    @Override
    public void setProperty(Object object, Object newValue) {
        MetaMethod setter = this.getSetter();
        if (setter == null) {
            CachedField field = this.getField();
            if (field != null && !field.isFinal()) {
                field.setProperty(object, newValue);
                return;
            }
            throw new GroovyRuntimeException("Cannot set read-only property: " + this.name);
        }
        newValue = DefaultTypeTransformation.castToType(newValue, this.getType());
        setter.invoke(object, new Object[]{newValue});
    }

    public CachedField getField() {
        return this.field;
    }

    public MetaMethod getGetter() {
        return this.getter;
    }

    public MetaMethod getSetter() {
        return this.setter;
    }

    public void setField(CachedField field) {
        this.field = field;
    }

    void setGetter(MetaMethod getter) {
        this.getter = getter;
    }

    void setSetter(MetaMethod setter) {
        this.setter = setter;
    }
}

