/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.operator;

import groovy.lang.Closure;
import groovyx.gpars.dataflow.Dataflow;
import groovyx.gpars.dataflow.DataflowReadChannel;
import groovyx.gpars.dataflow.DataflowWriteChannel;
import groovyx.gpars.group.DefaultPGroup;
import groovyx.gpars.group.PGroup;
import groovyx.gpars.scheduler.Pool;
import java.util.List;
import java.util.Map;

public final class Pipeline {
    private final PGroup group;
    private DataflowReadChannel output;
    private boolean complete = false;

    public Pipeline(DataflowReadChannel output) {
        this(Dataflow.retrieveCurrentDFPGroup(), output);
    }

    public Pipeline(Pool pool, DataflowReadChannel output) {
        this(new DefaultPGroup(pool), output);
        if (pool == null) {
            throw new IllegalArgumentException("A pipeline needs a thread pool to work with.");
        }
    }

    public Pipeline(PGroup group, DataflowReadChannel output) {
        if (output == null) {
            throw new IllegalArgumentException("Cannot build a pipeline around a null channel.");
        }
        if (group == null) {
            throw new IllegalArgumentException("A pipeline needs a PGroup instance to work with.");
        }
        this.group = group;
        this.output = output;
    }

    public PGroup getGroup() {
        return this.group;
    }

    public DataflowReadChannel getOutput() {
        return this.output;
    }

    public boolean isComplete() {
        return this.complete;
    }

    private void checkState() {
        if (this.complete) {
            throw new IllegalStateException("The pipeline has been closed already.");
        }
    }

    public <V> Pipeline chainWith(Closure<V> closure) {
        this.checkState();
        this.output = this.output.chainWith(this.group, closure);
        return this;
    }

    public <V> Pipeline chainWith(Map<String, Object> params, Closure<V> closure) {
        this.checkState();
        this.output = this.output.chainWith(this.group, params, closure);
        return this;
    }

    public <V> Pipeline or(Closure<V> closure) {
        return this.chainWith(closure);
    }

    public Pipeline filter(Closure<Boolean> closure) {
        this.checkState();
        this.output = this.output.filter(this.group, closure);
        return this;
    }

    public Pipeline filter(Map<String, Object> params, Closure<Boolean> closure) {
        this.checkState();
        this.output = this.output.filter(this.group, params, closure);
        return this;
    }

    public <V> void into(DataflowWriteChannel<V> target) {
        this.checkState();
        this.output.into(this.group, target);
        this.complete = true;
    }

    public <V> void into(Map<String, Object> params, DataflowWriteChannel<V> target) {
        this.checkState();
        this.output.into(this.group, params, target);
        this.complete = true;
    }

    public <V> void or(DataflowWriteChannel<V> target) {
        this.into(target);
    }

    public <V> void split(DataflowWriteChannel<V> target1, DataflowWriteChannel<V> target2) {
        this.checkState();
        this.output.split(this.group, target1, target2);
        this.complete = true;
    }

    public <V> void split(List<DataflowWriteChannel<V>> targets) {
        this.checkState();
        this.output.split(this.group, targets);
        this.complete = true;
    }

    public <V> void split(Map<String, Object> params, DataflowWriteChannel<V> target1, DataflowWriteChannel<V> target2) {
        this.checkState();
        this.output.split(this.group, params, target1, target2);
        this.complete = true;
    }

    public <V> void split(Map<String, Object> params, List<DataflowWriteChannel<V>> targets) {
        this.checkState();
        this.output.split(this.group, params, targets);
        this.complete = true;
    }

    public <V> Pipeline tap(DataflowWriteChannel<V> target) {
        this.checkState();
        this.output = this.output.tap(this.group, target);
        return this;
    }

    public <V> Pipeline tap(Map<String, Object> params, DataflowWriteChannel<V> target) {
        this.checkState();
        this.output = this.output.tap(this.group, params, target);
        return this;
    }

    Pipeline merge(DataflowReadChannel<Object> other, Closure closure) {
        this.checkState();
        this.output = this.output.merge(this.group, other, closure);
        return this;
    }

    Pipeline merge(List<DataflowReadChannel<Object>> others, Closure closure) {
        this.checkState();
        this.output = this.output.merge(this.group, others, closure);
        return this;
    }

    Pipeline merge(Map<String, Object> params, DataflowReadChannel<Object> other, Closure closure) {
        this.checkState();
        this.output = this.output.merge(this.group, params, other, closure);
        return this;
    }

    Pipeline merge(Map<String, Object> params, List<DataflowReadChannel<Object>> others, Closure closure) {
        this.checkState();
        this.output = this.output.merge(this.group, params, others, closure);
        return this;
    }

    public <T> void binaryChoice(DataflowWriteChannel<T> trueBranch, DataflowWriteChannel<T> falseBranch, Closure<Boolean> code) {
        this.checkState();
        this.output.binaryChoice(this.group, trueBranch, falseBranch, code);
        this.complete = true;
    }

    public <T> void binaryChoice(Map<String, Object> params, DataflowWriteChannel<T> trueBranch, DataflowWriteChannel<T> falseBranch, Closure<Boolean> code) {
        this.checkState();
        this.output.binaryChoice(this.group, params, trueBranch, falseBranch, code);
        this.complete = true;
    }

    public <T> void choice(List<DataflowWriteChannel<T>> outputs, Closure<Integer> code) {
        this.checkState();
        this.output.choice(this.group, outputs, code);
        this.complete = true;
    }

    public <T> void choice(Map<String, Object> params, List<DataflowWriteChannel<T>> outputs, Closure<Integer> code) {
        this.checkState();
        this.output.choice(this.group, params, outputs, code);
        this.complete = true;
    }

    public void separate(List<DataflowWriteChannel<?>> outputs, Closure<List<Object>> code) {
        this.checkState();
        this.output.separate(this.group, outputs, code);
        this.complete = true;
    }

    public void separate(Map<String, Object> params, List<DataflowWriteChannel<?>> outputs, Closure<List<Object>> code) {
        this.checkState();
        this.output.separate(this.group, params, outputs, code);
        this.complete = true;
    }
}

