import * as crypto from "crypto";
import * as querystring from "querystring";
import { ParsedQs } from "qs";
import { AudienceRestrictionXML, CacheProvider, Profile, SamlOptions, SamlConfig, XMLOutput, AuthOptions } from "./types";
declare class SAML {
    /**
     * Note that some methods in SAML are not yet marked as protected as they are used in testing.
     * Those methods start with an underscore, e.g. _generateLogoutRequest
     */
    options: SamlOptions;
    cacheProvider: CacheProvider;
    pemFiles: string[];
    constructor(ctorOptions: SamlConfig);
    initialize(ctorOptions: SamlConfig): SamlOptions;
    protected signRequest(samlMessage: querystring.ParsedUrlQueryInput): void;
    protected generateAuthorizeRequestAsync(this: SAML, isPassive: boolean, isHttpPostBinding: boolean): Promise<string>;
    _generateLogoutRequest(this: SAML, user: Profile): Promise<string>;
    _generateLogoutResponse(this: SAML, logoutRequest: Profile, success: boolean): string;
    _requestToUrlAsync(request: string | null | undefined, response: string | null, operation: string, additionalParameters: querystring.ParsedUrlQuery): Promise<string>;
    _getAdditionalParams(relayState: string, operation: "authorize" | "logout", overrideParams?: querystring.ParsedUrlQuery): querystring.ParsedUrlQuery;
    getAuthorizeUrlAsync(RelayState: string, host: string | undefined, options: AuthOptions): Promise<string>;
    getAuthorizeMessageAsync(RelayState: string, host?: string, options?: AuthOptions): Promise<querystring.ParsedUrlQueryInput>;
    getAuthorizeFormAsync(RelayState: string, host?: string, options?: AuthOptions): Promise<string>;
    getLogoutUrlAsync(user: Profile, RelayState: string, options: AuthOptions): Promise<string>;
    getLogoutResponseUrl(samlLogoutRequest: Profile, RelayState: string, options: AuthOptions, success: boolean, callback: (err: Error | null, url?: string) => void): void;
    getLogoutResponseUrlAsync(samlLogoutRequest: Profile, RelayState: string, options: AuthOptions, success: boolean): Promise<string>;
    protected getKeyInfosAsPem(): Promise<string[]>;
    protected getSignedAssertion(signedXml: string): Promise<string | null>;
    validatePostResponseAsync(container: Record<string, string>): Promise<{
        profile: Profile | null;
        loggedOut: boolean;
    }>;
    protected validateInResponseTo(inResponseTo: string | null): Promise<void>;
    validateRedirectAsync(container: ParsedQs, originalQuery: string): Promise<{
        profile: Profile | null;
        loggedOut: boolean;
    }>;
    protected hasValidSignatureForRedirect(container: ParsedQs, originalQuery: string): Promise<boolean | void>;
    protected validateSignatureForRedirect(urlString: crypto.BinaryLike, signature: string, alg: string, pemFile: string): boolean;
    protected verifyLogoutRequest(doc: XMLOutput): void;
    protected verifyLogoutResponse(doc: XMLOutput): Promise<void>;
    protected verifyIssuer(samlMessage: XMLOutput): void;
    protected processValidlySignedAssertionAsync(this: SAML, xml: string, // assertion XML
    samlResponseXml: string, // should be deprecated, this is unsigned
    inResponseTo: string | null): Promise<{
        profile: Profile;
        loggedOut: boolean;
    }>;
    protected checkTimestampsValidityError(nowMs: number, notBefore: string, notOnOrAfter: string, maxTimeLimitMs?: number): Error | null;
    protected checkAudienceValidityError(expectedAudience: string, audienceRestrictions: AudienceRestrictionXML[]): Error | null;
    validatePostRequestAsync(container: Record<string, string>, { _parseDomFromString, _parseXml2JsFromString, _validateSignature, }?: {
        _parseDomFromString?: ((xml: string) => Promise<Document>) | undefined;
        _parseXml2JsFromString?: ((xml: string | Buffer) => Promise<import("./types").XmlJsObject>) | undefined;
        _validateSignature?: ((fullXml: string, currentNode: Element, pemFiles: string[]) => boolean) | undefined;
    }): Promise<{
        profile: Profile;
        loggedOut: boolean;
    }>;
    protected processValidlySignedPostRequestAsync(this: SAML, doc: XMLOutput, dom: Document): Promise<{
        profile: Profile;
        loggedOut: boolean;
    }>;
    protected processValidlySignedSamlLogoutAsync(this: SAML, doc: XMLOutput, dom: Document): Promise<{
        profile: Profile | null;
        loggedOut: boolean;
    }>;
    generateServiceProviderMetadata(this: SAML, decryptionCert: string | null, publicCerts?: string | string[] | null): string;
    /**
     * Process max age assertion and use it if it is more restrictive than the NotOnOrAfter age
     * assertion received in the SAMLResponse.
     *
     * @param maxAssertionAgeMs Max time after IssueInstant that we will accept assertion, in Ms.
     * @param notOnOrAfter Expiration provided in response.
     * @param issueInstant Time when response was issued.
     * @returns {*} The expiration time to be used, in Ms.
     */
    protected calcMaxAgeAssertionTime(maxAssertionAgeMs: number, notOnOrAfter: string, issueInstant: string): number;
    protected mustValidateInResponseTo(hasInResponseTo: boolean): boolean;
}
export { SAML };
