/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.Bytecode;
import sun.jvm.hotspot.oops.ConstantPool;
import sun.jvm.hotspot.oops.ConstantPoolCache;
import sun.jvm.hotspot.oops.Method;

public abstract class BytecodeWithCPIndex
extends Bytecode {
    BytecodeWithCPIndex(Method method, int bci) {
        super(method, bci);
    }

    public int index() {
        if (this.code() == 186) {
            int index = this.getIndexU4();
            if (ConstantPool.isInvokedynamicIndex(index)) {
                return ConstantPool.decodeInvokedynamicIndex(index);
            }
            return index;
        }
        return this.getIndexU2(this.code(), false);
    }

    protected int indexForFieldOrMethod() {
        ConstantPoolCache cpCache = this.method().getConstants().getCache();
        int cpCacheIndex = this.index();
        if (cpCache == null) {
            return cpCacheIndex;
        }
        return cpCache.getEntryAt(0xFFFF & cpCacheIndex).getConstantPoolIndex();
    }
}

