/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.export.UseTable;
import org.jmol.export.__RayTracerExporter;
import org.jmol.util.GData;
import org.jmol.viewer.Viewer;

public class _TachyonExporter
extends __RayTracerExporter {
    String lighting;
    String phong;
    UseTable textures = new UseTable(" ");
    private String textureCode;

    public _TachyonExporter() {
        this.commentChar = "# ";
    }

    @Override
    boolean initializeOutput(Viewer vwr, double privateKey, GData gdata, Map<String, Object> params) {
        this.getLightingInfo();
        return this.initOutput(vwr, privateKey, gdata, params);
    }

    private void getLightingInfo() {
        this.lighting = " AMBIENT " + _TachyonExporter.round((float)this.gdata.getAmbientPercent() / 100.0f) + " DIFFUSE " + _TachyonExporter.round((float)this.gdata.getDiffusePercent() / 100.0f) + " SPECULAR " + _TachyonExporter.round((float)this.gdata.getSpecularPercent() / 100.0f);
        this.phong = " Phong Plastic 0.5 Phong_size " + this.gdata.getSpecularExponent();
    }

    @Override
    protected void outputHeader() {
        this.initVars();
        this.output("# ******************************************************\n");
        this.output("# Created by Jmol " + Viewer.getJmolVersion() + "\n");
        this.output("#\n");
        this.output("# This script was generated on " + this.getExportDate() + "\n");
        this.output("#\n");
        this.output("# Requires Tachyon version 0.98.7 or newer\n");
        this.output("#\n");
        this.output("# Default tachyon rendering command for this scene:\n");
        this.output("#   tachyon  -aasamples 12 %s -format TARGA -o %s.tga\n");
        this.output("#\n");
        this.output("# ******************************************************\n");
        this.output("\n");
        this.output(this.getJmolPerspective());
        this.output("\n");
        this.output("Begin_Scene\n");
        this.output("Resolution " + this.screenWidth + " " + this.screenHeight + "\n");
        this.output("Shader_Mode Medium\n");
        this.output("  Trans_VMD\n");
        this.output("  Fog_VMD\n");
        this.output("End_Shader_Mode\n");
        this.output("Camera\n");
        this.output("  Zoom 3.0\n");
        this.output("  Aspectratio 1\n");
        this.output("  Antialiasing 12\n");
        this.output("  Raydepth 8\n");
        this.output("  Center " + this.triad(this.screenWidth / 2, this.screenHeight / 2, 0.0f) + "\n");
        this.output("  Viewdir 0 0 1\n");
        this.output("  Updir   0 1 0\n");
        this.output("End_Camera\n");
        this.output("Directional_Light Direction " + _TachyonExporter.round(this.lightSource) + " Color 1 1 1\n");
        this.output("\n");
        this.output("Background " + this.rgbFractionalFromColix(this.backgroundColix) + "\n");
        this.output("\n");
    }

    @Override
    protected void outputFooter() {
        this.output("End_Scene\n");
    }

    @Override
    protected void output(T3 pt) {
        this.output(this.triad(pt));
    }

    private String triad(float x, float y, float z) {
        return (int)x + " " + (int)(-y) + " " + (int)z;
    }

    private String triad(T3 pt) {
        if (Float.isNaN(pt.x)) {
            return "0 0 0";
        }
        return this.triad(pt.x, pt.y, pt.z);
    }

    private void outputTextureCode() {
        this.output(this.textureCode);
        this.output("\n");
    }

    private void outputTexture(short colix, boolean useTexDef) {
        this.outputTexture2(this.rgbFractionalFromColix(colix), _TachyonExporter.opacityFractionalFromColix(colix), useTexDef);
    }

    private void outputTexture(int argb, boolean useTexDef) {
        this.outputTexture2(this.rgbFractionalFromArgb(argb), _TachyonExporter.opacityFractionalFromArgb(argb), useTexDef);
    }

    private void outputTexture2(String rgb, String opacity, boolean useTexDef) {
        String string = this.textureCode = useTexDef ? this.textures.getDef("t" + rgb + opacity) : null;
        if (useTexDef && this.textureCode.startsWith(" ")) {
            return;
        }
        SB sb = new SB();
        sb.append(this.lighting);
        sb.append(" Opacity " + opacity);
        sb.append(this.phong);
        sb.append(" Color " + rgb);
        sb.append(" TexFunc 0\n");
        if (!useTexDef) {
            this.textureCode = "Texture " + sb;
            return;
        }
        this.output("TexDef " + this.textureCode);
        this.output(sb.toString());
        this.textureCode = " " + this.textureCode;
    }

    @Override
    protected void outputCircle(int x, int y, int z, float radius, short colix, boolean doFill) {
        this.tempV1.set(0.0f, 0.0f, -1.0f);
        this.outputRing(x, y, z, this.tempV1, radius, colix, doFill);
    }

    private void outputRing(int x, int y, int z, V3 tempV1, float radius, short colix, boolean doFill) {
        this.outputTexture(colix, true);
        this.output("Ring Center ");
        this.output(this.triad(x, y, z));
        this.output(" Normal " + this.triad(tempV1));
        this.output(" Inner " + _TachyonExporter.round(doFill ? 0.0 : (double)radius * 0.95));
        this.output(" Outer " + _TachyonExporter.round(radius));
        this.outputTextureCode();
    }

    @Override
    protected void outputCone(P3 screenBase, P3 screenTip, float radius, short colix, boolean isBarb) {
        this.tm.unTransformPoint(screenBase, this.tempP1);
        this.tm.unTransformPoint(screenTip, this.tempP2);
        radius = this.vwr.tm.unscaleToScreen(screenBase.z, radius);
        M3 matRotateScale = this.getRotationMatrix(this.tempP1, this.tempP2, radius);
        this.export3D.drawSurface(_TachyonExporter.getConeMesh(this.tempP1, matRotateScale, colix), colix);
    }

    @Override
    protected void outputCylinder(P3 screenA, P3 screenB, float radius, short colix, boolean withCaps) {
        this.outputTexture(colix, true);
        this.output("FCylinder Base ");
        this.output(this.triad(screenA));
        this.output(" Apex ");
        this.output(this.triad(screenB));
        this.output(" Rad " + _TachyonExporter.round(radius));
        this.outputTextureCode();
        if (withCaps && radius > 1.0f) {
            this.tempV1.sub2(screenA, screenB);
            this.outputRing((int)screenA.x, (int)screenA.y, (int)screenA.z, this.tempV1, radius, colix, true);
            this.tempV1.scale(-1.0f);
            this.outputRing((int)screenB.x, (int)screenB.y, (int)screenB.z, this.tempV1, radius, colix, true);
        }
    }

    @Override
    protected void fillConicalCylinder(P3 screenA, P3 screenB, int madBond, short colix, byte endcaps) {
        int diameter = (int)this.vwr.tm.scaleToScreen((int)((screenA.z + screenB.z) / 2.0f), madBond);
        this.fillCylinderScreenMad(colix, endcaps, diameter, screenA, screenB);
    }

    @Override
    protected void outputCylinderConical(P3 screenA, P3 screenB, float radius1, float radius2, short colix) {
    }

    @Override
    protected void outputEllipsoid(P3 center, float radius, double[] coef, short colix) {
        this.tm.transformPt3fSafe(center, this.tempP1);
        this.outputSphere(this.tempP1.x, this.tempP1.y, this.tempP1.z, radius, colix);
    }

    @Override
    protected void outputSurface(T3[] vertices, T3[] normals, short[] colixes, int[][] indices, short[] polygonColixes, int nVertices, int nPolygons, int nTriangles, BS bsPolygons, int faceVertexMax, short colix, Lst<Short> colorList, Map<Short, Integer> htColixes, P3 offset) {
        int i0;
        int i;
        if (polygonColixes != null) {
            int i02;
            boolean isAll = bsPolygons == null;
            int i2 = i02 = isAll ? nPolygons - 1 : bsPolygons.nextSetBit(0);
            while (i2 >= 0) {
                _TachyonExporter.setTempVertex(vertices[indices[i2][0]], offset, this.tempP1);
                _TachyonExporter.setTempVertex(vertices[indices[i2][1]], offset, this.tempP2);
                _TachyonExporter.setTempVertex(vertices[indices[i2][2]], offset, this.tempP3);
                this.tm.transformPt3fSafe(this.tempP1, this.tempP1);
                this.tm.transformPt3fSafe(this.tempP2, this.tempP2);
                this.tm.transformPt3fSafe(this.tempP3, this.tempP3);
                this.outputTriangle(this.tempP1, this.tempP2, this.tempP3, colix);
                i2 = isAll ? i2 - 1 : bsPolygons.nextSetBit(i2 + 1);
            }
            return;
        }
        this.outputTexture(colixes == null ? colix : colixes[0], false);
        this.output("VertexArray  Numverts " + nVertices + "\nCoords\n");
        for (i = 0; i < nVertices; ++i) {
            this.outputVertex(vertices[i], offset);
        }
        this.output("\nNormals\n");
        for (i = 0; i < nVertices; ++i) {
            _TachyonExporter.setTempVertex(vertices[i], offset, this.tempP1);
            this.output(this.triad(this.getScreenNormal(this.tempP1, normals[i], 10.0f)) + "\n");
        }
        String rgb = colixes == null ? this.rgbFractionalFromColix(colix) : null;
        this.output("\nColors\n");
        for (int i3 = 0; i3 < nVertices; ++i3) {
            this.output((colixes == null ? rgb : this.rgbFractionalFromColix(colixes[i3])) + "\n");
        }
        this.outputTextureCode();
        this.output("\nTriMesh " + nTriangles + "\n");
        boolean isAll = bsPolygons == null;
        int i4 = i0 = isAll ? nPolygons - 1 : bsPolygons.nextSetBit(0);
        while (i4 >= 0) {
            this.output(indices[i4][0] + " " + indices[i4][1] + " " + indices[i4][2] + "\n");
            if (faceVertexMax == 4 && indices[i4].length == 4) {
                this.output(indices[i4][0] + " " + indices[i4][2] + " " + indices[i4][3] + "\n");
            }
            i4 = isAll ? i4 - 1 : bsPolygons.nextSetBit(i4 + 1);
        }
        this.output("\nEnd_VertexArray\n");
    }

    @Override
    protected void outputSphere(float x, float y, float z, float radius, short colix) {
        this.outputTexture(colix, true);
        this.output("Sphere Center ");
        this.output(this.triad(x, y, z));
        this.output(" Rad " + _TachyonExporter.round(radius));
        this.outputTextureCode();
    }

    @Override
    protected void outputTextPixel(int x, int y, int z, int argb) {
        this.outputTexture(argb, true);
        this.output("Sphere Center ");
        this.output(this.triad(x, y, z));
        this.output(" Rad 1");
        this.outputTextureCode();
    }

    @Override
    protected void outputTriangle(T3 ptA, T3 ptB, T3 ptC, short colix) {
        this.outputTexture(colix, true);
        this.output("TRI");
        this.output(" V0 " + this.triad(ptA));
        this.output(" V1 " + this.triad(ptB));
        this.output(" V2 " + this.triad(ptC));
        this.outputTextureCode();
    }
}

