/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.openstreetmap.gui.jmapviewer.interfaces.IProjected;

public class TileAnchor {
    protected final Point2D tileOrigin;
    protected final Point2D nextTileOrigin;

    public TileAnchor(Point2D tileOrigin, Point2D nextTileOrigin) {
        this.tileOrigin = tileOrigin;
        this.nextTileOrigin = nextTileOrigin;
    }

    public TileAnchor(IProjected tileOrigin, IProjected nextTileOrigin) {
        this.tileOrigin = new Point2D.Double(tileOrigin.getEast(), tileOrigin.getNorth());
        this.nextTileOrigin = new Point2D.Double(nextTileOrigin.getEast(), nextTileOrigin.getNorth());
    }

    public Point2D getTileOrigin() {
        return this.tileOrigin;
    }

    public Point2D getNextTileOrigin() {
        return this.nextTileOrigin;
    }

    public String toString() {
        return "TileAnchor{" + String.valueOf(this.tileOrigin) + "; " + String.valueOf(this.nextTileOrigin) + "}";
    }

    public AffineTransform convert(TileAnchor other) {
        Point2D src1 = this.getTileOrigin();
        Point2D src2 = this.getNextTileOrigin();
        Point2D dest1 = other.getTileOrigin();
        Point2D dest2 = other.getNextTileOrigin();
        double scaleX = (dest2.getX() - dest1.getX()) / (src2.getX() - src1.getX());
        double scaleY = (dest2.getY() - dest1.getY()) / (src2.getY() - src1.getY());
        double offsetX0 = dest1.getX() - scaleX * src1.getX();
        double offsetY0 = dest1.getY() - scaleY * src1.getY();
        return new AffineTransform(scaleX, 0.0, 0.0, scaleY, offsetX0, offsetY0);
    }
}

