/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.openstreetmap.josm.io.remotecontrol.RequestProcessor;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;

public class PermissionPrefWithDefault {
    private static final List<PermissionPrefWithDefault> PREFS = new ArrayList<PermissionPrefWithDefault>();
    public static final PermissionPrefWithDefault LOAD_DATA = new PermissionPrefWithDefault("remotecontrol.permission.load-data", true, I18n.tr("Load data from API", new Object[0]));
    public static final PermissionPrefWithDefault IMPORT_DATA = new PermissionPrefWithDefault("remotecontrol.permission.import", true, I18n.tr("Import data from URL", new Object[0]));
    public static final PermissionPrefWithDefault EXPORT_DATA = new PermissionPrefWithDefault("remotecontrol.permission.export", false, I18n.tr("Export data from JOSM", new Object[0]));
    public static final PermissionPrefWithDefault OPEN_FILES = new PermissionPrefWithDefault("remotecontrol.permission.open-files", false, I18n.tr("Open local files", new Object[0]));
    public static final PermissionPrefWithDefault ALLOW_WEB_RESOURCES = new PermissionPrefWithDefault("remotecontrol.permission.open-remote-files", false, I18n.tr("Open remote files", new Object[0]));
    public static final PermissionPrefWithDefault LOAD_IMAGERY = new PermissionPrefWithDefault("remotecontrol.permission.imagery", true, I18n.tr("Load imagery layers", new Object[0]));
    public static final PermissionPrefWithDefault CHANGE_SELECTION = new PermissionPrefWithDefault("remotecontrol.permission.change-selection", true, I18n.tr("Change the selection", new Object[0]));
    public static final PermissionPrefWithDefault CHANGE_VIEWPORT = new PermissionPrefWithDefault("remotecontrol.permission.change-viewport", true, I18n.tr("Change the viewport", new Object[0]));
    public static final PermissionPrefWithDefault CREATE_OBJECTS = new PermissionPrefWithDefault("remotecontrol.permission.create-objects", true, I18n.tr("Create new objects", new Object[0]));
    public static final PermissionPrefWithDefault READ_PROTOCOL_VERSION = new PermissionPrefWithDefault("remotecontrol.permission.read-protocolversion", true, I18n.tr("Read protocol version", new Object[0]));
    public final String pref;
    public final boolean defaultVal;
    public final String preferenceText;

    public PermissionPrefWithDefault(String pref, boolean defaultVal, String preferenceText) {
        this.pref = pref;
        this.defaultVal = defaultVal;
        this.preferenceText = preferenceText;
    }

    public boolean isAllowed() {
        return Config.getPref().getBoolean(this.pref, this.defaultVal);
    }

    public static List<PermissionPrefWithDefault> getPermissionPrefs() {
        if (PREFS.isEmpty()) {
            RequestProcessor.initialize();
        }
        return Collections.unmodifiableList(PREFS);
    }

    public static void addPermissionPref(PermissionPrefWithDefault pref) {
        if (pref.pref != null && PREFS.parallelStream().noneMatch(tPref -> pref.pref.equals(tPref.pref))) {
            PREFS.add(pref);
        }
    }

    public static boolean removePermissionPref(PermissionPrefWithDefault pref) {
        List toRemove = Collections.emptyList();
        if (pref.pref != null) {
            toRemove = PREFS.parallelStream().filter(tPref -> pref.pref.equals(tPref.pref)).collect(Collectors.toList());
        }
        return PREFS.removeAll(toRemove);
    }
}

