/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.task;

import org.jsampler.AudioDeviceModel;
import org.jsampler.CC;
import org.jsampler.JSI18n;
import org.jsampler.SamplerModel;
import org.jsampler.task.EnhancedTask;
import org.linuxsampler.lscp.AudioOutputDevice;
import org.linuxsampler.lscp.AudioOutputDriver;
import org.linuxsampler.lscp.Parameter;

public class Audio {
    private Audio() {
    }

    public static class UpdateDevices
    extends EnhancedTask {
        public UpdateDevices() {
            this.setTitle("Audio.UpdateDevices_task");
            this.setDescription(JSI18n.i18n.getMessage("Audio.UpdateDevices.desc"));
        }

        @Override
        public void exec() throws Exception {
            int n;
            SamplerModel samplerModel = CC.getSamplerModel();
            Integer[] integerArray = CC.getClient().getAudioOutputDeviceIDs();
            boolean bl = false;
            for (AudioDeviceModel audioDeviceModel : samplerModel.getAudioDevices()) {
                for (n = 0; n < integerArray.length; ++n) {
                    if (audioDeviceModel.getDeviceId() != integerArray[n].intValue()) continue;
                    integerArray[n] = -1;
                    bl = true;
                }
                if (!bl) {
                    samplerModel.removeAudioDeviceById(audioDeviceModel.getDeviceId());
                }
                bl = false;
            }
            Integer[] integerArray2 = integerArray;
            int n2 = integerArray2.length;
            for (int i = 0; i < n2; ++i) {
                n = integerArray2[i];
                if (n < 0) continue;
                AudioOutputDevice audioOutputDevice = CC.getClient().getAudioOutputDeviceInfo(n);
                samplerModel.addAudioDevice(audioOutputDevice);
            }
        }
    }

    public static class UpdateDeviceInfo
    extends EnhancedTask {
        private int dev;

        public UpdateDeviceInfo(int n) {
            this.setTitle("Audio.UpdateDeviceInfo_task");
            this.setDescription(JSI18n.i18n.getMessage("Audio.UpdateDeviceInfo.desc", n));
            this.dev = n;
        }

        @Override
        public void exec() throws Exception {
            AudioOutputDevice audioOutputDevice = CC.getClient().getAudioOutputDeviceInfo(this.dev);
            CC.getSamplerModel().getAudioDeviceById(this.dev).setDeviceInfo(audioOutputDevice);
        }
    }

    public static class SetChannelCount
    extends EnhancedTask {
        private int deviceId;
        private int channels;

        public SetChannelCount(int n, int n2) {
            this.setTitle("SetAudioOutputChannelCount_task");
            this.setDescription(JSI18n.i18n.getMessage("Audio.SetChannelCount.desc", n));
            this.deviceId = n;
            this.channels = n2;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().setAudioOutputChannelCount(this.deviceId, this.channels);
        }
    }

    public static class SetChannelParameter
    extends EnhancedTask {
        private int dev;
        private int channel;
        private Parameter prm;

        public SetChannelParameter(int n, int n2, Parameter parameter) {
            this.setTitle("Audio.SetChannelParameter_task");
            this.setDescription(JSI18n.i18n.getMessage("Audio.SetChannelParameter.desc"));
            this.dev = n;
            this.channel = n2;
            this.prm = parameter;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().setAudioOutputChannelParameter(this.dev, this.channel, this.prm);
        }
    }

    public static class SetDeviceParameter
    extends EnhancedTask {
        private int dev;
        private Parameter prm;

        public SetDeviceParameter(int n, Parameter parameter) {
            this.setTitle("Audio.SetDeviceParameter_task");
            this.setDescription(JSI18n.i18n.getMessage("Audio.SetDeviceParameter.desc", n));
            this.dev = n;
            this.prm = parameter;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().setAudioOutputDeviceParameter(this.dev, this.prm);
        }
    }

    public static class EnableDevice
    extends EnhancedTask {
        private int dev;
        private boolean enable;

        public EnableDevice(int n, boolean bl) {
            this.setTitle("Audio.EnableDevice_task");
            this.setDescription(JSI18n.i18n.getMessage("Audio.EnableDevice.desc", n));
            this.dev = n;
            this.enable = bl;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().enableAudioOutputDevice(this.dev, this.enable);
            CC.getSamplerModel().getAudioDeviceById(this.dev).setActive(this.enable);
        }
    }

    public static class DestroyDevice
    extends EnhancedTask {
        private int deviceId;

        public DestroyDevice(int n) {
            this.setTitle("Audio.DestroyDevice_task");
            this.setDescription(JSI18n.i18n.getMessage("Audio.DestroyDevice.desc", n));
            this.deviceId = n;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().destroyAudioOutputDevice(this.deviceId);
        }
    }

    public static class CreateDevice
    extends EnhancedTask<Integer> {
        private String driver;
        private Parameter[] parameters;

        public CreateDevice(String string, Parameter ... parameterArray) {
            this.setTitle("Audio.CreateDevice_task");
            this.setDescription(JSI18n.i18n.getMessage("Audio.CreateDevice.desc"));
            this.driver = string;
            this.parameters = parameterArray;
        }

        @Override
        public void exec() throws Exception {
            Integer n = CC.getClient().createAudioOutputDevice(this.driver, this.parameters);
            this.setResult(n);
        }
    }

    public static class GetDriverParametersInfo
    extends EnhancedTask<Parameter[]> {
        private String driver;
        Parameter[] depList;

        public GetDriverParametersInfo(String string, Parameter ... parameterArray) {
            this.setTitle("Audio.GetDriverParametersInfo_task");
            this.setDescription(JSI18n.i18n.getMessage("Audio.GetDriverParametersInfo.desc"));
            this.driver = string;
            this.depList = parameterArray;
        }

        @Override
        public void exec() throws Exception {
            AudioOutputDriver audioOutputDriver = CC.getClient().getAudioOutputDriverInfo(this.driver, this.depList);
            this.setResult(audioOutputDriver.getParameters());
        }
    }

    public static class GetDrivers
    extends EnhancedTask<AudioOutputDriver[]> {
        public GetDrivers() {
            this.setTitle("Audio.GetDrivers_task");
            this.setDescription(JSI18n.i18n.getMessage("Audio.GetDrivers.desc"));
        }

        @Override
        public void exec() throws Exception {
            this.setResult(CC.getClient().getAudioOutputDrivers());
        }
    }
}

