/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view;

import javax.swing.table.AbstractTableModel;
import org.jsampler.DefaultOrchestraModel;
import org.jsampler.OrchestraModel;
import org.jsampler.event.OrchestraEvent;
import org.jsampler.event.OrchestraListener;

public class InstrumentTableModel
extends AbstractTableModel {
    private OrchestraModel orchestraModel;
    private final Handler eventHandler = new Handler();

    public InstrumentTableModel() {
        this(new DefaultOrchestraModel());
    }

    public InstrumentTableModel(OrchestraModel orchestraModel) {
        this.setOrchestraModel(orchestraModel);
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        return this.orchestraModel.getInstrumentCount();
    }

    @Override
    public String getColumnName(int n) {
        String string = this.orchestraModel.getName();
        if (string == null || string.length() == 0) {
            return " ";
        }
        return string;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.orchestraModel.getInstrument(n);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.orchestraModel.getInstrument(n).setName(object.toString());
        this.fireTableCellUpdated(n, n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public OrchestraModel getOrchestraModel() {
        return this.orchestraModel;
    }

    public void setOrchestraModel(OrchestraModel orchestraModel) {
        if (orchestraModel == null) {
            throw new IllegalArgumentException("orchestraModel should be non-null!");
        }
        if (this.getOrchestraModel() != null) {
            this.getOrchestraModel().removeOrchestraListener(this.getHandler());
        }
        this.orchestraModel = orchestraModel;
        orchestraModel.addOrchestraListener(this.getHandler());
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }

    private Handler getHandler() {
        return this.eventHandler;
    }

    private class Handler
    implements OrchestraListener {
        private Handler() {
        }

        @Override
        public void nameChanged(OrchestraEvent orchestraEvent) {
            InstrumentTableModel.this.fireTableStructureChanged();
        }

        @Override
        public void descriptionChanged(OrchestraEvent orchestraEvent) {
            InstrumentTableModel.this.fireTableDataChanged();
        }

        @Override
        public void instrumentAdded(OrchestraEvent orchestraEvent) {
            InstrumentTableModel.this.fireTableDataChanged();
        }

        @Override
        public void instrumentRemoved(OrchestraEvent orchestraEvent) {
            InstrumentTableModel.this.fireTableDataChanged();
        }

        @Override
        public void instrumentChanged(OrchestraEvent orchestraEvent) {
            InstrumentTableModel.this.fireTableDataChanged();
        }
    }
}

