/*
 * Decompiled with CFR 0.152.
 */
package org.linuxsampler.lscp;

import org.linuxsampler.lscp.AbstractInstrument;
import org.linuxsampler.lscp.Client;
import org.linuxsampler.lscp.LscpException;
import org.linuxsampler.lscp.LscpI18n;
import org.linuxsampler.lscp.MidiInstrumentEntry;
import org.linuxsampler.lscp.Parseable;
import org.linuxsampler.lscp.Parser;

public class MidiInstrumentInfo
extends AbstractInstrument
implements Parseable {
    private int mapId = -1;
    private MidiInstrumentEntry entry;
    private String engine;
    private String instrName = "Untitled";
    private double volume = 1.0;
    private LoadMode loadMode = LoadMode.DEFAULT;

    public MidiInstrumentInfo() {
    }

    public MidiInstrumentInfo(int n, MidiInstrumentEntry midiInstrumentEntry) {
        this.mapId = n;
        this.entry = midiInstrumentEntry;
    }

    public MidiInstrumentInfo(int n, MidiInstrumentEntry midiInstrumentEntry, String[] stringArray) throws LscpException {
        this.mapId = n;
        this.entry = midiInstrumentEntry;
        for (String string : stringArray) {
            if (this.parse(string)) continue;
            Client.getLogger().info(LscpI18n.getLogMsg("unknownLine", string));
        }
    }

    public MidiInstrumentEntry getEntry() {
        return this.entry;
    }

    public int getMapId() {
        return this.mapId;
    }

    public int getMidiBank() {
        return this.entry.getMidiBank();
    }

    public int getMidiProgram() {
        return this.entry.getMidiProgram();
    }

    @Override
    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String string) {
        this.engine = string;
    }

    public String getInstrumentName() {
        return this.instrName;
    }

    public double getVolume() {
        return this.volume;
    }

    public void setVolume(double d) {
        this.volume = d;
    }

    public LoadMode getLoadMode() {
        return this.loadMode;
    }

    public void setLoadMode(LoadMode loadMode) {
        this.loadMode = loadMode;
    }

    @Override
    public boolean parse(String string) throws LscpException {
        if (string.startsWith("NAME: ")) {
            this.setName(Parser.toNonEscapedString(string.substring("NAME: ".length())));
        } else if (string.startsWith("ENGINE_NAME: ")) {
            this.setEngine(string.substring("ENGINE_NAME: ".length()));
        } else if (string.startsWith("INSTRUMENT_NAME: ")) {
            this.instrName = Parser.toNonEscapedString(string.substring("INSTRUMENT_NAME: ".length()));
        } else if (string.startsWith("LOAD_MODE: ")) {
            if ((string = string.substring("LOAD_MODE: ".length())).length() == 0) {
                this.setLoadMode(LoadMode.DEFAULT);
            } else {
                this.setLoadMode(LoadMode.valueOf(string));
            }
        } else if (string.startsWith("VOLUME: ")) {
            string = string.substring("VOLUME: ".length());
            this.setVolume(Parser.parseFloat(string));
        } else {
            return super.parse(string);
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof MidiInstrumentInfo)) {
            return false;
        }
        MidiInstrumentInfo midiInstrumentInfo = (MidiInstrumentInfo)object;
        if (this.getMapId() != midiInstrumentInfo.getMapId()) {
            return false;
        }
        if (this.getMidiBank() != midiInstrumentInfo.getMidiBank()) {
            return false;
        }
        return this.getMidiProgram() == midiInstrumentInfo.getMidiProgram();
    }

    public static enum LoadMode {
        DEFAULT("Default"),
        ON_DEMAND("On Demand"),
        ON_DEMAND_HOLD("On Demand and Hold"),
        PERSISTENT("Persistent");

        private final String name;

        private LoadMode(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

