/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler;

import java.util.Vector;
import org.jsampler.DefaultOrchestraModel;
import org.jsampler.OrchestraListModel;
import org.jsampler.OrchestraModel;
import org.jsampler.event.ListEvent;
import org.jsampler.event.ListListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultOrchestraListModel
implements OrchestraListModel {
    private final Vector<OrchestraModel> orchestras = new Vector();
    private final Vector<ListListener<OrchestraModel>> listeners = new Vector();

    @Override
    public void addOrchestraListListener(ListListener<OrchestraModel> listListener) {
        this.listeners.add(listListener);
    }

    @Override
    public void removeOrchestraListListener(ListListener<OrchestraModel> listListener) {
        this.listeners.remove(listListener);
    }

    @Override
    public int getOrchestraCount() {
        return this.orchestras.size();
    }

    @Override
    public OrchestraModel getOrchestra(int n) {
        return this.orchestras.get(n);
    }

    @Override
    public void addOrchestra(OrchestraModel orchestraModel) {
        this.insertOrchestra(orchestraModel, this.getOrchestraCount());
    }

    @Override
    public void insertOrchestra(OrchestraModel orchestraModel, int n) {
        if (orchestraModel == null) {
            throw new IllegalArgumentException("orchestra should be non-null!");
        }
        this.orchestras.insertElementAt(orchestraModel, n);
        this.fireOrchestraAdded(orchestraModel);
    }

    @Override
    public void removeOrchestra(int n) {
        OrchestraModel orchestraModel = this.orchestras.get(n);
        this.orchestras.removeElementAt(n);
        this.fireOrchestraRemoved(orchestraModel);
    }

    @Override
    public boolean removeOrchestra(OrchestraModel orchestraModel) {
        boolean bl = this.orchestras.removeElement(orchestraModel);
        if (bl) {
            this.fireOrchestraRemoved(orchestraModel);
        }
        return bl;
    }

    @Override
    public void removeAllOrchestras() {
        for (int i = 0; i < this.getOrchestraCount(); ++i) {
            this.removeOrchestra(i);
        }
    }

    @Override
    public int getOrchestraIndex(OrchestraModel orchestraModel) {
        if (orchestraModel == null) {
            return -1;
        }
        for (int i = 0; i < this.getOrchestraCount(); ++i) {
            if (this.getOrchestra(i) != orchestraModel) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void moveOrchestraOnTop(OrchestraModel orchestraModel) {
        if (orchestraModel == null) {
            return;
        }
        int n = this.getOrchestraIndex(orchestraModel);
        if (n <= 0) {
            return;
        }
        this.removeOrchestra(n);
        this.insertOrchestra(orchestraModel, 0);
    }

    @Override
    public void moveOrchestraUp(OrchestraModel orchestraModel) {
        if (orchestraModel == null) {
            return;
        }
        int n = this.getOrchestraIndex(orchestraModel);
        if (n <= 0) {
            return;
        }
        this.removeOrchestra(n);
        this.insertOrchestra(orchestraModel, n - 1);
    }

    @Override
    public void moveOrchestraDown(OrchestraModel orchestraModel) {
        if (orchestraModel == null) {
            return;
        }
        int n = this.getOrchestraIndex(orchestraModel);
        if (n < 0 || n == this.getOrchestraCount() - 1) {
            return;
        }
        this.removeOrchestra(n);
        this.insertOrchestra(orchestraModel, n + 1);
    }

    @Override
    public void moveOrchestraAtBottom(OrchestraModel orchestraModel) {
        if (orchestraModel == null) {
            return;
        }
        int n = this.getOrchestraIndex(orchestraModel);
        if (n < 0 || n == this.getOrchestraCount() - 1) {
            return;
        }
        this.removeOrchestra(n);
        this.insertOrchestra(orchestraModel, this.getOrchestraCount());
    }

    @Override
    public void readObject(Node node) {
        if (node.getNodeType() != 1 || !node.getNodeName().equals("orchestras")) {
            throw new IllegalArgumentException("Not an orchestra list node!");
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            DefaultOrchestraModel defaultOrchestraModel = new DefaultOrchestraModel();
            defaultOrchestraModel.readObject(node);
            this.addOrchestra(defaultOrchestraModel);
        }
    }

    @Override
    public void writeObject(Document document, Node node) {
        Element element = document.createElement("orchestras");
        node.appendChild(element);
        node = element;
        for (int i = 0; i < this.getOrchestraCount(); ++i) {
            this.getOrchestra(i).writeObject(document, node);
        }
    }

    private void fireOrchestraAdded(OrchestraModel orchestraModel) {
        ListEvent<OrchestraModel> listEvent = new ListEvent<OrchestraModel>(this, orchestraModel);
        for (ListListener<OrchestraModel> listListener : this.listeners) {
            listListener.entryAdded(listEvent);
        }
    }

    private void fireOrchestraRemoved(OrchestraModel orchestraModel) {
        ListEvent<OrchestraModel> listEvent = new ListEvent<OrchestraModel>(this, orchestraModel);
        for (ListListener<OrchestraModel> listListener : this.listeners) {
            listListener.entryRemoved(listEvent);
        }
    }
}

