/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.logger;

import java.util.List;
import java.util.Map;
import org.apache.kafka.server.logger.Log4jCoreController;
import org.apache.kafka.server.logger.LoggingControllerDelegate;
import org.apache.kafka.server.logger.LoggingControllerMBean;
import org.apache.kafka.server.logger.NoOpController;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoggingController
implements LoggingControllerMBean {
    private static final Logger LOGGER;
    public static final String ROOT_LOGGER = "root";
    private static final LoggingControllerDelegate DELEGATE;

    public static Map<String, String> loggers() {
        return DELEGATE.loggers();
    }

    public static boolean logLevel(String loggerName, String logLevel) {
        return DELEGATE.logLevel(loggerName, logLevel);
    }

    public static boolean unsetLogLevel(String loggerName) {
        return DELEGATE.unsetLogLevel(loggerName);
    }

    public static boolean loggerExists(String loggerName) {
        return DELEGATE.loggerExists(loggerName);
    }

    @Override
    public List<String> getLoggers() {
        return LoggingController.loggers().entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).toList();
    }

    @Override
    public String getLogLevel(String loggerName) {
        return LoggingController.loggers().getOrDefault(loggerName, "No such logger.");
    }

    @Override
    public boolean setLogLevel(String loggerName, String level) {
        return LoggingController.logLevel(loggerName, level);
    }

    static {
        LoggingControllerDelegate tempDelegate;
        LOGGER = LogManager.getLogger(LoggingController.class);
        try {
            tempDelegate = new Log4jCoreController();
        }
        catch (ClassCastException | LinkageError e) {
            LOGGER.info("No supported logging implementation found. Logging configuration endpoint will be disabled.");
            tempDelegate = new NoOpController();
        }
        catch (Exception e) {
            LOGGER.warn("A problem occurred, while initializing the logging controller. Logging configuration endpoint will be disabled.", (Throwable)e);
            tempDelegate = new NoOpController();
        }
        DELEGATE = tempDelegate;
    }
}

