/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.quota;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ThrottleCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottledChannel
implements Delayed {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThrottledChannel.class);
    private final Time time;
    private final int throttleTimeMs;
    private final ThrottleCallback callback;
    private final long endTimeNanos;

    public ThrottledChannel(Time time, int throttleTimeMs, ThrottleCallback callback) {
        this.time = time;
        this.throttleTimeMs = throttleTimeMs;
        this.callback = callback;
        this.endTimeNanos = time.nanoseconds() + TimeUnit.MILLISECONDS.toNanos(throttleTimeMs);
        callback.startThrottling();
    }

    public void notifyThrottlingDone() {
        LOGGER.trace("Channel throttled for: {} ms", (Object)this.throttleTimeMs);
        this.callback.endThrottling();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.endTimeNanos - this.time.nanoseconds(), TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(Delayed other) {
        ThrottledChannel otherChannel = (ThrottledChannel)other;
        return Long.compare(this.endTimeNanos, otherChannel.endTimeNanos);
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }
}

