/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.extensions;

import io.smallrye.openapi.model.Extensions;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.MapModelIO;
import io.smallrye.openapi.runtime.io.Names;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class ExtensionIO<V, A extends V, O extends V, AB, OB>
extends MapModelIO<Object, V, A, O, AB, OB> {
    private static final String PROP_VALUE = "value";
    private static final String EXTENSION_PROPERTY_PREFIX = "x-";
    private static final String PROP_PARSE_VALUE = "parseValue";

    public static boolean isExtension(String name) {
        return name.toLowerCase().startsWith(EXTENSION_PROPERTY_PREFIX);
    }

    public static boolean isExtension(Map.Entry<String, ?> entry) {
        return ExtensionIO.isExtension(entry.getKey());
    }

    public ExtensionIO(IOContext<V, A, O, AB, OB> context) {
        super(context, Names.EXTENSION, Names.create(Object.class));
    }

    @Override
    protected Optional<String> getName(AnnotationInstance annotation) {
        return super.getName(annotation).map(name -> name.startsWith(EXTENSION_PROPERTY_PREFIX) ? name : EXTENSION_PROPERTY_PREFIX.concat((String)name));
    }

    @Override
    public Object read(AnnotationInstance extension) {
        Object parsedValue;
        IoLogging.logger.annotation("@Extension");
        String extValue = (String)this.value(extension, PROP_VALUE);
        if (Boolean.TRUE.equals(this.value(extension, PROP_PARSE_VALUE, false))) {
            String name = this.getName(extension).orElseThrow(IllegalStateException::new);
            parsedValue = this.scannerContext().getExtensions().stream().map(ext -> ext.parseExtension(name, extValue)).filter(Objects::nonNull).findFirst().orElse(extValue);
        } else {
            parsedValue = extValue;
        }
        return parsedValue;
    }

    public Map<String, Object> readExtensible(AnnotationInstance extensible) {
        AnnotationInstance[] extensions = Optional.ofNullable(extensible.value("extensions")).map(AnnotationValue::asNestedArray).orElseGet(() -> (AnnotationInstance[])this.getRepeatableAnnotations(extensible.target()).stream().toArray(AnnotationInstance[]::new));
        if (extensions.length > 0) {
            return this.readMap(extensions);
        }
        return null;
    }

    @Override
    public Map<String, Object> readObjectMap(O node) {
        return this.readMap(node, ExtensionIO::isExtension, this.jsonIO()::fromJson);
    }

    @Override
    public Object readObject(O node) {
        return this.jsonIO().fromJson(node);
    }

    @Override
    public Optional<O> write(Extensible<?> model) {
        return this.optionalJsonObject(model.getExtensions()).map(node -> {
            model.getExtensions().entrySet().stream().map(e -> ExtensionIO.isExtension(e) ? e : ExtensionIO.entry(EXTENSION_PROPERTY_PREFIX + (String)e.getKey(), e.getValue())).filter(Predicate.not(e -> Extensions.isPrivateExtension((String)((String)e.getKey())))).forEach(e -> this.setIfPresent(node, (String)e.getKey(), this.jsonIO().toJson(e.getValue())));
            return node;
        }).map(this.jsonIO()::buildObject);
    }
}

