/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl;

import io.vertx.core.Handler;
import io.vertx.core.eventbus.DeliveryContext;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.impl.MessageImpl;
import io.vertx.core.impl.ContextInternal;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

abstract class DeliveryContextBase<T>
implements DeliveryContext<T> {
    private static final AtomicIntegerFieldUpdater<DeliveryContextBase> UPDATER = AtomicIntegerFieldUpdater.newUpdater(DeliveryContextBase.class, "interceptorIdx");
    public final MessageImpl<?, T> message;
    public final ContextInternal context;
    private final Handler<DeliveryContext>[] interceptors;
    private volatile int interceptorIdx;

    protected DeliveryContextBase(MessageImpl<?, T> message, Handler<DeliveryContext>[] interceptors, ContextInternal context) {
        this.message = message;
        this.interceptors = interceptors;
        this.context = context;
        this.interceptorIdx = 0;
    }

    void dispatch() {
        this.next();
    }

    @Override
    public Message<T> message() {
        return this.message;
    }

    protected abstract void execute();

    @Override
    public void next() {
        int idx = UPDATER.getAndIncrement(this);
        if (idx < this.interceptors.length) {
            Handler<DeliveryContext> interceptor = this.interceptors[idx];
            if (this.context.inThread()) {
                this.context.dispatch(this, interceptor);
            } else {
                try {
                    interceptor.handle(this);
                }
                catch (Throwable t) {
                    this.context.reportException(t);
                }
            }
        } else if (idx == this.interceptors.length) {
            this.execute();
        } else {
            throw new IllegalStateException();
        }
    }
}

