/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StreamUtil;

public final class StringPropertyReplacer {
    private static final Logger logger = Logger.getLogger(StringPropertyReplacer.class);
    private static final String FILE_SEPARATOR = File.separator;
    private static final String PATH_SEPARATOR = File.pathSeparator;
    private static final String FILE_SEPARATOR_ALIAS = "/";
    private static final String PATH_SEPARATOR_ALIAS = ":";
    private static final PropertyResolver NULL_RESOLVER = property -> null;
    private static PropertyResolver DEFAULT_PROPERTY_RESOLVER;
    private static final int MAX_KEY_LENGTH = 0x400000;

    public static void setDefaultPropertyResolver(PropertyResolver systemVariables) {
        DEFAULT_PROPERTY_RESOLVER = systemVariables;
    }

    public static String replaceProperties(String string) {
        return StringPropertyReplacer.replaceProperties(string, StringPropertyReplacer.getDefaultPropertyResolver());
    }

    public static String replaceProperties(String string, PropertyResolver resolver) {
        if (string == null) {
            return null;
        }
        int index = string.indexOf("${");
        if (index == -1) {
            return string;
        }
        try {
            return string.substring(0, index).concat(StreamUtil.readString(StringPropertyReplacer.replaceProperties(new ByteArrayInputStream(string.substring(index).getBytes(StandardCharsets.UTF_8)), resolver), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream replaceProperties(InputStream source, PropertyResolver resolver) {
        return StringPropertyReplacer.replaceProperties(source, false, resolver);
    }

    private static InputStream replaceProperties(final InputStream source, final boolean readUntilCurlyBrace, final PropertyResolver resolver) {
        return new InputStream(){
            private ByteArrayInputStream buffer;
            private boolean closed;

            @Override
            public int read() throws IOException {
                int c;
                if (this.closed) {
                    throw new IOException("Stream closed");
                }
                if (this.buffer != null) {
                    c = this.buffer.read();
                    if (c != -1) {
                        return c;
                    }
                    this.buffer = null;
                }
                if ((c = source.read()) == 125 && readUntilCurlyBrace) {
                    return -2;
                }
                if (c != 36) {
                    return c;
                }
                int next = source.read();
                if (next != 123) {
                    this.buffer = new ByteArrayInputStream(new byte[]{(byte)c, (byte)next});
                    return this.read();
                }
                int keyChar = -1;
                InputStream keyStream = StringPropertyReplacer.replaceProperties(source, true, resolver);
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                while ((keyChar = keyStream.read()) > -1) {
                    bytes.write((byte)keyChar);
                    if (bytes.size() != 0x400000) continue;
                    logger.log(Logger.Level.WARN, (Object)"Detected an unclosed ${, replacement will not be performed");
                    keyChar = -1;
                    break;
                }
                String keyString = bytes.toString(StandardCharsets.UTF_8.name());
                String replacement = null;
                if (keyChar == -1) {
                    replacement = "${" + keyString;
                } else {
                    replacement = StringPropertyReplacer.replaceProperty(resolver, keyString);
                    if (replacement == null) {
                        replacement = "${" + keyString + "}";
                    } else {
                        try {
                            replacement = StringPropertyReplacer.replaceProperties(replacement, resolver);
                        }
                        catch (StackOverflowError ex) {
                            throw new IllegalStateException("Infinite recursion happening when replacing properties on '" + replacement + "'");
                        }
                    }
                }
                this.buffer = new ByteArrayInputStream(replacement.getBytes(StandardCharsets.UTF_8));
                return this.read();
            }

            @Override
            public void close() throws IOException {
                this.closed = true;
                source.close();
            }
        };
    }

    private static String replaceProperty(PropertyResolver resolver, String key) {
        String value = null;
        if (FILE_SEPARATOR_ALIAS.equals(key)) {
            value = FILE_SEPARATOR;
        } else if (PATH_SEPARATOR_ALIAS.equals(key)) {
            value = PATH_SEPARATOR;
        } else {
            value = StringPropertyReplacer.resolveValue(resolver, key);
            if (value == null) {
                int colon = key.indexOf(58);
                if (colon > 0) {
                    String realKey = key.substring(0, colon);
                    value = StringPropertyReplacer.resolveValue(resolver, realKey);
                    if (value == null && (value = StringPropertyReplacer.resolveCompositeKey(realKey, resolver)) == null) {
                        value = key.substring(colon + 1);
                    }
                } else {
                    value = StringPropertyReplacer.resolveCompositeKey(key, resolver);
                }
            }
        }
        return value;
    }

    private static String resolveCompositeKey(String key, PropertyResolver resolver) {
        String value = null;
        int comma = key.indexOf(44);
        if (comma > -1) {
            if (comma > 0) {
                String key1 = key.substring(0, comma);
                value = StringPropertyReplacer.resolveValue(resolver, key1);
            }
            if (value == null && comma < key.length() - 1) {
                String key2 = key.substring(comma + 1);
                value = StringPropertyReplacer.resolveValue(resolver, key2);
            }
        }
        return value;
    }

    private static String resolveValue(PropertyResolver resolver, String key) {
        if (resolver == null) {
            return StringPropertyReplacer.getDefaultPropertyResolver().resolve(key);
        }
        return resolver.resolve(key);
    }

    private static PropertyResolver getDefaultPropertyResolver() {
        return Optional.ofNullable(DEFAULT_PROPERTY_RESOLVER).orElse(NULL_RESOLVER);
    }

    public static interface PropertyResolver {
        public String resolve(String var1);
    }
}

