/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SingleValueExtensionBase<T> {
    private final T value;

    protected SingleValueExtensionBase(@NotNull T value) {
        this.value = value;
    }

    public T getValue(@NotNull String key) {
        if (!key.equals(this.getIdentifier())) {
            throw new IllegalArgumentException(String.format("%s is the only valid key.", this.getIdentifier()));
        }
        return this.value;
    }

    @NotNull
    protected abstract String getIdentifier();

    @NotNull
    public T getValue() {
        return this.value;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleValueExtensionBase that = (SingleValueExtensionBase)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }
}

