/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.deployment.binder;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import java.util.function.BooleanSupplier;

public class StorkBinderProcessor {
    static final String OBSERVABLE_CLIENT = "io.smallrye.stork.api.Service";
    static final String METRICS_BEAN_CLASS = "io.quarkus.micrometer.runtime.binder.stork.StorkObservationCollectorBean";
    static final Class<?> OBSERVABLE_CLIENT_CLASS = MicrometerRecorder.getClassForName((String)"io.smallrye.stork.api.Service");

    @BuildStep(onlyIf={StorkMetricsSupportEnabled.class})
    AdditionalBeanBuildItem addStorkObservationCollector() {
        return AdditionalBeanBuildItem.unremovableOf((String)METRICS_BEAN_CLASS);
    }

    static class StorkMetricsSupportEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;

        StorkMetricsSupportEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return OBSERVABLE_CLIENT_CLASS != null && this.mConfig.checkBinderEnabledWithDefault((MicrometerConfig.CapabilityEnabled)this.mConfig.binder().stork());
        }
    }
}

