/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.saml.mappers;

import org.jboss.logging.Logger;
import org.keycloak.broker.provider.AbstractIdentityProviderMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public abstract class AbstractAttributeToRoleMapper
extends AbstractIdentityProviderMapper {
    private static final Logger LOG = Logger.getLogger(AbstractAttributeToRoleMapper.class);

    public void importNewUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        RoleModel role = this.getRole(realm, mapperModel);
        if (role == null) {
            return;
        }
        if (this.applies(mapperModel, context)) {
            user.grantRole(role);
        }
    }

    public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        RoleModel role = this.getRole(realm, mapperModel);
        if (role == null) {
            return;
        }
        String roleName = (String)mapperModel.getConfig().get("role");
        if (!context.hasMapperGrantedRole(roleName)) {
            if (this.applies(mapperModel, context)) {
                context.addMapperGrantedRole(roleName);
                if (!role.isClientRole() && user.getRealmRoleMappingsStream().noneMatch(r -> r.equals((Object)role)) || role.isClientRole() && user.getClientRoleMappingsStream(session.clients().getClientById(realm, role.getContainerId())).noneMatch(r -> r.equals((Object)role))) {
                    user.grantRole(role);
                }
            } else if (!role.isClientRole() && user.getRealmRoleMappingsStream().anyMatch(r -> r.equals((Object)role)) || role.isClientRole() && user.getClientRoleMappingsStream(session.clients().getClientById(realm, role.getContainerId())).anyMatch(r -> r.equals((Object)role))) {
                user.deleteRoleMapping(role);
            }
        }
    }

    protected abstract boolean applies(IdentityProviderMapperModel var1, BrokeredIdentityContext var2);

    private RoleModel getRole(RealmModel realm, IdentityProviderMapperModel mapperModel) {
        String roleName = (String)mapperModel.getConfig().get("role");
        RoleModel role = KeycloakModelUtils.getRoleFromString((RealmModel)realm, (String)roleName);
        if (role == null) {
            LOG.warnf("Unable to find role '%s' for mapper '%s' on realm '%s'.", (Object)roleName, (Object)mapperModel.getName(), (Object)realm.getName());
        }
        return role;
    }
}

