/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.h2.command.query.Query;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionList;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableType;
import org.h2.util.HasSQL;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueRow;

public class IndexCondition {
    public static final int EQUALITY = 1;
    public static final int START = 2;
    public static final int END = 4;
    public static final int RANGE = 6;
    public static final int ALWAYS_FALSE = 8;
    public static final int SPATIAL_INTERSECTS = 16;
    private final Column column;
    private final Column[] columns;
    private final boolean compoundColumns;
    private final int compareType;
    private final Expression expression;
    private final List<Expression> expressionList;
    private final Query expressionQuery;

    private IndexCondition(int n, ExpressionColumn expressionColumn, Column[] columnArray, Expression expression, List<Expression> list, Query query) {
        this.compareType = n;
        if (expressionColumn != null) {
            this.column = expressionColumn.getColumn();
            this.columns = null;
            this.compoundColumns = false;
        } else if (columnArray != null) {
            this.column = null;
            this.columns = columnArray;
            this.compoundColumns = true;
        } else {
            this.column = null;
            this.columns = null;
            this.compoundColumns = false;
        }
        this.expression = expression;
        this.expressionList = list;
        this.expressionQuery = query;
    }

    public static IndexCondition get(int n, ExpressionColumn expressionColumn, Expression expression) {
        return new IndexCondition(n, expressionColumn, null, expression, null, null);
    }

    public static IndexCondition getInList(ExpressionColumn expressionColumn, List<Expression> list) {
        return new IndexCondition(10, expressionColumn, null, null, list, null);
    }

    public static IndexCondition getCompoundInList(ExpressionList expressionList, List<Expression> list) {
        int n = expressionList.getSubexpressionCount();
        Column[] columnArray = new Column[n];
        int n2 = n;
        while (--n2 >= 0) {
            columnArray[n2] = ((ExpressionColumn)expressionList.getSubexpression(n2)).getColumn();
        }
        return new IndexCondition(10, null, columnArray, null, list, null);
    }

    public static IndexCondition getInArray(ExpressionColumn expressionColumn, Expression expression) {
        return new IndexCondition(11, expressionColumn, null, expression, null, null);
    }

    public static IndexCondition getInQuery(ExpressionColumn expressionColumn, Query query) {
        assert (query.isRandomAccessResult());
        return new IndexCondition(12, expressionColumn, null, null, null, query);
    }

    public Value getCurrentValue(SessionLocal sessionLocal) {
        return this.expression.getValue(sessionLocal);
    }

    public Value[] getCurrentValueList(SessionLocal sessionLocal) {
        Object object;
        TreeSet<Value> treeSet = new TreeSet<Value>(sessionLocal.getDatabase().getCompareMode());
        if (this.compareType == 10) {
            if (this.isCompoundColumns()) {
                object = this.getColumns();
                for (Expression expression : this.expressionList) {
                    ValueRow valueRow = (ValueRow)expression.getValue(sessionLocal);
                    valueRow = Column.convert(sessionLocal, (Column[])object, valueRow);
                    treeSet.add(valueRow);
                }
            } else {
                object = this.getColumn();
                for (Expression expression : this.expressionList) {
                    Value value = expression.getValue(sessionLocal);
                    value = ((Column)object).convert(sessionLocal, value);
                    treeSet.add(value);
                }
            }
        } else if (this.compareType == 11) {
            object = this.expression.getValue(sessionLocal);
            if (object instanceof ValueArray) {
                for (Value value : ((ValueArray)object).getList()) {
                    treeSet.add(value);
                }
            }
        } else {
            throw DbException.getInternalError("compareType = " + this.compareType);
        }
        object = treeSet.toArray(new Value[treeSet.size()]);
        Arrays.sort(object, sessionLocal.getDatabase().getCompareMode());
        return object;
    }

    public ResultInterface getCurrentResult() {
        return this.expressionQuery.query(0L);
    }

    public String getSQL(int n) {
        if (this.compareType == 9) {
            return "FALSE";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder = this.isCompoundColumns() ? this.buildSql(n, stringBuilder) : this.buildSql(n, this.getColumn(), stringBuilder);
        return stringBuilder.toString();
    }

    private StringBuilder buildSql(int n, StringBuilder stringBuilder) {
        if (this.compareType == 10) {
            stringBuilder.append(" IN(");
            int n2 = this.expressionList.size();
            for (int i = 0; i < n2; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.expressionList.get(i).getSQL(n));
            }
            return stringBuilder.append(')');
        }
        throw DbException.getInternalError("Multiple columns can only be used with compound IN lists.");
    }

    private StringBuilder buildSql(int n, Column column, StringBuilder stringBuilder) {
        column.getSQL(stringBuilder, n);
        switch (this.compareType) {
            case 0: {
                stringBuilder.append(" = ");
                break;
            }
            case 6: {
                stringBuilder.append(this.expression.isNullConstant() || column.getType().getValueType() == 8 && this.expression.isConstant() ? " IS " : " IS NOT DISTINCT FROM ");
                break;
            }
            case 5: {
                stringBuilder.append(" >= ");
                break;
            }
            case 3: {
                stringBuilder.append(" > ");
                break;
            }
            case 4: {
                stringBuilder.append(" <= ");
                break;
            }
            case 2: {
                stringBuilder.append(" < ");
                break;
            }
            case 10: {
                Expression.writeExpressions(stringBuilder.append(" IN("), this.expressionList, n).append(')');
                break;
            }
            case 11: {
                return this.expression.getSQL(stringBuilder.append(" = ANY("), n, 0).append(')');
            }
            case 12: {
                stringBuilder.append(" IN(");
                this.expressionQuery.getPlanSQL(stringBuilder, n);
                stringBuilder.append(')');
                break;
            }
            case 8: {
                stringBuilder.append(" && ");
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + this.compareType);
            }
        }
        if (this.expression != null) {
            this.expression.getSQL(stringBuilder, n, 0);
        }
        return stringBuilder;
    }

    public int getMask(ArrayList<IndexCondition> arrayList) {
        switch (this.compareType) {
            case 9: {
                return 8;
            }
            case 0: 
            case 6: {
                return 1;
            }
            case 10: 
            case 11: 
            case 12: {
                if (arrayList.size() > 1) {
                    if (this.isCompoundColumns()) {
                        Column[] columnArray = this.getColumns();
                        int n = columnArray.length;
                        while (--n >= 0) {
                            if (TableType.TABLE == columnArray[n].getTable().getTableType()) continue;
                            return 0;
                        }
                    } else if (TableType.TABLE != this.getColumn().getTable().getTableType()) {
                        return 0;
                    }
                }
                return 1;
            }
            case 3: 
            case 5: {
                return 2;
            }
            case 2: 
            case 4: {
                return 4;
            }
            case 8: {
                return 16;
            }
        }
        throw DbException.getInternalError("type=" + this.compareType);
    }

    public boolean isAlwaysFalse() {
        return this.compareType == 9;
    }

    public boolean isStart() {
        switch (this.compareType) {
            case 0: 
            case 3: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public boolean isEnd() {
        switch (this.compareType) {
            case 0: 
            case 2: 
            case 4: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public boolean isSpatialIntersects() {
        switch (this.compareType) {
            case 8: {
                return true;
            }
        }
        return false;
    }

    public int getCompareType() {
        return this.compareType;
    }

    public Column getColumn() {
        if (!this.isCompoundColumns()) {
            return this.column;
        }
        throw DbException.getInternalError("The getColumn() method cannot be with multiple columns.");
    }

    public Column[] getColumns() {
        if (this.isCompoundColumns()) {
            return this.columns;
        }
        throw DbException.getInternalError("The getColumns() method cannot be with a single column.");
    }

    public boolean isCompoundColumns() {
        return this.compoundColumns;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public List<Expression> getExpressionList() {
        return this.expressionList;
    }

    public Query getExpressionQuery() {
        return this.expressionQuery;
    }

    public boolean isEvaluatable() {
        if (this.expression != null) {
            return this.expression.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR);
        }
        if (this.expressionList != null) {
            for (Expression expression : this.expressionList) {
                if (expression.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) continue;
                return false;
            }
            return true;
        }
        return this.expressionQuery.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR);
    }

    public IndexCondition cloneWithIndexColumns(Index index) {
        int n;
        if (!this.isCompoundColumns()) {
            throw DbException.getInternalError("The cloneWithColumns() method cannot be with a single column.");
        }
        IndexColumn[] indexColumnArray = index.getIndexColumns();
        int n2 = indexColumnArray.length;
        if (n2 != this.columns.length) {
            return null;
        }
        int[] nArray = new int[n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (indexColumnArray[i] == null || indexColumnArray[i].column == null) {
                return null;
            }
            for (n = 0; n < this.columns.length; ++n) {
                if (this.columns[n] != indexColumnArray[i].column) continue;
                nArray[n] = i;
                ++n3;
            }
        }
        if (n3 != n2) {
            return null;
        }
        Column[] columnArray = new Column[n2];
        for (n = 0; n < n2; ++n) {
            columnArray[n] = this.columns[nArray[n]];
        }
        ArrayList<Expression> arrayList = new ArrayList<Expression>(n2);
        for (Expression expression : this.expressionList) {
            HasSQL hasSQL;
            Expression expression2;
            if (expression instanceof ValueExpression) {
                expression2 = (ValueExpression)expression;
                hasSQL = (ValueRow)((ValueExpression)expression2).getValue(null);
                ValueRow valueRow = hasSQL.cloneWithOrder(nArray);
                arrayList.add(ValueExpression.get(valueRow));
                continue;
            }
            if (expression instanceof ExpressionList) {
                expression2 = (ExpressionList)expression;
                hasSQL = ((ExpressionList)expression2).cloneWithOrder(nArray);
                arrayList.add((Expression)hasSQL);
                continue;
            }
            throw DbException.getInternalError("Unexpected expression type: " + expression.getClass());
        }
        return new IndexCondition(10, null, columnArray, null, arrayList, null);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.isCompoundColumns()) {
            stringBuilder.append("column=").append(this.column);
        } else {
            stringBuilder.append("columns=");
            Column.writeColumns(stringBuilder, this.columns, 3);
        }
        stringBuilder.append(", compareType=");
        return IndexCondition.compareTypeToString(stringBuilder, this.compareType).append(", expression=").append(this.expression).append(", expressionList=").append(this.expressionList).append(", expressionQuery=").append(this.expressionQuery).toString();
    }

    private static StringBuilder compareTypeToString(StringBuilder stringBuilder, int n) {
        boolean bl = false;
        if ((n & 1) == 1) {
            bl = true;
            stringBuilder.append("EQUALITY");
        }
        if ((n & 2) == 2) {
            if (bl) {
                stringBuilder.append(", ");
            }
            bl = true;
            stringBuilder.append("START");
        }
        if ((n & 4) == 4) {
            if (bl) {
                stringBuilder.append(", ");
            }
            bl = true;
            stringBuilder.append("END");
        }
        if ((n & 8) == 8) {
            if (bl) {
                stringBuilder.append(", ");
            }
            bl = true;
            stringBuilder.append("ALWAYS_FALSE");
        }
        if ((n & 0x10) == 16) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("SPATIAL_INTERSECTS");
        }
        return stringBuilder;
    }
}

