/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.util.Set;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.events.BaseClientEvent;

@ProtoTypeId(value=65576)
public class ClientUpdatedEvent
extends BaseClientEvent {
    @ProtoField(value=3)
    final String clientId;

    @ProtoFactory
    ClientUpdatedEvent(String id, String realmId, String clientId) {
        super(id, realmId);
        this.clientId = clientId;
    }

    public static ClientUpdatedEvent create(String clientUuid, String clientId, String realmId) {
        return new ClientUpdatedEvent(clientUuid, realmId, clientId);
    }

    @Override
    public String toString() {
        return String.format("ClientUpdatedEvent [ realmId=%s, clientUuid=%s, clientId=%s ]", this.realmId, this.getId(), this.clientId);
    }

    @Override
    public void addInvalidations(RealmCacheManager realmCache, Set<String> invalidations) {
        realmCache.clientUpdated(this.realmId, this.getId(), this.clientId, invalidations);
    }
}

