/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.Column;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.annotations.CollectionId;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.models.spi.ModelsContext;

public class CollectionIdAnnotation
implements CollectionId {
    private Column column;
    private Class<? extends IdentifierGenerator> generatorImplementation;
    private String generator;

    public CollectionIdAnnotation(ModelsContext modelContext) {
        this.column = (Column)JpaAnnotations.COLUMN.createUsage(modelContext);
        this.generatorImplementation = IdentifierGenerator.class;
        this.generator = "";
    }

    public CollectionIdAnnotation(CollectionId annotation, ModelsContext modelContext) {
        this.column = (Column)OrmAnnotationHelper.extractJdkValue(annotation, HibernateAnnotations.COLLECTION_ID, "column", modelContext);
        this.generatorImplementation = annotation.generatorImplementation();
        this.generator = annotation.generator();
    }

    public CollectionIdAnnotation(Map<String, Object> attributeValues, ModelsContext modelContext) {
        this.column = (Column)attributeValues.get("column");
        this.generatorImplementation = (Class)attributeValues.get("generatorImplementation");
        this.generator = (String)attributeValues.get("generator");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return CollectionId.class;
    }

    @Override
    public Column column() {
        return this.column;
    }

    public void column(Column value) {
        this.column = value;
    }

    @Override
    public Class<? extends IdentifierGenerator> generatorImplementation() {
        return this.generatorImplementation;
    }

    public void generatorImplementation(Class<? extends IdentifierGenerator> value) {
        this.generatorImplementation = value;
    }

    @Override
    public String generator() {
        return this.generator;
    }

    public void generator(String value) {
        this.generator = value;
    }
}

