/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import jakarta.persistence.ParameterMode;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.procedure.FunctionReturn;
import org.hibernate.procedure.internal.AbstractStandardCallableStatementSupport;
import org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.spi.ProcedureParameterMetadataImplementor;
import org.hibernate.sql.exec.internal.JdbcCallImpl;
import org.hibernate.sql.exec.spi.JdbcCallParameterRegistration;
import org.hibernate.sql.exec.spi.JdbcOperationQueryCall;

public class JTDSCallableStatementSupport
extends AbstractStandardCallableStatementSupport {
    public static final JTDSCallableStatementSupport INSTANCE = new JTDSCallableStatementSupport();

    @Override
    public JdbcOperationQueryCall interpretCall(ProcedureCallImplementor<?> procedureCall) {
        String procedureName = procedureCall.getProcedureName();
        FunctionReturn functionReturn = procedureCall.getFunctionReturn();
        ProcedureParameterMetadataImplementor parameterMetadata = procedureCall.getParameterMetadata();
        List<ProcedureParameterImplementor<?>> registrations = parameterMetadata.getRegistrationsAsList();
        int paramStringSizeEstimate = functionReturn == null && parameterMetadata.hasNamedParameters() ? registrations.size() * 12 : registrations.size() * 2;
        JdbcCallImpl.Builder builder = new JdbcCallImpl.Builder();
        if (functionReturn != null) {
            throw new QueryException("The jTDS driver does not support calling functions through the JDBC CallableStatement API");
        }
        int offset = 1;
        StringBuilder buffer = new StringBuilder(9 + procedureName.length() + paramStringSizeEstimate).append("{call ");
        buffer.append(procedureName);
        if (registrations.isEmpty()) {
            buffer.append('(');
        } else {
            int sep = 40;
            for (int i = 0; i < registrations.size(); ++i) {
                ProcedureParameterImplementor<?> parameter = registrations.get(i);
                if (parameter.getMode() == ParameterMode.REF_CURSOR) {
                    throw new QueryException("Dialect [" + procedureCall.getSession().getJdbcServices().getJdbcEnvironment().getDialect().getClass().getName() + "] not known to support REF_CURSOR parameters");
                }
                buffer.append((char)sep);
                JdbcCallParameterRegistration registration = parameter.toJdbcParameterRegistration(i + offset, procedureCall);
                if (parameter.getName() != null) {
                    buffer.append('@').append(parameter.getName()).append("=?");
                } else {
                    buffer.append("?");
                }
                sep = 44;
                builder.addParameterRegistration(registration);
            }
        }
        buffer.append(")}");
        builder.setCallableName(buffer.toString());
        return builder.buildJdbcCall();
    }
}

