/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.internal.dynamic;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.results.ResultBuilderInstantiationValued;
import org.hibernate.query.results.internal.Builders;
import org.hibernate.query.results.internal.dynamic.DynamicResultBuilder;
import org.hibernate.query.sqm.DynamicInstantiationNature;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.instantiation.internal.ArgumentDomainResult;
import org.hibernate.sql.results.graph.instantiation.internal.DynamicInstantiationResultImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.type.descriptor.java.JavaType;

public class DynamicResultBuilderInstantiation<J>
implements DynamicResultBuilder,
ResultBuilderInstantiationValued,
NativeQuery.InstantiationResultNode<J> {
    private final JavaType<J> javaType;
    private final List<InstantiationArgument> argumentResultBuilders;

    public DynamicResultBuilderInstantiation(JavaType<J> javaType) {
        this.javaType = javaType;
        this.argumentResultBuilders = new ArrayList<InstantiationArgument>();
    }

    private DynamicResultBuilderInstantiation(DynamicResultBuilderInstantiation<J> original) {
        this.javaType = original.javaType;
        ArrayList<InstantiationArgument> arguments = new ArrayList<InstantiationArgument>(original.argumentResultBuilders.size());
        for (InstantiationArgument arg : original.argumentResultBuilders) {
            arguments.add(new InstantiationArgument(arg.argumentBuilder.cacheKeyInstance(), arg.resultAlias));
        }
        this.argumentResultBuilders = arguments;
    }

    @Override
    public Class<?> getJavaType() {
        return this.javaType.getJavaTypeClass();
    }

    @Override
    public NativeQuery.InstantiationResultNode<J> addBasicArgument(String columnAlias, String argumentAlias) {
        this.argumentResultBuilders.add(new InstantiationArgument(Builders.scalar(columnAlias), argumentAlias));
        return this;
    }

    @Override
    public DynamicResultBuilderInstantiation<?> cacheKeyInstance() {
        return new DynamicResultBuilderInstantiation<J>(this);
    }

    @Override
    public DomainResult<?> buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, DomainResultCreationState domainResultCreationState) {
        if (this.argumentResultBuilders.isEmpty()) {
            throw new IllegalStateException("DynamicResultBuilderInstantiation defined no arguments");
        }
        ArrayList argumentDomainResults = new ArrayList(this.argumentResultBuilders.size());
        for (int i = 0; i < this.argumentResultBuilders.size(); ++i) {
            argumentDomainResults.add(new ArgumentDomainResult(this.argumentResultBuilders.get((int)i).argumentBuilder.buildResult(jdbcResultsMetadata, i, domainResultCreationState)));
        }
        return new DynamicInstantiationResultImpl<J>(null, DynamicInstantiationNature.CLASS, this.javaType, argumentDomainResults);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicResultBuilderInstantiation that = (DynamicResultBuilderInstantiation)o;
        return this.javaType.equals(that.javaType) && this.argumentResultBuilders.equals(that.argumentResultBuilders);
    }

    public int hashCode() {
        int result = this.javaType.hashCode();
        result = 31 * result + this.argumentResultBuilders.hashCode();
        return result;
    }

    private static class InstantiationArgument {
        private final DynamicResultBuilder argumentBuilder;
        private final String resultAlias;

        public InstantiationArgument(DynamicResultBuilder argumentBuilder, String resultAlias) {
            this.argumentBuilder = argumentBuilder;
            this.resultAlias = resultAlias;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InstantiationArgument that = (InstantiationArgument)o;
            return this.argumentBuilder.equals(that.argumentBuilder) && this.resultAlias.equals(that.resultAlias);
        }

        public int hashCode() {
            int result = this.argumentBuilder.hashCode();
            result = 31 * result + this.resultAlias.hashCode();
            return result;
        }
    }
}

