/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.usertype;

import jakarta.persistence.AttributeConverter;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.hibernate.Incubating;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public interface UserType<J> {
    public int getSqlType();

    public Class<J> returnedClass();

    default public boolean equals(J x, J y) {
        return Objects.equals(x, y);
    }

    default public int hashCode(J x) {
        return Objects.hashCode(x);
    }

    @Deprecated(since="7", forRemoval=true)
    default public J nullSafeGet(ResultSet rs, int position, SharedSessionContractImplementor session, @Deprecated Object owner) throws SQLException {
        return this.nullSafeGet(rs, position, session);
    }

    default public J nullSafeGet(ResultSet rs, int position, WrapperOptions options) throws SQLException {
        J result = rs.getObject(position, this.returnedClass());
        return rs.wasNull() ? null : (J)result;
    }

    @Deprecated(since="7", forRemoval=true)
    default public void nullSafeSet(PreparedStatement st, J value, int position, SharedSessionContractImplementor session) throws SQLException {
        this.nullSafeSet(st, value, position, (WrapperOptions)session);
    }

    default public void nullSafeSet(PreparedStatement st, J value, int position, WrapperOptions options) throws SQLException {
        if (value == null) {
            st.setNull(position, this.getSqlType());
        } else {
            st.setObject(position, value, this.getSqlType());
        }
    }

    public J deepCopy(J var1);

    public boolean isMutable();

    default public Serializable disassemble(J value) {
        if (Serializable.class.isAssignableFrom(this.returnedClass())) {
            return (Serializable)this.deepCopy(value);
        }
        throw new UnsupportedOperationException("User-defined type '" + this.getClass().getName() + "' does not override 'disassemble()'");
    }

    default public J assemble(Serializable cached, Object owner) {
        if (this.returnedClass().isInstance(cached)) {
            return (J)this.deepCopy(cached);
        }
        throw new UnsupportedOperationException("User-defined type '" + this.getClass().getName() + "' does not override 'assemble()'");
    }

    default public J replace(J detached, J managed, Object owner) {
        return this.deepCopy(detached);
    }

    default public long getDefaultSqlLength() {
        return 255L;
    }

    default public int getDefaultSqlPrecision() {
        return 19;
    }

    default public int getDefaultSqlScale() {
        return 2;
    }

    @Deprecated(since="7.0", forRemoval=true)
    default public long getDefaultSqlLength(Dialect dialect, JdbcType jdbcType) {
        return this.getDefaultSqlLength();
    }

    @Deprecated(since="7.0", forRemoval=true)
    default public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return this.getDefaultSqlPrecision();
    }

    @Deprecated(since="7.0", forRemoval=true)
    default public int getDefaultSqlScale(Dialect dialect, JdbcType jdbcType) {
        return this.getDefaultSqlScale();
    }

    @Incubating
    default public AttributeConverter<J, ?> getValueConverter() {
        return null;
    }

    @Incubating
    default public Boolean isComparable() {
        return null;
    }
}

