/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.ConstantInfo;
import io.vertx.codegen.GenException;
import io.vertx.codegen.Helper;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.Model;
import io.vertx.codegen.ModuleInfo;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.Signature;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.TypeValidator;
import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.codegen.doc.Doc;
import io.vertx.codegen.doc.Tag;
import io.vertx.codegen.doc.Text;
import io.vertx.codegen.doc.Token;
import io.vertx.codegen.type.AnnotationValueInfo;
import io.vertx.codegen.type.AnnotationValueInfoFactory;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.EnumTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeMirrorFactory;
import io.vertx.codegen.type.TypeUse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class ClassModel
implements Model {
    public static final String VERTX_READ_STREAM = "io.vertx.core.streams.ReadStream";
    public static final String VERTX_WRITE_STREAM = "io.vertx.core.streams.WriteStream";
    public static final String VERTX_ASYNC_RESULT = "io.vertx.core.AsyncResult";
    public static final String VERTX_HANDLER = "io.vertx.core.Handler";
    public static final String JSON_OBJECT = "io.vertx.core.json.JsonObject";
    public static final String JSON_ARRAY = "io.vertx.core.json.JsonArray";
    public static final String VERTX = "io.vertx.core.Vertx";
    public static final String ITERABLE = "java.lang.Iterable";
    public static final String ITERATOR = "java.util.Iterator";
    public static final String FUNCTION = "java.util.function.Function";
    private static final Logger logger = Logger.getLogger(ClassModel.class.getName());
    private static final ClassTypeInfo ASYNC_RESULT_TYPE = new ClassTypeInfo(ClassKind.ASYNC_RESULT, "io.vertx.core.AsyncResult", null, false, Arrays.asList(new TypeParamInfo.Class("io.vertx.core.AsyncResult", 0, "T")), null);
    private static final ClassTypeInfo HANDLER_TYPE = new ClassTypeInfo(ClassKind.HANDLER, "io.vertx.core.Handler", null, false, Arrays.asList(new TypeParamInfo.Class("io.vertx.core.Handler", 0, "T")), null);
    protected final ProcessingEnvironment env;
    protected final AnnotationValueInfoFactory annotationValueInfoFactory;
    protected final Messager messager;
    protected final TypeMirrorFactory typeFactory;
    protected final Doc.Factory docFactory;
    protected final TypeElement modelElt;
    protected final Elements elementUtils;
    protected final Types typeUtils;
    protected boolean processed = false;
    protected LinkedHashMap<ExecutableElement, MethodInfo> methods = new LinkedHashMap();
    protected LinkedHashMap<ExecutableElement, MethodInfo> anyJavaTypeMethods = new LinkedHashMap();
    protected Set<MethodInfo> futureMethods = new HashSet<MethodInfo>();
    protected List<ConstantInfo> constants = new ArrayList<ConstantInfo>();
    protected Set<ClassTypeInfo> collectedTypes = new HashSet<ClassTypeInfo>();
    protected Set<ClassTypeInfo> importedTypes = new HashSet<ClassTypeInfo>();
    protected Set<ApiTypeInfo> referencedTypes = new HashSet<ApiTypeInfo>();
    protected Set<ClassTypeInfo> referencedDataObjectTypes = new HashSet<ClassTypeInfo>();
    protected Set<EnumTypeInfo> referencedEnumTypes = new HashSet<EnumTypeInfo>();
    protected boolean concrete;
    protected ClassTypeInfo type;
    protected String ifaceSimpleName;
    protected String ifaceFQCN;
    protected String ifacePackageName;
    protected String ifaceComment;
    protected Doc doc;
    protected List<TypeInfo> superTypes = new ArrayList<TypeInfo>();
    protected TypeInfo concreteSuperType;
    private List<TypeInfo> superTypeArguments;
    protected List<TypeInfo> abstractSuperTypes = new ArrayList<TypeInfo>();
    protected TypeInfo handlerArg;
    protected TypeInfo readStreamArg;
    protected TypeInfo writeStreamArg;
    protected TypeInfo iterableArg;
    protected TypeInfo iteratorArg;
    protected TypeInfo[] functionArgs;
    protected Map<String, List<MethodInfo>> methodMap;
    protected Map<String, List<AnnotationValueInfo>> methodAnnotationsMap = new LinkedHashMap<String, List<AnnotationValueInfo>>();
    protected List<AnnotationValueInfo> annotations;
    protected boolean deprecated;
    protected Text deprecatedDesc;

    public ClassModel(ProcessingEnvironment env, TypeMirrorFactory typeFactory, TypeElement modelElt) {
        this.elementUtils = env.getElementUtils();
        this.typeUtils = env.getTypeUtils();
        this.env = env;
        this.typeFactory = typeFactory;
        this.docFactory = new Doc.Factory(env.getMessager(), this.elementUtils, this.typeUtils, typeFactory, modelElt);
        this.messager = env.getMessager();
        this.modelElt = modelElt;
        this.annotationValueInfoFactory = new AnnotationValueInfoFactory(typeFactory);
        this.deprecated = modelElt.getAnnotation(Deprecated.class) != null;
    }

    @Override
    public String getKind() {
        return "class";
    }

    @Override
    public String getFqn() {
        return this.type.getRaw().getName();
    }

    @Override
    public TypeElement getElement() {
        return this.modelElt;
    }

    public List<MethodInfo> getMethods() {
        return new ArrayList<MethodInfo>(this.methods.values());
    }

    public List<MethodInfo> getAnyJavaTypeMethods() {
        return new ArrayList<MethodInfo>(this.anyJavaTypeMethods.values());
    }

    public List<MethodInfo> getStaticMethods() {
        return this.methods.values().stream().filter(MethodInfo::isStaticMethod).collect(Collectors.toList());
    }

    public List<MethodInfo> getInstanceMethods() {
        return this.methods.values().stream().filter(m -> !m.isStaticMethod()).collect(Collectors.toList());
    }

    public List<ConstantInfo> getConstants() {
        return this.constants;
    }

    public boolean isConcrete() {
        return this.concrete;
    }

    public Set<ClassTypeInfo> getImportedTypes() {
        return this.importedTypes;
    }

    public Set<ApiTypeInfo> getReferencedTypes() {
        return this.referencedTypes;
    }

    public Set<ClassTypeInfo> getReferencedDataObjectTypes() {
        return this.referencedDataObjectTypes;
    }

    public Set<EnumTypeInfo> getReferencedEnumTypes() {
        return this.referencedEnumTypes;
    }

    public String getIfaceSimpleName() {
        return this.ifaceSimpleName;
    }

    public String getIfaceFQCN() {
        return this.ifaceFQCN;
    }

    public String getIfacePackageName() {
        return this.ifacePackageName;
    }

    public String getIfaceComment() {
        return this.ifaceComment;
    }

    public Doc getDoc() {
        return this.doc;
    }

    public ClassTypeInfo getType() {
        return this.type;
    }

    @Override
    public ModuleInfo getModule() {
        return this.type.getRaw().getModule();
    }

    public List<TypeInfo> getSuperTypes() {
        return this.superTypes;
    }

    public TypeInfo getConcreteSuperType() {
        return this.concreteSuperType;
    }

    public List<TypeInfo> getAbstractSuperTypes() {
        return this.abstractSuperTypes;
    }

    public Map<String, List<MethodInfo>> getMethodMap() {
        return this.methodMap;
    }

    public List<TypeParamInfo.Class> getTypeParams() {
        return this.type.getRaw().getParams();
    }

    public List<TypeInfo> getSuperTypeArguments() {
        return this.superTypeArguments;
    }

    @Override
    public List<AnnotationValueInfo> getAnnotations() {
        return this.annotations;
    }

    public Map<String, List<AnnotationValueInfo>> getMethodAnnotations() {
        return this.methodAnnotationsMap;
    }

    private void sortMethodMap(Map<String, List<MethodInfo>> map) {
        for (List<MethodInfo> list : map.values()) {
            list.sort(Comparator.comparingInt(meth -> meth.getParams().size()));
        }
    }

    private void determineApiTypes() {
        this.importedTypes = this.collectedTypes.stream().map(ClassTypeInfo::getRaw).flatMap(Helper.instanceOf(ClassTypeInfo.class)).filter(t -> !t.getPackageName().equals(this.ifaceFQCN)).collect(Collectors.toSet());
        this.referencedTypes = this.collectedTypes.stream().map(ClassTypeInfo::getRaw).flatMap(Helper.instanceOf(ApiTypeInfo.class)).filter(t -> !t.equals(this.type.getRaw())).collect(Collectors.toSet());
        this.referencedDataObjectTypes = this.collectedTypes.stream().map(ClassTypeInfo::getRaw).filter(TypeInfo::isDataObjectHolder).collect(Collectors.toSet());
        this.referencedEnumTypes = this.collectedTypes.stream().map(ClassTypeInfo::getRaw).flatMap(Helper.instanceOf(EnumTypeInfo.class)).filter(t -> t.getKind() == ClassKind.ENUM).collect(Collectors.toSet());
    }

    @Override
    public boolean process() {
        if (!this.processed) {
            this.traverseType(this.modelElt);
            this.determineApiTypes();
            this.processTypeAnnotations();
            this.logNonFutures();
            this.processed = true;
            return true;
        }
        return false;
    }

    private void logNonFutures() {
        this.methods.values().stream().filter(m -> m.getOwnerTypes().size() == 1).filter(m -> m.getKind() == MethodKind.CALLBACK && !this.futureMethods.contains(m)).forEach(meth -> this.messager.printMessage(Diagnostic.Kind.NOTE, "Non future method " + this.type.getRaw().getName() + ": " + meth));
    }

    private void processTypeAnnotations() {
        this.annotations = this.elementUtils.getAllAnnotationMirrors(this.modelElt).stream().map(this.annotationValueInfoFactory::processAnnotation).collect(Collectors.toList());
    }

    private void traverseType(Element elem) {
        DeclaredType declaredType = (DeclaredType)elem.asType();
        switch (elem.getKind()) {
            case ENUM: 
            case CLASS: {
                throw new GenException(elem, "@VertxGen can only be used with interfaces or enums in " + declaredType.toString());
            }
            case INTERFACE: {
                if (this.ifaceFQCN != null) {
                    throw new GenException(elem, "Can only have one interface per file");
                }
                this.type = this.typeFactory.create(declaredType).getRaw();
                Helper.checkUnderModule(this, "@VertxGen");
                this.ifaceFQCN = declaredType.toString();
                this.ifaceSimpleName = elem.getSimpleName().toString();
                this.ifacePackageName = this.elementUtils.getPackageOf(elem).getQualifiedName().toString();
                this.ifaceComment = this.elementUtils.getDocComment(elem);
                this.doc = this.docFactory.createDoc(elem);
                if (this.doc != null) {
                    this.doc.getBlockTags().stream().filter(tag -> tag.getName().equals("deprecated")).findFirst().ifPresent(tag -> {
                        this.deprecatedDesc = new Text(Helper.normalizeWhitespaces(tag.getValue())).map(Token.tagMapper(this.elementUtils, this.typeUtils, this.modelElt));
                    });
                }
                this.deprecated = this.deprecated || this.deprecatedDesc != null;
                this.concrete = elem.getAnnotation(VertxGen.class) == null || elem.getAnnotation(VertxGen.class).concrete();
                Object tm = declaredType;
                List<? extends TypeMirror> list = tm.getTypeArguments();
                for (TypeMirror typeMirror : list) {
                    TypeVariable typeVariable = (TypeVariable)typeMirror;
                    if (this.isObjectBound(typeVariable.getUpperBound())) continue;
                    throw new GenException(elem, "Type variable bounds not supported " + typeVariable.getUpperBound());
                }
                List<? extends TypeMirror> list2 = this.typeUtils.directSupertypes((TypeMirror)tm);
                for (TypeMirror typeMirror : list2) {
                    TypeInfo superTypeInfo;
                    if (typeMirror.toString().equals(Object.class.getName())) continue;
                    try {
                        superTypeInfo = this.typeFactory.create(typeMirror);
                    }
                    catch (IllegalArgumentException e) {
                        throw new GenException(elem, e.getMessage());
                    }
                    switch (superTypeInfo.getKind()) {
                        case API: {
                            try {
                                ApiTypeInfo superType = (ApiTypeInfo)this.typeFactory.create(typeMirror).getRaw();
                                if (superType.isConcrete()) {
                                    if (this.concrete) {
                                        if (this.concreteSuperType != null) {
                                            throw new GenException(elem, "A concrete interface cannot extend more than one concrete interfaces");
                                        }
                                    } else {
                                        throw new GenException(elem, "A abstract interface cannot extend a concrete interface");
                                    }
                                    this.concreteSuperType = superTypeInfo;
                                } else {
                                    this.abstractSuperTypes.add(superTypeInfo);
                                }
                                this.superTypes.add(superTypeInfo);
                                break;
                            }
                            catch (Exception e) {
                                throw new GenException(elem, e.getMessage());
                            }
                        }
                    }
                    superTypeInfo.collectImports(this.collectedTypes);
                }
                if (this.concreteSuperType == null || !this.concreteSuperType.isParameterized()) break;
                tm = (DeclaredType)this.modelElt.asType();
                List<? extends TypeMirror> list3 = this.typeUtils.directSupertypes((TypeMirror)tm);
                for (TypeMirror typeMirror : list3) {
                    DeclaredType abc;
                    TypeElement tt;
                    if (typeMirror.getKind() != TypeKind.DECLARED || !(tt = (TypeElement)(abc = (DeclaredType)typeMirror).asElement()).getQualifiedName().toString().equals(this.concreteSuperType.getRaw().getName())) continue;
                    ArrayList<TypeInfo> list4 = new ArrayList<TypeInfo>();
                    int size = tt.getTypeParameters().size();
                    for (int i = 0; i < size; ++i) {
                        TypeMirror q = abc.getTypeArguments().get(i);
                        TypeInfo ti = this.typeFactory.create(q);
                        list4.add(ti);
                    }
                    this.superTypeArguments = list4;
                }
                break;
            }
        }
        this.handlerArg = this.extractArg(VERTX_HANDLER, declaredType);
        this.readStreamArg = this.extractArg(VERTX_READ_STREAM, declaredType);
        this.writeStreamArg = this.extractArg(VERTX_WRITE_STREAM, declaredType);
        this.iterableArg = this.extractArg(ITERABLE, declaredType);
        this.iteratorArg = this.extractArg(ITERATOR, declaredType);
        this.functionArgs = this.extractArgs(FUNCTION, declaredType);
        block18: for (Element element : elem.getEnclosedElements()) {
            if (Helper.isGenIgnore(element)) continue;
            switch (element.getKind()) {
                case METHOD: 
                case FIELD: {
                    continue block18;
                }
            }
            throw new GenException(elem, "@VertxGen can only declare methods and not " + declaredType.toString());
        }
        if (elem.getKind() == ElementKind.INTERFACE) {
            TypeMirror objectType = this.elementUtils.getTypeElement("java.lang.Object").asType();
            this.elementUtils.getAllMembers((TypeElement)elem).stream().filter(elt -> !this.typeUtils.isSameType(elt.getEnclosingElement().asType(), objectType)).flatMap(Helper.FILTER_FIELD).forEach(elt -> {
                boolean allowAnyJavaType;
                GenIgnore genIgnore = elt.getAnnotation(GenIgnore.class);
                if (genIgnore != null) {
                    if (!Arrays.asList(genIgnore.value()).contains("permitted-type")) {
                        return;
                    }
                    allowAnyJavaType = true;
                } else {
                    allowAnyJavaType = false;
                }
                ConstantInfo cst = this.fieldMethod(this.typeUtils, (VariableElement)elt, allowAnyJavaType);
                if (cst != null) {
                    cst.getType().collectImports(this.collectedTypes);
                    this.constants.add(cst);
                }
            });
            this.elementUtils.getAllMembers((TypeElement)elem).stream().filter(elt -> !this.typeUtils.isSameType(elt.getEnclosingElement().asType(), objectType)).flatMap(Helper.FILTER_METHOD).forEach(elt -> {
                boolean allowAnyJavaType;
                GenIgnore genIgnore = elt.getAnnotation(GenIgnore.class);
                if (genIgnore != null) {
                    if (!Arrays.asList(genIgnore.value()).contains("permitted-type")) {
                        return;
                    }
                    allowAnyJavaType = true;
                } else {
                    allowAnyJavaType = false;
                }
                MethodInfo meth = this.createMethod((ExecutableElement)elt, allowAnyJavaType);
                if (meth != null) {
                    meth.collectImports(this.collectedTypes);
                    if (allowAnyJavaType) {
                        this.anyJavaTypeMethods.put((ExecutableElement)elt, meth);
                    } else {
                        this.methodAnnotationsMap.put(meth.getName(), elt.getAnnotationMirrors().stream().map(this.annotationValueInfoFactory::processAnnotation).collect(Collectors.toList()));
                        this.methods.put((ExecutableElement)elt, meth);
                    }
                }
            });
            for (Map map : Arrays.asList(this.methods, this.anyJavaTypeMethods)) {
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry2 = iterator.next();
                    MethodInfo methodInfo = (MethodInfo)entry2.getValue();
                    List<ParamInfo> params = methodInfo.getParams();
                    int paramSize = params.size();
                    if (methodInfo.isUseFutures() && paramSize > 0) {
                        TypeInfo callbackType = methodInfo.getCallbackType();
                        if (callbackType == null || callbackType.getKind() != ClassKind.ASYNC_RESULT || !methodInfo.getOwnerTypes().contains(this.type) || methodInfo.getOwnerTypes().size() != 1) continue;
                        TypeInfo arg = ((ParameterizedTypeInfo)callbackType).getArg(0);
                        throw new GenException((Element)entry2.getKey(), "Cannot use Handler<AsyncResult<" + arg.getSimpleName() + ">>, instead use a Future<" + arg.getSimpleName() + "> return");
                    }
                    TypeInfo returnType = methodInfo.getReturnType();
                    if (!returnType.isParameterized() || !returnType.getRaw().getName().equals("io.vertx.core.Future")) continue;
                    TypeInfo asyncType = ((ParameterizedTypeInfo)returnType).getArg(0);
                    ArrayList<ParamInfo> p = new ArrayList<ParamInfo>(params);
                    p.add(new ParamInfo(p.size(), "handler", null, new ParameterizedTypeInfo(HANDLER_TYPE, false, Collections.singletonList(new ParameterizedTypeInfo(ASYNC_RESULT_TYPE, false, Collections.singletonList(asyncType))))));
                    Signature t = new Signature(methodInfo.getName(), p);
                    Optional<MethodInfo> opt = map.values().stream().filter(m -> m.getName().equals(methodInfo.getName())).filter(m -> m.getSignature().equals(t)).findFirst();
                    if (!opt.isPresent()) continue;
                    this.futureMethods.add(opt.get());
                    iterator.remove();
                }
            }
            Stream.concat(this.methods.entrySet().stream(), this.anyJavaTypeMethods.entrySet().stream()).forEach(entry -> {
                MethodInfo method = (MethodInfo)entry.getValue();
                TypeInfo returnType = method.getReturnType();
                ExecutableElement methodElt = (ExecutableElement)entry.getKey();
                if (!method.isFluent()) {
                    if (method.isOwnedBy(this.type)) {
                        this.checkReturnType(methodElt, returnType, this.anyJavaTypeMethods.containsKey(methodElt));
                    }
                } else if (returnType.isNullable()) {
                    throw new GenException(methodElt, "Fluent return type cannot be nullable");
                }
            });
            this.methodMap = this.methods.values().stream().collect(Collectors.groupingBy(MethodInfo::getName));
            this.sortMethodMap(this.methodMap);
            for (List<MethodInfo> list : this.methodMap.values()) {
                list.forEach(this::checkMethod);
                MethodInfo methodInfo = list.get(0);
                for (MethodInfo method : list) {
                    if (method.isStaticMethod() == methodInfo.isStaticMethod()) continue;
                    throw new GenException(elem, "Overloaded method " + method.getName() + " cannot be both static and instance");
                }
            }
        }
    }

    protected void checkParamType(ExecutableElement elem, TypeInfo typeInfo, int pos, int numParams, boolean allowAnyJavaType) {
        TypeValidator.validateParamType(elem, typeInfo, allowAnyJavaType);
    }

    protected void checkReturnType(ExecutableElement elem, TypeInfo type, boolean allowAnyJavaType) {
        TypeValidator.validateReturnType(elem, type, allowAnyJavaType);
    }

    private TypeInfo extractArg(String subType, DeclaredType declaredType) {
        TypeInfo[] typeInfos = this.extractArgs(subType, declaredType);
        return typeInfos != null && typeInfos.length > 0 ? typeInfos[0] : null;
    }

    private TypeInfo[] extractArgs(String subType, DeclaredType declaredType) {
        TypeElement parameterizedElt = this.elementUtils.getTypeElement(subType);
        TypeMirror parameterizedType = parameterizedElt.asType();
        TypeMirror rawType = this.typeUtils.erasure(parameterizedType);
        if (this.typeUtils.isSubtype(declaredType, rawType)) {
            List<? extends TypeParameterElement> typeParameters = parameterizedElt.getTypeParameters();
            TypeInfo[] typeInfos = new TypeInfo[typeParameters.size()];
            for (int i = 0; i < typeParameters.size(); ++i) {
                DeclaredType dt;
                TypeElement a;
                TypeMirror resolved = Helper.resolveTypeParameter(this.typeUtils, declaredType, typeParameters.get(i));
                if (resolved != null && resolved.getKind() == TypeKind.DECLARED && (a = (TypeElement)(dt = (DeclaredType)resolved).asElement()).getQualifiedName().toString().equals(VERTX_ASYNC_RESULT)) {
                    return null;
                }
                typeInfos[i] = this.typeFactory.create(resolved);
            }
            return typeInfos;
        }
        return null;
    }

    private ConstantInfo fieldMethod(Types typeUtils, VariableElement modelField, boolean allowAnyJavaType) {
        Set<Modifier> mods = modelField.getModifiers();
        if (!mods.contains((Object)Modifier.PUBLIC)) {
            return null;
        }
        TypeInfo type = this.typeFactory.create(modelField.asType());
        TypeValidator.validateConstantType(typeUtils, modelField, type, modelField.asType(), allowAnyJavaType);
        Doc doc = this.docFactory.createDoc(modelField);
        return new ConstantInfo(doc, modelField.getSimpleName().toString(), type);
    }

    /*
     * WARNING - void declaration
     */
    private MethodInfo createMethod(ExecutableElement modelMethod, boolean allowAnyJavaType) {
        void var15_22;
        TypeInfo returnType;
        boolean isFluent;
        ApiTypeInfo declaringApiType;
        Set<Modifier> mods = modelMethod.getModifiers();
        if (!mods.contains((Object)Modifier.PUBLIC)) {
            return null;
        }
        TypeElement declaringElt = (TypeElement)modelMethod.getEnclosingElement();
        TypeInfo declaringType = this.typeFactory.create(declaringElt.asType());
        ExecutableType resolvedMethodType = (ExecutableType)this.typeUtils.asMemberOf((DeclaredType)this.modelElt.asType(), modelMethod);
        if (!declaringElt.equals(this.modelElt) && declaringType.getKind() != ClassKind.API && declaringType.getKind() != ClassKind.HANDLER) {
            return null;
        }
        if (!declaringElt.equals(this.modelElt) && declaringType.getKind() == ClassKind.API && (declaringApiType = (ApiTypeInfo)declaringType.getRaw()).isConcrete() && this.typeUtils.isSameType(resolvedMethodType, modelMethod.asType())) {
            return null;
        }
        ClassTypeInfo type = this.typeFactory.create(declaringElt.asType()).getRaw();
        boolean isDefault = mods.contains((Object)Modifier.DEFAULT);
        boolean isStatic = mods.contains((Object)Modifier.STATIC);
        if (isStatic && !this.concrete) {
            throw new GenException(modelMethod, "Abstract interface cannot declare static methods");
        }
        boolean isCacheReturn = modelMethod.getAnnotation(CacheReturn.class) != null;
        ArrayList<TypeParamInfo.Method> typeParams = new ArrayList<TypeParamInfo.Method>();
        for (TypeParameterElement typeParameterElement : modelMethod.getTypeParameters()) {
            for (TypeMirror typeMirror : typeParameterElement.getBounds()) {
                if (this.isObjectBound(typeMirror)) continue;
                throw new GenException(modelMethod, "Type parameter bound not supported " + typeMirror);
            }
            typeParams.add((TypeParamInfo.Method)TypeParamInfo.create(typeParameterElement));
        }
        ArrayList<ExecutableElement> modelMethods = new ArrayList<ExecutableElement>();
        modelMethods.add(modelMethod);
        HashSet<ClassTypeInfo> hashSet = new HashSet<ClassTypeInfo>();
        ArrayList<DeclaredType> ancestors = new ArrayList<DeclaredType>(Helper.resolveAncestorTypes(this.modelElt, true, true));
        Collections.sort(ancestors, (o1, o2) -> {
            if (this.typeUtils.isSubtype((TypeMirror)o1, (TypeMirror)o2)) {
                return -1;
            }
            if (this.typeUtils.isSubtype((TypeMirror)o2, (TypeMirror)o1)) {
                return 1;
            }
            return ((TypeElement)o1.asElement()).getQualifiedName().toString().compareTo(((TypeElement)o2.asElement()).getQualifiedName().toString());
        });
        for (DeclaredType ancestorType : ancestors) {
            TypeElement ancestorElt = (TypeElement)ancestorType.asElement();
            if (ancestorElt.getAnnotation(VertxGen.class) == null) continue;
            this.elementUtils.getAllMembers(ancestorElt).stream().flatMap(Helper.FILTER_METHOD).filter(meth -> this.elementUtils.overrides(modelMethod, (ExecutableElement)meth, this.modelElt)).forEach(overridenMethodElt -> {
                modelMethods.add((ExecutableElement)overridenMethodElt);
                ownerTypes.add(this.typeFactory.create((DeclaredType)ancestorElt.asType()).getRaw());
            });
        }
        if (hashSet.isEmpty()) {
            Element enclosingElt = modelMethod.getEnclosingElement();
            if (this.typeUtils.isSameType(this.modelElt.asType(), enclosingElt.asType())) {
                boolean bl = this.getModule().useFutures;
            } else {
                boolean bl = this.typeFactory.create((DeclaredType)((DeclaredType)enclosingElt.asType())).getRaw().getModule().useFutures;
            }
        } else {
            boolean bl = ((ClassTypeInfo)hashSet.iterator().next()).getModule().useFutures;
        }
        hashSet.add(type);
        HashMap paramDescs = new HashMap();
        String comment = this.elementUtils.getDocComment(modelMethod);
        Doc doc = this.docFactory.createDoc(modelMethod);
        Text returnDesc = null;
        Text methodDeprecatedDesc = null;
        if (doc != null) {
            Optional<Tag> methodDeprecatedTag;
            doc.getBlockTags().stream().filter(tag -> tag.getName().equals("param")).map(Tag.Param::new).forEach(tag -> paramDescs.put(tag.getParamName(), tag.getParamDescription()));
            Optional<Tag> returnTag = doc.getBlockTags().stream().filter(tag -> tag.getName().equals("return")).findFirst();
            if (returnTag.isPresent()) {
                returnDesc = new Text(Helper.normalizeWhitespaces(returnTag.get().getValue())).map(Token.tagMapper(this.elementUtils, this.typeUtils, this.modelElt));
            }
            if ((methodDeprecatedTag = doc.getBlockTags().stream().filter(tag -> tag.getName().equals("deprecated")).findFirst()).isPresent()) {
                methodDeprecatedDesc = new Text(Helper.normalizeWhitespaces(methodDeprecatedTag.get().getValue())).map(Token.tagMapper(this.elementUtils, this.typeUtils, this.modelElt));
            }
        }
        ArrayList<ParamInfo> mParams = new ArrayList<ParamInfo>();
        ExecutableType methodType = (ExecutableType)modelMethod.asType();
        List<? extends VariableElement> params = modelMethod.getParameters();
        for (int i = 0; i < params.size(); ++i) {
            TypeInfo unresolvedTypeInfo;
            TypeInfo typeInfo;
            VariableElement param = params.get(i);
            TypeMirror typeMirror = resolvedMethodType.getParameterTypes().get(i);
            TypeUse typeUse = TypeUse.createParamTypeUse(this.env, modelMethods.toArray(new ExecutableElement[0]), i);
            try {
                typeInfo = this.typeFactory.create(typeUse, typeMirror);
            }
            catch (Exception e) {
                GenException ex = new GenException(param, e.getMessage());
                ex.setStackTrace(e.getStackTrace());
                throw ex;
            }
            String name = param.getSimpleName().toString();
            String desc = (String)paramDescs.get(name);
            Text text = desc != null ? new Text(desc).map(Token.tagMapper(this.elementUtils, this.typeUtils, this.modelElt)) : null;
            try {
                unresolvedTypeInfo = this.typeFactory.create(typeUse, methodType.getParameterTypes().get(i));
            }
            catch (Exception exception) {
                throw new GenException(param, exception.getMessage());
            }
            ParamInfo paramInfo = new ParamInfo(i, name, text, typeInfo, unresolvedTypeInfo);
            mParams.add(paramInfo);
        }
        AnnotationMirror fluentAnnotation = Helper.resolveMethodAnnotation(Fluent.class, this.elementUtils, this.typeUtils, declaringElt, modelMethod);
        boolean bl = isFluent = fluentAnnotation != null;
        if (isFluent) {
            isFluent = true;
            if (!this.typeUtils.isSameType(declaringElt.asType(), this.modelElt.asType())) {
                String msg = "Interface " + this.modelElt + " does not redeclare the @Fluent return type  of method " + modelMethod + " declared by " + declaringElt;
                this.messager.printMessage(Diagnostic.Kind.WARNING, msg, this.modelElt, fluentAnnotation);
                logger.warning(msg);
            } else {
                TypeMirror fluentType = modelMethod.getReturnType();
                if (!this.typeUtils.isAssignable(fluentType, this.modelElt.asType())) {
                    throw new GenException(modelMethod, "Methods marked with @Fluent must have a return type that extends the type");
                }
            }
        }
        TypeUse returnTypeUse = TypeUse.createReturnTypeUse(this.env, modelMethods.toArray(new ExecutableElement[modelMethods.size()]));
        try {
            returnType = this.typeFactory.create(returnTypeUse, resolvedMethodType.getReturnType());
        }
        catch (Exception e) {
            GenException genEx = new GenException(modelMethod, e.getMessage());
            genEx.initCause(e);
            throw genEx;
        }
        returnType.collectImports(this.collectedTypes);
        if (isCacheReturn && returnType.isVoid()) {
            throw new GenException(modelMethod, "void method can't be marked with @CacheReturn");
        }
        boolean methodDeprecated = modelMethod.getAnnotation(Deprecated.class) != null || this.deprecatedDesc != null;
        boolean methodOverride = modelMethod.getAnnotation(Override.class) != null;
        String methodName = modelMethod.getSimpleName().toString();
        MethodInfo methodInfo = this.createMethodInfo(hashSet, methodName, comment, doc, returnType, returnDesc, isFluent, isCacheReturn, mParams, modelMethod, isStatic, isDefault, typeParams, declaringElt, methodDeprecated, methodDeprecatedDesc, (boolean)var15_22, methodOverride);
        for (Map.Entry entry : this.methods.entrySet()) {
            ExecutableType t2;
            ExecutableType t1;
            if (!((MethodInfo)entry.getValue()).getName().equals(modelMethod.getSimpleName().toString()) || !this.typeUtils.isSubsignature(t1 = (ExecutableType)((ExecutableElement)entry.getKey()).asType(), t2 = (ExecutableType)modelMethod.asType()) || !this.typeUtils.isSubsignature(t2, t1)) continue;
            ((MethodInfo)entry.getValue()).getOwnerTypes().addAll(methodInfo.getOwnerTypes());
            return null;
        }
        if (hashSet.size() == 1) {
            void var33_51;
            List<ParamInfo> p = methodInfo.getParams();
            boolean bl2 = false;
            while (var33_51 < p.size()) {
                this.checkParamType(modelMethod, p.get((int)var33_51).getType(), (int)var33_51, p.size(), allowAnyJavaType);
                ++var33_51;
            }
        }
        return methodInfo;
    }

    protected MethodInfo createMethodInfo(Set<ClassTypeInfo> ownerTypes, String methodName, String comment, Doc doc, TypeInfo returnType, Text returnDescription, boolean isFluent, boolean isCacheReturn, List<ParamInfo> mParams, ExecutableElement methodElt, boolean isStatic, boolean isDefault, ArrayList<TypeParamInfo.Method> typeParams, TypeElement declaringElt, boolean methodDeprecated, Text methodDeprecatedDesc, boolean useFutures, boolean methodOverride) {
        return new MethodInfo(ownerTypes, methodName, returnType, returnDescription, isFluent, isCacheReturn, mParams, comment, doc, isStatic, isDefault, typeParams, methodDeprecated, methodDeprecatedDesc, useFutures, methodOverride);
    }

    protected void checkMethod(MethodInfo methodInfo) {
    }

    private boolean isObjectBound(TypeMirror bound) {
        return bound.getKind() == TypeKind.DECLARED && bound.toString().equals(Object.class.getName());
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public Text getDeprecatedDesc() {
        return this.deprecatedDesc;
    }

    @Override
    public Map<String, Object> getVars() {
        Map<String, Object> vars = Model.super.getVars();
        vars.put("importedTypes", this.getImportedTypes());
        vars.put("concrete", this.isConcrete());
        vars.put("type", this.getType());
        vars.put("ifacePackageName", this.getIfacePackageName());
        vars.put("ifaceSimpleName", this.getIfaceSimpleName());
        vars.put("ifaceFQCN", this.getIfaceFQCN());
        vars.put("ifaceComment", this.getIfaceComment());
        vars.put("doc", this.doc);
        vars.put("methods", this.getMethods());
        vars.put("constants", this.getConstants());
        vars.put("referencedTypes", this.getReferencedTypes());
        vars.put("superTypes", this.getSuperTypes());
        vars.put("concreteSuperType", this.getConcreteSuperType());
        vars.put("abstractSuperTypes", this.getAbstractSuperTypes());
        vars.put("handlerType", this.getHandlerArg());
        vars.put("methodsByName", this.getMethodMap());
        vars.put("classAnnotations", this.getAnnotations());
        vars.put("annotationsByMethodName", this.getMethodAnnotations());
        vars.put("referencedDataObjectTypes", this.getReferencedDataObjectTypes());
        vars.put("referencedEnumTypes", this.getReferencedEnumTypes());
        vars.put("typeParams", this.getTypeParams());
        vars.put("instanceMethods", this.getInstanceMethods());
        vars.put("staticMethods", this.getStaticMethods());
        vars.put("deprecated", this.isDeprecated());
        vars.put("deprecatedDesc", this.getDeprecatedDesc());
        return vars;
    }

    public boolean isHandler() {
        return this.handlerArg != null;
    }

    public TypeInfo getHandlerArg() {
        return this.handlerArg;
    }

    public boolean isReadStream() {
        return this.readStreamArg != null;
    }

    public TypeInfo getReadStreamArg() {
        return this.readStreamArg;
    }

    public boolean isWriteStream() {
        return this.writeStreamArg != null;
    }

    public TypeInfo getWriteStreamArg() {
        return this.writeStreamArg;
    }

    public boolean isIterable() {
        return this.iterableArg != null;
    }

    public TypeInfo getIterableArg() {
        return this.iterableArg;
    }

    public boolean isIterator() {
        return this.iteratorArg != null;
    }

    public TypeInfo getIteratorArg() {
        return this.iteratorArg;
    }

    public boolean isFunction() {
        return this.functionArgs != null;
    }

    public TypeInfo[] getFunctionArgs() {
        return this.functionArgs;
    }
}

