/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.utils.WasmArrayInfo;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.wasm.ir.JsBuiltinDescriptor;
import org.jetbrains.kotlin.wasm.ir.WasmImportDescriptor;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\f\u001a\u00020\r*\u00020\u000e\u001a\f\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u0011\u001a\f\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u0011\u001a\f\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u000e\u001a\n\u0010\u0016\u001a\u00020\r*\u00020\u000e\u001a\n\u0010\u0017\u001a\u00020\r*\u00020\u000e\u001a\n\u0010\u0018\u001a\u00020\r*\u00020\u000e\u001a\f\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u000e\u001a\f\u0010\u001b\u001a\u0004\u0018\u00010\u0015*\u00020\u000e\u001a\f\u0010\u001c\u001a\u0004\u0018\u00010\u0015*\u00020\u000e\u001a\f\u0010\u001d\u001a\u0004\u0018\u00010\u0015*\u00020\u0011\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"excludedFromCodegenFqName", "Lorg/jetbrains/kotlin/name/FqName;", "wasmImportFqName", "wasmOpFqName", "wasmNoOpCastFqName", "wasmAutoboxedFqName", "wasmPrimitiveConstructorFqName", "wasmArrayOfFqName", "jsFunFqName", "jsPrimitiveFqName", "wasmExportFqName", "jsBuiltinFqName", "hasExcludedFromCodegenAnnotation", "", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "getWasmImportDescriptor", "Lorg/jetbrains/kotlin/wasm/ir/WasmImportDescriptor;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getJsBuiltinDescriptor", "Lorg/jetbrains/kotlin/wasm/ir/JsBuiltinDescriptor;", "getWasmOpAnnotation", "", "hasWasmNoOpCastAnnotation", "hasWasmAutoboxedAnnotation", "hasWasmPrimitiveConstructorAnnotation", "getWasmArrayAnnotation", "Lorg/jetbrains/kotlin/backend/wasm/utils/WasmArrayInfo;", "getJsFunAnnotation", "getJsPrimitiveType", "getWasmExportNameIfWasmExport", "backend.wasm"})
public final class AnnotationsKt {
    @NotNull
    private static final FqName excludedFromCodegenFqName = new FqName("kotlin.wasm.internal.ExcludedFromCodegen");
    @NotNull
    private static final FqName wasmImportFqName = new FqName("kotlin.wasm.WasmImport");
    @NotNull
    private static final FqName wasmOpFqName = new FqName("kotlin.wasm.internal.WasmOp");
    @NotNull
    private static final FqName wasmNoOpCastFqName = new FqName("kotlin.wasm.internal.WasmNoOpCast");
    @NotNull
    private static final FqName wasmAutoboxedFqName = new FqName("kotlin.wasm.internal.WasmAutoboxed");
    @NotNull
    private static final FqName wasmPrimitiveConstructorFqName = new FqName("kotlin.wasm.internal.WasmPrimitiveConstructor");
    @NotNull
    private static final FqName wasmArrayOfFqName = new FqName("kotlin.wasm.internal.WasmArrayOf");
    @NotNull
    private static final FqName jsFunFqName = new FqName("kotlin.JsFun");
    @NotNull
    private static final FqName jsPrimitiveFqName = new FqName("kotlin.wasm.internal.JsPrimitive");
    @NotNull
    private static final FqName wasmExportFqName = new FqName("kotlin.wasm.WasmExport");
    @NotNull
    private static final FqName jsBuiltinFqName = new FqName("kotlin.wasm.internal.JsBuiltin");

    public static final boolean hasExcludedFromCodegenAnnotation(@NotNull IrAnnotationContainer $this$hasExcludedFromCodegenAnnotation) {
        Intrinsics.checkNotNullParameter($this$hasExcludedFromCodegenAnnotation, "<this>");
        return IrUtilsKt.hasAnnotation($this$hasExcludedFromCodegenAnnotation, excludedFromCodegenFqName);
    }

    @Nullable
    public static final WasmImportDescriptor getWasmImportDescriptor(@NotNull IrFunction $this$getWasmImportDescriptor) {
        Intrinsics.checkNotNullParameter($this$getWasmImportDescriptor, "<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getWasmImportDescriptor, wasmImportFqName);
        if (irConstructorCall == null) {
            return null;
        }
        IrConstructorCall annotation = irConstructorCall;
        Object e2 = annotation.getArguments().get(0);
        Intrinsics.checkNotNull(e2, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst");
        Object object = ((IrConst)e2).getValue();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.String");
        String moduleName2 = (String)object;
        Object e3 = annotation.getArguments().get(1);
        IrConst irConst = e3 instanceof IrConst ? (IrConst)e3 : null;
        Object object2 = irConst != null ? irConst.getValue() : null;
        String declarationName = object2 instanceof String ? (String)object2 : null;
        String string = declarationName;
        if (string == null) {
            String string2 = $this$getWasmImportDescriptor.getName().asString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        }
        return new WasmImportDescriptor(moduleName2, (WasmSymbolReadOnly<String>)new WasmSymbol<String>(string));
    }

    @Nullable
    public static final JsBuiltinDescriptor getJsBuiltinDescriptor(@NotNull IrFunction $this$getJsBuiltinDescriptor) {
        Intrinsics.checkNotNullParameter($this$getJsBuiltinDescriptor, "<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getJsBuiltinDescriptor, jsBuiltinFqName);
        if (irConstructorCall == null) {
            return null;
        }
        IrConstructorCall annotation = irConstructorCall;
        Object e2 = annotation.getArguments().get(0);
        Intrinsics.checkNotNull(e2, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst");
        Object object = ((IrConst)e2).getValue();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.String");
        String moduleName2 = (String)object;
        Object e3 = annotation.getArguments().get(1);
        IrConst irConst = e3 instanceof IrConst ? (IrConst)e3 : null;
        Object object2 = irConst != null ? irConst.getValue() : null;
        String declarationName = object2 instanceof String ? (String)object2 : null;
        Object e4 = annotation.getArguments().get(2);
        IrConst irConst2 = e4 instanceof IrConst ? (IrConst)e4 : null;
        Object object3 = irConst2 != null ? irConst2.getValue() : null;
        Intrinsics.checkNotNull(object3, "null cannot be cast to non-null type kotlin.String");
        String polyfillImpl = (String)object3;
        String string = "wasm:" + moduleName2;
        String string2 = declarationName;
        if (string2 == null) {
            String string3 = $this$getJsBuiltinDescriptor.getName().asString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "asString(...)");
        }
        return new JsBuiltinDescriptor(string, string2, polyfillImpl);
    }

    @Nullable
    public static final String getWasmOpAnnotation(@NotNull IrAnnotationContainer $this$getWasmOpAnnotation) {
        Intrinsics.checkNotNullParameter($this$getWasmOpAnnotation, "<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getWasmOpAnnotation, wasmOpFqName);
        return irConstructorCall != null ? AnnotationUtilsKt.getSingleConstStringArgument(irConstructorCall) : null;
    }

    public static final boolean hasWasmNoOpCastAnnotation(@NotNull IrAnnotationContainer $this$hasWasmNoOpCastAnnotation) {
        Intrinsics.checkNotNullParameter($this$hasWasmNoOpCastAnnotation, "<this>");
        return IrUtilsKt.hasAnnotation($this$hasWasmNoOpCastAnnotation, wasmNoOpCastFqName);
    }

    public static final boolean hasWasmAutoboxedAnnotation(@NotNull IrAnnotationContainer $this$hasWasmAutoboxedAnnotation) {
        Intrinsics.checkNotNullParameter($this$hasWasmAutoboxedAnnotation, "<this>");
        return IrUtilsKt.hasAnnotation($this$hasWasmAutoboxedAnnotation, wasmAutoboxedFqName);
    }

    public static final boolean hasWasmPrimitiveConstructorAnnotation(@NotNull IrAnnotationContainer $this$hasWasmPrimitiveConstructorAnnotation) {
        Intrinsics.checkNotNullParameter($this$hasWasmPrimitiveConstructorAnnotation, "<this>");
        return IrUtilsKt.hasAnnotation($this$hasWasmPrimitiveConstructorAnnotation, wasmPrimitiveConstructorFqName);
    }

    @Nullable
    public static final WasmArrayInfo getWasmArrayAnnotation(@NotNull IrAnnotationContainer $this$getWasmArrayAnnotation) {
        WasmArrayInfo wasmArrayInfo;
        Intrinsics.checkNotNullParameter($this$getWasmArrayAnnotation, "<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getWasmArrayAnnotation, wasmArrayOfFqName);
        if (irConstructorCall != null) {
            IrConstructorCall it = irConstructorCall;
            boolean bl = false;
            Object e2 = it.getArguments().get(0);
            Intrinsics.checkNotNull(e2, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrClassReference");
            IrSymbolOwner irSymbolOwner = ((IrClassReference)e2).getSymbol().getOwner();
            Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            IrClass irClass = (IrClass)irSymbolOwner;
            Object e3 = it.getArguments().get(1);
            Intrinsics.checkNotNull(e3, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst");
            Object object = ((IrConst)e3).getValue();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
            Object e4 = it.getArguments().get(2);
            IrConst irConst = e4 instanceof IrConst ? (IrConst)e4 : null;
            Object object2 = irConst != null ? irConst.getValue() : null;
            Boolean bl2 = object2 instanceof Boolean ? (Boolean)object2 : null;
            wasmArrayInfo = new WasmArrayInfo(irClass, (Boolean)object, bl2 != null ? bl2 : true);
        } else {
            wasmArrayInfo = null;
        }
        return wasmArrayInfo;
    }

    @Nullable
    public static final String getJsFunAnnotation(@NotNull IrAnnotationContainer $this$getJsFunAnnotation) {
        Intrinsics.checkNotNullParameter($this$getJsFunAnnotation, "<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getJsFunAnnotation, jsFunFqName);
        return irConstructorCall != null ? AnnotationUtilsKt.getSingleConstStringArgument(irConstructorCall) : null;
    }

    @Nullable
    public static final String getJsPrimitiveType(@NotNull IrAnnotationContainer $this$getJsPrimitiveType) {
        Intrinsics.checkNotNullParameter($this$getJsPrimitiveType, "<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getJsPrimitiveType, jsPrimitiveFqName);
        return irConstructorCall != null ? AnnotationUtilsKt.getSingleConstStringArgument(irConstructorCall) : null;
    }

    @Nullable
    public static final String getWasmExportNameIfWasmExport(@NotNull IrFunction $this$getWasmExportNameIfWasmExport) {
        Intrinsics.checkNotNullParameter($this$getWasmExportNameIfWasmExport, "<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getWasmExportNameIfWasmExport, wasmExportFqName);
        if (irConstructorCall == null) {
            return null;
        }
        IrConstructorCall annotation = irConstructorCall;
        if (annotation.getArguments().isEmpty()) {
            return $this$getWasmExportNameIfWasmExport.getName().getIdentifier();
        }
        Object e2 = annotation.getArguments().get(0);
        IrConst irConst = e2 instanceof IrConst ? (IrConst)e2 : null;
        Object object = irConst != null ? irConst.getValue() : null;
        String nameFromAnnotation = object instanceof String ? (String)object : null;
        String string = nameFromAnnotation;
        if (string == null) {
            String string2 = $this$getWasmExportNameIfWasmExport.getName().getIdentifier();
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "getIdentifier(...)");
        }
        return string;
    }
}

